/*
 * Decompiled with CFR 0.152.
 */
package rdts.protocols;

import java.io.Serializable;
import rdts.base.Lattice;
import rdts.base.LocalUid;
import rdts.datatypes.Epoch;
import rdts.datatypes.Epoch$;
import rdts.protocols.MultiRoundVoting$;
import rdts.protocols.Participants;
import rdts.protocols.Participants$;
import rdts.protocols.Voting;
import rdts.protocols.Voting$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class MultiRoundVoting<A>
implements Product,
Serializable {
    private final Epoch<Voting<A>> rounds;

    public static <A> MultiRoundVoting<A> apply(Epoch<Voting<A>> epoch) {
        return MultiRoundVoting$.MODULE$.apply(epoch);
    }

    public static MultiRoundVoting<?> fromProduct(Product product) {
        return MultiRoundVoting$.MODULE$.fromProduct(product);
    }

    public static <A> Lattice<MultiRoundVoting<A>> lattice() {
        return MultiRoundVoting$.MODULE$.lattice();
    }

    public static <A> MultiRoundVoting<A> unapply(MultiRoundVoting<A> multiRoundVoting) {
        return MultiRoundVoting$.MODULE$.unapply(multiRoundVoting);
    }

    public static <A> MultiRoundVoting<A> unchanged() {
        return MultiRoundVoting$.MODULE$.unchanged();
    }

    public MultiRoundVoting(Epoch<Voting<A>> rounds) {
        this.rounds = rounds;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -513334588, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MultiRoundVoting)) return false;
        MultiRoundVoting multiRoundVoting = (MultiRoundVoting)object;
        Epoch<Voting<A>> epoch = this.rounds();
        Epoch<Voting<A>> epoch2 = multiRoundVoting.rounds();
        if (epoch == null) {
            if (epoch2 != null) {
                return false;
            }
        } else if (!((Object)epoch).equals(epoch2)) return false;
        if (!multiRoundVoting.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof MultiRoundVoting;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "MultiRoundVoting";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "rounds";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Epoch<Voting<A>> rounds() {
        return this.rounds;
    }

    public MultiRoundVoting<A> release() {
        return MultiRoundVoting$.MODULE$.apply(Epoch$.MODULE$.apply(this.rounds().counter() + 1L, Voting$.MODULE$.unchanged()));
    }

    public MultiRoundVoting<A> upkeep(LocalUid x$1, Participants x$2) {
        Option<Tuple2<A, Object>> option = this.rounds().value().leadingCount();
        if (option instanceof Some) {
            Option option2 = Some$.MODULE$.unapply((Some)option);
            if (!option2.isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option2.get();
                Object value = tuple2._1();
                int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (this.checkIfMajorityPossible(x$2)) {
                    return this.voteFor(value, x$1, x$2);
                }
            }
            return this.release();
        }
        if (None$.MODULE$.equals(option)) {
            return MultiRoundVoting$.MODULE$.unchanged();
        }
        throw new MatchError(option);
    }

    public boolean checkIfMajorityPossible(Participants x$12) {
        int totalVotes = this.rounds().value().votes().size();
        int remainingVotes = Participants$.MODULE$.participants(x$12).size() - totalVotes;
        Option possible = this.rounds().value().leadingCount().map((Function1 & Serializable)x$1 -> {
            Object object = x$1._1();
            int n = BoxesRunTime.unboxToInt((Object)x$1._2());
            return n + remainingVotes >= this.rounds().value().threshold(x$12);
        });
        return BoxesRunTime.unboxToBoolean((Object)possible.getOrElse(MultiRoundVoting::checkIfMajorityPossible$$anonfun$1));
    }

    public MultiRoundVoting<A> voteFor(A c, LocalUid x$2, Participants x$3) {
        return MultiRoundVoting$.MODULE$.apply(Epoch$.MODULE$.apply(this.rounds().counter(), this.rounds().value().voteFor(c, x$2, x$3)));
    }

    public Option<A> result(Participants x$1) {
        return this.rounds().value().result(x$1);
    }

    public <A> MultiRoundVoting<A> copy(Epoch<Voting<A>> rounds) {
        return new MultiRoundVoting<A>(rounds);
    }

    public <A> Epoch<Voting<A>> copy$default$1() {
        return this.rounds();
    }

    public Epoch<Voting<A>> _1() {
        return this.rounds();
    }

    private static final boolean checkIfMajorityPossible$$anonfun$1() {
        return true;
    }
}

