/*
 * Decompiled with CFR 0.152.
 */
package rdts.datatypes.alternatives.rga;

import java.io.Serializable;
import java.util.NoSuchElementException;
import rdts.base.Bottom;
import rdts.base.Lattice;
import rdts.base.Lattice$;
import rdts.base.LocalUid;
import rdts.base.Uid;
import rdts.base.Uid$;
import rdts.datatypes.alternatives.rga.DeltaSequence$;
import rdts.datatypes.alternatives.rga.DeltaSequence$DeltaSequenceOrder$;
import rdts.datatypes.alternatives.rga.Vertex;
import rdts.datatypes.alternatives.rga.Vertex$;
import rdts.datatypes.contextual.ReplicatedSet;
import rdts.datatypes.contextual.ReplicatedSet$;
import rdts.dotted.Dotted;
import rdts.dotted.Dotted$;
import rdts.dotted.HasDots;
import rdts.dotted.HasDots$;
import rdts.time.Dots;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DeltaSequence<A>
implements Product,
Serializable {
    private final ReplicatedSet<Vertex> vertices;
    private final DeltaSequenceOrder edges;
    private final Map<Vertex, A> values;

    public static <A> DeltaSequence<A> apply(ReplicatedSet<Vertex> replicatedSet, DeltaSequenceOrder deltaSequenceOrder, Map<Vertex, A> map) {
        return DeltaSequence$.MODULE$.apply(replicatedSet, deltaSequenceOrder, map);
    }

    public static <A> bottom<A> bottom() {
        return DeltaSequence$.MODULE$.bottom();
    }

    public static <A> Lattice<DeltaSequence<A>> deltaSequenceLattice() {
        return DeltaSequence$.MODULE$.deltaSequenceLattice();
    }

    public static <A> DeltaSequence<A> empty() {
        return DeltaSequence$.MODULE$.empty();
    }

    public static DeltaSequence<?> fromProduct(Product product) {
        return DeltaSequence$.MODULE$.fromProduct(product);
    }

    public static <A> hasDots<A> hasDots() {
        return DeltaSequence$.MODULE$.hasDots();
    }

    public static <A> DeltaSequence<A> unapply(DeltaSequence<A> deltaSequence) {
        return DeltaSequence$.MODULE$.unapply(deltaSequence);
    }

    public DeltaSequence(ReplicatedSet<Vertex> vertices, DeltaSequenceOrder edges, Map<Vertex, A> values) {
        this.vertices = vertices;
        this.edges = edges;
        this.values = values;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DeltaSequence)) return false;
        DeltaSequence deltaSequence = (DeltaSequence)object;
        ReplicatedSet<Vertex> replicatedSet = this.vertices();
        ReplicatedSet<Vertex> replicatedSet2 = deltaSequence.vertices();
        if (replicatedSet == null) {
            if (replicatedSet2 != null) {
                return false;
            }
        } else if (!((Object)replicatedSet).equals(replicatedSet2)) return false;
        DeltaSequenceOrder deltaSequenceOrder = this.edges();
        DeltaSequenceOrder deltaSequenceOrder2 = deltaSequence.edges();
        if (deltaSequenceOrder == null) {
            if (deltaSequenceOrder2 != null) {
                return false;
            }
        } else if (!((Object)deltaSequenceOrder).equals(deltaSequenceOrder2)) return false;
        Map<Vertex, A> map = this.values();
        Map<Vertex, A> map2 = deltaSequence.values();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!deltaSequence.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DeltaSequence;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "DeltaSequence";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "vertices";
            }
            case 1: {
                return "edges";
            }
            case 2: {
                return "values";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ReplicatedSet<Vertex> vertices() {
        return this.vertices;
    }

    public DeltaSequenceOrder edges() {
        return this.edges;
    }

    public Map<Vertex, A> values() {
        return this.values;
    }

    public DeltaSequence<A> current() {
        return this;
    }

    public Option<Vertex> successor(Vertex v) {
        Option option2 = this.current().edges().inner().get((Object)v);
        if (None$.MODULE$.equals(option2)) {
            return None$.MODULE$;
        }
        if (option2 instanceof Some) {
            Vertex u = (Vertex)((Some)option2).value();
            if (this.current().vertices().contains(u)) {
                return Some$.MODULE$.apply((Object)u);
            }
            return this.successor(u);
        }
        throw new MatchError((Object)option2);
    }

    public Dotted<DeltaSequence<A>> addRightDelta(Uid replica, Vertex left, Vertex insertee, A value, Dots context) {
        DeltaSequenceOrder newEdges = this.current().edges().addRightEdgeDelta(left, insertee);
        Dotted<ReplicatedSet<Vertex>> newVertices = this.current().vertices().add((LocalUid)Uid$.MODULE$.toLocal().convert((Object)replica), insertee, context);
        Object[] objectArray = new Tuple2[1];
        Vertex vertex = (Vertex)Predef$.MODULE$.ArrowAssoc((Object)insertee);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vertex, value);
        Map newValues = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return newVertices.context().wrap(DeltaSequence$.MODULE$.apply(newVertices.data(), newEdges, newValues));
    }

    public Dotted<DeltaSequence<A>> prependDelta(Uid replica, A value, Dots context) {
        return this.addRightDelta(replica, Vertex$.MODULE$.start(), Vertex$.MODULE$.fresh(), value, context);
    }

    public Dotted<DeltaSequence<A>> removeDelta(Vertex v) {
        return this.current().vertices().remove(v).map((Function1 & Serializable)vert -> {
            DeltaSequence<A> deltaSequence = this.current();
            return deltaSequence.copy((ReplicatedSet<Vertex>)vert, deltaSequence.copy$default$2(), deltaSequence.copy$default$3());
        });
    }

    public Dotted<DeltaSequence<A>> filterDelta(Function1<A, Object> keep, Dots context) {
        Iterable removed = (Iterable)this.current().values().collect((PartialFunction)new Serializable(keep){
            private final Function1 keep$1;
            {
                this.keep$1 = keep$2;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                Vertex k = (Vertex)tuple2._1();
                Object v = tuple2._2();
                return !BoxesRunTime.unboxToBoolean((Object)this.keep$1.apply(v));
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Vertex k = (Vertex)tuple2._1();
                    Object v = tuple2._2();
                    if (!BoxesRunTime.unboxToBoolean((Object)this.keep$1.apply(v))) {
                        return k;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        return (Dotted)removed.foldLeft(context.wrap(this.current()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            Dotted curr = (Dotted)tuple2._1();
            Vertex toRemove = (Vertex)tuple2._2();
            Dotted Dotted_this = curr;
            Function1 & Serializable f$proxy1 = (Function1 & Serializable)_$1 -> (Function1 & Serializable)contextual$1 -> _$1.removeDelta(toRemove);
            Dotted delta = (Dotted)((Function1)f$proxy1.apply(Dotted_this.data())).apply((Object)Dotted_this.context());
            return (Dotted)((Object)Lattice$.MODULE$.merge(curr, delta, Dotted$.MODULE$.lattice(DeltaSequence$.MODULE$.hasDots(), DeltaSequence$.MODULE$.bottom(), DeltaSequence$.MODULE$.deltaSequenceLattice())));
        });
    }

    public List<A> toList() {
        return this.iterator().toList();
    }

    public Iterator<A> iterator() {
        return this.vertexIterator().map((Function1 & Serializable)v -> this.current().values().apply(v));
    }

    public Iterator<Vertex> vertexIterator() {
        return new AbstractIterator<Vertex>(this){
            private Vertex lastVertex;
            private Option currentSuccessor;
            private final /* synthetic */ DeltaSequence $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.lastVertex = Vertex$.MODULE$.start();
                this.currentSuccessor = $outer.successor(this.lastVertex());
            }

            public Vertex lastVertex() {
                return this.lastVertex;
            }

            public void lastVertex_$eq(Vertex x$1) {
                this.lastVertex = x$1;
            }

            public Option currentSuccessor() {
                return this.currentSuccessor;
            }

            public void currentSuccessor_$eq(Option x$1) {
                this.currentSuccessor = x$1;
            }

            public boolean hasNext() {
                return this.currentSuccessor().isDefined();
            }

            public Vertex next() {
                Option option2 = this.currentSuccessor();
                if (option2 instanceof Some) {
                    Vertex v = (Vertex)((Some)option2).value();
                    this.lastVertex_$eq(v);
                    this.currentSuccessor_$eq(this.$outer.successor(v));
                    return v;
                }
                throw new NoSuchElementException("Requesting iterator value after Vertex.end!");
            }
        };
    }

    public <A> DeltaSequence<A> copy(ReplicatedSet<Vertex> vertices, DeltaSequenceOrder edges, Map<Vertex, A> values) {
        return new DeltaSequence<A>(vertices, edges, values);
    }

    public <A> ReplicatedSet<Vertex> copy$default$1() {
        return this.vertices();
    }

    public <A> DeltaSequenceOrder copy$default$2() {
        return this.edges();
    }

    public <A> Map<Vertex, A> copy$default$3() {
        return this.values();
    }

    public ReplicatedSet<Vertex> _1() {
        return this.vertices();
    }

    public DeltaSequenceOrder _2() {
        return this.edges();
    }

    public Map<Vertex, A> _3() {
        return this.values();
    }

    public static class DeltaSequenceOrder
    implements Product,
    Serializable {
        private final Map<Vertex, Vertex> inner;

        public static DeltaSequenceOrder apply(Map<Vertex, Vertex> map) {
            return DeltaSequence$DeltaSequenceOrder$.MODULE$.apply(map);
        }

        public static DeltaSequenceOrder fromProduct(Product product) {
            return DeltaSequence$DeltaSequenceOrder$.MODULE$.fromProduct(product);
        }

        public static DeltaSequenceOrder unapply(DeltaSequenceOrder deltaSequenceOrder) {
            return DeltaSequence$DeltaSequenceOrder$.MODULE$.unapply(deltaSequenceOrder);
        }

        public DeltaSequenceOrder(Map<Vertex, Vertex> inner) {
            this.inner = inner;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeltaSequenceOrder)) return false;
            DeltaSequenceOrder deltaSequenceOrder = (DeltaSequenceOrder)object;
            Map<Vertex, Vertex> map = this.inner();
            Map<Vertex, Vertex> map2 = deltaSequenceOrder.inner();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!deltaSequenceOrder.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DeltaSequenceOrder;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DeltaSequenceOrder";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "inner";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<Vertex, Vertex> inner() {
            return this.inner;
        }

        public DeltaSequenceOrder addRightEdgeDelta(Vertex left, Vertex insertee) {
            Option option2 = this.inner().get((Object)left);
            if (None$.MODULE$.equals(option2)) {
                Object[] objectArray = new Tuple2[1];
                Vertex vertex = (Vertex)Predef$.MODULE$.ArrowAssoc((Object)left);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vertex, (Object)insertee);
                return DeltaSequence$DeltaSequenceOrder$.MODULE$.apply((Map<Vertex, Vertex>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }
            if (option2 instanceof Some) {
                Vertex right = (Vertex)((Some)option2).value();
                if (right.timestamp() > insertee.timestamp()) {
                    return this.addRightEdgeDelta(right, insertee);
                }
                Object[] objectArray = new Tuple2[2];
                Vertex vertex = (Vertex)Predef$.MODULE$.ArrowAssoc((Object)left);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vertex, (Object)insertee);
                Vertex vertex2 = (Vertex)Predef$.MODULE$.ArrowAssoc((Object)insertee);
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vertex2, (Object)right);
                return DeltaSequence$DeltaSequenceOrder$.MODULE$.apply((Map<Vertex, Vertex>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }
            throw new MatchError((Object)option2);
        }

        public DeltaSequenceOrder addRightEdge(Vertex left, Vertex insertee) {
            return DeltaSequence$DeltaSequenceOrder$.MODULE$.apply((Map<Vertex, Vertex>)((Map)this.inner().$plus$plus(this.addRightEdgeDelta(left, insertee).inner())));
        }

        public DeltaSequenceOrder copy(Map<Vertex, Vertex> inner) {
            return new DeltaSequenceOrder(inner);
        }

        public Map<Vertex, Vertex> copy$default$1() {
            return this.inner();
        }

        public Map<Vertex, Vertex> _1() {
            return this.inner();
        }
    }

    public static class bottom<A>
    implements Bottom<DeltaSequence<A>> {
        public bottom() {
            Bottom.$init$(this);
        }

        @Override
        public DeltaSequence<A> empty() {
            return DeltaSequence$.MODULE$.empty();
        }
    }

    public static class hasDots<A>
    implements HasDots<DeltaSequence<A>> {
        public hasDots() {
            HasDots.$init$(this);
        }

        @Override
        public Dots dots(DeltaSequence<A> value) {
            return ReplicatedSet$.MODULE$.hasDots().dots(value.vertices());
        }

        @Override
        public Option<DeltaSequence<A>> removeDots(DeltaSequence<A> value, Dots dots) {
            return HasDots$.MODULE$.apply(ReplicatedSet$.MODULE$.hasDots()).removeDots(value.vertices(), dots).map(arg_0 -> DeltaSequence$.rdts$datatypes$alternatives$rga$DeltaSequence$hasDots$$_$removeDots$$anonfun$1(value, arg_0));
        }
    }
}

