/*
 * Decompiled with CFR 0.152.
 */
package rdts.datatypes.experiments.protocols.raft;

import java.io.Serializable;
import rdts.base.Lattice$;
import rdts.base.LocalUid;
import rdts.base.Uid;
import rdts.base.Uid$;
import rdts.datatypes.contextual.ReplicatedSet;
import rdts.datatypes.contextual.ReplicatedSet$;
import rdts.datatypes.experiments.protocols.raft.RaftState;
import rdts.datatypes.experiments.protocols.raft.RaftState$;
import rdts.datatypes.experiments.protocols.raft.RaftToken;
import rdts.datatypes.experiments.protocols.raft.RaftToken$;
import rdts.datatypes.experiments.protocols.raft.RaftTokens$;
import rdts.dotted.Dotted;
import rdts.dotted.Dotted$;
import rdts.syntax.DeltaBuffer;
import rdts.time.Dots;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

public class RaftTokens
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RaftTokens.class.getDeclaredField("given_LocalUid$lzy1"));
    private final Uid replicaID;
    private final RaftState<RaftToken> tokenAgreement;
    private final DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> want;
    private final DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> tokenFreed;
    private volatile Object given_LocalUid$lzy1;

    public static RaftTokens apply(Uid uid, RaftState<RaftToken> raftState, DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer, DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2) {
        return RaftTokens$.MODULE$.apply(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public static RaftTokens fromProduct(Product product) {
        return RaftTokens$.MODULE$.fromProduct(product);
    }

    public static RaftTokens init(Uid uid) {
        return RaftTokens$.MODULE$.init(uid);
    }

    public static RaftTokens unapply(RaftTokens raftTokens) {
        return RaftTokens$.MODULE$.unapply(raftTokens);
    }

    public RaftTokens(Uid replicaID, RaftState<RaftToken> tokenAgreement, DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> want, DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> tokenFreed) {
        this.replicaID = replicaID;
        this.tokenAgreement = tokenAgreement;
        this.want = want;
        this.tokenFreed = tokenFreed;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RaftTokens)) return false;
        RaftTokens raftTokens = (RaftTokens)object;
        Uid uid = this.replicaID();
        Uid uid2 = raftTokens.replicaID();
        if (uid == null) {
            if (uid2 != null) {
                return false;
            }
        } else if (!((Object)uid).equals(uid2)) return false;
        RaftState<RaftToken> raftState = this.tokenAgreement();
        RaftState<RaftToken> raftState2 = raftTokens.tokenAgreement();
        if (raftState == null) {
            if (raftState2 != null) {
                return false;
            }
        } else if (!((Object)raftState).equals(raftState2)) return false;
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer = this.want();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2 = raftTokens.want();
        if (deltaBuffer == null) {
            if (deltaBuffer2 != null) {
                return false;
            }
        } else if (!((Object)deltaBuffer).equals(deltaBuffer2)) return false;
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer3 = this.tokenFreed();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer4 = raftTokens.tokenFreed();
        if (deltaBuffer3 == null) {
            if (deltaBuffer4 != null) {
                return false;
            }
        } else if (!((Object)deltaBuffer3).equals(deltaBuffer4)) return false;
        if (!raftTokens.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RaftTokens;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "RaftTokens";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "replicaID";
            }
            case 1: {
                return "tokenAgreement";
            }
            case 2: {
                return "want";
            }
            case 3: {
                return "tokenFreed";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Uid replicaID() {
        return this.replicaID;
    }

    public RaftState<RaftToken> tokenAgreement() {
        return this.tokenAgreement;
    }

    public DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> want() {
        return this.want;
    }

    public DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> tokenFreed() {
        return this.tokenFreed;
    }

    public final LocalUid given_LocalUid() {
        Object object = this.given_LocalUid$lzy1;
        if (object instanceof LocalUid) {
            return (LocalUid)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LocalUid)this.given_LocalUid$lzyINIT1();
    }

    private Object given_LocalUid$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_LocalUid$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LocalUid localUid = null;
                    try {
                        localUid = (LocalUid)Uid$.MODULE$.toLocal().convert((Object)this.replicaID());
                        object2 = localUid == null ? LazyVals.NullValue$.MODULE$ : localUid;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_LocalUid$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return localUid;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<RaftToken> owned(String value) {
        Set<RaftToken> freed = this.tokenFreed().state().data().elements();
        List owners = this.tokenAgreement().values().filter((Function1 & Serializable)t -> {
            String string = t.value();
            String string2 = value;
            return !(string != null ? !string.equals(string2) : string2 != null) && !freed.contains(t);
        });
        List mine = owners.filter((Function1 & Serializable)_$1 -> {
            Uid uid = _$1.owner();
            Uid uid2 = this.replicaID();
            return !(uid != null ? !((Object)uid).equals(uid2) : uid2 != null);
        });
        Option option2 = mine.headOption();
        Option option3 = owners.headOption();
        if (!(option2 != null ? !option2.equals(option3) : option3 != null)) {
            return mine;
        }
        return package$.MODULE$.Nil();
    }

    public boolean isOwned(String value) {
        return this.owned(value).nonEmpty();
    }

    public RaftTokens acquire(String value) {
        RaftToken token = RaftToken$.MODULE$.apply(Random$.MODULE$.nextLong(), this.replicaID(), value);
        if (!this.tokenAgreement().values().iterator().$plus$plus(this::acquire$$anonfun$1).exists((Function1 & Serializable)_$2 -> _$2.same(token))) {
            Dotted.lattice x$2$proxy1 = Dotted$.MODULE$.lattice(ReplicatedSet$.MODULE$.hasDots(), ReplicatedSet$.MODULE$.bottom(), ReplicatedSet$.MODULE$.lattice());
            Function1 & Serializable f$proxy1 = (Function1 & Serializable)_$3 -> (Function1 & Serializable)contextual$1 -> _$3.add(this.given_LocalUid(), token, (Dots)contextual$1);
            Dotted<ReplicatedSet<RaftToken>> Dotted_this = this.want().state();
            Function1 & Serializable f$proxy2 = (Function1 & Serializable)_$1 -> (Function1 & Serializable)contextual$1 -> (Dotted)((Function1)f$proxy1.apply(_$1)).apply(contextual$1);
            DeltaBuffer deltaBuffer = this.want().applyDelta((Dotted)((Function1)f$proxy2.apply(Dotted_this.data())).apply((Object)Dotted_this.context()), x$2$proxy1);
            Uid uid = this.copy$default$1();
            RaftState<RaftToken> raftState = this.copy$default$2();
            DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2 = this.copy$default$4();
            return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
        }
        return this;
    }

    public RaftTokens free(String value) {
        Dotted.lattice x$2$proxy2 = Dotted$.MODULE$.lattice(ReplicatedSet$.MODULE$.hasDots(), ReplicatedSet$.MODULE$.bottom(), ReplicatedSet$.MODULE$.lattice());
        Function1 & Serializable f$proxy3 = (Function1 & Serializable)_$4 -> (Function1 & Serializable)contextual$2 -> _$4.addAll(this.given_LocalUid(), this.owned(value), (Dots)contextual$2);
        Dotted<ReplicatedSet<RaftToken>> Dotted_this = this.tokenFreed().state();
        Function1 & Serializable f$proxy4 = (Function1 & Serializable)_$1 -> (Function1 & Serializable)contextual$1 -> (Dotted)((Function1)f$proxy3.apply(_$1)).apply(contextual$1);
        DeltaBuffer deltaBuffer = this.tokenFreed().applyDelta((Dotted)((Function1)f$proxy4.apply(Dotted_this.data())).apply((Object)Dotted_this.context()), x$2$proxy2);
        Uid uid = this.copy$default$1();
        RaftState<RaftToken> raftState = this.copy$default$2();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2 = this.copy$default$3();
        return this.copy(uid, raftState, deltaBuffer2, deltaBuffer);
    }

    public RaftTokens update() {
        RaftState<RaftToken> generalDuties = this.tokenAgreement().supportLeader(this.replicaID()).supportProposal(this.replicaID());
        Uid uid = this.tokenAgreement().leader();
        Uid uid2 = this.replicaID();
        if (!(uid != null ? !((Object)uid).equals(uid2) : uid2 != null)) {
            Dotted.lattice x$2$proxy3 = Dotted$.MODULE$.lattice(ReplicatedSet$.MODULE$.hasDots(), ReplicatedSet$.MODULE$.bottom(), ReplicatedSet$.MODULE$.lattice());
            Function1 & Serializable f$proxy5 = (Function1 & Serializable)_$5 -> (Function1 & Serializable)contextual$3 -> _$5.removeAll((Iterable)this.want().state().data().elements().filter((Function1 & Serializable)elem -> generalDuties.values().contains(elem)));
            Dotted<ReplicatedSet<RaftToken>> Dotted_this = this.want().state();
            Function1 & Serializable f$proxy6 = (Function1 & Serializable)_$1 -> (Function1 & Serializable)contextual$1 -> (Dotted)((Function1)f$proxy5.apply(_$1)).apply(contextual$1);
            DeltaBuffer unwanted = this.want().applyDelta((Dotted)((Function1)f$proxy6.apply(Dotted_this.data())).apply((Object)Dotted_this.context()), x$2$proxy3);
            Option option2 = ((ReplicatedSet)((Dotted)((Object)unwanted.state())).data()).elements().headOption();
            if (None$.MODULE$.equals(option2)) {
                return this.copy(this.copy$default$1(), generalDuties, unwanted, this.copy$default$4());
            }
            if (option2 instanceof Some) {
                RaftToken tok = (RaftToken)((Some)option2).value();
                RaftState<RaftToken> raftState = generalDuties.propose(this.replicaID(), tok);
                Uid uid3 = this.copy$default$1();
                DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer = this.copy$default$4();
                return this.copy(uid3, raftState, unwanted, deltaBuffer);
            }
            throw new MatchError((Object)option2);
        }
        return this.copy(this.copy$default$1(), generalDuties, this.copy$default$3(), this.copy$default$4());
    }

    public RaftTokens applyWant(Dotted<ReplicatedSet<RaftToken>> state) {
        DeltaBuffer deltaBuffer = this.want().applyDelta(state, Dotted$.MODULE$.lattice(ReplicatedSet$.MODULE$.hasDots(), ReplicatedSet$.MODULE$.bottom(), ReplicatedSet$.MODULE$.lattice()));
        Uid uid = this.copy$default$1();
        RaftState<RaftToken> raftState = this.copy$default$2();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2 = this.copy$default$4();
        return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public RaftTokens applyFree(Dotted<ReplicatedSet<RaftToken>> state) {
        DeltaBuffer deltaBuffer = this.tokenFreed().applyDelta(state, Dotted$.MODULE$.lattice(ReplicatedSet$.MODULE$.hasDots(), ReplicatedSet$.MODULE$.bottom(), ReplicatedSet$.MODULE$.lattice()));
        Uid uid = this.copy$default$1();
        RaftState<RaftToken> raftState = this.copy$default$2();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2 = this.copy$default$3();
        return this.copy(uid, raftState, deltaBuffer2, deltaBuffer);
    }

    public RaftTokens applyRaft(RaftState<RaftToken> state) {
        RaftState<RaftToken> raftState = Lattice$.MODULE$.merge(this.tokenAgreement(), state, RaftState$.MODULE$.raftLatticeInstance());
        Uid uid = this.copy$default$1();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer = this.copy$default$3();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2 = this.copy$default$4();
        return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public RaftTokens lead() {
        RaftState<RaftToken> raftState = this.tokenAgreement().becomeCandidate(this.replicaID());
        Uid uid = this.copy$default$1();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer = this.copy$default$3();
        DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> deltaBuffer2 = this.copy$default$4();
        return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public RaftTokens copy(Uid replicaID, RaftState<RaftToken> tokenAgreement, DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> want, DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> tokenFreed) {
        return new RaftTokens(replicaID, tokenAgreement, want, tokenFreed);
    }

    public Uid copy$default$1() {
        return this.replicaID();
    }

    public RaftState<RaftToken> copy$default$2() {
        return this.tokenAgreement();
    }

    public DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> copy$default$3() {
        return this.want();
    }

    public DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> copy$default$4() {
        return this.tokenFreed();
    }

    public Uid _1() {
        return this.replicaID();
    }

    public RaftState<RaftToken> _2() {
        return this.tokenAgreement();
    }

    public DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> _3() {
        return this.want();
    }

    public DeltaBuffer<Dotted<ReplicatedSet<RaftToken>>> _4() {
        return this.tokenFreed();
    }

    private final IterableOnce acquire$$anonfun$1() {
        return this.want().state().data().elements().iterator();
    }
}

