/*
 * Decompiled with CFR 0.152.
 */
package rdts.datatypes.contextual;

import java.io.Serializable;
import rdts.base.Bottom;
import rdts.base.Lattice;
import rdts.base.LocalUid;
import rdts.base.LocalUid$;
import rdts.datatypes.contextual.CausalQueue$;
import rdts.datatypes.contextual.CausalQueue$QueueElement$;
import rdts.dotted.Dotted;
import rdts.dotted.Dotted$;
import rdts.dotted.HasDots;
import rdts.time.Dot;
import rdts.time.Dots;
import rdts.time.Dots$;
import rdts.time.VectorClock;
import rdts.time.VectorClock$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class CausalQueue<T>
implements Product,
Serializable {
    private final Queue<QueueElement<T>> values;

    public static <T> CausalQueue<T> apply(Queue<QueueElement<T>> queue) {
        return CausalQueue$.MODULE$.apply(queue);
    }

    public static <T> Bottom<CausalQueue<T>> bottomInstance() {
        return CausalQueue$.MODULE$.bottomInstance();
    }

    public static <T> elementLattice<T> elementLattice() {
        return CausalQueue$.MODULE$.elementLattice();
    }

    public static <T> CausalQueue<T> empty() {
        return CausalQueue$.MODULE$.empty();
    }

    public static CausalQueue<?> fromProduct(Product product) {
        return CausalQueue$.MODULE$.fromProduct(product);
    }

    public static <A> hasDots<A> hasDots() {
        return CausalQueue$.MODULE$.hasDots();
    }

    public static <A> lattice<A> lattice() {
        return CausalQueue$.MODULE$.lattice();
    }

    public static <T> CausalQueue<T> unapply(CausalQueue<T> causalQueue) {
        return CausalQueue$.MODULE$.unapply(causalQueue);
    }

    public CausalQueue(Queue<QueueElement<T>> values) {
        this.values = values;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CausalQueue)) return false;
        CausalQueue causalQueue = (CausalQueue)object;
        Queue<QueueElement<T>> queue = this.values();
        Queue<QueueElement<T>> queue2 = causalQueue.values();
        if (queue == null) {
            if (queue2 != null) {
                return false;
            }
        } else if (!queue.equals(queue2)) return false;
        if (!causalQueue.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CausalQueue;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "CausalQueue";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "values";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Queue<QueueElement<T>> values() {
        return this.values;
    }

    public Dotted<CausalQueue<T>> enqueue(LocalUid x$1, T e, Dots context) {
        VectorClock time = context.clock().inc(LocalUid$.MODULE$.replicaId(x$1));
        Dot dot = time.dotOf(LocalUid$.MODULE$.replicaId(x$1));
        return Dotted$.MODULE$.apply(CausalQueue$.MODULE$.apply(Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QueueElement[]{CausalQueue$QueueElement$.MODULE$.apply(e, dot, time)}))), Dots$.MODULE$.single(dot));
    }

    public T head() {
        Object e;
        QueueElement queueElement = (QueueElement)this.values().head();
        QueueElement queueElement2 = CausalQueue$QueueElement$.MODULE$.unapply(queueElement);
        Object t = queueElement2._1();
        Dot dot = queueElement2._2();
        VectorClock vectorClock = queueElement2._3();
        Object e2 = e = t;
        return e2;
    }

    public Dotted<CausalQueue<T>> dequeue() {
        Dot dot;
        QueueElement queueElement = (QueueElement)this.values().head();
        QueueElement queueElement2 = CausalQueue$QueueElement$.MODULE$.unapply(queueElement);
        Object t = queueElement2._1();
        Dot dot2 = queueElement2._2();
        VectorClock vectorClock = queueElement2._3();
        Dot dot3 = dot = dot2;
        return Dotted$.MODULE$.apply(CausalQueue$.MODULE$.empty(), Dots$.MODULE$.single(dot3));
    }

    public Dotted<CausalQueue<T>> removeBy(Function1<T, Object> p) {
        Queue toRemove = (Queue)((StrictOptimizedIterableOps)this.values().filter((Function1 & Serializable)e -> BoxesRunTime.unboxToBoolean((Object)p.apply(e.value())))).map((Function1 & Serializable)_$1 -> _$1.dot());
        return Dotted$.MODULE$.apply(CausalQueue$.MODULE$.empty(), Dots$.MODULE$.from((Iterable<Dot>)toRemove));
    }

    public Queue<T> elements() {
        return (Queue)this.values().map((Function1 & Serializable)_$2 -> _$2.value());
    }

    public <T> CausalQueue<T> copy(Queue<QueueElement<T>> values) {
        return new CausalQueue<T>(values);
    }

    public <T> Queue<QueueElement<T>> copy$default$1() {
        return this.values();
    }

    public Queue<QueueElement<T>> _1() {
        return this.values();
    }

    public static class QueueElement<T>
    implements Product,
    Serializable {
        private final T value;
        private final Dot dot;
        private final VectorClock order;

        public static <T> QueueElement<T> apply(T t, Dot dot, VectorClock vectorClock) {
            return CausalQueue$QueueElement$.MODULE$.apply(t, dot, vectorClock);
        }

        public static QueueElement<?> fromProduct(Product product) {
            return CausalQueue$QueueElement$.MODULE$.fromProduct(product);
        }

        public static <T> QueueElement<T> unapply(QueueElement<T> queueElement) {
            return CausalQueue$QueueElement$.MODULE$.unapply(queueElement);
        }

        public QueueElement(T value, Dot dot, VectorClock order) {
            this.value = value;
            this.dot = dot;
            this.order = order;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueueElement)) return false;
            QueueElement queueElement = (QueueElement)object;
            if (!BoxesRunTime.equals(this.value(), queueElement.value())) return false;
            Dot dot = this.dot();
            Dot dot2 = queueElement.dot();
            if (dot == null) {
                if (dot2 != null) {
                    return false;
                }
            } else if (!((Object)dot).equals(dot2)) return false;
            VectorClock vectorClock = this.order();
            VectorClock vectorClock2 = queueElement.order();
            if (vectorClock == null) {
                if (vectorClock2 != null) {
                    return false;
                }
            } else if (!((Object)vectorClock).equals(vectorClock2)) return false;
            if (!queueElement.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QueueElement;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "QueueElement";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "value";
                }
                case 1: {
                    return "dot";
                }
                case 2: {
                    return "order";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public T value() {
            return this.value;
        }

        public Dot dot() {
            return this.dot;
        }

        public VectorClock order() {
            return this.order;
        }

        public <T> QueueElement<T> copy(T value, Dot dot, VectorClock order) {
            return new QueueElement<T>(value, dot, order);
        }

        public <T> T copy$default$1() {
            return this.value();
        }

        public <T> Dot copy$default$2() {
            return this.dot();
        }

        public <T> VectorClock copy$default$3() {
            return this.order();
        }

        public T _1() {
            return this.value();
        }

        public Dot _2() {
            return this.dot();
        }

        public VectorClock _3() {
            return this.order();
        }
    }

    public static class elementLattice<T>
    implements Lattice<QueueElement<T>> {
        public elementLattice() {
            Lattice.$init$(this);
        }

        @Override
        public QueueElement<T> merge(QueueElement<T> left, QueueElement<T> right) {
            if (left.order().$less(right.order())) {
                return right;
            }
            return left;
        }
    }

    public static class hasDots<A>
    implements HasDots<CausalQueue<A>> {
        public hasDots() {
            HasDots.$init$(this);
        }

        @Override
        public Dots dots(CausalQueue<A> value) {
            return Dots$.MODULE$.from((Iterable<Dot>)value.values().view().map(CausalQueue$::rdts$datatypes$contextual$CausalQueue$hasDots$$_$dots$$anonfun$1));
        }

        @Override
        public Option<CausalQueue<A>> removeDots(CausalQueue<A> value, Dots dots) {
            return Some$.MODULE$.apply(CausalQueue$.MODULE$.apply((Queue)value.values().filter(arg_0 -> CausalQueue$.rdts$datatypes$contextual$CausalQueue$hasDots$$_$removeDots$$anonfun$1(dots, arg_0))));
        }
    }

    public static class lattice<A>
    implements Lattice<CausalQueue<A>> {
        public lattice() {
            Lattice.$init$(this);
        }

        @Override
        public CausalQueue<A> merge(CausalQueue<A> left, CausalQueue<A> right) {
            return CausalQueue$.MODULE$.apply((Queue)((SeqOps)((SeqOps)left.values().concat(right.values())).sortBy(CausalQueue$::rdts$datatypes$contextual$CausalQueue$lattice$$_$merge$$anonfun$1, VectorClock$.MODULE$.vectorClockTotalOrdering())).distinct());
        }
    }
}

