/*
 * Decompiled with CFR 0.152.
 */
package reactives.core;

import java.io.Serializable;
import reactives.core.AdmissionTicket;
import reactives.core.DynamicScope;
import reactives.core.PlanTransactionScope$DynamicTransactionLookup$;
import reactives.core.PlanTransactionScope$StaticInTransaction$;
import reactives.core.ReSource;
import reactives.core.Scheduler;
import reactives.core.Transaction;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface PlanTransactionScope<State> {
    public void planTransaction(Seq<ReSource> var1, Function1<AdmissionTicket<State>, BoxedUnit> var2);

    public static class DynamicTransactionLookup<State>
    implements PlanTransactionScope<State>,
    Product,
    Serializable {
        private final Scheduler<State> scheduler;
        private final DynamicScope<State> dynamicScope;

        public static <State> DynamicTransactionLookup<State> apply(Scheduler<State> scheduler, DynamicScope<State> dynamicScope) {
            return PlanTransactionScope$DynamicTransactionLookup$.MODULE$.apply(scheduler, dynamicScope);
        }

        public static DynamicTransactionLookup<?> fromProduct(Product product) {
            return PlanTransactionScope$DynamicTransactionLookup$.MODULE$.fromProduct(product);
        }

        public static <State> DynamicTransactionLookup<State> unapply(DynamicTransactionLookup<State> dynamicTransactionLookup) {
            return PlanTransactionScope$DynamicTransactionLookup$.MODULE$.unapply(dynamicTransactionLookup);
        }

        public DynamicTransactionLookup(Scheduler<State> scheduler, DynamicScope<State> dynamicScope) {
            this.scheduler = scheduler;
            this.dynamicScope = dynamicScope;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DynamicTransactionLookup)) return false;
            DynamicTransactionLookup dynamicTransactionLookup = (DynamicTransactionLookup)object;
            Scheduler<State> scheduler = this.scheduler();
            Scheduler<State> scheduler2 = dynamicTransactionLookup.scheduler();
            if (scheduler == null) {
                if (scheduler2 != null) {
                    return false;
                }
            } else if (!scheduler.equals(scheduler2)) return false;
            DynamicScope<State> dynamicScope = this.dynamicScope();
            DynamicScope<State> dynamicScope2 = dynamicTransactionLookup.dynamicScope();
            if (dynamicScope == null) {
                if (dynamicScope2 != null) {
                    return false;
                }
            } else if (!dynamicScope.equals(dynamicScope2)) return false;
            if (!dynamicTransactionLookup.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DynamicTransactionLookup;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DynamicTransactionLookup";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "scheduler";
            }
            if (1 == n2) {
                return "dynamicScope";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Scheduler<State> scheduler() {
            return this.scheduler;
        }

        public DynamicScope<State> dynamicScope() {
            return this.dynamicScope;
        }

        @Override
        public void planTransaction(Seq<ReSource> inintialWrites, Function1<AdmissionTicket<State>, BoxedUnit> admission) {
            Option<Transaction<State>> option = this.dynamicScope().maybeTransaction();
            if (option instanceof Some) {
                Transaction tx = (Transaction)((Some)option).value();
                tx.followup(() -> this.scheduler().forceNewTransaction(inintialWrites, admission));
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.scheduler().forceNewTransaction(inintialWrites, admission);
                return;
            }
            throw new MatchError(option);
        }

        public <State> DynamicTransactionLookup<State> copy(Scheduler<State> scheduler, DynamicScope<State> dynamicScope) {
            return new DynamicTransactionLookup<State>(scheduler, dynamicScope);
        }

        public <State> Scheduler<State> copy$default$1() {
            return this.scheduler();
        }

        public <State> DynamicScope<State> copy$default$2() {
            return this.dynamicScope();
        }

        public Scheduler<State> _1() {
            return this.scheduler();
        }

        public DynamicScope<State> _2() {
            return this.dynamicScope();
        }
    }

    public static class StaticInTransaction<State>
    implements PlanTransactionScope<State>,
    Product,
    Serializable {
        private final Transaction<State> tx;
        private final Scheduler<State> scheduler;

        public static <State> StaticInTransaction<State> apply(Transaction<State> transaction, Scheduler<State> scheduler) {
            return PlanTransactionScope$StaticInTransaction$.MODULE$.apply(transaction, scheduler);
        }

        public static StaticInTransaction<?> fromProduct(Product product) {
            return PlanTransactionScope$StaticInTransaction$.MODULE$.fromProduct(product);
        }

        public static <State> StaticInTransaction<State> unapply(StaticInTransaction<State> staticInTransaction) {
            return PlanTransactionScope$StaticInTransaction$.MODULE$.unapply(staticInTransaction);
        }

        public StaticInTransaction(Transaction<State> tx, Scheduler<State> scheduler) {
            this.tx = tx;
            this.scheduler = scheduler;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StaticInTransaction)) return false;
            StaticInTransaction staticInTransaction = (StaticInTransaction)object;
            Transaction<State> transaction = this.tx();
            Transaction<State> transaction2 = staticInTransaction.tx();
            if (transaction == null) {
                if (transaction2 != null) {
                    return false;
                }
            } else if (!transaction.equals(transaction2)) return false;
            Scheduler<State> scheduler = this.scheduler();
            Scheduler<State> scheduler2 = staticInTransaction.scheduler();
            if (scheduler == null) {
                if (scheduler2 != null) {
                    return false;
                }
            } else if (!scheduler.equals(scheduler2)) return false;
            if (!staticInTransaction.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StaticInTransaction;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StaticInTransaction";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tx";
            }
            if (1 == n2) {
                return "scheduler";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Transaction<State> tx() {
            return this.tx;
        }

        public Scheduler<State> scheduler() {
            return this.scheduler;
        }

        @Override
        public void planTransaction(Seq<ReSource> inintialWrites, Function1<AdmissionTicket<State>, BoxedUnit> admission) {
            this.tx().followup(() -> this.scheduler().forceNewTransaction(inintialWrites, admission));
        }

        public <State> StaticInTransaction<State> copy(Transaction<State> tx, Scheduler<State> scheduler) {
            return new StaticInTransaction<State>(tx, scheduler);
        }

        public <State> Transaction<State> copy$default$1() {
            return this.tx();
        }

        public <State> Scheduler<State> copy$default$2() {
            return this.scheduler();
        }

        public Transaction<State> _1() {
            return this.tx();
        }

        public Scheduler<State> _2() {
            return this.scheduler();
        }
    }
}

