/*
 * Decompiled with CFR 0.152.
 */
package reactives.core;

import reactives.core.AccessHandler;
import reactives.core.DynamicTicket;
import reactives.core.Observation;
import reactives.core.ReSource;
import reactives.core.Result;
import reactives.core.Transaction;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;

public final class ReevTicket<State, V>
extends DynamicTicket<State>
implements Result<State, V> {
    private V _before;
    private final AccessHandler<State> accessHandler;
    private Set collectedDependencies;
    private boolean _propagate;
    private V value;
    private Observation effect;

    public ReevTicket(Transaction<State> tx2, V _before, AccessHandler<State> accessHandler) {
        this._before = _before;
        this.accessHandler = accessHandler;
        super(tx2);
        this.collectedDependencies = null;
        this._propagate = false;
        this.effect = null;
    }

    private V _before() {
        return this._before;
    }

    private void _before_$eq(V x$0) {
        this._before = x$0;
    }

    @Override
    public Object collectStatic(ReSource reactive) {
        if (this.collectedDependencies != null) {
            Set x$proxy1 = this.collectedDependencies;
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (!x$proxy1.contains((Object)reactive)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }
        return this.accessHandler.staticAccess(reactive);
    }

    @Override
    public Object collectDynamic(ReSource reactive) {
        if (this.collectedDependencies == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"may not access dynamic dependencies without tracking dependencies");
        }
        Set x$proxy2 = this.collectedDependencies;
        if (x$proxy2 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        Set updatedDeps = (Set)x$proxy2.$plus((Object)reactive);
        if (updatedDeps == this.collectedDependencies) {
            return this.accessHandler.staticAccess(reactive);
        }
        this.collectedDependencies = updatedDeps;
        return this.accessHandler.dynamicAccess(reactive);
    }

    public String toString() {
        return "Result(value = " + this.value + ", propagate = " + this.activate() + ", deps = " + this.collectedDependencies + ")";
    }

    public V before() {
        return this._before();
    }

    public ReevTicket<State, V> trackDependencies(Set<ReSource> initial) {
        this.collectedDependencies = initial;
        return this;
    }

    public ReevTicket<State, V> trackStatic() {
        this.collectedDependencies = null;
        return this;
    }

    public ReevTicket<State, V> withPropagate(boolean p) {
        this._propagate = p;
        return this;
    }

    public ReevTicket<State, V> withValue(V v) {
        Predef$.MODULE$.require(v != null, ReevTicket::withValue$$anonfun$1);
        this.value = v;
        this._propagate = true;
        return this;
    }

    public ReevTicket<State, V> withEffect(Observation v) {
        this.effect = v;
        return this;
    }

    @Override
    public boolean activate() {
        return this._propagate;
    }

    @Override
    public void forValue(Function1<V, BoxedUnit> f) {
        if (this.value != null) {
            f.apply(this.value);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEffect(Function1<Observation, BoxedUnit> f) {
        if (this.effect != null) {
            void var2_2;
            Observation x$proxy3 = this.effect;
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            f.apply((Object)var2_2);
            return;
        }
    }

    @Override
    public Option<Set<ReSource>> inputs() {
        return Option$.MODULE$.apply((Object)this.collectedDependencies);
    }

    public <NT> ReevTicket<State, NT> reset(NT nb) {
        this._propagate = false;
        this.value = null;
        this.effect = null;
        this.collectedDependencies = null;
        ReevTicket res = this;
        res._before_$eq(nb);
        return res;
    }

    private static final Object withValue$$anonfun$1() {
        return "value must not be null";
    }
}

