/*
 * Decompiled with CFR 0.152.
 */
package reactives.fullmv.mirrors;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import reactives.fullmv.FullMVUtil$notWorthToMoveToTaskpool$;
import reactives.fullmv.mirrors.Host$;
import reactives.fullmv.mirrors.Hosted;
import reactives.fullmv.mirrors.RemoteBlocked;
import reactives.fullmv.mirrors.RemoteBlocked$;
import reactives.fullmv.mirrors.RemoteGCd$;
import reactives.fullmv.mirrors.RemoteLocked;
import reactives.fullmv.mirrors.RemoteLocked$;
import reactives.fullmv.mirrors.RemoteSubsumed$;
import reactives.fullmv.mirrors.RemoteTryLockResult;
import reactives.fullmv.mirrors.RemoteTrySubsumeResult;
import reactives.fullmv.mirrors.SubsumableLockHost;
import reactives.fullmv.mirrors.SubsumableLockProxy;
import reactives.fullmv.sgt.synchronization.Blocked0$;
import reactives.fullmv.sgt.synchronization.GarbageCollected0$;
import reactives.fullmv.sgt.synchronization.LockStateResult0;
import reactives.fullmv.sgt.synchronization.Locked0$;
import reactives.fullmv.sgt.synchronization.SubsumableLock;
import reactives.fullmv.sgt.synchronization.Successful0$;
import reactives.fullmv.sgt.synchronization.TryLockResult0;
import reactives.fullmv.sgt.synchronization.TrySubsumeResult0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;

public class SubsumableLockReflection
implements SubsumableLockProxy,
Hosted,
SubsumableLock {
    private int hc;
    private AtomicInteger refCount;
    private final SubsumableLockHost host;
    private final long guid;
    private final SubsumableLockProxy proxy;

    public SubsumableLockReflection(SubsumableLockHost host, long guid, SubsumableLockProxy proxy) {
        this.host = host;
        this.guid = guid;
        this.proxy = proxy;
        Hosted.$init$(this);
        SubsumableLock.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public int hc() {
        return this.hc;
    }

    @Override
    public void reactives$fullmv$mirrors$Hosted$_setter_$hc_$eq(int x$0) {
        this.hc = x$0;
    }

    @Override
    public AtomicInteger refCount() {
        return this.refCount;
    }

    @Override
    public void reactives$fullmv$sgt$synchronization$SubsumableLock$_setter_$refCount_$eq(AtomicInteger x$0) {
        this.refCount = x$0;
    }

    @Override
    public SubsumableLockHost host() {
        return this.host;
    }

    @Override
    public long guid() {
        return this.guid;
    }

    public SubsumableLockProxy proxy() {
        return this.proxy;
    }

    @Override
    public Future<LockStateResult0> getLockedRoot() {
        return this.proxy().getLockedRoot();
    }

    @Override
    public Future<TryLockResult0> tryLock0(int hopCount) {
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " sending remote tryLock request"));
        }
        return this.proxy().remoteTryLock().map((Function1 & Serializable)x$1 -> {
            TryLockResult0 tryLockResult0;
            RemoteTryLockResult remoteTryLockResult = x$1;
            if (remoteTryLockResult instanceof RemoteLocked) {
                RemoteLocked remoteLocked = RemoteLocked$.MODULE$.unapply((RemoteLocked)remoteTryLockResult);
                SubsumableLock subsumableLock = remoteLocked._1();
                SubsumableLock lock = subsumableLock;
                if (lock == this) {
                    if (Host$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " locked remotely; adding " + hopCount + " new refs (retaining connection establishment reference as thread reference)"));
                    }
                    if (hopCount > 0) {
                        this.localAddRefs(hopCount);
                    }
                } else {
                    if (Host$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " locked remotely under new parent " + lock + ", passing " + (hopCount + 1) + " new refs"));
                    }
                    lock.localAddRefs(hopCount + 1);
                }
                tryLockResult0 = Locked0$.MODULE$.apply(0, lock);
            } else if (remoteTryLockResult instanceof RemoteBlocked) {
                RemoteBlocked remoteBlocked = RemoteBlocked$.MODULE$.unapply((RemoteBlocked)remoteTryLockResult);
                SubsumableLock subsumableLock = remoteBlocked._1();
                SubsumableLock lock = subsumableLock;
                if (lock == this) {
                    if (Host$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " blocked remotely; " + hopCount + " new refs (retaining connection establishment reference as thread reference)"));
                    }
                    if (hopCount > 0) {
                        this.localAddRefs(hopCount);
                    }
                } else {
                    if (Host$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " blocked remotely under new parent " + lock + ", passing " + (hopCount + 1) + " new refs (retaining connection establishment reference as thread reference)"));
                    }
                    lock.localAddRefs(hopCount + 1);
                }
                tryLockResult0 = Blocked0$.MODULE$.apply(0, lock);
            } else if (RemoteGCd$.MODULE$.equals(remoteTryLockResult)) {
                if (this.refCount().get() > 0) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("remote was gc'd while " + this + " still holds a reference"));
                }
                tryLockResult0 = GarbageCollected0$.MODULE$;
            } else {
                throw new MatchError((Object)remoteTryLockResult);
            }
            return tryLockResult0;
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public Future<TrySubsumeResult0> trySubsume0(int hopCount, SubsumableLock lockedNewParent) {
        SubsumableLock subsumableLock = lockedNewParent;
        SubsumableLockReflection subsumableLockReflection = this;
        if (!(subsumableLock != null ? !subsumableLock.equals(subsumableLockReflection) : subsumableLockReflection != null)) {
            if (lockedNewParent != this) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("instance caching broken? " + this + " came into contact with different reflection of same origin on same host"));
            }
            if (Host$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] trySubsume " + this + " to itself reentrant success; " + hopCount + " new refs (includes new thread reference)"));
            }
            if (hopCount > 0) {
                this.localAddRefs(hopCount);
            }
            return Future$.MODULE$.successful((Object)Successful0$.MODULE$.apply(0));
        }
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " sending remote trySubsume " + lockedNewParent + " request, adding remote parameter transfer reference"));
        }
        lockedNewParent.localAddRefs(1);
        return this.proxy().remoteTrySubsume(lockedNewParent).map((Function1 & Serializable)x$1 -> {
            TrySubsumeResult0 trySubsumeResult0;
            RemoteTrySubsumeResult remoteTrySubsumeResult = x$1;
            if (RemoteSubsumed$.MODULE$.equals(remoteTrySubsumeResult)) {
                if (Host$.MODULE$.DEBUG()) {
                    Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " remote trySubsume succeeded, sending " + (hopCount + 1) + " new refs to " + lockedNewParent));
                }
                lockedNewParent.localAddRefs(hopCount + 1);
                trySubsumeResult0 = Successful0$.MODULE$.apply(0);
            } else if (remoteTrySubsumeResult instanceof RemoteBlocked) {
                RemoteBlocked remoteBlocked = RemoteBlocked$.MODULE$.unapply((RemoteBlocked)remoteTrySubsumeResult);
                SubsumableLock subsumableLock = remoteBlocked._1();
                SubsumableLock newParent = subsumableLock;
                if (newParent == this) {
                    if (Host$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " remote trySubsume " + lockedNewParent + " blocked, " + hopCount + " new refs (retaining connection establishment reference as thread reference)"));
                    }
                    if (hopCount > 0) {
                        newParent.localAddRefs(hopCount);
                    }
                } else {
                    if (Host$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " remote trySubsume " + lockedNewParent + " blocked under new parent " + newParent + ", passing " + (hopCount + 1) + " refs (retaining connection establishment reference as thread reference)"));
                    }
                    newParent.localAddRefs(hopCount + 1);
                }
                trySubsumeResult0 = Blocked0$.MODULE$.apply(0, newParent);
            } else if (RemoteGCd$.MODULE$.equals(remoteTrySubsumeResult)) {
                if (this.refCount().get() > 0) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("remote was gc'd while " + this + " still holds a reference"));
                }
                trySubsumeResult0 = GarbageCollected0$.MODULE$;
            } else {
                throw new MatchError((Object)remoteTrySubsumeResult);
            }
            return trySubsumeResult0;
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public void asyncUnlock0() {
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " sending unlock request"));
        }
        this.proxy().remoteUnlock();
    }

    @Override
    public void remoteUnlock() {
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " passing through unlock request"));
        }
        this.proxy().remoteUnlock();
    }

    @Override
    public Future<RemoteTryLockResult> remoteTryLock() {
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " passing through tryLock request"));
        }
        return this.proxy().remoteTryLock().map((Function1 & Serializable)res -> {
            if (Host$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " passing through tryLock result " + res));
            }
            return res;
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public Future<RemoteTrySubsumeResult> remoteTrySubsume(SubsumableLock lockedNewParent) {
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " passing through trySubsume " + lockedNewParent + ", using parameter reference as connection establishment reference"));
        }
        return this.proxy().remoteTrySubsume(lockedNewParent).map((Function1 & Serializable)res -> {
            if (Host$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " passing through trySubsume " + lockedNewParent + " result " + res));
            }
            return res;
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public void dumped() {
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " no refs remaining, deallocating and dropping remote reference"));
        }
        this.proxy().asyncRemoteRefDropped();
    }

    public String toString() {
        int refs = this.refCount().get();
        return "SubsumableLockReflection(" + this.guid() + " on " + this.host() + ", " + (String)(refs <= 0 ? "gc'd" : BoxesRunTime.boxToInteger((int)refs).toString() + " refs") + ")";
    }
}

