/*
 * Decompiled with CFR 0.152.
 */
package reactives.core;

import reactives.core.InitialChange;
import reactives.core.ReSource;
import reactives.core.ReadAs;
import reactives.core.Transaction;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public final class AdmissionTicket<State> {
    private final Transaction<State> tx;
    private final Set<ReSource> declaredWrites;
    private Map<ReSource, InitialChange<State>> _initialChanges;
    private Function1 wrapUp;

    public AdmissionTicket(Transaction<State> tx, Set<ReSource> declaredWrites) {
        this.tx = tx;
        this.declaredWrites = declaredWrites;
        this._initialChanges = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.wrapUp = null;
    }

    public Transaction<State> tx() {
        return this.tx;
    }

    public Map<ReSource, InitialChange<State>> initialChanges() {
        return this._initialChanges;
    }

    public <T> void recordChange(InitialChange<State> ic) {
        if (!this.declaredWrites.contains((Object)ic.source())) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"must not set a source that has not been pre-declared for the transaction");
        }
        if (this._initialChanges.contains((Object)ic.source())) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"must not admit same source twice in one turn");
        }
        ReSource reSource = (ReSource)Predef$.MODULE$.ArrowAssoc((Object)ic.source());
        this._initialChanges = (Map)this._initialChanges.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)reSource, ic));
    }

    public <A> A now(ReadAs reactive) {
        return this.tx().now(reactive);
    }

    public Function1 wrapUp() {
        return this.wrapUp;
    }

    public void wrapUp_$eq(Function1 x$1) {
        this.wrapUp = x$1;
    }
}

