/*
 * Decompiled with CFR 0.152.
 */
package reactives.fullmv.sgt.synchronization;

import java.io.Serializable;
import reactives.fullmv.FullMVEngine;
import reactives.fullmv.FullMVTurn;
import reactives.fullmv.FullMVUtil$;
import reactives.fullmv.mirrors.Host$;
import reactives.fullmv.sgt.synchronization.Blocked$;
import reactives.fullmv.sgt.synchronization.Deallocated$;
import reactives.fullmv.sgt.synchronization.Locked;
import reactives.fullmv.sgt.synchronization.Locked$;
import reactives.fullmv.sgt.synchronization.SubsumableLock;
import reactives.fullmv.sgt.synchronization.Successful$;
import reactives.fullmv.sgt.synchronization.TryLockResult;
import reactives.fullmv.sgt.synchronization.TrySubsumeResult;
import reactives.parrp.Backoff;
import reactives.parrp.Backoff$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;

public final class SubsumableLockImpl$
implements Serializable {
    private static final boolean DEBUG;
    private static final Future<None$> futureNone;
    public static final SubsumableLockImpl$ MODULE$;

    private SubsumableLockImpl$() {
    }

    static {
        MODULE$ = new SubsumableLockImpl$();
        DEBUG = Host$.MODULE$.DEBUG();
        futureNone = Future$.MODULE$.successful((Object)None$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SubsumableLockImpl$.class);
    }

    public boolean DEBUG() {
        return DEBUG;
    }

    public <R> SubsumableLock acquireLock(FullMVTurn contender, Duration timeout) {
        if (this.DEBUG()) {
            System.out.println("[" + Thread.currentThread().getName() + "] syncing on SCC of " + contender);
        }
        Backoff bo = new Backoff(Backoff$.MODULE$.$lessinit$greater$default$1(), Backoff$.MODULE$.$lessinit$greater$default$2(), Backoff$.MODULE$.$lessinit$greater$default$3());
        return this.reTryLock$1(contender, timeout, bo);
    }

    public <R> Option<SubsumableLock> acquireLock(FullMVTurn defender, FullMVTurn contender, Duration timeout) {
        FullMVEngine fullMVEngine = defender.host();
        FullMVEngine fullMVEngine2 = contender.host();
        if (fullMVEngine == null ? fullMVEngine2 != null : !fullMVEngine.equals(fullMVEngine2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("trying to sync " + defender + " and " + contender + " from different hosts"));
        }
        if (this.DEBUG()) {
            System.out.println("[" + Thread.currentThread().getName() + "] syncing " + defender + " and " + contender + " into a common SCC");
        }
        Backoff bo = new Backoff(Backoff$.MODULE$.$lessinit$greater$default$1(), Backoff$.MODULE$.$lessinit$greater$default$2(), Backoff$.MODULE$.$lessinit$greater$default$3());
        return this.reTryLock$2(contender, timeout, defender, bo);
    }

    public Future<None$> futureNone() {
        return futureNone;
    }

    private final SubsumableLock reTryLock$1(FullMVTurn contender$1, Duration timeout$1, Backoff bo$1) {
        TryLockResult tryLockResult;
        while (true) {
            if ((tryLockResult = FullMVUtil$.MODULE$.myAwait(contender$1.tryLock(), timeout$1)) instanceof Locked) {
                SubsumableLock subsumableLock;
                Locked locked = Locked$.MODULE$.unapply((Locked)tryLockResult);
                SubsumableLock lockedRoot = subsumableLock = locked._1();
                if (this.DEBUG()) {
                    System.out.println("[" + Thread.currentThread().getName() + "] now owns SCC of " + contender$1 + " under " + lockedRoot);
                }
                return lockedRoot;
            }
            if (!Blocked$.MODULE$.equals(tryLockResult)) break;
            bo$1.backoff();
        }
        if (Deallocated$.MODULE$.equals(tryLockResult)) {
            throw new AssertionError((Object)"this should be impossible we're calling tryLock on the contender only, which cannot deallocate concurrently.");
        }
        throw new MatchError((Object)tryLockResult);
    }

    private final Option reTryLock$2(FullMVTurn contender$2, Duration timeout$2, FullMVTurn defender$1, Backoff bo$2) {
        TryLockResult tryLockResult;
        while (true) {
            if ((tryLockResult = FullMVUtil$.MODULE$.myAwait(contender$2.tryLock(), timeout$2)) instanceof Locked) {
                Locked locked = Locked$.MODULE$.unapply((Locked)tryLockResult);
                SubsumableLock subsumableLock = locked._1();
                SubsumableLock lockedRoot = subsumableLock;
                TrySubsumeResult trySubsumeResult = FullMVUtil$.MODULE$.myAwait(defender$1.trySubsume(lockedRoot), timeout$2);
                if (Successful$.MODULE$.equals(trySubsumeResult)) {
                    if (this.DEBUG()) {
                        System.out.println("[" + Thread.currentThread().getName() + "] now owns SCC of " + defender$1 + " and " + contender$2 + " under " + lockedRoot);
                    }
                    return Some$.MODULE$.apply((Object)lockedRoot);
                }
                if (Blocked$.MODULE$.equals(trySubsumeResult)) {
                    lockedRoot.asyncUnlock();
                    bo$2.backoff();
                    continue;
                }
                if (Deallocated$.MODULE$.equals(trySubsumeResult)) {
                    if (this.DEBUG()) {
                        System.out.println("[" + Thread.currentThread().getName() + "] aborting sync due to deallocation contention");
                    }
                    lockedRoot.asyncUnlock();
                    return None$.MODULE$;
                }
                throw new MatchError((Object)trySubsumeResult);
            }
            if (!Blocked$.MODULE$.equals(tryLockResult)) break;
            bo$2.backoff();
        }
        if (Deallocated$.MODULE$.equals(tryLockResult)) {
            throw new AssertionError((Object)"this should be impossible we're calling tryLock on the contender only, which cannot deallocate concurrently.");
        }
        throw new MatchError((Object)tryLockResult);
    }
}

