/*
 * Decompiled with CFR 0.152.
 */
package reactives.locking;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Iterator;
import reactives.locking.Key;
import reactives.locking.Keychain$;
import reactives.locking.ReLock;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public class Keychain<InterTurn> {
    private final long id;
    private final ArrayDeque<Key<InterTurn>> keys;
    private Map<Key<InterTurn>, Object> fallthrough;

    public static <IT> Keychain<IT> apply(Key<IT> key, long l) {
        return Keychain$.MODULE$.apply(key, l);
    }

    public Keychain(long id) {
        this.id = id;
        this.keys = new ArrayDeque(2);
        this.fallthrough = Predef$.MODULE$.Map().empty();
    }

    public long id() {
        return this.id;
    }

    public String toString() {
        return "Keychain(" + this.id() + ")";
    }

    public ArrayDeque<Key<InterTurn>> reactives$locking$Keychain$$keys() {
        return this.keys;
    }

    private Map<Key<InterTurn>, Object> fallthrough() {
        return this.fallthrough;
    }

    private void fallthrough_$eq(Map<Key<InterTurn>, Object> x$0) {
        this.fallthrough = x$0;
    }

    public void addFallthrough(Key<InterTurn> key, int amount) {
        Keychain keychain = this;
        synchronized (keychain) {
            this.fallthrough_$eq((Map)this.fallthrough().updated(key, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.fallthrough().getOrElse(key, Keychain::addFallthrough$$anonfun$1)) + amount))));
        }
    }

    public int addFallthrough$default$2() {
        return 1;
    }

    public void removeFallthrough(Key<InterTurn> key) {
        Keychain keychain = this;
        synchronized (keychain) {
            int old = BoxesRunTime.unboxToInt((Object)this.fallthrough().getOrElse(key, Keychain::$anonfun$1));
            if (old <= 1) {
                this.fallthrough_$eq((Map)this.fallthrough().$minus(key));
                v0 = BoxedUnit.UNIT;
            } else {
                this.fallthrough_$eq((Map)this.fallthrough().updated(key, (Object)BoxesRunTime.boxToInteger((int)(old - 1))));
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    public void append(Keychain<InterTurn> other) {
        if (this == other) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("tried to append " + this + " to itself"));
        }
        if (!Thread.holdsLock(this)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("tried to append " + this + " and " + other + " without holding lock on " + this));
        }
        if (!Thread.holdsLock(other)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("tried to append " + this + " and " + other + " without holding lock on " + other));
        }
        Iterator<Key<InterTurn>> it = other.reactives$locking$Keychain$$keys().iterator();
        while (it.hasNext()) {
            it.next().keychain_$eq(this);
        }
        super.fallthrough().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Key k = (Key)tuple2._1();
                int a = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.addFallthrough(k, a);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.reactives$locking$Keychain$$keys().addAll(other.reactives$locking$Keychain$$keys());
    }

    public void release(Key<InterTurn> key) {
        if (!Thread.holdsLock(this)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("tried to release " + key + " without holding " + this));
        }
        Key<InterTurn> head = this.reactives$locking$Keychain$$keys().poll();
        if (head != key) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("tried to drop " + key + " from " + this + " but is not head! (" + this.reactives$locking$Keychain$$keys() + ")"));
        }
        ArrayBuffer<ReLock<InterTurn>> locks = key.grabLocks();
        if (locks.toSet().size() != locks.size()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"duplicated locks detected");
        }
        if (this.reactives$locking$Keychain$$keys().isEmpty()) {
            locks.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.transfer(null, key, _$1.transfer$default$3()));
        } else {
            Key<InterTurn> target = this.reactives$locking$Keychain$$keys().peek();
            locks.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.transfer(target, key, this.fallthrough().nonEmpty()));
            this.fallthrough_$eq((Map)this.fallthrough().$minus(target));
            target.continue();
        }
        ArrayBuffer<ReLock<InterTurn>> arrayBuffer = locks;
        synchronized (arrayBuffer) {
            locks.clear();
        }
    }

    private static final int addFallthrough$$anonfun$1() {
        return 0;
    }

    private static final int $anonfun$1() {
        return 0;
    }
}

