/*
 * Decompiled with CFR 0.152.
 */
package reactives.locking;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import reactives.locking.Key;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public final class ReLock<InterTurn> {
    private final AtomicReference<Key<InterTurn>> owner = new AtomicReference();
    private final AtomicReference<Queue<Key<InterTurn>>> shared = new AtomicReference<Queue>(Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
    private boolean writeLock = true;

    public Key<InterTurn> getOwner() {
        return this.owner.get();
    }

    public boolean isWriteLock() {
        return this.writeLock;
    }

    public boolean isOwner(Key<InterTurn> key) {
        return this.owner.get() == key;
    }

    public Key<InterTurn> tryLock(Key<InterTurn> key, boolean write) {
        Key<InterTurn> current;
        do {
            if (!this.owner.compareAndSet(null, key)) continue;
            key.addLock(this);
            this.writeLock = write;
        } while ((current = this.owner.get()) == null);
        return current;
    }

    public boolean tryLock$default$2() {
        return true;
    }

    private <T> void transform(AtomicReference<T> v, Function1<T, T> f) {
        Object update;
        T old;
        while (!v.compareAndSet(old = v.get(), update = f.apply(old))) {
        }
    }

    public void share(Key<InterTurn> key) {
        this.transform(this.shared, (Function1 & Serializable)_$1 -> _$1.enqueue((Object)key));
    }

    public Key<InterTurn> acquired(Key<InterTurn> key) {
        this.transform(this.shared, (Function1 & Serializable)q -> {
            Tuple2 tuple2 = q.dequeue();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Key k = (Key)tuple2._1();
            Queue r = (Queue)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)k, (Object)r);
            Key k2 = (Key)tuple22._1();
            Queue r2 = (Queue)tuple22._2();
            Key key = k2;
            Key key2 = key;
            if (key == null ? key2 != null : !key.equals(key2)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("resolved await in wrong order got " + k2 + " expected " + key + " remaining " + r2));
            }
            return r2;
        });
        return key;
    }

    public void transfer(Key target, Key<InterTurn> oldOwner, boolean transferWriteSet) {
        Key trueTarget;
        this.writeLock = transferWriteSet && this.writeLock;
        Key key = trueTarget = !transferWriteSet && this.shared.get().isEmpty() ? null : target;
        if (!this.owner.compareAndSet(oldOwner, trueTarget)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " is held by " + this.owner + " but tried to transfer by " + oldOwner + " (to " + target + ")"));
        }
        if (trueTarget != null) {
            trueTarget.addLock(this);
            return;
        }
    }

    public boolean transfer$default$3() {
        return false;
    }
}

