/*
 * Decompiled with CFR 0.152.
 */
package reactives.fullmv.mirrors;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import reactives.fullmv.mirrors.CacheResult;
import reactives.fullmv.mirrors.Found$;
import reactives.fullmv.mirrors.Host;
import reactives.fullmv.mirrors.Host$;
import reactives.fullmv.mirrors.Instantiated$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public interface HostImpl<T>
extends Host<T> {
    public static void $init$(HostImpl $this) {
        $this.reactives$fullmv$mirrors$HostImpl$_setter_$instances_$eq(new ConcurrentHashMap());
    }

    public ConcurrentMap<Object, T> instances();

    public void reactives$fullmv$mirrors$HostImpl$_setter_$instances_$eq(ConcurrentMap var1);

    public static Option getInstance$(HostImpl $this, long guid) {
        return $this.getInstance(guid);
    }

    @Override
    default public Option<T> getInstance(long guid) {
        return Option$.MODULE$.apply(this.instances().get(BoxesRunTime.boxToLong((long)guid)));
    }

    public static CacheResult getCachedOrReceiveRemote$(HostImpl $this, long guid, Function0 instantiateReflection) {
        return $this.getCachedOrReceiveRemote(guid, instantiateReflection);
    }

    @Override
    default public <U extends T> CacheResult<T, U> getCachedOrReceiveRemote(long guid, Function0<U> instantiateReflection) {
        CacheResult cacheResult;
        Object known = this.findOrReserveInstance$1(guid);
        if (known != null) {
            if (Host$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] on " + this + " cache hit " + known));
            }
            cacheResult = Found$.MODULE$.apply(known);
        } else {
            if (Host$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] on " + this + " cache miss for " + guid + ", invoking instantiation..."));
            }
            Object instance = instantiateReflection.apply();
            boolean replaced = this.instances().replace(BoxesRunTime.boxToLong((long)guid), this.dummy(), instance);
            if (!replaced) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("someone stole the dummy placeholder while instantiating remotely received " + guid + " on " + this + "!"));
            }
            if (Host$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] on " + this + " cached newly instantiated " + instance));
            }
            cacheResult = Instantiated$.MODULE$.apply(instance);
        }
        return cacheResult;
    }

    public static void dropInstance$(HostImpl $this, long guid, Object instance) {
        $this.dropInstance(guid, instance);
    }

    @Override
    default public void dropInstance(long guid, T instance) {
        boolean removed = this.instances().remove(BoxesRunTime.boxToLong((long)guid), instance);
        if (!removed) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("removal of " + instance + " on " + this + " failed"));
        }
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] on " + this + " evicted " + instance));
            return;
        }
    }

    public static Object createLocal$(HostImpl $this, Function1 create) {
        return $this.createLocal(create);
    }

    @Override
    default public <U extends T> U createLocal(Function1<Object, U> create) {
        long guid = this.redoId$1();
        Object instance = create.apply((Object)BoxesRunTime.boxToLong((long)guid));
        boolean replaced = this.instances().replace(BoxesRunTime.boxToLong((long)guid), this.dummy(), instance);
        if (!replaced) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("someone stole the dummy placeholder while creating new instance " + guid + " on " + this + "!"));
        }
        if (Host$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] on " + this + " created local instance " + instance));
        }
        return (U)instance;
    }

    private Object findOrReserveInstance$1(long guid$1) {
        T found;
        while (BoxesRunTime.equals(found = this.instances().putIfAbsent(BoxesRunTime.boxToLong((long)guid$1), this.dummy()), this.dummy())) {
            if (Host$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] on " + this + " cache contended for " + guid$1));
            }
            Thread.yield();
        }
        return found;
    }

    private long redoId$1() {
        T known;
        long id;
        while ((id = ThreadLocalRandom.current().nextLong()) == Host$.MODULE$.dummyGuid() || (known = this.instances().putIfAbsent(BoxesRunTime.boxToLong((long)id), this.dummy())) != null) {
        }
        return id;
    }
}

