/*
 * Decompiled with CFR 0.152.
 */
package reactives.fullmv;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import reactives.core.InitialChange;
import reactives.core.Initializer;
import reactives.core.ReSource;
import reactives.fullmv.FullMVEngine;
import reactives.fullmv.FullMVState;
import reactives.fullmv.FullMVTurn;
import reactives.fullmv.FullMVTurnImpl$;
import reactives.fullmv.FullMVUtil$;
import reactives.fullmv.FullMVUtil$notWorthToMoveToTaskpool$;
import reactives.fullmv.MutableTransactionSpanningTreeNode;
import reactives.fullmv.TransactionSpanningTreeNode;
import reactives.fullmv.TurnPhase$;
import reactives.fullmv.mirrors.Hosted;
import reactives.fullmv.sgt.synchronization.Blocked$;
import reactives.fullmv.sgt.synchronization.Blocked0;
import reactives.fullmv.sgt.synchronization.Blocked0$;
import reactives.fullmv.sgt.synchronization.CompletedState$;
import reactives.fullmv.sgt.synchronization.ConcurrentDeallocation$;
import reactives.fullmv.sgt.synchronization.Deallocated$;
import reactives.fullmv.sgt.synchronization.GarbageCollected0$;
import reactives.fullmv.sgt.synchronization.LockStateResult;
import reactives.fullmv.sgt.synchronization.LockStateResult0;
import reactives.fullmv.sgt.synchronization.Locked$;
import reactives.fullmv.sgt.synchronization.Locked0;
import reactives.fullmv.sgt.synchronization.Locked0$;
import reactives.fullmv.sgt.synchronization.LockedState;
import reactives.fullmv.sgt.synchronization.LockedState$;
import reactives.fullmv.sgt.synchronization.SubsumableLock;
import reactives.fullmv.sgt.synchronization.SubsumableLockImpl$;
import reactives.fullmv.sgt.synchronization.Successful$;
import reactives.fullmv.sgt.synchronization.Successful0;
import reactives.fullmv.sgt.synchronization.Successful0$;
import reactives.fullmv.sgt.synchronization.TryLockResult;
import reactives.fullmv.sgt.synchronization.TryLockResult0;
import reactives.fullmv.sgt.synchronization.TrySubsumeResult;
import reactives.fullmv.sgt.synchronization.TrySubsumeResult0;
import reactives.fullmv.sgt.synchronization.UnlockedState$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class FullMVTurnImpl
implements Initializer,
Hosted,
FullMVTurn {
    private int hc;
    private ConcurrentHashMap waiters;
    private AtomicReference phaseReplicators;
    private AtomicReference predecessorReplicators;
    private final FullMVEngine host;
    private final long guid;
    private final Thread userlandThread;
    private Map<ReSource, InitialChange<FullMVState<Object, FullMVTurn>>> initialChanges;
    private AtomicInteger activeBranches;
    private volatile int phase;
    private final AtomicReference<SubsumableLock> subsumableLock;
    private List<FullMVTurn> successorsIncludingSelf;
    private volatile MutableTransactionSpanningTreeNode<FullMVTurn> selfNode;
    private volatile scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>> predecessorSpanningTreeNodes;
    private volatile int predecessorReplicationClock;

    public static long PARK_AFTER() {
        return FullMVTurnImpl$.MODULE$.PARK_AFTER();
    }

    public FullMVTurnImpl(FullMVEngine host, long guid, Thread userlandThread, SubsumableLock initialLock) {
        this.host = host;
        this.guid = guid;
        this.userlandThread = userlandThread;
        Hosted.$init$(this);
        FullMVTurn.$init$(this);
        this.activeBranches = new AtomicInteger(0);
        this.phase = TurnPhase$.MODULE$.Uninitialized();
        this.subsumableLock = new AtomicReference<SubsumableLock>(initialLock);
        this.successorsIncludingSelf = package$.MODULE$.Nil().$colon$colon((Object)this);
        this.selfNode = new MutableTransactionSpanningTreeNode<FullMVTurnImpl>(this);
        this.predecessorSpanningTreeNodes = new Map.Map1((Object)this, (Object)this.selfNode());
        this.predecessorReplicationClock = 0;
        Statics.releaseFence();
    }

    @Override
    public int hc() {
        return this.hc;
    }

    @Override
    public void reactives$fullmv$mirrors$Hosted$_setter_$hc_$eq(int x$0) {
        this.hc = x$0;
    }

    public ConcurrentHashMap waiters() {
        return this.waiters;
    }

    public AtomicReference phaseReplicators() {
        return this.phaseReplicators;
    }

    public AtomicReference predecessorReplicators() {
        return this.predecessorReplicators;
    }

    @Override
    public void reactives$fullmv$FullMVTurn$_setter_$waiters_$eq(ConcurrentHashMap x$0) {
        this.waiters = x$0;
    }

    @Override
    public void reactives$fullmv$FullMVTurn$_setter_$phaseReplicators_$eq(AtomicReference x$0) {
        this.phaseReplicators = x$0;
    }

    @Override
    public void reactives$fullmv$FullMVTurn$_setter_$predecessorReplicators_$eq(AtomicReference x$0) {
        this.predecessorReplicators = x$0;
    }

    @Override
    public FullMVEngine host() {
        return this.host;
    }

    @Override
    public long guid() {
        return this.guid;
    }

    public Thread userlandThread() {
        return this.userlandThread;
    }

    public Map<ReSource, InitialChange<FullMVState<Object, FullMVTurn>>> initialChanges() {
        return this.initialChanges;
    }

    public void initialChanges_$eq(Map<ReSource, InitialChange<FullMVState<Object, FullMVTurn>>> x$1) {
        this.initialChanges = x$1;
    }

    public AtomicInteger activeBranches() {
        return this.activeBranches;
    }

    public void activeBranches_$eq(AtomicInteger x$1) {
        this.activeBranches = x$1;
    }

    @Override
    public int phase() {
        return this.phase;
    }

    public void phase_$eq(int x$1) {
        this.phase = x$1;
    }

    public AtomicReference<SubsumableLock> subsumableLock() {
        return this.subsumableLock;
    }

    public List<FullMVTurn> successorsIncludingSelf() {
        return this.successorsIncludingSelf;
    }

    public void successorsIncludingSelf_$eq(List<FullMVTurn> x$1) {
        this.successorsIncludingSelf = x$1;
    }

    public MutableTransactionSpanningTreeNode<FullMVTurn> selfNode() {
        return this.selfNode;
    }

    public void selfNode_$eq(MutableTransactionSpanningTreeNode<FullMVTurn> x$1) {
        this.selfNode = x$1;
    }

    public scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>> predecessorSpanningTreeNodes() {
        return this.predecessorSpanningTreeNodes;
    }

    public void predecessorSpanningTreeNodes_$eq(scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>> x$1) {
        this.predecessorSpanningTreeNodes = x$1;
    }

    @Override
    public void ensurePredecessorReplication(TransactionSpanningTreeNode<FullMVTurn> startAt, int clock) {
        if (clock > this.predecessorReplicationClock()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"recevied newer predecessors from a remote copy?");
        }
    }

    @Override
    public void asyncRemoteBranchComplete(int forPhase) {
        if (FullMVUtil$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " branch on some remote completed"));
        }
        this.activeBranchDifferential(forPhase, -1);
    }

    @Override
    public void activeBranchDifferential(int forState, int differential) {
        if (this.phase() != forState) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " received branch differential for wrong state " + TurnPhase$.MODULE$.toString(forState)));
        }
        if (differential == 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " received 0 branch diff"));
        }
        if (this.activeBranches().get() + differential < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " received branch diff into negative count"));
        }
        int remaining = this.activeBranches().addAndGet(differential);
        if (remaining == 0) {
            LockSupport.unpark(this.userlandThread());
            return;
        }
    }

    @Override
    public void newBranchFromRemote(int forPhase) {
        if (this.phase() != forPhase) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " received branch differential for wrong state " + TurnPhase$.MODULE$.toString(forPhase)));
        }
        if (FullMVUtil$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " new branch on remote is actually loop-back to local"));
            return;
        }
    }

    @Override
    public Future<BoxedUnit> addRemoteBranch(int forPhase) {
        if (this.phase() != forPhase) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " received branch differential for wrong state " + TurnPhase$.MODULE$.toString(forPhase)));
        }
        if (FullMVUtil$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " new branch on some remote"));
        }
        this.activeBranches().getAndIncrement();
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void awaitAndSwitchPhase(int newPhase) {
        if (newPhase <= this.phase()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " cannot progress backwards to phase " + newPhase + "."));
        }
        this.awaitAndSwitchPhase0$1(newPhase, 0, 0L, null);
        this.wakeWaitersAfterPhaseSwitch(newPhase);
        ((List)this.phaseReplicators().get()).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.asyncNewPhase(newPhase));
        if (FullMVUtil$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " switched phase."));
            return;
        }
    }

    private void awaitBranchCountZero() {
        while (this.activeBranches().get() > 0) {
            LockSupport.park(this);
        }
    }

    private void beginPhase(int phase) {
        if (this.phase() != TurnPhase$.MODULE$.Uninitialized()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " already begun"));
        }
        if (this.activeBranches().get() != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " cannot begin " + phase + ": " + this.activeBranches().get() + " branches active!"));
        }
        if (((MutableTransactionSpanningTreeNode)this.selfNode()).size() != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " cannot begin " + phase + ": already has predecessors!"));
        }
        this.phase_$eq(phase);
        if (FullMVUtil$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " begun."));
            return;
        }
    }

    public void beginFraming() {
        this.beginPhase(TurnPhase$.MODULE$.Framing());
    }

    public void beginExecuting() {
        this.beginPhase(TurnPhase$.MODULE$.Executing());
    }

    public void completeFraming() {
        if (this.phase() != TurnPhase$.MODULE$.Framing()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " cannot complete framing: Not in framing phase"));
        }
        this.awaitAndSwitchPhase(TurnPhase$.MODULE$.Executing());
    }

    public void completeExecuting() {
        if (this.phase() != TurnPhase$.MODULE$.Executing()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " cannot complete executing: Not in executing phase"));
        }
        this.awaitAndSwitchPhase(TurnPhase$.MODULE$.Completed());
        this.phaseReplicators().set(null);
        this.predecessorReplicators().set(null);
        this.predecessorSpanningTreeNodes_$eq((scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>>)Predef$.MODULE$.Map().empty());
        this.successorsIncludingSelf_$eq(null);
        this.selfNode_$eq(null);
        SubsumableLock l = this.subsumableLock().getAndSet(null);
        if (SubsumableLockImpl$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " deallocating, dropping reference on " + l + "."));
        }
        l.localSubRefs(1);
        this.host().dropInstance(this.guid(), this);
    }

    @Override
    public boolean isTransitivePredecessor(FullMVTurn txn) {
        FullMVEngine fullMVEngine = txn.host();
        FullMVEngine fullMVEngine2 = this.host();
        if (fullMVEngine == null ? fullMVEngine2 != null : !fullMVEngine.equals(fullMVEngine2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("predecessor query for " + txn + " before " + this + " is hosted on " + txn.host() + " different from " + this.host()));
        }
        return this.predecessorSpanningTreeNodes().contains((Object)txn);
    }

    @Override
    public final Future<Object> acquireRemoteBranchIfPhaseAtMost(int maxPhase) {
        int pOptimistic;
        while ((pOptimistic = this.phase()) <= maxPhase) {
            int before = this.activeBranches().get();
            if (before != 0 && this.activeBranches().compareAndSet(before, before + 1)) {
                int pSecure = this.phase();
                if (pSecure > maxPhase) {
                    this.asyncRemoteBranchComplete(pSecure);
                }
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)pSecure));
            }
            Thread.yield();
        }
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)pOptimistic));
    }

    @Override
    public Future<Object> addPredecessor(TransactionSpanningTreeNode<FullMVTurn> predecessorSpanningTree) {
        FullMVTurn predecessor = predecessorSpanningTree.txn();
        if (predecessor.phase() == TurnPhase$.MODULE$.Completed()) {
            if (FullMVUtil$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " aborting predecessor addition of known completed " + predecessor));
            }
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (this.isTransitivePredecessor(predecessor)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("attempted to establish already existing predecessor relation " + predecessor + " -> " + this));
        }
        if (FullMVUtil$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " adding predecessor " + predecessor + "."));
        }
        return FullMVUtil$.MODULE$.broadcast(this.successorsIncludingSelf(), (Function1 & Serializable)_$2 -> _$2.maybeNewReachableSubtree(this, predecessorSpanningTree)).map((Function1 & Serializable)_$3 -> predecessor.phase() == TurnPhase$.MODULE$.Completed(), (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    public int predecessorReplicationClock() {
        return this.predecessorReplicationClock;
    }

    public void predecessorReplicationClock_$eq(int x$1) {
        this.predecessorReplicationClock = x$1;
    }

    @Override
    public Future<BoxedUnit> maybeNewReachableSubtree(FullMVTurn attachBelow, TransactionSpanningTreeNode<FullMVTurn> spanningSubTreeRoot) {
        if (!this.isTransitivePredecessor(spanningSubTreeRoot.txn())) {
            List<Future<BoxedUnit>> incompleteCallsAccumulator = FullMVUtil$.MODULE$.newAccumulator();
            Tuple2<scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>>, List<Future<BoxedUnit>>> tuple2 = this.copySubTreeRootAndAssessChildren(this.predecessorSpanningTreeNodes(), attachBelow, spanningSubTreeRoot, incompleteCallsAccumulator);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Map updatedTree = (scala.collection.immutable.Map)tuple2._1();
            List updatedAccu = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)updatedTree, (Object)updatedAccu);
            scala.collection.immutable.Map updatedTree2 = (scala.collection.immutable.Map)tuple22._1();
            List updatedAccu2 = (List)tuple22._2();
            this.predecessorSpanningTreeNodes_$eq((scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>>)updatedTree2);
            int clock = this.predecessorReplicationClock() + 1;
            this.predecessorReplicationClock_$eq(clock);
            List updated2Accu = FullMVUtil$.MODULE$.accumulateBroadcastFutures(updatedAccu2, (Iterable)this.predecessorReplicators().get(), (Function1 & Serializable)_$4 -> _$4.newPredecessors(this.selfNode(), clock));
            return FullMVUtil$.MODULE$.condenseCallResults((Iterable<Future<BoxedUnit>>)updated2Accu);
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    @Override
    public Tuple2<TransactionSpanningTreeNode<FullMVTurn>, Object> clockedPredecessors() {
        return Tuple2$.MODULE$.apply((Object)this.selfNode(), (Object)BoxesRunTime.boxToInteger((int)this.predecessorReplicationClock()));
    }

    private Tuple2<scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>>, List<Future<BoxedUnit>>> copySubTreeRootAndAssessChildren(scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>> bufferPredecessorSpanningTreeNodes, FullMVTurn attachBelow, TransactionSpanningTreeNode<FullMVTurn> spanningSubTreeRoot, List<Future<BoxedUnit>> newSuccessorCallsAccumulator) {
        FullMVTurn newTransitivePredecessor = spanningSubTreeRoot.txn();
        FullMVEngine fullMVEngine = newTransitivePredecessor.host();
        FullMVEngine fullMVEngine2 = this.host();
        if (fullMVEngine == null ? fullMVEngine2 != null : !fullMVEngine.equals(fullMVEngine2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("new predecessor " + newTransitivePredecessor + " of " + this + " is hosted on " + newTransitivePredecessor.host() + " different from " + this.host()));
        }
        if (newTransitivePredecessor.phase() != TurnPhase$.MODULE$.Completed()) {
            Future<BoxedUnit> newSuccessorCall = newTransitivePredecessor.newSuccessor(this);
            List updatedAccu = FullMVUtil$.MODULE$.accumulateFuture(newSuccessorCallsAccumulator, newSuccessorCall);
            MutableTransactionSpanningTreeNode<FullMVTurn> copiedSpanningTreeNode = new MutableTransactionSpanningTreeNode<FullMVTurn>(newTransitivePredecessor);
            FullMVTurn fullMVTurn = (FullMVTurn)Predef$.MODULE$.ArrowAssoc((Object)newTransitivePredecessor);
            scala.collection.immutable.Map updatedBufferPredecessorSpanningTreeNodes = (scala.collection.immutable.Map)bufferPredecessorSpanningTreeNodes.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)fullMVTurn, copiedSpanningTreeNode));
            ((MutableTransactionSpanningTreeNode)updatedBufferPredecessorSpanningTreeNodes.apply((Object)attachBelow)).addChild(copiedSpanningTreeNode);
            Iterator<TransactionSpanningTreeNode<FullMVTurn>> it = spanningSubTreeRoot.iterator();
            while (it.hasNext()) {
                TransactionSpanningTreeNode<FullMVTurn> child = it.next();
                if (this.isTransitivePredecessor(child.txn())) continue;
                Tuple2<scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>>, List<Future<BoxedUnit>>> tuple2 = this.copySubTreeRootAndAssessChildren((scala.collection.immutable.Map<FullMVTurn, MutableTransactionSpanningTreeNode<FullMVTurn>>)updatedBufferPredecessorSpanningTreeNodes, newTransitivePredecessor, child, newSuccessorCallsAccumulator);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                scala.collection.immutable.Map updated2Buffer = (scala.collection.immutable.Map)tuple2._1();
                List updated2Accu = (List)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)updated2Buffer, (Object)updated2Accu);
                scala.collection.immutable.Map updated2Buffer2 = (scala.collection.immutable.Map)tuple22._1();
                List updated2Accu2 = (List)tuple22._2();
                updatedBufferPredecessorSpanningTreeNodes = updated2Buffer2;
                updatedAccu = updated2Accu2;
            }
            return Tuple2$.MODULE$.apply((Object)updatedBufferPredecessorSpanningTreeNodes, updatedAccu);
        }
        return Tuple2$.MODULE$.apply(bufferPredecessorSpanningTreeNodes, newSuccessorCallsAccumulator);
    }

    @Override
    public Future<BoxedUnit> newSuccessor(FullMVTurn successor) {
        FullMVEngine fullMVEngine = successor.host();
        FullMVEngine fullMVEngine2 = this.host();
        if (fullMVEngine == null ? fullMVEngine2 != null : !fullMVEngine.equals(fullMVEngine2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("new successor " + successor + " of " + this + " is hosted on " + successor.host() + " different from " + this.host()));
        }
        List<FullMVTurn> before = this.successorsIncludingSelf();
        if (before != null) {
            this.successorsIncludingSelf_$eq((List<FullMVTurn>)before.$colon$colon((Object)successor));
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    @Override
    public Future<LockStateResult> getLockedRoot() {
        SubsumableLock l = this.subsumableLock().get();
        if (l == null) {
            if (this.phase() != TurnPhase$.MODULE$.Completed()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("lock was deallocated although " + this + " is still active?"));
            }
            return CompletedState$.MODULE$.futured();
        }
        return l.getLockedRoot().flatMap((Function1 & Serializable)x$1 -> {
            LockStateResult0 lockStateResult0 = x$1;
            if (lockStateResult0 instanceof LockedState) {
                long l;
                LockedState lockedState = (LockedState)lockStateResult0;
                LockedState lockedState2 = LockedState$.MODULE$.unapply(lockedState);
                long lock = l = lockedState2._1();
                LockedState x = lockedState;
                return Future$.MODULE$.successful((Object)x);
            }
            if (UnlockedState$.MODULE$.equals(lockStateResult0)) {
                return UnlockedState$.MODULE$.futured();
            }
            if (ConcurrentDeallocation$.MODULE$.equals(lockStateResult0)) {
                return this.getLockedRoot();
            }
            throw new MatchError((Object)lockStateResult0);
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public Future<TryLockResult> tryLock() {
        if (SubsumableLockImpl$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " dispatching local tryLock request"));
        }
        return this.tryLock0(0);
    }

    public Future<TryLockResult> tryLock0(int hopCount) {
        SubsumableLock l = this.subsumableLock().get();
        if (l == null) {
            return Deallocated$.MODULE$.futured();
        }
        return l.tryLock0(hopCount).flatMap((Function1 & Serializable)x$1 -> {
            TryLockResult0 tryLockResult0 = x$1;
            if (tryLockResult0 instanceof Locked0) {
                Locked0 locked0 = Locked0$.MODULE$.unapply((Locked0)tryLockResult0);
                int n = locked0._1();
                SubsumableLock subsumableLock = locked0._2();
                int failedRefChanges = n;
                SubsumableLock newLockedRoot = subsumableLock;
                int finalFailedRefChanges = failedRefChanges + this.trySwap(l, newLockedRoot);
                if (SubsumableLockImpl$.MODULE$.DEBUG()) {
                    Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " tryLocked " + newLockedRoot + ", correcting " + finalFailedRefChanges + " failed ref changes (thread reference is retained and passed out)"));
                }
                if (finalFailedRefChanges > 0) {
                    newLockedRoot.localSubRefs(finalFailedRefChanges);
                }
                return Future$.MODULE$.successful((Object)Locked$.MODULE$.apply(newLockedRoot));
            }
            if (tryLockResult0 instanceof Blocked0) {
                Blocked0 blocked0 = Blocked0$.MODULE$.unapply((Blocked0)tryLockResult0);
                int n = blocked0._1();
                SubsumableLock subsumableLock = blocked0._2();
                int failedRefChanges = n;
                SubsumableLock newRoot = subsumableLock;
                int finalFailedRefChanges = 1 + failedRefChanges + this.trySwap(l, newRoot);
                if (SubsumableLockImpl$.MODULE$.DEBUG()) {
                    Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " tryLock blocked under " + newRoot + ", correcting " + finalFailedRefChanges + " failed ref changes (includes thread reference)"));
                }
                newRoot.localSubRefs(finalFailedRefChanges);
                return Blocked$.MODULE$.futured();
            }
            if (GarbageCollected0$.MODULE$.equals(tryLockResult0)) {
                SubsumableLock subsumableLock = this.subsumableLock().get();
                SubsumableLock subsumableLock2 = l;
                if (!(subsumableLock != null ? !subsumableLock.equals(subsumableLock2) : subsumableLock2 != null)) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)(l + " tryLock returned GC'd although it is still referenced"));
                }
                return this.tryLock0(hopCount);
            }
            throw new MatchError((Object)tryLockResult0);
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public Future<TrySubsumeResult> trySubsume(SubsumableLock lockedNewParent) {
        if (SubsumableLockImpl$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " dispatching local trySubsume " + lockedNewParent + " request"));
        }
        return this.trySubsume0(0, lockedNewParent);
    }

    private Future<TrySubsumeResult> trySubsume0(int hopCount, SubsumableLock lockedNewParent) {
        SubsumableLock l = this.subsumableLock().get();
        if (l == null) {
            return Deallocated$.MODULE$.futured();
        }
        return l.trySubsume0(hopCount, lockedNewParent).flatMap((Function1 & Serializable)x$1 -> {
            TrySubsumeResult0 trySubsumeResult0 = x$1;
            if (trySubsumeResult0 instanceof Successful0) {
                int n;
                Successful0 successful0 = Successful0$.MODULE$.unapply((Successful0)trySubsumeResult0);
                int failedRefChanges = n = successful0._1();
                int finalFailedRefChanges = failedRefChanges + this.trySwap(l, lockedNewParent);
                if (SubsumableLockImpl$.MODULE$.DEBUG()) {
                    Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " trySubsumed under " + lockedNewParent + ", correcting " + finalFailedRefChanges + " failed ref changes"));
                }
                if (finalFailedRefChanges > 0) {
                    lockedNewParent.localSubRefs(finalFailedRefChanges);
                }
                return Successful$.MODULE$.futured();
            }
            if (trySubsumeResult0 instanceof Blocked0) {
                Blocked0 blocked0 = Blocked0$.MODULE$.unapply((Blocked0)trySubsumeResult0);
                int n = blocked0._1();
                SubsumableLock subsumableLock = blocked0._2();
                int failedRefChanges = n;
                SubsumableLock newRoot = subsumableLock;
                int finalFailedRefChanges = 1 + failedRefChanges + this.trySwap(l, newRoot);
                if (SubsumableLockImpl$.MODULE$.DEBUG()) {
                    Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " trySubsume blocked under " + newRoot + ", correcting " + finalFailedRefChanges + " failed ref changes (includes thread reference)"));
                }
                newRoot.localSubRefs(finalFailedRefChanges);
                return Blocked$.MODULE$.futured();
            }
            if (GarbageCollected0$.MODULE$.equals(trySubsumeResult0)) {
                SubsumableLock subsumableLock = this.subsumableLock().get();
                SubsumableLock subsumableLock2 = l;
                if (!(subsumableLock != null ? !subsumableLock.equals(subsumableLock2) : subsumableLock2 != null)) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)(l + " trySubsume returned GC'd although it is still referenced"));
                }
                return this.trySubsume0(hopCount, lockedNewParent);
            }
            throw new MatchError((Object)trySubsumeResult0);
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public Future<TryLockResult> remoteTryLock() {
        if (SubsumableLockImpl$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " dispatching remote tryLock request"));
        }
        return this.tryLock0(0).map((Function1 & Serializable)res -> {
            if (SubsumableLockImpl$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " returning tryLock result " + res + " to remote (retaining thread reference as remote transfer reference)"));
            }
            return res;
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    @Override
    public Future<TrySubsumeResult> remoteTrySubsume(SubsumableLock lockedNewParent) {
        if (SubsumableLockImpl$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " dispatching remote trySubsume " + lockedNewParent + " request"));
        }
        return this.trySubsume0(0, lockedNewParent).map((Function1 & Serializable)res -> {
            if (SubsumableLockImpl$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " returning trySubsume " + lockedNewParent + " request to remote, dropping remote parameter reference and retaining thread reference as remote transfer reference on result"));
            }
            lockedNewParent.localSubRefs(1);
            return res;
        }, (ExecutionContext)FullMVUtil$notWorthToMoveToTaskpool$.MODULE$);
    }

    private int trySwap(SubsumableLock from, SubsumableLock to) {
        SubsumableLock subsumableLock = from;
        SubsumableLock subsumableLock2 = to;
        if (!(subsumableLock != null ? !subsumableLock.equals(subsumableLock2) : subsumableLock2 != null)) {
            return 0;
        }
        if (this.subsumableLock().compareAndSet(from, to)) {
            if (SubsumableLockImpl$.MODULE$.DEBUG()) {
                Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " parent cas " + from + " to " + to + " succeeded, dropping ref"));
            }
            from.localSubRefs(1);
            return 0;
        }
        if (SubsumableLockImpl$.MODULE$.DEBUG()) {
            Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " parent cas " + from + " to " + to + " failed due to contention"));
        }
        return 1;
    }

    public String toString() {
        return "FullMVTurn(" + this.guid() + " on " + this.host() + ", " + TurnPhase$.MODULE$.toString(this.phase()) + (String)(this.activeBranches().get() != 0 ? "(" + this.activeBranches().get() + ")" : "") + ")";
    }

    private final void awaitAndSwitchPhase0$1(int newPhase$1, int firstUnknownPredecessorIndex, long parkAfter, FullMVTurn registeredForWaiting) {
        while (true) {
            if (this.activeBranches().get() > 0) {
                if (registeredForWaiting != null) {
                    registeredForWaiting.waiters().remove(this.userlandThread());
                }
                this.awaitBranchCountZero();
                long l = 0L;
                Object var8_6 = null;
                parkAfter = l;
                registeredForWaiting = var8_6;
                continue;
            }
            if (firstUnknownPredecessorIndex == ((MutableTransactionSpanningTreeNode)this.selfNode()).size()) {
                if (registeredForWaiting != null) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)(this + " is still registered on " + registeredForWaiting + " as waiter despite having finished waiting for it"));
                }
                if (firstUnknownPredecessorIndex == ((MutableTransactionSpanningTreeNode)this.selfNode()).size()) {
                    if (this.activeBranches().get() != 0) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)"should be impossible to regain a branch at this point");
                    }
                    this.phase_$eq(newPhase$1);
                    return;
                }
                long l = 0L;
                Object var11_8 = null;
                parkAfter = l;
                registeredForWaiting = var11_8;
                continue;
            }
            FullMVTurn currentUnknownPredecessor = (FullMVTurn)((MutableTransactionSpanningTreeNode)this.selfNode()).children()[firstUnknownPredecessorIndex].txn();
            if (currentUnknownPredecessor.phase() < newPhase$1) {
                long parkAfter2;
                if (registeredForWaiting != null) {
                    if (FullMVUtil$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " parking for " + currentUnknownPredecessor + "."));
                    }
                    long timeBefore = System.nanoTime();
                    LockSupport.parkNanos(currentUnknownPredecessor, 10000000000L);
                    if (System.nanoTime() - timeBefore > 7500000000L) {
                        throw new Exception(this.activeBranches().get() == 0 && currentUnknownPredecessor.phase() < newPhase$1 ? Thread.currentThread().getName() + " " + this + " stalled waiting for transition to " + TurnPhase$.MODULE$.toString(newPhase$1) + " of " + currentUnknownPredecessor : Thread.currentThread().getName() + " " + this + " stalled due do missing wake-up after transition to " + TurnPhase$.MODULE$.toString(newPhase$1) + " of " + currentUnknownPredecessor);
                    }
                    if (FullMVUtil$.MODULE$.DEBUG()) {
                        Predef$.MODULE$.println((Object)("[" + Thread.currentThread().getName() + "] " + this + " unparked with " + this.activeBranches().get() + " tasks in queue."));
                    }
                    long l = 0L;
                    FullMVTurn fullMVTurn = currentUnknownPredecessor;
                    parkAfter = l;
                    registeredForWaiting = fullMVTurn;
                    continue;
                }
                long now = System.nanoTime();
                long l = parkAfter2 = parkAfter > 0L ? parkAfter : now + FullMVTurnImpl$.MODULE$.PARK_AFTER();
                if (now > parkAfter2) {
                    currentUnknownPredecessor.waiters().put(this.userlandThread(), BoxesRunTime.boxToInteger((int)newPhase$1));
                    long l2 = 0L;
                    FullMVTurn fullMVTurn = currentUnknownPredecessor;
                    parkAfter = l2;
                    registeredForWaiting = fullMVTurn;
                    continue;
                }
                Thread.yield();
                long l3 = parkAfter2;
                Object var27_18 = null;
                parkAfter = l3;
                registeredForWaiting = var27_18;
                continue;
            }
            if (registeredForWaiting != null) {
                currentUnknownPredecessor.waiters().remove(this.userlandThread());
            }
            int n = firstUnknownPredecessorIndex + 1;
            long l = 0L;
            Object var31_21 = null;
            firstUnknownPredecessorIndex = n;
            parkAfter = l;
            registeredForWaiting = var31_21;
        }
    }
}

