/*
 * Decompiled with CFR 0.152.
 */
package replication.dtn;

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import de.rmgk.delay;
import java.io.Serializable;
import java.net.URI;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import rdts.base.Lattice;
import rdts.base.Uid;
import replication.dtn.BinaryAsBase64;
import replication.dtn.ReplicaListener;
import replication.dtn.ReplicaMutator;
import replication.dtn.WsRecvData;
import replication.dtn.WsSendData;
import replication.dtn.WsSendData$;
import replication.dtn.dtn$package$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class Replica<S> {
    private final Uid id;
    private final String dtnNodeId;
    private final String service;
    private volatile S data;
    private final Lattice<S> evidence$1;
    private final JsonValueCodec<S> evidence$2;
    private final AtomicReference<List<WebSocket>> connections;
    private final ReplicaMutator<S> mut;

    public Replica(Uid id, String dtnNodeId, String service, S data, Lattice<S> evidence$1, JsonValueCodec<S> evidence$2) {
        this.id = id;
        this.dtnNodeId = dtnNodeId;
        this.service = service;
        this.data = data;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        AtomicReference<Nil$> ar = new AtomicReference<Nil$>();
        ar.set(package$.MODULE$.Nil());
        this.connections = ar;
        this.mut = new ReplicaMutator(this);
    }

    public Uid id() {
        return this.id;
    }

    public String service() {
        return this.service;
    }

    public S data() {
        return this.data;
    }

    public void data_$eq(S x$1) {
        this.data = x$1;
    }

    public AtomicReference<List<WebSocket>> connections() {
        return this.connections;
    }

    public ReplicaMutator<S> mut() {
        return this.mut;
    }

    public void applyRemoteDelta(S delta) {
        Replica replica = this;
        synchronized (replica) {
            Lattice<S> Lattice_this = this.evidence$1;
            S left$proxy1 = this.data();
            this.data_$eq(Lattice_this.merge(left$proxy1, delta));
        }
    }

    public void applyLocalDelta(S delta) {
        Replica replica = this;
        synchronized (replica) {
            Lattice<S> Lattice_this = this.evidence$1;
            S left$proxy2 = this.data();
            this.data_$eq(Lattice_this.merge(left$proxy2, delta));
            ByteBuffer msg = this.message(delta);
            this.connections().get().foreach((Function1 & Serializable)ws -> ws.sendBinary(msg, true));
        }
    }

    public ByteBuffer message(S data) {
        WsSendData sendData = WsSendData$.MODULE$.apply(this.dtnNodeId, this.service(), new BinaryAsBase64(com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray(data, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray$default$2(), this.evidence$2)), false, 60000L);
        return ByteBuffer.wrap(com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray((Object)sendData, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray$default$2(), dtn$package$.MODULE$.given_JsonValueCodec_WsSendData()));
    }

    public void receive(ByteBuffer data) {
        WsRecvData receieved = (WsRecvData)com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromByteBuffer(data, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromByteBuffer$default$2(), dtn$package$.MODULE$.given_JsonValueCodec_WsRecvData());
        Predef$.MODULE$.println((Object)("received: " + receieved));
        Object delta = com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray(receieved.data().payload(), com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray$default$2(), this.evidence$2);
        Predef$.MODULE$.println((Object)("applying " + delta));
        this.applyRemoteDelta(delta);
        Predef$.MODULE$.println((Object)("value is now " + this.data()));
    }

    public delay.Async<Object, BoxedUnit> connectOn(URI uri) {
        return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
            try {
                ReplicaListener<S> listener = new ReplicaListener<S>(this, this.evidence$1, this.evidence$2);
                delay.Async async = new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                    delay.Callback callback = res2 -> {
                        try {
                            WebSocket webSocket;
                            WebSocket ws = webSocket = (WebSocket)res2.get();
                            Predef$.MODULE$.println((Object)"starting ws handler");
                            delay.Callback callback = cb;
                            delay.Callback callback2 = res3 -> {
                                try {
                                    WebSocket webSocket = (WebSocket)res3.get();
                                    delay.Callback callback = callback;
                                    delay.Callback callback2 = res2 -> {
                                        try {
                                            WebSocket webSocket = (WebSocket)res2.get();
                                            ws.request(1L);
                                            delay.Callback callback = callback;
                                            ((Function1)listener.modeSwitched().async().handleInCtx().apply(ctx)).apply(res -> {
                                                try {
                                                    boolean bl = BoxesRunTime.unboxToBoolean((Object)res.get());
                                                    this.connections().updateAndGet(_$3 -> _$3.$colon$colon((Object)ws));
                                                    ws.sendBinary(this.message(this.data()), true);
                                                    delay.Callback Callback_this = callback;
                                                    BoxedUnit value$proxy4 = BoxedUnit.UNIT;
                                                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)BoxedUnit.UNIT));
                                                }
                                                catch (Throwable throwable) {
                                                    Throwable throwable2;
                                                    Throwable e = throwable2 = throwable;
                                                    if (NonFatal$.MODULE$.apply(e)) {
                                                        res.recover((PartialFunction)new Serializable(e){
                                                            private final Throwable e$1;
                                                            {
                                                                this.e$1 = e$14;
                                                            }

                                                            public final boolean isDefinedAt(Throwable x) {
                                                                Throwable throwable = x;
                                                                return true;
                                                            }

                                                            public final Object applyOrElse(Throwable x, Function1 function1) {
                                                                Throwable throwable = x;
                                                                this.e$1.addSuppressed(x);
                                                                return BoxedUnit.UNIT;
                                                            }
                                                        });
                                                        delay.Callback Callback_this = callback;
                                                        Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                                                    }
                                                    throw throwable;
                                                }
                                            });
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable2;
                                            Throwable e = throwable2 = throwable;
                                            if (NonFatal$.MODULE$.apply(e)) {
                                                res2.recover((PartialFunction)new Serializable(e){
                                                    private final Throwable e$2;
                                                    {
                                                        this.e$2 = e$15;
                                                    }

                                                    public final boolean isDefinedAt(Throwable x) {
                                                        Throwable throwable = x;
                                                        return true;
                                                    }

                                                    public final Object applyOrElse(Throwable x, Function1 function1) {
                                                        Throwable throwable = x;
                                                        this.e$2.addSuppressed(x);
                                                        return BoxedUnit.UNIT;
                                                    }
                                                });
                                                delay.Callback Callback_this = callback;
                                                Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                                            }
                                            throw throwable;
                                        }
                                    };
                                    ws.sendText("/subscribe " + this.service(), true).whenComplete((res, ex) -> {
                                        if (ex != null) {
                                            delay.Callback Callback_this = callback2;
                                            Throwable ex$proxy5 = ex;
                                            Callback_this.complete((Try)Failure$.MODULE$.apply(ex$proxy5));
                                            return;
                                        }
                                        if (res != null) {
                                            delay.Callback Callback_this = callback2;
                                            WebSocket value$proxy3 = res;
                                            Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy3));
                                            return;
                                        }
                                        delay.Callback Callback_this = callback2;
                                        IllegalStateException ex$proxy6 = new IllegalStateException("completion stage returned nothing without failure");
                                        Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)ex$proxy6));
                                    });
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2;
                                    Throwable e = throwable2 = throwable;
                                    if (NonFatal$.MODULE$.apply(e)) {
                                        res3.recover((PartialFunction)new Serializable(e){
                                            private final Throwable e$3;
                                            {
                                                this.e$3 = e$16;
                                            }

                                            public final boolean isDefinedAt(Throwable x) {
                                                Throwable throwable = x;
                                                return true;
                                            }

                                            public final Object applyOrElse(Throwable x, Function1 function1) {
                                                Throwable throwable = x;
                                                this.e$3.addSuppressed(x);
                                                return BoxedUnit.UNIT;
                                            }
                                        });
                                        delay.Callback Callback_this = callback;
                                        Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                                    }
                                    throw throwable;
                                }
                            };
                            ws.sendText("/json", true).whenComplete((res, ex) -> {
                                if (ex != null) {
                                    delay.Callback Callback_this = callback2;
                                    Throwable ex$proxy3 = ex;
                                    Callback_this.complete((Try)Failure$.MODULE$.apply(ex$proxy3));
                                    return;
                                }
                                if (res != null) {
                                    delay.Callback Callback_this = callback2;
                                    WebSocket value$proxy2 = res;
                                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy2));
                                    return;
                                }
                                delay.Callback Callback_this = callback2;
                                IllegalStateException ex$proxy4 = new IllegalStateException("completion stage returned nothing without failure");
                                Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)ex$proxy4));
                            });
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            Throwable e = throwable2 = throwable;
                            if (NonFatal$.MODULE$.apply(e)) {
                                res2.recover((PartialFunction)new Serializable(e){
                                    private final Throwable e$4;
                                    {
                                        this.e$4 = e$17;
                                    }

                                    public final boolean isDefinedAt(Throwable x) {
                                        Throwable throwable = x;
                                        return true;
                                    }

                                    public final Object applyOrElse(Throwable x, Function1 function1) {
                                        Throwable throwable = x;
                                        this.e$4.addSuppressed(x);
                                        return BoxedUnit.UNIT;
                                    }
                                });
                                delay.Callback Callback_this = cb;
                                Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                            }
                            throw throwable;
                        }
                    };
                    dtn$package$.MODULE$.client().newWebSocketBuilder().buildAsync(uri, listener).whenComplete((res, ex) -> {
                        if (ex != null) {
                            delay.Callback Callback_this = callback;
                            Throwable ex$proxy1 = ex;
                            Callback_this.complete((Try)Failure$.MODULE$.apply(ex$proxy1));
                            return;
                        }
                        if (res != null) {
                            delay.Callback Callback_this = callback;
                            WebSocket value$proxy1 = res;
                            Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy1));
                            return;
                        }
                        delay.Callback Callback_this = callback;
                        IllegalStateException ex$proxy2 = new IllegalStateException("completion stage returned nothing without failure");
                        Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)ex$proxy2));
                    });
                });
                ((Function1)async.handleInCtx().apply(ctx)).apply(cb);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    delay.Callback Callback_this = cb;
                    Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                }
                throw throwable;
            }
        });
    }
}

