/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.access;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import lofi_acl.access.KeyDerivationKey;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.util.DigestFactory;
import rdts.time.Dot;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.ModuleSerializationProxy;

public final class KeyDerivationKey$
implements Serializable {
    private static final byte[] encryptionStringAsBytes;
    public static final byte[] lofi_acl$access$KeyDerivationKey$$$contextForSigningKeys;
    private static final byte[] contextPrefixForDerivationKeys;
    private static final SecureRandom secureRandom;
    public static final KeyDerivationKey$ MODULE$;

    private KeyDerivationKey$() {
    }

    static {
        MODULE$ = new KeyDerivationKey$();
        encryptionStringAsBytes = "encryption".getBytes(StandardCharsets.UTF_8);
        lofi_acl$access$KeyDerivationKey$$$contextForSigningKeys = "signing".getBytes(StandardCharsets.UTF_8);
        contextPrefixForDerivationKeys = "derivation".getBytes(StandardCharsets.UTF_8);
        secureRandom = SecureRandom.getInstanceStrong();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KeyDerivationKey$.class);
    }

    public byte[] lofi_acl$access$KeyDerivationKey$$$contextForEncryptionKeys(Dot dot) {
        String replicaId = dot.place().delegate();
        Predef$.MODULE$.require(replicaId.length() == 44);
        ByteBuffer buffer = ByteBuffer.allocate(encryptionStringAsBytes.length + replicaId.length() + 8);
        buffer.put(encryptionStringAsBytes);
        buffer.put(replicaId.getBytes(StandardCharsets.UTF_8));
        buffer.putLong(dot.time());
        return buffer.array();
    }

    public KeyDerivationKey apply() {
        byte[] ikm = new byte[32];
        secureRandom.nextBytes(ikm);
        return this.apply(ikm);
    }

    public KeyDerivationKey apply(byte[] inputKeyMaterial) {
        return new KeyDerivationKey((byte[])inputKeyMaterial.clone());
    }

    public byte[] lofi_acl$access$KeyDerivationKey$$$derive256BitsOutputKeyMaterial(byte[] inputKeyMaterial, byte[] info) {
        Predef$.MODULE$.require(inputKeyMaterial.length == 32);
        HKDFParameters hkdfParameters = HKDFParameters.skipExtractParameters((byte[])inputKeyMaterial, (byte[])info);
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator(DigestFactory.createSHA256());
        hkdf.init((DerivationParameters)hkdfParameters);
        byte[] outputKeyMaterial = new byte[32];
        hkdf.generateBytes(outputKeyMaterial, 0, 32);
        return outputKeyMaterial;
    }

    public byte[] lofi_acl$access$KeyDerivationKey$$$generateChildKeyDerivationKeyMaterial(byte[] inputKeyMaterial, String realm) {
        byte[] context = new byte[contextPrefixForDerivationKeys.length + realm.length()];
        Object object = Predef$.MODULE$.byteArrayOps(contextPrefixForDerivationKeys);
        int n = ArrayOps$.MODULE$.copyToArray$extension(object, (Object)context);
        Object object2 = Predef$.MODULE$.byteArrayOps(realm.getBytes(StandardCharsets.UTF_8));
        int n2 = ArrayOps$.MODULE$.copyToArray$extension(object2, (Object)context, contextPrefixForDerivationKeys.length);
        return this.lofi_acl$access$KeyDerivationKey$$$derive256BitsOutputKeyMaterial(inputKeyMaterial, context);
    }
}

