/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.collections;

import java.io.Serializable;
import lofi_acl.collections.DeltaStore$;
import rdts.base.Bottom;
import rdts.base.Lattice;
import rdts.time.Dot;
import rdts.time.Dots;
import rdts.time.Dots$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class DeltaStore<RDT>
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DeltaStore.class.getDeclaredField("retrievableDots$lzy1"));
    private final Dots prefixDots;
    private final RDT prefix;
    private final Dots addressableDeltas;
    private final Map<Dot, Tuple2<Dots, RDT>> deltas;
    private volatile Object retrievableDots$lzy1;

    public static <RDT> DeltaStore<RDT> empty(Bottom<RDT> bottom2) {
        return DeltaStore$.MODULE$.empty(bottom2);
    }

    public static <RDT> DeltaStore<RDT> from(Dots dots, RDT RDT, Dots dots2, Map<Dot, Tuple2<Dots, RDT>> map) {
        return DeltaStore$.MODULE$.from(dots, RDT, dots2, map);
    }

    public static DeltaStore<?> fromProduct(Product product) {
        return DeltaStore$.MODULE$.fromProduct(product);
    }

    public static <RDT> DeltaStore<RDT> unapply(DeltaStore<RDT> deltaStore) {
        return DeltaStore$.MODULE$.unapply(deltaStore);
    }

    public DeltaStore(Dots prefixDots, RDT prefix, Dots addressableDeltas, Map<Dot, Tuple2<Dots, RDT>> deltas) {
        this.prefixDots = prefixDots;
        this.prefix = prefix;
        this.addressableDeltas = addressableDeltas;
        this.deltas = deltas;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DeltaStore)) return false;
        DeltaStore deltaStore = (DeltaStore)object;
        Dots dots = this.prefixDots();
        Dots dots2 = deltaStore.prefixDots();
        if (dots == null) {
            if (dots2 != null) {
                return false;
            }
        } else if (!dots.equals(dots2)) return false;
        if (!BoxesRunTime.equals(this.prefix(), deltaStore.prefix())) return false;
        Dots dots3 = this.addressableDeltas();
        Dots dots4 = deltaStore.addressableDeltas();
        if (dots3 == null) {
            if (dots4 != null) {
                return false;
            }
        } else if (!dots3.equals(dots4)) return false;
        Map<Dot, Tuple2<Dots, RDT>> map = this.deltas();
        Map<Dot, Tuple2<Dots, RDT>> map2 = deltaStore.deltas();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!deltaStore.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DeltaStore;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "DeltaStore";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "prefixDots";
            }
            case 1: {
                return "prefix";
            }
            case 2: {
                return "addressableDeltas";
            }
            case 3: {
                return "deltas";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Dots prefixDots() {
        return this.prefixDots;
    }

    public RDT prefix() {
        return this.prefix;
    }

    public Dots addressableDeltas() {
        return this.addressableDeltas;
    }

    public Map<Dot, Tuple2<Dots, RDT>> deltas() {
        return this.deltas;
    }

    public Dots retrievableDots() {
        Object object = this.retrievableDots$lzy1;
        if (object instanceof Dots) {
            return (Dots)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Dots)this.retrievableDots$lzyINIT1();
    }

    private Object retrievableDots$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.retrievableDots$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Dots dots = null;
                    try {
                        dots = this.prefixDots().union(this.addressableDeltas());
                        object2 = dots == null ? LazyVals.NullValue$.MODULE$ : dots;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.retrievableDots$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return dots;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean contains(Dots dots) {
        return this.retrievableDots().contains(dots);
    }

    public List<Tuple2<Dots, RDT>> readAvailableDeltas(Dots dots) {
        List collectedDeltas;
        Dots remaining = dots.intersect(this.retrievableDots());
        if (!this.addressableDeltas().contains(remaining)) {
            remaining = remaining.subtract(this.prefixDots());
            v0 = (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)this.prefixDots(), this.prefix()), (List)Nil$.MODULE$);
        } else {
            v0 = collectedDeltas = package$.MODULE$.List().empty();
        }
        while (!remaining.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)this.deltas().apply((Object)remaining.head());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Dots dotsOfDelta = (Dots)tuple2._1();
            Tuple2 dottedDelta = tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dottedDelta, (Object)dotsOfDelta);
            Tuple2 dottedDelta2 = (Tuple2)tuple22._1();
            Dots dotsOfDelta2 = (Dots)tuple22._2();
            remaining = remaining.subtract(dotsOfDelta2);
            collectedDeltas = collectedDeltas.$colon$colon((Object)dottedDelta2);
        }
        return collectedDeltas;
    }

    public Option<Tuple2<Dots, RDT>> readAvailableDeltasAsSingleDelta(Dots dots, Lattice<RDT> lattice) {
        return this.readAvailableDeltas(dots).reduceOption((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Dots lDots = (Dots)tuple22._1();
                    Object lDelta = tuple22._2();
                    if (tuple23 != null) {
                        Dots rDots = (Dots)tuple23._1();
                        Object rDelta = tuple23._2();
                        return Tuple2$.MODULE$.apply((Object)lDots.union(rDots), lattice.merge(lDelta, rDelta));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public DeltaStore<RDT> replacePrefixPruningDeltas(Dots dots, RDT delta) {
        Dots toPrune = dots.intersect(this.addressableDeltas());
        Map prunedDeltas = (Map)this.deltas().removedAll((IterableOnce)toPrune.iterator());
        return DeltaStore$.MODULE$.lofi_acl$collections$DeltaStore$$$apply(dots, delta, this.addressableDeltas().subtract(dots), prunedDeltas);
    }

    public DeltaStore<RDT> mergeIntoPrefixPruningDeltas(Dots dots, RDT delta, Lattice<RDT> lattice) {
        Dots toPrune = dots.intersect(this.addressableDeltas());
        Map prunedDeltas = (Map)this.deltas().removedAll((IterableOnce)toPrune.iterator());
        return DeltaStore$.MODULE$.lofi_acl$collections$DeltaStore$$$apply(this.prefixDots().union(dots), lattice.merge(this.prefix(), delta), this.addressableDeltas().subtract(dots), prunedDeltas);
    }

    public DeltaStore<RDT> replaceOrMergeIntoPrefixPruningDeltas(Dots dots, RDT delta, Lattice<RDT> x$3) {
        if (!dots.contains(this.prefixDots())) {
            return this.mergeIntoPrefixPruningDeltas(dots, delta, x$3);
        }
        return this.replacePrefixPruningDeltas(dots, delta);
    }

    public DeltaStore<RDT> addDeltaEvenIfRedundant(Dots dots, RDT delta) {
        Dots dots2 = (Dots)Predef$.MODULE$.ArrowAssoc((Object)dots);
        Tuple2 dottedDelta = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dots2, delta);
        Dots dots3 = this.addressableDeltas().union(dots);
        Map map = (Map)this.deltas().$plus$plus((IterableOnce)dots.iterator().map((Function1 & Serializable)dot -> {
            Dot dot2 = (Dot)Predef$.MODULE$.ArrowAssoc(dot);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dot2, (Object)dottedDelta);
        }));
        Dots dots4 = this.copy$default$1();
        RDT RDT = this.copy$default$2();
        return this.copy(dots4, RDT, dots3, map);
    }

    public DeltaStore<RDT> addDeltaOnlyAtDot(Dot dot, Dots dots, RDT delta) {
        Predef$.MODULE$.require(dots.contains(dot));
        Dots dots2 = this.addressableDeltas().add(dot);
        Dot dot2 = (Dot)Predef$.MODULE$.ArrowAssoc((Object)dot);
        Dots dots3 = (Dots)Predef$.MODULE$.ArrowAssoc((Object)dots);
        Map map = (Map)this.deltas().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dot2, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dots3, delta)));
        Dots dots4 = this.copy$default$1();
        RDT RDT = this.copy$default$2();
        return this.copy(dots4, RDT, dots2, map);
    }

    public DeltaStore<RDT> addDeltaIfNew(Dots dots, RDT delta) {
        Dots dotsToStore = dots.subtract(this.prefixDots()).subtract(this.addressableDeltas());
        if (dotsToStore.isEmpty()) {
            return this;
        }
        Dots dots2 = (Dots)Predef$.MODULE$.ArrowAssoc((Object)dots);
        Tuple2 dottedDelta = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dots2, delta);
        Dots dots3 = this.addressableDeltas().union(dotsToStore);
        Map map = (Map)this.deltas().$plus$plus((IterableOnce)dotsToStore.iterator().map((Function1 & Serializable)dot -> {
            Dot dot2 = (Dot)Predef$.MODULE$.ArrowAssoc(dot);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dot2, (Object)dottedDelta);
        }));
        Dots dots4 = this.copy$default$1();
        RDT RDT = this.copy$default$2();
        return this.copy(dots4, RDT, dots3, map);
    }

    public DeltaStore<RDT> discardDeltasContainedInPrefix() {
        Dots toPrune = this.addressableDeltas().intersect(this.prefixDots());
        Dots dots = this.addressableDeltas().subtract(toPrune);
        Map map = (Map)this.deltas().removedAll((IterableOnce)toPrune.iterator());
        Dots dots2 = this.copy$default$1();
        RDT RDT = this.copy$default$2();
        return this.copy(dots2, RDT, dots, map);
    }

    public DeltaStore<RDT> compactAllDeltasIntoPrefixSkippingDuplicates(Lattice<RDT> lattice, Bottom<RDT> bottom2) {
        if (this.deltas().isEmpty()) {
            return this;
        }
        Dots newPrefixDots = this.prefixDots();
        Object mergedDeltas = bottom2.empty();
        for (Tuple2 tuple2 : this.deltas()) {
            Dot dot;
            Tuple2 tuple22;
            block6: {
                block5: {
                    if (tuple2 == null) break block5;
                    tuple22 = (Tuple2)tuple2._2();
                    dot = (Dot)tuple2._1();
                    if (tuple22 != null) break block6;
                }
                throw new MatchError((Object)tuple2);
            }
            Dots dots = (Dots)tuple22._1();
            Object delta = tuple22._2();
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)dot, (Object)dots, delta);
            Dot dot2 = (Dot)tuple3._1();
            Dots dots2 = (Dots)tuple3._2();
            Object delta2 = tuple3._3();
            if (newPrefixDots.contains(dot2)) continue;
            newPrefixDots = newPrefixDots.union(dots2);
            mergedDeltas = lattice.merge(mergedDeltas, delta2);
        }
        return DeltaStore$.MODULE$.lofi_acl$collections$DeltaStore$$$apply(newPrefixDots, lattice.merge(this.prefix(), mergedDeltas), Dots$.MODULE$.empty(), Predef$.MODULE$.Map().empty());
    }

    public DeltaStore<RDT> compactAllDeltasIntoPrefix(Lattice<RDT> lattice) {
        if (this.deltas().isEmpty()) {
            return this;
        }
        Tuple2 tuple2 = (Tuple2)this.deltas().values().reduce((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Dots dotsLeft = (Dots)tuple22._1();
                    Object deltaLeft = tuple22._2();
                    if (tuple23 != null) {
                        Dots dotsRight = (Dots)tuple23._1();
                        Object deltaRight = tuple23._2();
                        return Tuple2$.MODULE$.apply((Object)dotsLeft.union(dotsRight), lattice.merge(deltaLeft, deltaRight));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dots mergedDots = (Dots)tuple2._1();
        Object mergedDeltas = tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)mergedDots, mergedDeltas);
        Dots mergedDots2 = (Dots)tuple22._1();
        Object mergedDeltas2 = tuple22._2();
        return DeltaStore$.MODULE$.lofi_acl$collections$DeltaStore$$$apply(this.prefixDots().union(mergedDots2), lattice.merge(this.prefix(), mergedDeltas2), Dots$.MODULE$.empty(), Predef$.MODULE$.Map().empty());
    }

    private <RDT> DeltaStore<RDT> copy(Dots prefixDots, RDT prefix, Dots addressableDeltas, Map<Dot, Tuple2<Dots, RDT>> deltas) {
        return new DeltaStore<RDT>(prefixDots, prefix, addressableDeltas, deltas);
    }

    private <RDT> Dots copy$default$1() {
        return this.prefixDots();
    }

    private <RDT> RDT copy$default$2() {
        return this.prefix();
    }

    private <RDT> Dots copy$default$3() {
        return this.addressableDeltas();
    }

    private <RDT> Map<Dot, Tuple2<Dots, RDT>> copy$default$4() {
        return this.deltas();
    }

    public Dots _1() {
        return this.prefixDots();
    }

    public RDT _2() {
        return this.prefix();
    }

    public Dots _3() {
        return this.addressableDeltas();
    }

    public Map<Dot, Tuple2<Dots, RDT>> _4() {
        return this.deltas();
    }
}

