/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.sync;

import channels.tls.PrivateIdentity;
import crypto.PublicIdentity;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.SSLSocket;
import lofi_acl.sync.ConnectionManager$;
import lofi_acl.sync.MessageReceiver;
import lofi_acl.sync.MessageSerialization;
import lofi_acl.transport.P2PTlsTcpConnector;
import lofi_acl.transport.P2PTlsTcpConnector$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class ConnectionManager<MSG> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConnectionManager.class.getDeclaredField("ec$lzy1"));
    public final MessageReceiver<MSG> lofi_acl$sync$ConnectionManager$$messageHandler;
    public final MessageSerialization<MSG> lofi_acl$sync$ConnectionManager$$msgCodec;
    private final ExecutorService executor;
    private volatile Object ec$lzy1;
    private final P2PTlsTcpConnector connector;
    private volatile boolean running;
    public volatile boolean lofi_acl$sync$ConnectionManager$$stopped;
    public volatile Map<PublicIdentity, SSLSocket> lofi_acl$sync$ConnectionManager$$connections;
    private final PublicIdentity localPublicId;
    private final Object receiverFutureLock;
    private Set<Future<?>> receiverThreads;
    public volatile Map<PublicIdentity, DataOutputStream> lofi_acl$sync$ConnectionManager$$outputStreams;

    public ConnectionManager(PrivateIdentity privateIdentity, MessageReceiver<MSG> messageHandler, MessageSerialization<MSG> msgCodec) {
        this.lofi_acl$sync$ConnectionManager$$messageHandler = messageHandler;
        this.lofi_acl$sync$ConnectionManager$$msgCodec = msgCodec;
        this.executor = Executors.newCachedThreadPool();
        this.connector = new P2PTlsTcpConnector(privateIdentity, P2PTlsTcpConnector$.MODULE$.$lessinit$greater$default$2());
        this.running = false;
        this.lofi_acl$sync$ConnectionManager$$stopped = false;
        None$ listenerFuture = None$.MODULE$;
        this.lofi_acl$sync$ConnectionManager$$connections = Predef$.MODULE$.Map().empty();
        this.localPublicId = privateIdentity.getPublic();
        this.receiverFutureLock = new Object();
        this.receiverThreads = Predef$.MODULE$.Set().empty();
        this.lofi_acl$sync$ConnectionManager$$outputStreams = Predef$.MODULE$.Map().empty();
    }

    private final ExecutionContext ec() {
        Object object = this.ec$lzy1;
        if (object instanceof ExecutionContext) {
            return (ExecutionContext)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ExecutionContext)this.ec$lzyINIT1();
    }

    private Object ec$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ec$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ExecutionContextExecutor executionContextExecutor = null;
                    try {
                        executionContextExecutor = ExecutionContext$.MODULE$.fromExecutor((Executor)this.executor);
                        object2 = executionContextExecutor == null ? LazyVals.NullValue$.MODULE$ : executionContextExecutor;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ec$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return executionContextExecutor;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean send(PublicIdentity user, MSG msg) {
        return this.sendMultiple(user, (Seq<MSG>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{msg}));
    }

    public boolean sendMultiple(PublicIdentity user, Seq<MSG> msgs) {
        if (this.lofi_acl$sync$ConnectionManager$$stopped) {
            return false;
        }
        Option option = this.lofi_acl$sync$ConnectionManager$$outputStreams.get((Object)user);
        if (option instanceof Some) {
            DataOutputStream outputStream = (DataOutputStream)((Some)option).value();
            Future$.MODULE$.apply((Function0 & Serializable)() -> {
                this.sendMultiple$$anonfun$1(outputStream, msgs);
                return BoxedUnit.UNIT;
            }, this.ec());
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public boolean broadcast(Seq<MSG> msg) {
        return this.connectedUsers().forall((Function1 & Serializable)user -> this.sendMultiple((PublicIdentity)user, msg));
    }

    public void acceptIncomingConnections() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.running) {
                throw new IllegalStateException("Already listening");
            }
            if (this.lofi_acl$sync$ConnectionManager$$stopped) {
                throw new UnsupportedOperationException("Cannot restart listener of Sync");
            }
            this.running = true;
            this.acceptConnection$1();
        }
    }

    public Option<Object> listenPort() {
        if (this.running) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.connector.listenPort()));
        }
        return None$.MODULE$;
    }

    public void shutdown() {
        this.lofi_acl$sync$ConnectionManager$$stopped = true;
        this.connector.closeServerSocket();
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.lofi_acl$sync$ConnectionManager$$outputStreams = Predef$.MODULE$.Map().empty();
            this.lofi_acl$sync$ConnectionManager$$connections.foreach((Function1)(JProcedure1 & Serializable)_$1 -> ((Socket)_$1._2()).close());
        }
        Object object = this.receiverFutureLock;
        synchronized (object) {
            this.receiverThreads.foreach((Function1 & Serializable)_$2 -> _$2.cancel(true));
        }
        List<Runnable> list = this.executor.shutdownNow();
    }

    public void connectTo(String host, int port) {
        this.connector.connect(host, port, this.ec()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                Console$.MODULE$.err().println("Can't connect to " + host + ":" + port);
                return;
            }
            if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                PublicIdentity peerId;
                SSLSocket socket = (SSLSocket)tuple2._1();
                PublicIdentity publicIdentity = peerId = (PublicIdentity)tuple2._2();
                PublicIdentity publicIdentity2 = this.localPublicId;
                if (!(publicIdentity != null ? !publicIdentity.equals(publicIdentity2) : publicIdentity2 != null)) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                this.connectionEstablished(socket, peerId, false);
                return;
            }
            throw new MatchError((Object)try_);
        }, this.ec());
    }

    public void connectToExpectingUserIfNoConnectionExists(String host, int port, PublicIdentity expectedUser) {
        block5: {
            PublicIdentity publicIdentity = expectedUser;
            PublicIdentity publicIdentity2 = this.localPublicId;
            if (!(publicIdentity != null ? !publicIdentity.equals(publicIdentity2) : publicIdentity2 != null)) {
                return;
            }
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                block4: {
                    if (this.lofi_acl$sync$ConnectionManager$$connections.contains((Object)expectedUser)) break block4;
                    break block5;
                }
                return;
            }
        }
        this.connector.connect(host, port, this.ec()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                Console$.MODULE$.err().println("Can't connect to " + host + ":" + port);
                return;
            }
            if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                PublicIdentity publicIdentity = (PublicIdentity)tuple2._2();
                SSLSocket socket = (SSLSocket)tuple2._1();
                if (publicIdentity != null) {
                    PublicIdentity peerId = publicIdentity;
                    PublicIdentity publicIdentity2 = expectedUser;
                    PublicIdentity publicIdentity3 = peerId;
                    if (!(publicIdentity2 != null ? !publicIdentity2.equals(publicIdentity3) : publicIdentity3 != null)) {
                        this.connectionEstablished(socket, peerId, false);
                        return;
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            throw new MatchError((Object)try_);
        }, this.ec());
    }

    public Set<PublicIdentity> connectedUsers() {
        return this.lofi_acl$sync$ConnectionManager$$connections.keySet();
    }

    private void connectionEstablished(SSLSocket socket, PublicIdentity peerIdentity, boolean establishedByRemote) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Option option = this.lofi_acl$sync$ConnectionManager$$connections.get((Object)peerIdentity);
            if (option instanceof Some) {
                SSLSocket existingConnection = (SSLSocket)((Some)option).value();
                if (establishedByRemote && StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(peerIdentity.id()), this.localPublicId.id()) || !establishedByRemote && StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(peerIdentity.id()), this.localPublicId.id())) {
                    this.lofi_acl$sync$ConnectionManager$$connections = (Map)this.lofi_acl$sync$ConnectionManager$$connections.updated((Object)peerIdentity, (Object)socket);
                    this.lofi_acl$sync$ConnectionManager$$outputStreams = (Map)this.lofi_acl$sync$ConnectionManager$$outputStreams.updated((Object)peerIdentity, (Object)new DataOutputStream(socket.getOutputStream()));
                    try {
                        existingConnection.close();
                        this.lofi_acl$sync$ConnectionManager$$messageHandler.connectionShutdown(peerIdentity);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.receiveFrom(peerIdentity, socket);
                    this.lofi_acl$sync$ConnectionManager$$messageHandler.connectionEstablished(peerIdentity);
                } else {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
            } else if (None$.MODULE$.equals(option)) {
                this.lofi_acl$sync$ConnectionManager$$connections = (Map)this.lofi_acl$sync$ConnectionManager$$connections.updated((Object)peerIdentity, (Object)socket);
                this.lofi_acl$sync$ConnectionManager$$outputStreams = (Map)this.lofi_acl$sync$ConnectionManager$$outputStreams.updated((Object)peerIdentity, (Object)new DataOutputStream(socket.getOutputStream()));
                this.receiveFrom(peerIdentity, socket);
                this.lofi_acl$sync$ConnectionManager$$messageHandler.connectionEstablished(peerIdentity);
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private void receiveFrom(PublicIdentity peerIdentity, SSLSocket socket) {
        Future<?> receiverFuture = this.executor.submit(new Runnable(socket, peerIdentity, this){
            private final SSLSocket socket$1;
            private final PublicIdentity peerIdentity$1;
            private final /* synthetic */ ConnectionManager $outer;
            {
                this.socket$1 = socket$2;
                this.peerIdentity$1 = peerIdentity$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                DataInputStream input = new DataInputStream(this.socket$1.getInputStream());
                while (!this.$outer.lofi_acl$sync$ConnectionManager$$stopped) {
                    try {
                        MSG msg = this.$outer.lofi_acl$sync$ConnectionManager$$msgCodec.readFromStream(input);
                        this.$outer.lofi_acl$sync$ConnectionManager$$messageHandler.receivedMessage(msg, this.peerIdentity$1);
                    }
                    catch (IOException e) {
                        try {
                            this.socket$1.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        $anon$1 var5_8 = this;
                        synchronized (var5_8) {
                            Option option = this.$outer.lofi_acl$sync$ConnectionManager$$connections.get((Object)this.peerIdentity$1);
                            if (option instanceof Some) {
                                SSLSocket storedSocket = (SSLSocket)((Some)option).value();
                                if (storedSocket == this.socket$1) {
                                    this.$outer.lofi_acl$sync$ConnectionManager$$connections = (Map)this.$outer.lofi_acl$sync$ConnectionManager$$connections.removed((Object)this.peerIdentity$1);
                                    this.$outer.lofi_acl$sync$ConnectionManager$$outputStreams = (Map)this.$outer.lofi_acl$sync$ConnectionManager$$outputStreams.removed((Object)this.peerIdentity$1);
                                    this.$outer.lofi_acl$sync$ConnectionManager$$messageHandler.connectionShutdown(this.peerIdentity$1);
                                }
                            } else if (!None$.MODULE$.equals(option)) {
                                throw new MatchError((Object)option);
                            }
                        }
                        return;
                    }
                    catch (InterruptedException e) {
                        try {
                            this.socket$1.close();
                        }
                        catch (IOException e3) {}
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                    }
                }
            }
        });
        Object object = this.receiverFutureLock;
        synchronized (object) {
            this.receiverThreads = (Set)this.receiverThreads.$plus(receiverFuture);
        }
    }

    private final void sendMultiple$$anonfun$1(DataOutputStream outputStream$1, Seq msgs$1) {
        DataOutputStream dataOutputStream = outputStream$1;
        synchronized (dataOutputStream) {
            msgs$1.foreach((Function1)(JProcedure1 & Serializable)msg -> this.lofi_acl$sync$ConnectionManager$$msgCodec.writeToStream(msg, outputStream$1));
        }
    }

    private final void acceptConnection$1() {
        if (this.lofi_acl$sync$ConnectionManager$$stopped) {
            this.running = false;
            return;
        }
        scala.concurrent.Future<Tuple2<SSLSocket, PublicIdentity>> connectionFuture = this.connector.acceptConnection(this.ec());
        connectionFuture.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.running = false;
                return;
            }
            if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                PublicIdentity peerIdentity;
                SSLSocket socket = (SSLSocket)tuple2._1();
                PublicIdentity publicIdentity = peerIdentity = (PublicIdentity)tuple2._2();
                PublicIdentity publicIdentity2 = this.localPublicId;
                if (!(publicIdentity != null ? !publicIdentity.equals(publicIdentity2) : publicIdentity2 != null)) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                } else {
                    this.connectionEstablished(socket, peerIdentity, true);
                }
                this.acceptConnection$1();
                return;
            }
            throw new MatchError((Object)try_);
        }, this.ec());
    }
}

