/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.sync.acl.bft;

import channels.tls.PrivateIdentity;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import crypto.Ed25519Util$;
import crypto.PublicIdentity;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import lofi_acl.access.PermissionTree;
import lofi_acl.access.PermissionTree$;
import lofi_acl.sync.acl.bft.Acl;
import lofi_acl.sync.acl.bft.Acl$;
import lofi_acl.sync.acl.bft.BftAclOpGraph$;
import lofi_acl.sync.acl.bft.BftAclOpGraph$Delegation$;
import lofi_acl.sync.acl.bft.BftAclOpGraph$EncodedDelegation$;
import lofi_acl.sync.acl.bft.InvalidSignatureException$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class BftAclOpGraph
implements Product,
Serializable {
    private final Map<String, Delegation> ops;
    private final scala.collection.immutable.Set<String> heads;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BftAclOpGraph$.class.getDeclaredField("opCodec$lzy1"));

    public static BftAclOpGraph apply(Map<String, Delegation> map, scala.collection.immutable.Set<String> set) {
        return BftAclOpGraph$.MODULE$.apply(map, set);
    }

    public static EncodedDelegation createSelfSignedRoot(PrivateIdentity privateIdentity) {
        return BftAclOpGraph$.MODULE$.createSelfSignedRoot(privateIdentity);
    }

    public static BftAclOpGraph fromProduct(Product product) {
        return BftAclOpGraph$.MODULE$.fromProduct(product);
    }

    public static JsonValueCodec<Delegation> opCodec() {
        return BftAclOpGraph$.MODULE$.opCodec();
    }

    public static BftAclOpGraph unapply(BftAclOpGraph bftAclOpGraph) {
        return BftAclOpGraph$.MODULE$.unapply(bftAclOpGraph);
    }

    public BftAclOpGraph(Map<String, Delegation> ops, scala.collection.immutable.Set<String> heads) {
        this.ops = ops;
        this.heads = heads;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BftAclOpGraph)) return false;
        BftAclOpGraph bftAclOpGraph = (BftAclOpGraph)object;
        Map<String, Delegation> map = this.ops();
        Map<String, Delegation> map2 = bftAclOpGraph.ops();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        scala.collection.immutable.Set<String> set = this.heads();
        scala.collection.immutable.Set<String> set2 = bftAclOpGraph.heads();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (!bftAclOpGraph.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BftAclOpGraph;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "BftAclOpGraph";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "ops";
        }
        if (1 == n2) {
            return "heads";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Map<String, Delegation> ops() {
        return this.ops;
    }

    public scala.collection.immutable.Set<String> heads() {
        return this.heads;
    }

    public Tuple2<BftAclOpGraph, EncodedDelegation> delegateAccess(PublicIdentity delegator, PrivateKey delegatorKey, PublicIdentity delegatee, PermissionTree read, PermissionTree write) {
        Predef$.MODULE$.require(read.lteq(write));
        Delegation op = BftAclOpGraph$Delegation$.MODULE$.apply(delegator, delegatee, read, write, this.heads());
        Predef$.MODULE$.require(this.isDelegationLegal(op));
        byte[] opBytes = com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray((Object)op, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray$default$2(), BftAclOpGraph$.MODULE$.opCodec());
        byte[] sig = Ed25519Util$.MODULE$.sign(opBytes, delegatorKey);
        String sigAsString = Base64.getEncoder().encodeToString(sig);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)sigAsString);
        return Tuple2$.MODULE$.apply((Object)BftAclOpGraph$.MODULE$.apply((Map<String, Delegation>)((Map)this.ops().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)op))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sigAsString})))), (Object)BftAclOpGraph$EncodedDelegation$.MODULE$.apply(sig, opBytes));
    }

    public boolean isDelegationLegal(Delegation op) {
        Acl referenceVersion = (Acl)this.reconstruct(op.parents()).get();
        return op.read().lteq((PermissionTree)referenceVersion.read().getOrElse((Object)op.delegator(), BftAclOpGraph::isDelegationLegal$$anonfun$1)) && op.write().lteq((PermissionTree)referenceVersion.write().getOrElse((Object)op.delegator(), BftAclOpGraph::isDelegationLegal$$anonfun$2));
    }

    public Either<scala.collection.immutable.Set<String>, BftAclOpGraph> receive(byte[] signature, byte[] encodedOp) {
        String signatureAsString = Base64.getEncoder().encodeToString(signature);
        if (this.ops().contains((Object)signatureAsString)) {
            return package$.MODULE$.Right().apply((Object)this);
        }
        Delegation delegation = (Delegation)com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray(encodedOp, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray$default$2(), BftAclOpGraph$.MODULE$.opCodec());
        if (delegation != null) {
            Delegation delegation2 = BftAclOpGraph$Delegation$.MODULE$.unapply(delegation);
            PublicIdentity publicIdentity = delegation2._1();
            PublicIdentity publicIdentity2 = delegation2._2();
            PermissionTree permissionTree = delegation2._3();
            PermissionTree permissionTree2 = delegation2._4();
            scala.collection.immutable.Set<String> set = delegation2._5();
            PublicIdentity delegator = publicIdentity;
            PublicIdentity delegatee = publicIdentity2;
            PermissionTree read = permissionTree;
            PermissionTree write = permissionTree2;
            scala.collection.immutable.Set<String> parents = set;
            Delegation delegation3 = delegation;
            if (!Ed25519Util$.MODULE$.checkEd25519Signature(encodedOp, signature, delegator)) {
                throw InvalidSignatureException$.MODULE$;
            }
            Predef$.MODULE$.require(read.lteq(write));
            scala.collection.immutable.Set missing = (scala.collection.immutable.Set)parents.filterNot((Function1 & Serializable)key -> this.ops().contains(key));
            if (missing.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)missing);
            }
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)signatureAsString);
            return package$.MODULE$.Right().apply((Object)BftAclOpGraph$.MODULE$.apply((Map<String, Delegation>)((Map)this.ops().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)delegation3))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.heads().$minus$minus(parents).$plus((Object)signatureAsString))));
        }
        throw new MatchError((Object)delegation);
    }

    public Option<Acl> reconstruct(scala.collection.immutable.Set<String> heads) {
        Predef$.MODULE$.require(heads.forall((Function1 & Serializable)key -> this.ops().contains(key)));
        scala.collection.mutable.Set visited = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        Stack toMerge = Stack$.MODULE$.from(heads);
        Acl resultAcl = Acl$.MODULE$.apply((Map<PublicIdentity, PermissionTree>)Predef$.MODULE$.Map().empty(), (Map<PublicIdentity, PermissionTree>)Predef$.MODULE$.Map().empty());
        while (toMerge.nonEmpty()) {
            String next = (String)toMerge.pop();
            if (visited.contains((Object)next)) continue;
            Delegation delegation = (Delegation)this.ops().apply((Object)next);
            if (delegation != null) {
                Delegation delegation2 = BftAclOpGraph$Delegation$.MODULE$.unapply(delegation);
                PublicIdentity publicIdentity = delegation2._1();
                PublicIdentity publicIdentity2 = delegation2._2();
                PermissionTree permissionTree = delegation2._3();
                PermissionTree permissionTree2 = delegation2._4();
                scala.collection.immutable.Set<String> set = delegation2._5();
                PublicIdentity delegatee = publicIdentity2;
                PermissionTree read = permissionTree;
                PermissionTree write = permissionTree2;
                scala.collection.immutable.Set<String> parents = set;
                visited.$plus$eq((Object)next);
                toMerge.$plus$plus$eq((IterableOnce)parents.diff((Set)visited));
                resultAcl = resultAcl.addPermissions(delegatee, read, write);
                continue;
            }
            throw new MatchError((Object)delegation);
        }
        return Some$.MODULE$.apply((Object)resultAcl);
    }

    public BftAclOpGraph copy(Map<String, Delegation> ops, scala.collection.immutable.Set<String> heads) {
        return new BftAclOpGraph(ops, heads);
    }

    public Map<String, Delegation> copy$default$1() {
        return this.ops();
    }

    public scala.collection.immutable.Set<String> copy$default$2() {
        return this.heads();
    }

    public Map<String, Delegation> _1() {
        return this.ops();
    }

    public scala.collection.immutable.Set<String> _2() {
        return this.heads();
    }

    private static final PermissionTree isDelegationLegal$$anonfun$1() {
        return PermissionTree$.MODULE$.empty();
    }

    private static final PermissionTree isDelegationLegal$$anonfun$2() {
        return PermissionTree$.MODULE$.empty();
    }

    public static class Delegation
    implements Product,
    Serializable {
        private final PublicIdentity delegator;
        private final PublicIdentity delegatee;
        private final PermissionTree read;
        private final PermissionTree write;
        private final scala.collection.immutable.Set<String> parents;

        public static Delegation apply(PublicIdentity publicIdentity, PublicIdentity publicIdentity2, PermissionTree permissionTree, PermissionTree permissionTree2, scala.collection.immutable.Set<String> set) {
            return BftAclOpGraph$Delegation$.MODULE$.apply(publicIdentity, publicIdentity2, permissionTree, permissionTree2, set);
        }

        public static Delegation fromProduct(Product product) {
            return BftAclOpGraph$Delegation$.MODULE$.fromProduct(product);
        }

        public static Delegation unapply(Delegation delegation) {
            return BftAclOpGraph$Delegation$.MODULE$.unapply(delegation);
        }

        public Delegation(PublicIdentity delegator, PublicIdentity delegatee, PermissionTree read, PermissionTree write, scala.collection.immutable.Set<String> parents) {
            this.delegator = delegator;
            this.delegatee = delegatee;
            this.read = read;
            this.write = write;
            this.parents = parents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Delegation)) return false;
            Delegation delegation = (Delegation)object;
            PublicIdentity publicIdentity = this.delegator();
            PublicIdentity publicIdentity2 = delegation.delegator();
            if (publicIdentity == null) {
                if (publicIdentity2 != null) {
                    return false;
                }
            } else if (!publicIdentity.equals(publicIdentity2)) return false;
            PublicIdentity publicIdentity3 = this.delegatee();
            PublicIdentity publicIdentity4 = delegation.delegatee();
            if (publicIdentity3 == null) {
                if (publicIdentity4 != null) {
                    return false;
                }
            } else if (!publicIdentity3.equals(publicIdentity4)) return false;
            PermissionTree permissionTree = this.read();
            PermissionTree permissionTree2 = delegation.read();
            if (permissionTree == null) {
                if (permissionTree2 != null) {
                    return false;
                }
            } else if (!((Object)permissionTree).equals(permissionTree2)) return false;
            PermissionTree permissionTree3 = this.write();
            PermissionTree permissionTree4 = delegation.write();
            if (permissionTree3 == null) {
                if (permissionTree4 != null) {
                    return false;
                }
            } else if (!((Object)permissionTree3).equals(permissionTree4)) return false;
            scala.collection.immutable.Set<String> set = this.parents();
            scala.collection.immutable.Set<String> set2 = delegation.parents();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!delegation.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Delegation;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Delegation";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "delegator";
                }
                case 1: {
                    return "delegatee";
                }
                case 2: {
                    return "read";
                }
                case 3: {
                    return "write";
                }
                case 4: {
                    return "parents";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PublicIdentity delegator() {
            return this.delegator;
        }

        public PublicIdentity delegatee() {
            return this.delegatee;
        }

        public PermissionTree read() {
            return this.read;
        }

        public PermissionTree write() {
            return this.write;
        }

        public scala.collection.immutable.Set<String> parents() {
            return this.parents;
        }

        public EncodedDelegation encode(String signature, JsonValueCodec<Delegation> x$2) {
            byte[] signatureBytes;
            byte[] delegationBytes = com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray((Object)this, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray$default$2(), x$2);
            if (!Ed25519Util$.MODULE$.checkEd25519Signature(delegationBytes, signatureBytes = Base64.getDecoder().decode(signature), this.delegator())) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            return BftAclOpGraph$EncodedDelegation$.MODULE$.apply(signatureBytes, delegationBytes);
        }

        public Delegation copy(PublicIdentity delegator, PublicIdentity delegatee, PermissionTree read, PermissionTree write, scala.collection.immutable.Set<String> parents) {
            return new Delegation(delegator, delegatee, read, write, parents);
        }

        public PublicIdentity copy$default$1() {
            return this.delegator();
        }

        public PublicIdentity copy$default$2() {
            return this.delegatee();
        }

        public PermissionTree copy$default$3() {
            return this.read();
        }

        public PermissionTree copy$default$4() {
            return this.write();
        }

        public scala.collection.immutable.Set<String> copy$default$5() {
            return this.parents();
        }

        public PublicIdentity _1() {
            return this.delegator();
        }

        public PublicIdentity _2() {
            return this.delegatee();
        }

        public PermissionTree _3() {
            return this.read();
        }

        public PermissionTree _4() {
            return this.write();
        }

        public scala.collection.immutable.Set<String> _5() {
            return this.parents();
        }
    }

    public static class EncodedDelegation
    implements Product,
    Serializable {
        private final byte[] sig;
        private final byte[] op;

        public static EncodedDelegation apply(byte[] byArray, byte[] byArray2) {
            return BftAclOpGraph$EncodedDelegation$.MODULE$.apply(byArray, byArray2);
        }

        public static EncodedDelegation fromProduct(Product product) {
            return BftAclOpGraph$EncodedDelegation$.MODULE$.fromProduct(product);
        }

        public static EncodedDelegation unapply(EncodedDelegation encodedDelegation) {
            return BftAclOpGraph$EncodedDelegation$.MODULE$.unapply(encodedDelegation);
        }

        public EncodedDelegation(byte[] sig, byte[] op) {
            this.sig = sig;
            this.op = op;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EncodedDelegation)) return false;
            EncodedDelegation encodedDelegation = (EncodedDelegation)object;
            if (this.sig() != encodedDelegation.sig()) return false;
            if (this.op() != encodedDelegation.op()) return false;
            if (!encodedDelegation.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EncodedDelegation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "EncodedDelegation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "sig";
            }
            if (1 == n2) {
                return "op";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte[] sig() {
            return this.sig;
        }

        public byte[] op() {
            return this.op;
        }

        public Try<Tuple2<String, Delegation>> decode(JsonValueCodec<Delegation> x$1) {
            Delegation delegation = (Delegation)com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray(this.op(), com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray$default$2(), x$1);
            PublicKey signer = delegation.delegator().publicKey();
            if (!Ed25519Util$.MODULE$.checkEd25519Signature(this.op(), this.sig(), signer)) {
                return Failure$.MODULE$.apply((Throwable)InvalidSignatureException$.MODULE$);
            }
            return Success$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)Base64.getEncoder().encodeToString(this.sig()), (Object)delegation));
        }

        public EncodedDelegation copy(byte[] sig, byte[] op) {
            return new EncodedDelegation(sig, op);
        }

        public byte[] copy$default$1() {
            return this.sig();
        }

        public byte[] copy$default$2() {
            return this.op();
        }

        public byte[] _1() {
            return this.sig();
        }

        public byte[] _2() {
            return this.op();
        }
    }
}

