/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.sync.acl.monotonic;

import channels.tls.PrivateIdentity;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import crypto.PublicIdentity;
import java.io.Serializable;
import lofi_acl.access.Filter;
import lofi_acl.access.Operation;
import lofi_acl.access.Operation$;
import lofi_acl.access.PermissionTree;
import lofi_acl.access.PermissionTree$;
import lofi_acl.access.PermissionTree$lattice$;
import lofi_acl.sync.acl.monotonic.MonotonicAcl$;
import lofi_acl.sync.acl.monotonic.MonotonicAclSyncMessage;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class MonotonicAcl<RDT>
implements Product,
Serializable {
    private final PublicIdentity root;
    private final Map<PublicIdentity, PermissionTree> read;
    private final Map<PublicIdentity, PermissionTree> write;

    public static <RDT> MonotonicAcl<RDT> apply(PublicIdentity publicIdentity, Map<PublicIdentity, PermissionTree> map, Map<PublicIdentity, PermissionTree> map2) {
        return MonotonicAcl$.MODULE$.apply(publicIdentity, map, map2);
    }

    public static <RDT> MonotonicAclSyncMessage.AclDelta<RDT> createRootOfTrust(PrivateIdentity privateIdentity, JsonValueCodec<MonotonicAclSyncMessage<RDT>> jsonValueCodec) {
        return MonotonicAcl$.MODULE$.createRootOfTrust(privateIdentity, jsonValueCodec);
    }

    public static MonotonicAcl<?> fromProduct(Product product) {
        return MonotonicAcl$.MODULE$.fromProduct(product);
    }

    public static <RDT> MonotonicAclSyncMessage.AclDelta<RDT> signDelta(MonotonicAclSyncMessage.AclDelta<RDT> aclDelta, PrivateIdentity privateIdentity, JsonValueCodec<MonotonicAclSyncMessage<RDT>> jsonValueCodec) {
        return MonotonicAcl$.MODULE$.signDelta(aclDelta, privateIdentity, jsonValueCodec);
    }

    public static <RDT> MonotonicAcl<RDT> unapply(MonotonicAcl<RDT> monotonicAcl) {
        return MonotonicAcl$.MODULE$.unapply(monotonicAcl);
    }

    public MonotonicAcl(PublicIdentity root, Map<PublicIdentity, PermissionTree> read, Map<PublicIdentity, PermissionTree> write) {
        this.root = root;
        this.read = read;
        this.write = write;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MonotonicAcl)) return false;
        MonotonicAcl monotonicAcl = (MonotonicAcl)object;
        PublicIdentity publicIdentity = this.root();
        PublicIdentity publicIdentity2 = monotonicAcl.root();
        if (publicIdentity == null) {
            if (publicIdentity2 != null) {
                return false;
            }
        } else if (!publicIdentity.equals(publicIdentity2)) return false;
        Map<PublicIdentity, PermissionTree> map = this.read();
        Map<PublicIdentity, PermissionTree> map2 = monotonicAcl.read();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<PublicIdentity, PermissionTree> map3 = this.write();
        Map<PublicIdentity, PermissionTree> map4 = monotonicAcl.write();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        if (!monotonicAcl.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof MonotonicAcl;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "MonotonicAcl";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "root";
            }
            case 1: {
                return "read";
            }
            case 2: {
                return "write";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PublicIdentity root() {
        return this.root;
    }

    public Map<PublicIdentity, PermissionTree> read() {
        return this.read;
    }

    public Map<PublicIdentity, PermissionTree> write() {
        return this.write;
    }

    public Option<MonotonicAcl<RDT>> addReadPermissionIfAllowed(PublicIdentity forPrincipal, PublicIdentity delegatingFrom, PermissionTree realm, Filter<RDT> x$4) {
        block3: {
            block2: {
                if (realm.lteq((PermissionTree)this.read().getOrElse((Object)delegatingFrom, MonotonicAcl::addReadPermissionIfAllowed$$anonfun$1))) break block2;
                PublicIdentity publicIdentity = delegatingFrom;
                PublicIdentity publicIdentity2 = this.root();
                if (publicIdentity != null ? !publicIdentity.equals(publicIdentity2) : publicIdentity2 != null) break block3;
            }
            return Some$.MODULE$.apply(MonotonicAcl$.MODULE$.apply(this.root(), this.addPermissionWithValidationAndMinimization(this.read(), forPrincipal, realm, x$4), this.write()));
        }
        return None$.MODULE$;
    }

    public Option<MonotonicAcl<RDT>> addWritePermissionIfAllowed(PublicIdentity forPrincipal, PublicIdentity delegatingFrom, PermissionTree realm, Filter<RDT> x$4) {
        block3: {
            block2: {
                if (realm.lteq((PermissionTree)this.write().getOrElse((Object)delegatingFrom, MonotonicAcl::addWritePermissionIfAllowed$$anonfun$1))) break block2;
                PublicIdentity publicIdentity = delegatingFrom;
                PublicIdentity publicIdentity2 = this.root();
                if (publicIdentity != null ? !publicIdentity.equals(publicIdentity2) : publicIdentity2 != null) break block3;
            }
            return Some$.MODULE$.apply(MonotonicAcl$.MODULE$.apply(this.root(), this.addPermissionWithValidationAndMinimization(this.read(), forPrincipal, realm, x$4), this.addPermissionWithValidationAndMinimization(this.write(), forPrincipal, realm, x$4)));
        }
        return None$.MODULE$;
    }

    public RDT filterReceivedDelta(RDT delta, PublicIdentity sender, Filter<RDT> filter2) {
        PermissionTree permission = (PermissionTree)this.write().getOrElse((Object)sender, MonotonicAcl::$anonfun$1);
        return filter2.filter(delta, permission);
    }

    public RDT filterDeltaToSend(RDT delta, PublicIdentity receiver, Filter<RDT> filter2) {
        PermissionTree permission = (PermissionTree)this.read().getOrElse((Object)receiver, MonotonicAcl::$anonfun$2);
        return filter2.filter(delta, permission);
    }

    public Option<MonotonicAcl<RDT>> addPermissionIfAllowed(PublicIdentity forPrincipal, PublicIdentity delegatingFrom, PermissionTree realm, Operation permissionLevel, Filter<RDT> x$5) {
        Operation operation = permissionLevel;
        Operation operation2 = Operation$.READ;
        Operation operation3 = operation;
        if (!(operation2 != null ? !operation2.equals(operation3) : operation3 != null)) {
            return this.addReadPermissionIfAllowed(forPrincipal, delegatingFrom, realm, x$5);
        }
        Operation operation4 = Operation$.WRITE;
        Operation operation5 = operation;
        if (!(operation4 != null ? !operation4.equals(operation5) : operation5 != null)) {
            return this.addWritePermissionIfAllowed(forPrincipal, delegatingFrom, realm, x$5);
        }
        throw new MatchError((Object)operation);
    }

    public boolean containsPrincipal(PublicIdentity publicIdentity) {
        return this.read().contains((Object)publicIdentity);
    }

    private Map<PublicIdentity, PermissionTree> addPermissionWithValidationAndMinimization(Map<PublicIdentity, PermissionTree> mapOfPermissions, PublicIdentity principal, PermissionTree permissionToAdd, Filter<RDT> x$4) {
        return (Map)mapOfPermissions.updatedWith((Object)principal, (Function1 & Serializable)old -> {
            PermissionTree permissionTree;
            Option option = old;
            if (None$.MODULE$.equals(option)) {
                permissionTree = permissionToAdd;
            } else if (option instanceof Some) {
                PermissionTree existingPermissions = (PermissionTree)((Some)option).value();
                PermissionTree$lattice$ Lattice_this = PermissionTree$lattice$.MODULE$;
                permissionTree = Lattice_this.merge(existingPermissions, permissionToAdd);
            } else {
                throw new MatchError((Object)option);
            }
            PermissionTree updated = permissionTree;
            PermissionTree minimized = x$4.minimizePermissionTree(updated);
            x$4.validatePermissionTree(minimized);
            return Some$.MODULE$.apply((Object)minimized);
        });
    }

    public <RDT> MonotonicAcl<RDT> copy(PublicIdentity root, Map<PublicIdentity, PermissionTree> read, Map<PublicIdentity, PermissionTree> write) {
        return new MonotonicAcl<RDT>(root, read, write);
    }

    public <RDT> PublicIdentity copy$default$1() {
        return this.root();
    }

    public <RDT> Map<PublicIdentity, PermissionTree> copy$default$2() {
        return this.read();
    }

    public <RDT> Map<PublicIdentity, PermissionTree> copy$default$3() {
        return this.write();
    }

    public PublicIdentity _1() {
        return this.root();
    }

    public Map<PublicIdentity, PermissionTree> _2() {
        return this.read();
    }

    public Map<PublicIdentity, PermissionTree> _3() {
        return this.write();
    }

    private static final PermissionTree addReadPermissionIfAllowed$$anonfun$1() {
        return PermissionTree$.MODULE$.empty();
    }

    private static final PermissionTree addWritePermissionIfAllowed$$anonfun$1() {
        return PermissionTree$.MODULE$.empty();
    }

    private static final PermissionTree $anonfun$1() {
        return PermissionTree$.MODULE$.empty();
    }

    private static final PermissionTree $anonfun$2() {
        return PermissionTree$.MODULE$.empty();
    }
}

