/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.sync.acl.monotonic;

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import com.github.plokhotnyuk.jsoniter_scala.core.package$;
import crypto.Ed25519Util$;
import crypto.PublicIdentity;
import crypto.PublicIdentity$;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Base64;
import lofi_acl.access.Operation;
import lofi_acl.access.PermissionTree;
import lofi_acl.sync.InvalidMessageException;
import lofi_acl.sync.MessageSerialization;
import lofi_acl.sync.acl.monotonic.MonotonicAclSyncMessage;
import lofi_acl.sync.acl.monotonic.MonotonicAclSyncMessage$AclDelta$;
import lofi_acl.sync.acl.monotonic.MonotonicAclSyncMessage$Signature$;
import rdts.base.Uid;
import rdts.time.Dot;
import rdts.time.Dot$;
import rdts.time.Dots;
import scala.Predef$;

public class SignatureVerifyingMessageSerialization<RDT>
implements MessageSerialization<MonotonicAclSyncMessage<RDT>> {
    private final JsonValueCodec<MonotonicAclSyncMessage<RDT>> x$3;

    public SignatureVerifyingMessageSerialization(PublicIdentity localIdentity, PrivateKey signingKey, JsonValueCodec<MonotonicAclSyncMessage<RDT>> x$3) {
        this.x$3 = x$3;
        Base64.Decoder base64Decoder = Base64.getDecoder();
    }

    @Override
    public void writeToStream(MonotonicAclSyncMessage<RDT> msg, DataOutputStream outputStream) {
        MonotonicAclSyncMessage<RDT> monotonicAclSyncMessage = msg;
        if (monotonicAclSyncMessage instanceof MonotonicAclSyncMessage.AclDelta) {
            MonotonicAclSyncMessage.AclDelta aclMsg = (MonotonicAclSyncMessage.AclDelta)monotonicAclSyncMessage;
            this.writeSigned(aclMsg, outputStream);
            return;
        }
        this.writeUnsigned(msg, outputStream);
    }

    @Override
    public MonotonicAclSyncMessage<RDT> readFromStream(DataInputStream inputStream) {
        if (inputStream.readBoolean()) {
            return this.readSigned(inputStream);
        }
        return this.readUnsigned(inputStream);
    }

    private MonotonicAclSyncMessage.AclDelta<RDT> readSigned(DataInputStream inputStream) {
        MonotonicAclSyncMessage deserializedMsg;
        byte[] signature = new byte[64];
        Predef$.MODULE$.require(inputStream.read(signature, 0, 64) == 64);
        int msgLength = inputStream.readInt();
        byte[] msgBytes = new byte[msgLength];
        Predef$.MODULE$.require(inputStream.read(msgBytes, 0, msgLength) == msgLength);
        MonotonicAclSyncMessage monotonicAclSyncMessage = deserializedMsg = (MonotonicAclSyncMessage)package$.MODULE$.readFromArray(msgBytes, package$.MODULE$.readFromArray$default$2(), this.x$3);
        if (monotonicAclSyncMessage instanceof MonotonicAclSyncMessage.AclDelta) {
            MonotonicAclSyncMessage.AclDelta aclDelta = (MonotonicAclSyncMessage.AclDelta)monotonicAclSyncMessage;
            MonotonicAclSyncMessage.AclDelta aclDelta2 = MonotonicAclSyncMessage$AclDelta$.MODULE$.unapply(aclDelta);
            PublicIdentity publicIdentity = aclDelta2._1();
            PermissionTree permissionTree = aclDelta2._2();
            Operation operation = aclDelta2._3();
            Dot dot = aclDelta2._4();
            Dots dots = aclDelta2._5();
            MonotonicAclSyncMessage.Signature signature2 = aclDelta2._6();
            if (dot != null) {
                Dot dot2 = Dot$.MODULE$.unapply(dot);
                Uid uid = dot2._1();
                long l = dot2._2();
                Uid author = uid;
                MonotonicAclSyncMessage.AclDelta aclEntry = aclDelta;
                if (!Ed25519Util$.MODULE$.checkEd25519Signature(msgBytes, signature, PublicIdentity$.MODULE$.apply(author.delegate()))) {
                    throw new SignatureException("Failed to verify signature of received message");
                }
                MonotonicAclSyncMessage.Signature signature3 = MonotonicAclSyncMessage$Signature$.MODULE$.apply(signature);
                PublicIdentity publicIdentity2 = aclEntry.copy$default$1();
                PermissionTree permissionTree2 = aclEntry.copy$default$2();
                Operation operation2 = aclEntry.copy$default$3();
                Dot dot3 = aclEntry.copy$default$4();
                Dots dots2 = aclEntry.copy$default$5();
                return aclEntry.copy(publicIdentity2, permissionTree2, operation2, dot3, dots2, signature3);
            }
        }
        throw new InvalidMessageException("Signed message is not an update to ACL");
    }

    private MonotonicAclSyncMessage<RDT> readUnsigned(DataInputStream inputStream) {
        int msgLength = inputStream.readInt();
        byte[] msgBytes = new byte[msgLength];
        Predef$.MODULE$.require(inputStream.read(msgBytes, 0, msgLength) == msgLength);
        MonotonicAclSyncMessage deserializedMessage = (MonotonicAclSyncMessage)package$.MODULE$.readFromArray(msgBytes, package$.MODULE$.readFromArray$default$2(), this.x$3);
        if (deserializedMessage instanceof MonotonicAclSyncMessage.AclDelta) {
            throw new InvalidMessageException("Expected AddAclEntry message to be signed");
        }
        return deserializedMessage;
    }

    private void writeSigned(MonotonicAclSyncMessage.AclDelta<RDT> msg, DataOutputStream outputStream) {
        Predef$.MODULE$.require(msg.signature() != null && msg.signature().sig().length == 64);
        byte[] msgBytes = package$.MODULE$.writeToArray(msg.copy(msg.copy$default$1(), msg.copy$default$2(), msg.copy$default$3(), msg.copy$default$4(), msg.copy$default$5(), null), package$.MODULE$.writeToArray$default$2(), this.x$3);
        outputStream.writeBoolean(true);
        outputStream.write(msg.signature().sig());
        outputStream.writeInt(msgBytes.length);
        outputStream.write(msgBytes);
    }

    private void writeUnsigned(MonotonicAclSyncMessage<RDT> msg, DataOutputStream outputStream) {
        byte[] msgBytes = package$.MODULE$.writeToArray(msg, package$.MODULE$.writeToArray$default$2(), this.x$3);
        outputStream.writeBoolean(false);
        outputStream.writeInt(msgBytes.length);
        outputStream.write(msgBytes);
    }
}

