/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.sync.acl.monotonic;

import channels.tls.PrivateIdentity;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import crypto.PublicIdentity;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import lofi_acl.access.Filter;
import lofi_acl.access.Operation;
import lofi_acl.access.PermissionTree;
import lofi_acl.collections.DeltaMapWithPrefix;
import lofi_acl.sync.JsoniterCodecs$;
import lofi_acl.sync.acl.Sync;
import lofi_acl.sync.acl.monotonic.FilteringAntiEntropy;
import lofi_acl.sync.acl.monotonic.MonotonicAcl;
import lofi_acl.sync.acl.monotonic.MonotonicAclSyncMessage;
import lofi_acl.sync.acl.monotonic.SyncWithMonotonicAcl$;
import rdts.base.Bottom;
import rdts.base.Lattice;
import rdts.base.Uid$;
import rdts.time.Dot;
import rdts.time.Dot$;
import rdts.time.Dots;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class SyncWithMonotonicAcl<RDT>
implements Sync<RDT> {
    private final PrivateIdentity localIdentity;
    private final Function1<RDT, BoxedUnit> onDeltaReceive;
    private final Lattice<RDT> lattice;
    private final FilteringAntiEntropy<RDT> antiEntropy;
    private volatile Option<Thread> antiEntropyThread;
    private final PublicIdentity localPublicId;
    private final AtomicReference<Tuple2<Dots, RDT>> rdtReference;
    private final AtomicReference<Dot> lastLocalRdtDot;
    private final AtomicReference<Dot> lastLocalAclDot;

    public static <RDT> SyncWithMonotonicAcl<RDT> createAsRootOfTrust(PrivateIdentity privateIdentity, Lattice<RDT> lattice, Bottom<RDT> bottom2, JsonValueCodec<RDT> jsonValueCodec, Filter<RDT> filter2, JsonValueCodec<MonotonicAclSyncMessage<RDT>> jsonValueCodec2) {
        return SyncWithMonotonicAcl$.MODULE$.createAsRootOfTrust(privateIdentity, lattice, bottom2, jsonValueCodec, filter2, jsonValueCodec2);
    }

    public static <RDT> Function1<RDT, BoxedUnit> $lessinit$greater$default$5() {
        return SyncWithMonotonicAcl$.MODULE$.$lessinit$greater$default$5();
    }

    public SyncWithMonotonicAcl(PrivateIdentity localIdentity, PublicIdentity rootOfTrust, List<MonotonicAclSyncMessage.AclDelta<RDT>> initialAclDeltas, DeltaMapWithPrefix<RDT> initialRdt, Function1<RDT, BoxedUnit> onDeltaReceive, Lattice<RDT> lattice, Bottom<RDT> bottom2, JsonValueCodec<RDT> rdtJsonCode, Filter<RDT> filter2) {
        this.localIdentity = localIdentity;
        this.onDeltaReceive = onDeltaReceive;
        this.lattice = lattice;
        this.antiEntropy = new FilteringAntiEntropy<RDT>(localIdentity, rootOfTrust, initialAclDeltas, initialRdt, this, rdtJsonCode, filter2, lattice, bottom2, JsoniterCodecs$.MODULE$.messageJsonCodec(rdtJsonCode));
        this.antiEntropyThread = None$.MODULE$;
        this.localPublicId = localIdentity.getPublic();
        Dots dots = (Dots)Predef$.MODULE$.ArrowAssoc((Object)initialRdt.allDots());
        Lattice Lattice_this = lattice;
        Object right$proxy1 = initialRdt.deltas().foldLeft(bottom2.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Object l = tuple2._1();
                if (tuple22 != null) {
                    Object r = tuple22._2();
                    Lattice Lattice_this = lattice;
                    return Lattice_this.merge(l, r);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        this.rdtReference = new AtomicReference<Tuple2>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dots, Lattice_this.merge(initialRdt.prefix(), right$proxy1)));
        this.lastLocalRdtDot = new AtomicReference<Object>(initialRdt._1().max(Uid$.MODULE$.apply(this.localPublicId.id())).getOrElse(this::$init$$$anonfun$1));
        String localId = localIdentity.getPublic().id();
        this.lastLocalAclDot = new AtomicReference<Object>(initialAclDeltas.filter((Function1 & Serializable)_$2 -> {
            String string = _$2.dot().place().delegate();
            String string2 = localId;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).maxByOption((Function1 & Serializable)_$3 -> _$3.dot().time(), (Ordering)Ordering.Long$.MODULE$).map((Function1 & Serializable)_$4 -> _$4.dot()).getOrElse(() -> SyncWithMonotonicAcl.$init$$$anonfun$5(localIdentity)));
    }

    private PrivateIdentity localIdentity() {
        return this.localIdentity;
    }

    public RDT state() {
        return (RDT)this.rdtReference.get()._2();
    }

    public MonotonicAcl<RDT> currentAcl() {
        return this.antiEntropy.acl();
    }

    public void grantPermissions(PublicIdentity affectedUser, PermissionTree realm, Operation typeOfPermission) {
        Dot dot2 = this.lastLocalAclDot.updateAndGet(dot -> dot.advance());
        this.antiEntropy.grantPermission(dot2, affectedUser, realm, typeOfPermission);
    }

    public void mutateRdt(Function1<RDT, RDT> deltaMutator) {
        Dot dot2 = this.lastLocalRdtDot.updateAndGet(dot -> dot.advance());
        this.antiEntropy.mutateRdt(dot2, deltaMutator.apply(this.rdtReference.get()._2()));
    }

    @Override
    public String connectionString() {
        return "localhost:" + this.antiEntropy.listenPort().getOrElse(SyncWithMonotonicAcl::connectionString$$anonfun$1);
    }

    @Override
    public void connect(PublicIdentity remoteUser, String remoteAddress) {
        String[] hostParts = remoteAddress.split(":");
        Predef$.MODULE$.require(hostParts.length == 2);
        Object[] objectArray = new Tuple2[1];
        PublicIdentity publicIdentity = (PublicIdentity)Predef$.MODULE$.ArrowAssoc((Object)remoteUser);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)publicIdentity, (Object)Tuple2$.MODULE$.apply((Object)hostParts[0], (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(hostParts[1])))));
        this.antiEntropy.newPeers((Set<Tuple2<PublicIdentity, Tuple2<String, Object>>>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    @Override
    public void receivedDelta(Dot dot, RDT delta) {
        Tuple2<Dots, RDT> tuple2 = this.rdtReference.updateAndGet(x$1 -> {
            Dots dots = (Dots)x$1._1();
            Object object = x$1._2();
            Dots dots2 = (Dots)Predef$.MODULE$.ArrowAssoc((Object)dots.add(dot));
            Lattice<RDT> Lattice_this = this.lattice;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dots2, Lattice_this.merge(object, delta));
        });
        this.onDeltaReceive.apply(delta);
    }

    public void start() {
        SyncWithMonotonicAcl syncWithMonotonicAcl = this;
        synchronized (syncWithMonotonicAcl) {
            Predef$.MODULE$.require(this.antiEntropyThread.isEmpty());
            this.antiEntropyThread = Some$.MODULE$.apply((Object)this.antiEntropy.start());
        }
    }

    public void stop() {
        SyncWithMonotonicAcl syncWithMonotonicAcl = this;
        synchronized (syncWithMonotonicAcl) {
            Predef$.MODULE$.require(this.antiEntropyThread.nonEmpty());
            this.antiEntropy.stop();
            ((Thread)this.antiEntropyThread.get()).interrupt();
            this.antiEntropyThread = None$.MODULE$;
        }
    }

    private final Dot $init$$$anonfun$1() {
        return Dot$.MODULE$.apply(Uid$.MODULE$.apply(this.localPublicId.id()), -1L);
    }

    private static final Dot $init$$$anonfun$5(PrivateIdentity localIdentity$1) {
        return Dot$.MODULE$.apply(Uid$.MODULE$.apply(localIdentity$1.getPublic().id()), -1L);
    }

    private static final int connectionString$$anonfun$1() {
        return -1;
    }
}

