/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.sync.no_acl;

import channels.tls.PrivateIdentity;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import crypto.PublicIdentity;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import lofi_acl.collections.DeltaStore;
import lofi_acl.collections.DeltaStore$;
import lofi_acl.sync.CausalityCheckingMessageHandler;
import lofi_acl.sync.ConnectionManager;
import lofi_acl.sync.MessageSerialization$;
import lofi_acl.sync.no_acl.MutuallyTrustingSyncMessage;
import lofi_acl.sync.no_acl.MutuallyTrustingSyncMessage$AddUsers$;
import lofi_acl.sync.no_acl.MutuallyTrustingSyncMessage$AnnouncePeers$;
import lofi_acl.sync.no_acl.MutuallyTrustingSyncMessage$Delta$;
import lofi_acl.sync.no_acl.MutuallyTrustingSyncMessage$RequestMissing$;
import lofi_acl.sync.no_acl.MutuallyTrustingSyncMessage$Time$;
import rdts.base.Bottom;
import rdts.base.Lattice;
import rdts.base.Lattice$;
import rdts.base.Uid$;
import rdts.time.Dot;
import rdts.time.Dot$;
import rdts.time.Dots;
import rdts.time.Dots$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Random;

public class MutuallyTrustingSync<RDT>
implements CausalityCheckingMessageHandler<MutuallyTrustingSyncMessage<RDT>> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MutuallyTrustingSync.class.getDeclaredField("ec$lzy1"));
    private LinkedBlockingQueue msgQueue;
    private volatile boolean lofi_acl$sync$CausalityCheckingMessageHandler$$stopped;
    private final PrivateIdentity localIdentity;
    private final Lattice<RDT> lattice;
    private final PublicIdentity localPublicId;
    private final AtomicReference<Tuple2<Dots, RDT>> rdtReference;
    private final AtomicReference<Dot> lastLocalRdtDot;
    private final AtomicReference<Tuple2<Dots, scala.collection.immutable.Set<PublicIdentity>>> permissionsReference;
    private final AtomicReference<Dot> lastLocalPermissionsDot;
    public volatile boolean lofi_acl$sync$no_acl$MutuallyTrustingSync$$stopped;
    public volatile DeltaStore<RDT> lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore;
    public volatile Dots lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots;
    private volatile Dots maxReferencedRdtDots;
    public volatile DeltaStore<scala.collection.immutable.Set<PublicIdentity>> lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore;
    public volatile Dots lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots;
    private volatile Dots maxReferencedPermissionDots;
    public final ConnectionManager<MutuallyTrustingSyncMessage<RDT>> lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager;
    private final ExecutorService executor;
    private volatile Object ec$lzy1;

    public MutuallyTrustingSync(PrivateIdentity localIdentity, Tuple2<Dots, RDT> initialRdt, Tuple2<Dots, scala.collection.immutable.Set<PublicIdentity>> initialPermissions, Lattice<RDT> lattice, Bottom<RDT> bottom2, JsonValueCodec<MutuallyTrustingSyncMessage<RDT>> msgJsonCode) {
        this.localIdentity = localIdentity;
        this.lattice = lattice;
        CausalityCheckingMessageHandler.$init$(this);
        this.localPublicId = localIdentity.getPublic();
        this.rdtReference = new AtomicReference<Tuple2<Dots, RDT>>(initialRdt);
        this.lastLocalRdtDot = new AtomicReference<Object>(((Dots)initialRdt._1()).max(Uid$.MODULE$.apply(this.localPublicId.id())).getOrElse(this::$init$$$anonfun$1));
        this.permissionsReference = new AtomicReference<Tuple2<Dots, scala.collection.immutable.Set<PublicIdentity>>>(initialPermissions);
        this.lastLocalPermissionsDot = new AtomicReference<Object>(((Dots)initialPermissions._1()).max(Uid$.MODULE$.apply(this.localPublicId.id())).getOrElse(this::$init$$$anonfun$2));
        this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$stopped = false;
        Map remoteTimes = Predef$.MODULE$.Map().empty();
        this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore = DeltaStore$.MODULE$.from((Dots)initialRdt._1(), initialRdt._2(), Dots$.MODULE$.empty(), Predef$.MODULE$.Map().empty());
        this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots = (Dots)initialRdt._1();
        this.maxReferencedRdtDots = (Dots)initialRdt._1();
        this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore = DeltaStore$.MODULE$.from((Dots)initialPermissions._1(), initialPermissions._2(), Dots$.MODULE$.empty(), Predef$.MODULE$.Map().empty());
        this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots = (Dots)initialPermissions._1();
        this.maxReferencedPermissionDots = (Dots)initialPermissions._1();
        this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager = new ConnectionManager<MutuallyTrustingSyncMessage<RDT>>(localIdentity, this, MessageSerialization$.MODULE$.derived(msgJsonCode));
        this.executor = Executors.newCachedThreadPool();
        Future<?> antiEntropyThread = this.executor.submit(new Runnable(this){
            private final Random rand;
            private final /* synthetic */ MutuallyTrustingSync $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.rand = new Random();
            }

            public void run() {
                while (!this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$stopped) {
                    Thread.sleep(Duration$.MODULE$.apply(30L, package$.MODULE$.SECONDS()).toMillis());
                    scala.collection.immutable.Set<PublicIdentity> users = this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.connectedUsers();
                    Option userToRequestMissingDataFrom = users.iterator().drop(this.rand.nextInt(users.size())).nextOption();
                    Option userToSendTimeTo = users.iterator().drop(this.rand.nextInt(users.size())).nextOption();
                    if (userToRequestMissingDataFrom.isDefined()) {
                        boolean bl = this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.send((PublicIdentity)userToRequestMissingDataFrom.get(), MutuallyTrustingSyncMessage$RequestMissing$.MODULE$.apply(this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore.retrievableDots(), this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots, this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore.retrievableDots(), this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots));
                    }
                    if (!userToSendTimeTo.isDefined()) continue;
                    boolean bl = this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.send((PublicIdentity)userToSendTimeTo.get(), MutuallyTrustingSyncMessage$Time$.MODULE$.apply(this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore.retrievableDots(), this.$outer.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore.retrievableDots()));
                }
            }
        });
        Statics.releaseFence();
    }

    @Override
    public LinkedBlockingQueue msgQueue() {
        return this.msgQueue;
    }

    @Override
    public boolean lofi_acl$sync$CausalityCheckingMessageHandler$$stopped() {
        return this.lofi_acl$sync$CausalityCheckingMessageHandler$$stopped;
    }

    @Override
    public void lofi_acl$sync$CausalityCheckingMessageHandler$$stopped_$eq(boolean x$1) {
        this.lofi_acl$sync$CausalityCheckingMessageHandler$$stopped = x$1;
    }

    @Override
    public void lofi_acl$sync$CausalityCheckingMessageHandler$_setter_$msgQueue_$eq(LinkedBlockingQueue x$0) {
        this.msgQueue = x$0;
    }

    private PrivateIdentity localIdentity() {
        return this.localIdentity;
    }

    private final ExecutionContext ec() {
        Object object = this.ec$lzy1;
        if (object instanceof ExecutionContext) {
            return (ExecutionContext)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ExecutionContext)this.ec$lzyINIT1();
    }

    private Object ec$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ec$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ExecutionContextExecutor executionContextExecutor = null;
                    try {
                        executionContextExecutor = ExecutionContext$.MODULE$.fromExecutor((Executor)this.executor);
                        object2 = executionContextExecutor == null ? LazyVals.NullValue$.MODULE$ : executionContextExecutor;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ec$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return executionContextExecutor;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void addUser(PublicIdentity user) {
        Dot dot2 = this.lastLocalPermissionsDot.updateAndGet(dot -> dot.advance());
        Dots dots = (Dots)this.permissionsReference.get()._1();
        MutuallyTrustingSyncMessage.AddUsers addUsersMsg = MutuallyTrustingSyncMessage$AddUsers$.MODULE$.apply((scala.collection.immutable.Set<PublicIdentity>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PublicIdentity[]{user}))), Dot.hasDot$.MODULE$.dots(dot2), dots);
        this.receivedMessage(addUsersMsg, this.localPublicId);
        boolean bl = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.broadcast((Seq<MutuallyTrustingSyncMessage<RDT>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MutuallyTrustingSyncMessage[]{addUsersMsg}));
    }

    public void mutateRdt(Function1<RDT, RDT> deltaMutator) {
        Dot dot2 = this.lastLocalRdtDot.updateAndGet(dot -> dot.advance());
        Tuple2<Dots, RDT> tuple2 = this.rdtReference.get();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dots dots = (Dots)tuple2._1();
        Object rdt = tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dots, rdt);
        Dots dots2 = (Dots)tuple22._1();
        Object rdt2 = tuple22._2();
        MutuallyTrustingSyncMessage.Delta<Object> delta = MutuallyTrustingSyncMessage$Delta$.MODULE$.apply(deltaMutator.apply(rdt2), Dot.hasDot$.MODULE$.dots(dot2), dots2, (Dots)this.permissionsReference.get()._1());
        this.receivedMessage(delta, this.localIdentity().getPublic());
        boolean bl = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.broadcast((Seq<MutuallyTrustingSyncMessage<RDT>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MutuallyTrustingSyncMessage[]{delta}));
    }

    @Override
    public void receivedMessage(MutuallyTrustingSyncMessage<RDT> msg, PublicIdentity sender) {
        if (((SetOps)this.permissionsReference.get()._2()).contains((Object)sender)) {
            this.msgQueue().put(Tuple2$.MODULE$.apply(msg, (Object)sender));
            return;
        }
    }

    @Override
    public void newMessageWithMissingPredecessors(MutuallyTrustingSyncMessage<RDT> msg, PublicIdentity sender) {
        Dots rdtMissing = Dots$.MODULE$.empty();
        Dots permMissing = Dots$.MODULE$.empty();
        MutuallyTrustingSyncMessage<RDT> mutuallyTrustingSyncMessage = msg;
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.Delta) {
            MutuallyTrustingSyncMessage.Delta delta = MutuallyTrustingSyncMessage$Delta$.MODULE$.unapply((MutuallyTrustingSyncMessage.Delta)mutuallyTrustingSyncMessage);
            Object RDT = delta._1();
            Dots dots = delta._2();
            Dots dots2 = delta._3();
            Dots dots3 = delta._4();
            Object delta2 = RDT;
            Dots dots4 = dots;
            Dots rdtCC = dots2;
            Dots permCC = dots3;
            this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots.union(dots4);
            this.maxReferencedRdtDots = this.maxReferencedRdtDots.union(rdtCC).union(dots4);
            this.maxReferencedPermissionDots = this.maxReferencedPermissionDots.union(permCC);
            rdtMissing = rdtCC;
            permMissing = permCC;
        } else if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.AddUsers) {
            MutuallyTrustingSyncMessage.AddUsers addUsers = MutuallyTrustingSyncMessage$AddUsers$.MODULE$.unapply((MutuallyTrustingSyncMessage.AddUsers)mutuallyTrustingSyncMessage);
            scala.collection.immutable.Set<PublicIdentity> set = addUsers._1();
            Dots dots = addUsers._2();
            Dots dots5 = addUsers._3();
            Dots dots6 = dots;
            Dots cc = dots5;
            this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots.union(dots6);
            this.maxReferencedPermissionDots = this.maxReferencedPermissionDots.union(dots6).union(cc);
            permMissing = cc;
        } else {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        this.requestDeltasIfStillMissingAfterDelay(sender, rdtMissing, permMissing, (Duration)Duration$.MODULE$.apply(1L, package$.MODULE$.SECONDS()));
    }

    @Override
    public boolean canHandleMessage(MutuallyTrustingSyncMessage<RDT> msg) {
        MutuallyTrustingSyncMessage<RDT> mutuallyTrustingSyncMessage = msg;
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.Time) {
            MutuallyTrustingSyncMessage.Time time = MutuallyTrustingSyncMessage$Time$.MODULE$.unapply((MutuallyTrustingSyncMessage.Time)mutuallyTrustingSyncMessage);
            Dots dots = time._1();
            Dots dots2 = time._2();
            return true;
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.AddUsers) {
            MutuallyTrustingSyncMessage.AddUsers addUsers = MutuallyTrustingSyncMessage$AddUsers$.MODULE$.unapply((MutuallyTrustingSyncMessage.AddUsers)mutuallyTrustingSyncMessage);
            scala.collection.immutable.Set<PublicIdentity> set = addUsers._1();
            Dots dots = addUsers._2();
            Dots dots3 = addUsers._3();
            scala.collection.immutable.Set<PublicIdentity> users = set;
            Dots dots4 = dots;
            Dots cc = dots3;
            return this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore.contains(cc);
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.Delta) {
            MutuallyTrustingSyncMessage.Delta delta = MutuallyTrustingSyncMessage$Delta$.MODULE$.unapply((MutuallyTrustingSyncMessage.Delta)mutuallyTrustingSyncMessage);
            Object RDT = delta._1();
            Dots dots = delta._2();
            Dots dots5 = delta._3();
            Dots dots6 = delta._4();
            Dots rdtCC = dots5;
            Dots permCC = dots6;
            return this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore.contains(rdtCC) && this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore.contains(permCC);
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.AnnouncePeers) {
            Map<PublicIdentity, Tuple2<String, Object>> map;
            MutuallyTrustingSyncMessage.AnnouncePeers announcePeers = MutuallyTrustingSyncMessage$AnnouncePeers$.MODULE$.unapply((MutuallyTrustingSyncMessage.AnnouncePeers)mutuallyTrustingSyncMessage);
            Map<PublicIdentity, Tuple2<String, Object>> peers = map = announcePeers._1();
            return true;
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.RequestMissing) {
            MutuallyTrustingSyncMessage.RequestMissing requestMissing = MutuallyTrustingSyncMessage$RequestMissing$.MODULE$.unapply((MutuallyTrustingSyncMessage.RequestMissing)mutuallyTrustingSyncMessage);
            Dots dots = requestMissing._1();
            Dots dots7 = requestMissing._2();
            Dots dots8 = requestMissing._3();
            Dots dots9 = requestMissing._4();
            return true;
        }
        throw new MatchError(mutuallyTrustingSyncMessage);
    }

    @Override
    public boolean handleMessage(MutuallyTrustingSyncMessage<RDT> msg, PublicIdentity sender) {
        MutuallyTrustingSyncMessage<RDT> mutuallyTrustingSyncMessage = msg;
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.AnnouncePeers) {
            Map<PublicIdentity, Tuple2<String, Object>> map;
            MutuallyTrustingSyncMessage.AnnouncePeers announcePeers = MutuallyTrustingSyncMessage$AnnouncePeers$.MODULE$.unapply((MutuallyTrustingSyncMessage.AnnouncePeers)mutuallyTrustingSyncMessage);
            Map<PublicIdentity, Tuple2<String, Object>> peers = map = announcePeers._1();
            peers.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    PublicIdentity user = (PublicIdentity)tuple2._1();
                    if (tuple22 != null) {
                        String host = (String)tuple22._1();
                        int port = BoxesRunTime.unboxToInt((Object)tuple22._2());
                        this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.connectToExpectingUserIfNoConnectionExists(host, port, user);
                        return;
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return false;
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.AddUsers) {
            MutuallyTrustingSyncMessage.AddUsers addUsers = MutuallyTrustingSyncMessage$AddUsers$.MODULE$.unapply((MutuallyTrustingSyncMessage.AddUsers)mutuallyTrustingSyncMessage);
            scala.collection.immutable.Set<PublicIdentity> set = addUsers._1();
            Dots dots = addUsers._2();
            Dots dots2 = addUsers._3();
            Dots permissionDots = dots;
            scala.collection.immutable.Set<PublicIdentity> newUsers = set;
            Tuple2<Dots, scala.collection.immutable.Set<PublicIdentity>> tuple2 = this.permissionsReference.getAndUpdate(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Dots dots = (Dots)tuple2._1();
                    scala.collection.immutable.Set users = (scala.collection.immutable.Set)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)permissionDots.union(dots), (Object)users.union((Set)newUsers));
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Dots oldPermDots = (Dots)tuple2._1();
            Dots oldPermDots2 = oldPermDots;
            this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore.addDeltaIfNew(permissionDots, newUsers);
            this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots.union(permissionDots);
            return oldPermDots2.contains(permissionDots);
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.Delta) {
            MutuallyTrustingSyncMessage.Delta delta = MutuallyTrustingSyncMessage$Delta$.MODULE$.unapply((MutuallyTrustingSyncMessage.Delta)mutuallyTrustingSyncMessage);
            Object RDT = delta._1();
            Dots dots = delta._2();
            Dots dots3 = delta._3();
            Dots dots4 = delta._4();
            Dots dots5 = dots;
            Object delta2 = RDT;
            Tuple2<Dots, RDT> tuple2 = this.rdtReference.getAndUpdate(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Dots oldRdtTime = (Dots)tuple2._1();
                    Object oldRdt = tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)oldRdtTime.union(dots5), this.lattice.merge(oldRdt, delta2));
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Dots oldRdtDots = (Dots)tuple2._1();
            Dots oldRdtDots2 = oldRdtDots;
            this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore.addDeltaIfNew(dots5, delta2);
            Lattice Lattice_this = Dots$.MODULE$.contextLattice();
            Dots left$proxy1 = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots;
            this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots = (Dots)Lattice_this.merge((Object)left$proxy1, (Object)dots5);
            this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.send(sender, MutuallyTrustingSyncMessage$Time$.MODULE$.apply(this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore.retrievableDots(), this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore.retrievableDots()));
            return oldRdtDots2.contains(dots5);
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.Time) {
            MutuallyTrustingSyncMessage.Time time = MutuallyTrustingSyncMessage$Time$.MODULE$.unapply((MutuallyTrustingSyncMessage.Time)mutuallyTrustingSyncMessage);
            Dots dots = time._1();
            Dots dots6 = time._2();
            Dots remoteRdtTime = dots;
            Dots remotePermissionTime = dots6;
            this.maxReferencedRdtDots = this.maxReferencedRdtDots.union(remoteRdtTime);
            this.maxReferencedPermissionDots = this.maxReferencedPermissionDots.union(remotePermissionTime);
            if (!this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots.contains(remoteRdtTime) || !this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots.contains(remotePermissionTime)) {
                this.requestDeltasIfStillMissingAfterDelay(sender, this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots, this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots, (Duration)Duration$.MODULE$.apply(50L, package$.MODULE$.MILLISECONDS()));
            }
            return false;
        }
        if (mutuallyTrustingSyncMessage instanceof MutuallyTrustingSyncMessage.RequestMissing) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            MutuallyTrustingSyncMessage.RequestMissing requestMissing = MutuallyTrustingSyncMessage$RequestMissing$.MODULE$.unapply((MutuallyTrustingSyncMessage.RequestMissing)mutuallyTrustingSyncMessage);
            Dots dots = requestMissing._1();
            Dots dots7 = requestMissing._2();
            Dots dots8 = requestMissing._3();
            Dots dots9 = requestMissing._4();
            Dots rdtMerged = dots;
            Dots rdtReceived = dots7;
            Dots permMerged = dots8;
            Dots permReceived = dots9;
            DeltaStore<RDT> rdtStore = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore;
            Dots missingRdtDeltas = rdtStore.retrievableDots().subtract(rdtMerged.union(rdtReceived));
            Option<Tuple2<Dots, RDT>> option = rdtStore.readAvailableDeltasAsSingleDelta(missingRdtDeltas, this.lattice);
            if (option instanceof Some && (tuple22 = (Tuple2)((Some)option).value()) != null) {
                Dots dots10 = (Dots)tuple22._1();
                Object delta = tuple22._2();
                v0 = BoxesRunTime.boxToBoolean((boolean)this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.send(sender, MutuallyTrustingSyncMessage$Delta$.MODULE$.apply(delta, dots10, Dots$.MODULE$.empty(), Dots$.MODULE$.empty())));
            } else if (None$.MODULE$.equals(option)) {
                v0 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            DeltaStore<scala.collection.immutable.Set<PublicIdentity>> permissionStore = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore;
            Dots missingPermissionDeltas = permissionStore.retrievableDots().subtract(permMerged.union(permReceived));
            Option<Tuple2<Dots, scala.collection.immutable.Set<PublicIdentity>>> option2 = permissionStore.readAvailableDeltasAsSingleDelta(missingPermissionDeltas, (Lattice<scala.collection.immutable.Set<PublicIdentity>>)Lattice$.MODULE$.setLattice());
            if (option2 instanceof Some && (tuple2 = (Tuple2)((Some)option2).value()) != null) {
                Dots dots11 = (Dots)tuple2._1();
                scala.collection.immutable.Set permDelta = (scala.collection.immutable.Set)tuple2._2();
                v1 = BoxesRunTime.boxToBoolean((boolean)this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.send(sender, MutuallyTrustingSyncMessage$AddUsers$.MODULE$.apply((scala.collection.immutable.Set<PublicIdentity>)permDelta, dots11, Dots$.MODULE$.empty())));
            } else if (None$.MODULE$.equals(option2)) {
                v1 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            return false;
        }
        throw new MatchError(mutuallyTrustingSyncMessage);
    }

    private void requestDeltasIfStillMissingAfterDelay(PublicIdentity remote, Dots rdtDots, Dots permDots, Duration delay) {
        scala.concurrent.Future future = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.requestDeltasIfStillMissingAfterDelay$$anonfun$1(delay, rdtDots, permDots, remote);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    private final Dot $init$$$anonfun$1() {
        return Dot$.MODULE$.apply(Uid$.MODULE$.apply(this.localPublicId.id()), -1L);
    }

    private final Dot $init$$$anonfun$2() {
        return Dot$.MODULE$.apply(Uid$.MODULE$.apply(this.localPublicId.id()), -1L);
    }

    private final void requestDeltasIfStillMissingAfterDelay$$anonfun$1(Duration delay$1, Dots rdtDots$1, Dots permDots$1, PublicIdentity remote$1) {
        Thread.sleep(delay$1.toMillis());
        if (!this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots.contains(rdtDots$1) || !this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots.contains(permDots$1)) {
            boolean bl = this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$connectionManager.send(remote$1, MutuallyTrustingSyncMessage$RequestMissing$.MODULE$.apply(this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$rdtDeltaStore.retrievableDots(), this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedRdtDots, this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$permissionDeltaStore.retrievableDots(), this.lofi_acl$sync$no_acl$MutuallyTrustingSync$$receivedPermissionDots));
            return;
        }
    }
}

