/*
 * Decompiled with CFR 0.152.
 */
package replication;

import channels.Abort;
import channels.Connection;
import channels.LatentConnection;
import channels.LatentConnection$;
import channels.MessageBuffer;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonReader;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter;
import de.rmgk.delay;
import java.io.Serializable;
import rdts.base.Lattice;
import rdts.base.Lattice$;
import rdts.base.LocalUid;
import rdts.base.Uid;
import rdts.time.Dot;
import rdts.time.Dots;
import rdts.time.Dots$;
import replication.Aead;
import replication.CachedMessage;
import replication.DeltaDissemination$;
import replication.JsoniterCodecs$;
import replication.ProtocolMessage;
import replication.ProtocolMessage$Payload$;
import replication.ProtocolMessage$Ping$;
import replication.ProtocolMessage$Pong$;
import replication.ProtocolMessage$Request$;
import replication.ReceivedCachedMessage;
import replication.SentCachedMessage;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class DeltaDissemination<State> {
    private final LocalUid replicaId;
    private final Function1<State, BoxedUnit> receiveCallback;
    private final boolean immediateForward;
    private final ExecutionContext sendingActor;
    private final Abort globalAbort;
    private final JsonValueCodec<State> x$7;
    private volatile List<Connection<CachedMessage<ProtocolMessage<State>>>> connections;
    private final delay.Callback<Object> printExceptionHandler;
    private final Object lock;
    private Queue<CachedMessage<ProtocolMessage.Payload<State>>> pastPayloads;
    private final int keepPastPayloads;
    private Map<Uid, Dots> contexts;

    public static ExecutionContext executeImmediately() {
        return DeltaDissemination$.MODULE$.executeImmediately();
    }

    public static <State> Option<Aead> $lessinit$greater$default$3() {
        return DeltaDissemination$.MODULE$.$lessinit$greater$default$3();
    }

    public static <State> boolean $lessinit$greater$default$4() {
        return DeltaDissemination$.MODULE$.$lessinit$greater$default$4();
    }

    public static <State> ExecutionContext $lessinit$greater$default$5() {
        return DeltaDissemination$.MODULE$.$lessinit$greater$default$5();
    }

    public static <State> Abort $lessinit$greater$default$6() {
        return DeltaDissemination$.MODULE$.$lessinit$greater$default$6();
    }

    public DeltaDissemination(LocalUid replicaId, Function1<State, BoxedUnit> receiveCallback, Option<Aead> crypto, boolean immediateForward, ExecutionContext sendingActor, Abort globalAbort, JsonValueCodec<State> x$7) {
        this.replicaId = replicaId;
        this.receiveCallback = receiveCallback;
        this.immediateForward = immediateForward;
        this.sendingActor = sendingActor;
        this.globalAbort = globalAbort;
        this.x$7 = x$7;
        this.connections = package$.MODULE$.Nil();
        this.printExceptionHandler = x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                Predef$.MODULE$.println((Object)"exception during connection activation");
                ex.printStackTrace();
                return;
            }
            if (try_ instanceof Success) {
                return;
            }
            throw new MatchError((Object)try_);
        };
        this.lock = new Object(){};
        this.pastPayloads = Queue$.MODULE$.empty();
        this.keepPastPayloads = 108;
        this.contexts = Predef$.MODULE$.Map().empty();
    }

    public LocalUid replicaId() {
        return this.replicaId;
    }

    public Abort globalAbort() {
        return this.globalAbort;
    }

    public final LocalUid given_LocalUid() {
        return this.replicaId();
    }

    public <T extends ProtocolMessage<State>> JsonValueCodec<T> pmscodec() {
        JsonValueCodec pmscodecInv = new JsonValueCodec<ProtocolMessage<State>>(this){
            private final /* synthetic */ DeltaDissemination $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ProtocolMessage nullValue() {
                return null;
            }

            public ProtocolMessage decodeValue(JsonReader in, ProtocolMessage protocolMessage) {
                return this.$outer.replication$DeltaDissemination$$_$_$d0$1(in, protocolMessage);
            }

            public void encodeValue(ProtocolMessage x, JsonWriter out) {
                this.$outer.replication$DeltaDissemination$$_$_$e0$1(x, out);
            }
        };
        return pmscodecInv;
    }

    public LatentConnection<CachedMessage<ProtocolMessage<State>>> cachedMessages(LatentConnection<MessageBuffer> conn) {
        return LatentConnection$.MODULE$.adapt((Function1 & Serializable)mb -> new ReceivedCachedMessage((MessageBuffer)mb, this.pmscodec()), (Function1 & Serializable)pm -> pm.messageBuffer(), conn);
    }

    public List<Connection<CachedMessage<ProtocolMessage<State>>>> connections() {
        return this.connections;
    }

    public void connections_$eq(List<Connection<CachedMessage<ProtocolMessage<State>>>> x$1) {
        this.connections = x$1;
    }

    public delay.Callback<Object> debugCallbackAndRemoveCon(Connection<CachedMessage<ProtocolMessage<State>>> con) {
        return x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object value = ((Success)try_).value();
                return;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                Object object = this.lock();
                synchronized (object) {
                    this.connections_$eq(this.connections().filter((Function1 & Serializable)cc -> {
                        Connection connection = cc;
                        Connection connection2 = con;
                        return connection == null ? connection2 != null : !connection.equals(connection2);
                    }));
                }
                Predef$.MODULE$.println((Object)("exception during message handling, removing connection " + con + " from list of connections"));
                exception.printStackTrace();
                return;
            }
            throw new MatchError((Object)try_);
        };
    }

    public void requestData() {
        SentCachedMessage<ProtocolMessage.Request> msg = new SentCachedMessage<ProtocolMessage.Request>(ProtocolMessage$Request$.MODULE$.apply(this.replicaId().uid(), this.selfContext()), this.pmscodec());
        this.connections().foreach((Function1)(JProcedure1 & Serializable)con -> this.send((Connection<CachedMessage<ProtocolMessage<State>>>)con, (CachedMessage<ProtocolMessage<State>>)msg));
    }

    public void pingAll() {
        SentCachedMessage<ProtocolMessage.Ping> msg = new SentCachedMessage<ProtocolMessage.Ping>(ProtocolMessage$Ping$.MODULE$.apply(System.nanoTime()), this.pmscodec());
        this.connections().foreach((Function1)(JProcedure1 & Serializable)conn -> this.send((Connection<CachedMessage<ProtocolMessage<State>>>)conn, (CachedMessage<ProtocolMessage<State>>)msg));
    }

    public delay.Callback<Object> printExceptionHandler() {
        return this.printExceptionHandler;
    }

    public void addBinaryConnection(LatentConnection<MessageBuffer> latentConnection) {
        ((Function1)this.prepareBinaryConnection(latentConnection).handleInCtx().apply((Object)BoxedUnit.UNIT)).apply(this.printExceptionHandler());
    }

    public void addObjectConnection(LatentConnection<ProtocolMessage<State>> latentConnection) {
        ((Function1)this.prepareObjectConnection(latentConnection).handleInCtx().apply((Object)BoxedUnit.UNIT)).apply(this.printExceptionHandler());
    }

    public delay.Async<Object, BoxedUnit> prepareBinaryConnection(LatentConnection<MessageBuffer> latentConnection) {
        return this.prepareLatentConnection(this.cachedMessages(latentConnection));
    }

    public delay.Async<Object, BoxedUnit> prepareObjectConnection(LatentConnection<ProtocolMessage<State>> latentConnection) {
        return this.prepareLatentConnection(LatentConnection$.MODULE$.adapt((Function1 & Serializable)pm -> new SentCachedMessage<ProtocolMessage>((ProtocolMessage)pm, (JsonValueCodec<ProtocolMessage>)this.pmscodec()), (Function1 & Serializable)cm -> (ProtocolMessage)cm.payload(), latentConnection));
    }

    public delay.Async<Object, BoxedUnit> prepareLatentConnection(LatentConnection<CachedMessage<ProtocolMessage<State>>> latentConnection) {
        delay.Async preparedConnection = latentConnection.prepare(from -> x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                CachedMessage msg = (CachedMessage)((Success)try_).value();
                this.handleMessage(msg, from);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable error = ((Failure)try_).exception();
                Predef$.MODULE$.println((Object)"exception during message handling");
                error.printStackTrace();
                return;
            }
            throw new MatchError((Object)try_);
        });
        return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
            Abort abort = this.globalAbort();
            try {
                delay.Async async = new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> ((Function1)preparedConnection.handleInCtx().apply(ctx)).apply(arg_0 -> this.$anonfun$2$$anonfun$1$$anonfun$1(cb, arg_0)));
                ((Function1)async.handleInCtx().apply((Object)abort)).apply(cb);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    delay.Callback Callback_this = cb;
                    Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                }
                throw throwable;
            }
        });
    }

    private void sendInitialSyncRequest(Connection<CachedMessage<ProtocolMessage<State>>> conn) {
        this.send(conn, new SentCachedMessage<ProtocolMessage<State>>(ProtocolMessage$Request$.MODULE$.apply(this.replicaId().uid(), this.selfContext()), this.pmscodec()));
    }

    public Object lock() {
        return this.lock;
    }

    public int keepPastPayloads() {
        return this.keepPastPayloads;
    }

    public List<CachedMessage<ProtocolMessage.Payload<State>>> allPayloads() {
        List list;
        Object object = this.lock();
        synchronized (object) {
            list = this.pastPayloads.toList();
        }
        return list;
    }

    private void rememberPayload(CachedMessage<ProtocolMessage.Payload<State>> payload) {
        Object object = this.lock();
        synchronized (object) {
            this.pastPayloads = this.pastPayloads.enqueue(payload);
            if (IterableOps.SizeCompareOps$.MODULE$.$greater$extension(this.pastPayloads.sizeIs(), this.keepPastPayloads())) {
                this.pastPayloads = (Queue)this.pastPayloads.drop(1);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    public Dots selfContext() {
        return (Dots)this.contexts.getOrElse((Object)this.replicaId().uid(), DeltaDissemination::selfContext$$anonfun$1);
    }

    public void applyDelta(State delta) {
        SentCachedMessage<ProtocolMessage<State>> sentCachedMessage;
        Object object = this.lock();
        synchronized (object) {
            Dot nextDot = this.selfContext().nextDot(this.replicaId().uid());
            ProtocolMessage.Payload<State> payload = ProtocolMessage$Payload$.MODULE$.apply(this.replicaId().uid(), Dots$.MODULE$.single(nextDot), delta);
            this.updateContext(this.replicaId().uid(), payload.dots());
            SentCachedMessage<ProtocolMessage<State>> message = new SentCachedMessage<ProtocolMessage<State>>(payload, this.pmscodec());
            this.rememberPayload(message);
            sentCachedMessage = message;
        }
        SentCachedMessage<ProtocolMessage<State>> message = sentCachedMessage;
        this.disseminate(message, this.disseminate$default$2());
    }

    public void updateContext(Uid rr, Dots dots) {
        Object object = this.lock();
        synchronized (object) {
            this.contexts = (Map)this.contexts.updatedWith((Object)rr, (Function1 & Serializable)curr -> {
                Lattice Lattice_this = Lattice$.MODULE$.optionLattice(Dots$.MODULE$.contextLattice());
                Some right$proxy1 = Some$.MODULE$.apply((Object)dots);
                return (Option)Lattice_this.merge(curr, (Object)right$proxy1);
            });
        }
    }

    public void handleMessage(CachedMessage<ProtocolMessage<State>> msg2, Connection<CachedMessage<ProtocolMessage<State>>> from) {
        if (this.globalAbort().closeRequest()) {
            return;
        }
        ProtocolMessage<State> protocolMessage = msg2.payload();
        if (protocolMessage instanceof ProtocolMessage.Ping) {
            long l;
            ProtocolMessage.Ping ping = ProtocolMessage$Ping$.MODULE$.unapply((ProtocolMessage.Ping)protocolMessage);
            long time = l = ping._1();
            this.send(from, new SentCachedMessage<ProtocolMessage<State>>(ProtocolMessage$Pong$.MODULE$.apply(time), this.pmscodec()));
            return;
        }
        if (protocolMessage instanceof ProtocolMessage.Pong) {
            long l;
            ProtocolMessage.Pong pong = ProtocolMessage$Pong$.MODULE$.unapply((ProtocolMessage.Pong)protocolMessage);
            long time = l = pong._1();
            Predef$.MODULE$.println((Object)("ping took " + Predef$.MODULE$.long2Long(System.nanoTime() - time).doubleValue() / (double)1000000 + "ms"));
            Predef$.MODULE$.println((Object)("current state is " + this.selfContext()));
            return;
        }
        if (protocolMessage instanceof ProtocolMessage.Request) {
            ProtocolMessage.Request request = ProtocolMessage$Request$.MODULE$.unapply((ProtocolMessage.Request)protocolMessage);
            Uid uid2 = request._1();
            Dots dots = request._2();
            Uid uid3 = uid2;
            Dots knows = dots;
            List relevant = this.allPayloads().filterNot((Function1 & Serializable)dt -> ((ProtocolMessage.Payload)dt.payload()).dots().lessThanEquals(knows));
            Lattice Lattice_this = Dots$.MODULE$.contextLattice();
            Dots right$proxy2 = (Dots)relevant.map((Function1 & Serializable)dt -> ((ProtocolMessage.Payload)dt.payload()).dots()).reduceOption((Function2 & Serializable)(left, right) -> (Dots)Lattice$.MODULE$.merge(left, right, Dots$.MODULE$.contextLattice())).getOrElse(DeltaDissemination::$anonfun$6);
            Dots newknowledge = (Dots)Lattice_this.merge((Object)knows, (Object)right$proxy2);
            Dots diff = this.selfContext().subtract(newknowledge);
            if (!diff.isEmpty()) {
                throw new IllegalStateException("could not answer request, missing deltas for: " + diff + "\n  relevant: " + relevant + "\n knows: " + knows + "\n  selfcontext: " + this.selfContext() + "}");
            }
            relevant.foreach((Function1)(JProcedure1 & Serializable)msg -> this.send(from, new SentCachedMessage<ProtocolMessage<State>>(((ProtocolMessage.Payload)msg.payload()).addSender(this.replicaId().uid()), this.pmscodec())));
            Lattice Lattice_this2 = Dots$.MODULE$.contextLattice();
            Dots left$proxy1 = this.selfContext();
            this.updateContext(uid3, (Dots)Lattice_this2.merge((Object)left$proxy1, (Object)knows));
            return;
        }
        if (protocolMessage instanceof ProtocolMessage.Payload) {
            ProtocolMessage.Payload payload = (ProtocolMessage.Payload)protocolMessage;
            ProtocolMessage.Payload payload2 = ProtocolMessage$Payload$.MODULE$.unapply(payload);
            Set<Uid> set = payload2._1();
            Dots dots = payload2._2();
            Object t = payload2._3();
            Set<Uid> uid4 = set;
            Dots context = dots;
            Object data = t;
            ProtocolMessage.Payload payload3 = payload;
            if (context.lessThanEquals(this.selfContext())) {
                return;
            }
            Object object = this.lock();
            synchronized (object) {
                uid4.foreach((Function1)(JProcedure1 & Serializable)uid -> this.updateContext((Uid)uid, context));
                this.updateContext(this.replicaId().uid(), context);
                this.rememberPayload(msg2);
            }
            this.receiveCallback.apply(data);
            if (this.immediateForward) {
                this.disseminate(msg2, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Connection[]{from})));
                return;
            }
            return;
        }
        throw new MatchError(protocolMessage);
    }

    public void send(Connection<CachedMessage<ProtocolMessage<State>>> con, CachedMessage<ProtocolMessage<State>> payload) {
        if (this.globalAbort().closeRequest()) {
            return;
        }
        this.sendingActor.execute(() -> ((Function1)con.send((Object)payload).handleInCtx().apply((Object)BoxedUnit.UNIT)).apply(this.debugCallbackAndRemoveCon(con)));
    }

    public void disseminate(CachedMessage<ProtocolMessage<State>> payload, Set<Connection<CachedMessage<ProtocolMessage<State>>>> except) {
        List<Connection<CachedMessage<ProtocolMessage<State>>>> list;
        Object object = this.lock();
        synchronized (object) {
            list = this.connections();
        }
        List<Connection<CachedMessage<ProtocolMessage<State>>>> cons = list;
        cons.filterNot((Function1 & Serializable)con -> except.contains(con)).foreach((Function1)(JProcedure1 & Serializable)con -> this.send((Connection<CachedMessage<ProtocolMessage<State>>>)con, payload));
    }

    public Set<Connection<CachedMessage<ProtocolMessage<State>>>> disseminate$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final String f0$1(int i) {
        int n = i;
        if (0 == n) {
            return "time";
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private static final String f1$1(int i) {
        int n = i;
        if (0 == n) {
            return "time";
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private static final String f2$1(int i) {
        int n = i;
        switch (n) {
            case 0: {
                return "senders";
            }
            case 1: {
                return "dots";
            }
            case 2: {
                return "data";
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private static final String f3$1(int i) {
        int n = i;
        if (0 == n) {
            return "sender";
        }
        if (1 == n) {
            return "knows";
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private static final ProtocolMessage.Pong d1$1(JsonReader in, ProtocolMessage.Pong pong) {
        if (in.isNextToken((byte)123)) {
            long _time = 0L;
            int p0 = 1;
            boolean pd = true;
            if (!in.isNextToken((byte)125)) {
                in.rollbackToken();
                int l = -1;
                while (l < 0 || in.isNextToken((byte)44)) {
                    l = in.readKeyAsCharBuf();
                    if (in.isCharBufEqualsTo(l, "time")) {
                        if ((p0 & 1) == 0) {
                            throw in.duplicatedKeyError(l);
                        }
                        p0 ^= 1;
                        _time = in.readLong();
                        continue;
                    }
                    if (in.isCharBufEqualsTo(l, "type")) {
                        if (pd) {
                            pd = false;
                            in.skip();
                            continue;
                        }
                        throw in.duplicatedKeyError(l);
                    }
                    in.skip();
                }
                if (!in.isCurrentToken((byte)125)) {
                    throw in.objectEndOrCommaError();
                }
            }
            if (p0 != 0) {
                throw in.requiredFieldError(DeltaDissemination.f0$1(Integer.numberOfTrailingZeros(p0)));
            }
            return new ProtocolMessage.Pong(_time);
        }
        return (ProtocolMessage.Pong)in.readNullOrTokenError((Object)pong, (byte)123);
    }

    private static final ProtocolMessage.Ping d2$1(JsonReader in, ProtocolMessage.Ping ping) {
        if (in.isNextToken((byte)123)) {
            long _time = 0L;
            int p0 = 1;
            boolean pd = true;
            if (!in.isNextToken((byte)125)) {
                in.rollbackToken();
                int l = -1;
                while (l < 0 || in.isNextToken((byte)44)) {
                    l = in.readKeyAsCharBuf();
                    if (in.isCharBufEqualsTo(l, "time")) {
                        if ((p0 & 1) == 0) {
                            throw in.duplicatedKeyError(l);
                        }
                        p0 ^= 1;
                        _time = in.readLong();
                        continue;
                    }
                    if (in.isCharBufEqualsTo(l, "type")) {
                        if (pd) {
                            pd = false;
                            in.skip();
                            continue;
                        }
                        throw in.duplicatedKeyError(l);
                    }
                    in.skip();
                }
                if (!in.isCurrentToken((byte)125)) {
                    throw in.objectEndOrCommaError();
                }
            }
            if (p0 != 0) {
                throw in.requiredFieldError(DeltaDissemination.f1$1(Integer.numberOfTrailingZeros(p0)));
            }
            return new ProtocolMessage.Ping(_time);
        }
        return (ProtocolMessage.Ping)in.readNullOrTokenError((Object)ping, (byte)123);
    }

    private final ProtocolMessage.Payload d3$1(JsonReader in, ProtocolMessage.Payload payload) {
        if (in.isNextToken((byte)123)) {
            Set _senders = (Set)JsoniterCodecs$.MODULE$.GSetStateCodec(JsoniterCodecs$.MODULE$.given_JsonValueCodec_Uid()).nullValue();
            Dots _dots = (Dots)JsoniterCodecs$.MODULE$.CausalContextCodec().nullValue();
            Object _data = this.x$7.nullValue();
            int p0 = 7;
            boolean pd = true;
            if (!in.isNextToken((byte)125)) {
                in.rollbackToken();
                int l = -1;
                while (l < 0 || in.isNextToken((byte)44)) {
                    l = in.readKeyAsCharBuf();
                    if (in.isCharBufEqualsTo(l, "senders")) {
                        if ((p0 & 1) == 0) {
                            throw in.duplicatedKeyError(l);
                        }
                        p0 ^= 1;
                        _senders = (Set)JsoniterCodecs$.MODULE$.GSetStateCodec(JsoniterCodecs$.MODULE$.given_JsonValueCodec_Uid()).decodeValue(in, (Object)_senders);
                        continue;
                    }
                    if (in.isCharBufEqualsTo(l, "dots")) {
                        if ((p0 & 2) == 0) {
                            throw in.duplicatedKeyError(l);
                        }
                        p0 ^= 2;
                        _dots = (Dots)JsoniterCodecs$.MODULE$.CausalContextCodec().decodeValue(in, (Object)_dots);
                        continue;
                    }
                    if (in.isCharBufEqualsTo(l, "data")) {
                        if ((p0 & 4) == 0) {
                            throw in.duplicatedKeyError(l);
                        }
                        p0 ^= 4;
                        _data = this.x$7.decodeValue(in, _data);
                        continue;
                    }
                    if (in.isCharBufEqualsTo(l, "type")) {
                        if (pd) {
                            pd = false;
                            in.skip();
                            continue;
                        }
                        throw in.duplicatedKeyError(l);
                    }
                    in.skip();
                }
                if (!in.isCurrentToken((byte)125)) {
                    throw in.objectEndOrCommaError();
                }
            }
            if ((p0 & 6) != 0) {
                throw in.requiredFieldError(DeltaDissemination.f2$1(Integer.numberOfTrailingZeros(p0 & 6)));
            }
            return new ProtocolMessage.Payload<Object>((Set<Uid>)_senders, _dots, _data);
        }
        return (ProtocolMessage.Payload)in.readNullOrTokenError((Object)payload, (byte)123);
    }

    private static final ProtocolMessage.Request d4$1(JsonReader in, ProtocolMessage.Request request) {
        if (in.isNextToken((byte)123)) {
            Uid _sender = (Uid)JsoniterCodecs$.MODULE$.given_JsonValueCodec_Uid().nullValue();
            Dots _knows = (Dots)JsoniterCodecs$.MODULE$.CausalContextCodec().nullValue();
            int p0 = 3;
            boolean pd = true;
            if (!in.isNextToken((byte)125)) {
                in.rollbackToken();
                int l = -1;
                while (l < 0 || in.isNextToken((byte)44)) {
                    l = in.readKeyAsCharBuf();
                    if (in.isCharBufEqualsTo(l, "sender")) {
                        if ((p0 & 1) == 0) {
                            throw in.duplicatedKeyError(l);
                        }
                        p0 ^= 1;
                        _sender = (Uid)JsoniterCodecs$.MODULE$.given_JsonValueCodec_Uid().decodeValue(in, (Object)_sender);
                        continue;
                    }
                    if (in.isCharBufEqualsTo(l, "knows")) {
                        if ((p0 & 2) == 0) {
                            throw in.duplicatedKeyError(l);
                        }
                        p0 ^= 2;
                        _knows = (Dots)JsoniterCodecs$.MODULE$.CausalContextCodec().decodeValue(in, (Object)_knows);
                        continue;
                    }
                    if (in.isCharBufEqualsTo(l, "type")) {
                        if (pd) {
                            pd = false;
                            in.skip();
                            continue;
                        }
                        throw in.duplicatedKeyError(l);
                    }
                    in.skip();
                }
                if (!in.isCurrentToken((byte)125)) {
                    throw in.objectEndOrCommaError();
                }
            }
            if (p0 != 0) {
                throw in.requiredFieldError(DeltaDissemination.f3$1(Integer.numberOfTrailingZeros(p0)));
            }
            return new ProtocolMessage.Request(_sender, _knows);
        }
        return (ProtocolMessage.Request)in.readNullOrTokenError((Object)request, (byte)123);
    }

    public final ProtocolMessage replication$DeltaDissemination$$_$_$d0$1(JsonReader in, ProtocolMessage protocolMessage) {
        in.setMark();
        if (in.isNextToken((byte)123)) {
            if (in.isCharBufEqualsTo(in.readKeyAsCharBuf(), "type")) {
                Product product;
                int l = in.readStringAsCharBuf();
                if (in.isCharBufEqualsTo(l, "Request")) {
                    in.rollbackToMark();
                    return DeltaDissemination.d4$1(in, null);
                }
                if (in.isCharBufEqualsTo(l, "Payload")) {
                    in.rollbackToMark();
                    return this.d3$1(in, null);
                }
                if (in.isCharBufEqualsTo(l, "Ping")) {
                    in.rollbackToMark();
                    product = DeltaDissemination.d2$1(in, null);
                } else if (in.isCharBufEqualsTo(l, "Pong")) {
                    in.rollbackToMark();
                    product = DeltaDissemination.d1$1(in, null);
                } else {
                    throw in.discriminatorValueError("type");
                }
                return product;
            }
            throw in.decodeError("expected key: \"type\"");
        }
        return (ProtocolMessage)in.readNullOrTokenError((Object)protocolMessage, (byte)123);
    }

    private static final void e1$1(ProtocolMessage.Request x, JsonWriter out) {
        out.writeObjectStart();
        out.writeNonEscapedAsciiKey("type");
        out.writeNonEscapedAsciiVal("Request");
        out.writeNonEscapedAsciiKey("sender");
        JsoniterCodecs$.MODULE$.given_JsonValueCodec_Uid().encodeValue((Object)x.sender(), out);
        out.writeNonEscapedAsciiKey("knows");
        JsoniterCodecs$.MODULE$.CausalContextCodec().encodeValue((Object)x.knows(), out);
        out.writeObjectEnd();
    }

    private final void e2$1(ProtocolMessage.Payload x, JsonWriter out) {
        out.writeObjectStart();
        out.writeNonEscapedAsciiKey("type");
        out.writeNonEscapedAsciiVal("Payload");
        Set<Uid> v = x.senders();
        if (!v.isEmpty()) {
            out.writeNonEscapedAsciiKey("senders");
            JsoniterCodecs$.MODULE$.GSetStateCodec(JsoniterCodecs$.MODULE$.given_JsonValueCodec_Uid()).encodeValue(v, out);
        }
        out.writeNonEscapedAsciiKey("dots");
        JsoniterCodecs$.MODULE$.CausalContextCodec().encodeValue((Object)x.dots(), out);
        out.writeNonEscapedAsciiKey("data");
        this.x$7.encodeValue(x.data(), out);
        out.writeObjectEnd();
    }

    private static final void e3$1(ProtocolMessage.Ping x, JsonWriter out) {
        out.writeObjectStart();
        out.writeNonEscapedAsciiKey("type");
        out.writeNonEscapedAsciiVal("Ping");
        out.writeNonEscapedAsciiKey("time");
        out.writeVal(x.time());
        out.writeObjectEnd();
    }

    private static final void e4$1(ProtocolMessage.Pong x, JsonWriter out) {
        out.writeObjectStart();
        out.writeNonEscapedAsciiKey("type");
        out.writeNonEscapedAsciiVal("Pong");
        out.writeNonEscapedAsciiKey("time");
        out.writeVal(x.time());
        out.writeObjectEnd();
    }

    public final void replication$DeltaDissemination$$_$_$e0$1(ProtocolMessage x, JsonWriter out) {
        ProtocolMessage protocolMessage = x;
        if (protocolMessage instanceof ProtocolMessage.Request) {
            ProtocolMessage.Request vx = (ProtocolMessage.Request)protocolMessage;
            DeltaDissemination.e1$1(vx, out);
            return;
        }
        if (protocolMessage instanceof ProtocolMessage.Payload) {
            ProtocolMessage.Payload vx = (ProtocolMessage.Payload)protocolMessage;
            this.e2$1(vx, out);
            return;
        }
        if (protocolMessage instanceof ProtocolMessage.Ping) {
            ProtocolMessage.Ping vx = (ProtocolMessage.Ping)protocolMessage;
            DeltaDissemination.e3$1(vx, out);
            return;
        }
        if (protocolMessage instanceof ProtocolMessage.Pong) {
            ProtocolMessage.Pong vx = (ProtocolMessage.Pong)protocolMessage;
            DeltaDissemination.e4$1(vx, out);
            return;
        }
        throw new MatchError((Object)protocolMessage);
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ void $anonfun$2$$anonfun$1$$anonfun$1(delay.Callback cb$1, Try res) {
        try {
            conn = var3_3 = (Connection)res.get();
            var5_5 = this.lock();
            synchronized (var5_5) {
                this.connections_$eq(this.connections().$colon$colon((Object)conn));
            }
            Callback_this = cb$1;
            this.sendInitialSyncRequest(conn);
            value$proxy1 = BoxedUnit.UNIT;
            Callback_this.complete((Try)Success$.MODULE$.apply((Object)BoxedUnit.UNIT));
        }
        catch (Throwable var8_8) {
            block7: {
                e = var9_9 = var8_8;
                if (!NonFatal$.MODULE$.apply(e)) break block7;
                var11_11 = res;
                if (!(var11_11 instanceof Failure)) ** GOTO lbl-1000
                v1 = exception = ((Failure)var11_11).exception();
                var13_13 = e;
                if (v1 == null ? var13_13 != null : v1.equals(var13_13) == false) {
                    e.addSuppressed(exception);
                    v2 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = other = var11_11;
                }
                Callback_this = cb$1;
                Callback_this.complete((Try)Failure$.MODULE$.apply(e));
            }
            throw var8_8;
        }
    }

    private static final Dots selfContext$$anonfun$1() {
        return Dots$.MODULE$.empty();
    }

    private static final Dots $anonfun$6() {
        return Dots$.MODULE$.empty();
    }
}

