/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.access;

import com.google.crypto.tink.subtle.ChaCha20Poly1305;
import java.io.Serializable;
import lofi_acl.access.EncryptedDeltaParts;
import lofi_acl.access.EncryptedDeltaParts$;
import lofi_acl.access.IsolatedDeltaParts;
import lofi_acl.access.IsolatedDeltaParts$;
import lofi_acl.access.KeyDerivationKey;
import lofi_acl.access.KeyHierarchy;
import rdts.time.Dot;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;

public class FullKeyHierarchy
implements KeyHierarchy {
    private final KeyDerivationKey kdk;

    public FullKeyHierarchy(KeyDerivationKey kdk) {
        this.kdk = kdk;
    }

    private KeyDerivationKey kdk() {
        return this.kdk;
    }

    @Override
    public Option<KeyDerivationKey> pathKey(String[] path) {
        return Some$.MODULE$.apply((Object)this.kdk().recursiveChildKeyDerivationKey(path));
    }

    @Override
    public KeyHierarchy withKeys(KeyHierarchy other) {
        return this;
    }

    @Override
    public EncryptedDeltaParts encryptDelta(Dot dot, IsolatedDeltaParts isolatedDeltaParts) {
        return this.encryptDeltaRec(this.kdk(), dot, isolatedDeltaParts);
    }

    private EncryptedDeltaParts encryptDeltaRec(KeyDerivationKey kdk, Dot dot, IsolatedDeltaParts isolatedDeltaParts) {
        IsolatedDeltaParts isolatedDeltaParts2 = isolatedDeltaParts;
        if (isolatedDeltaParts2 != null) {
            IsolatedDeltaParts isolatedDeltaParts3 = IsolatedDeltaParts$.MODULE$.unapply(isolatedDeltaParts2);
            Object object = isolatedDeltaParts3._1();
            if (object instanceof byte[]) {
                byte[] serializedValue = (byte[])object;
                return EncryptedDeltaParts$.MODULE$.apply(new ChaCha20Poly1305(kdk.encryptionKey(dot)).encrypt(serializedValue, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE))));
            }
            if (object instanceof Map) {
                Map children = (Map)object;
                return EncryptedDeltaParts$.MODULE$.apply(children.map((Function1 & Serializable)x$1 -> {
                    String string = (String)x$1._1();
                    IsolatedDeltaParts isolatedDeltaParts = (IsolatedDeltaParts)x$1._2();
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.encryptDeltaRec(kdk.childKeyDerivationKey(string), dot, isolatedDeltaParts));
                }).filterNot((Function1 & Serializable)_$1 -> ((EncryptedDeltaParts)_$1._2()).isEmpty()));
            }
        }
        throw new MatchError((Object)isolatedDeltaParts2);
    }

    @Override
    public IsolatedDeltaParts decryptDelta(Dot dot, EncryptedDeltaParts encryptedDeltaParts) {
        return this.decryptDeltaRec(this.kdk(), dot, encryptedDeltaParts);
    }

    private IsolatedDeltaParts decryptDeltaRec(KeyDerivationKey kdk, Dot dot, EncryptedDeltaParts encryptedDeltaParts) {
        EncryptedDeltaParts encryptedDeltaParts2 = encryptedDeltaParts;
        if (encryptedDeltaParts2 != null) {
            EncryptedDeltaParts encryptedDeltaParts3 = EncryptedDeltaParts$.MODULE$.unapply(encryptedDeltaParts2);
            Object object = encryptedDeltaParts3._1();
            if (object instanceof byte[]) {
                byte[] ciphertext = (byte[])object;
                return IsolatedDeltaParts$.MODULE$.apply(new ChaCha20Poly1305(kdk.encryptionKey(dot)).decrypt(ciphertext, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE))));
            }
            if (object instanceof Map) {
                Map children = (Map)object;
                return IsolatedDeltaParts$.MODULE$.apply(children.map((Function1 & Serializable)x$1 -> {
                    String string = (String)x$1._1();
                    EncryptedDeltaParts encryptedDeltaParts = (EncryptedDeltaParts)x$1._2();
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.decryptDeltaRec(kdk.childKeyDerivationKey(string), dot, encryptedDeltaParts));
                }).filterNot((Function1 & Serializable)_$2 -> ((IsolatedDeltaParts)_$2._2()).isEmpty()));
            }
        }
        throw new MatchError((Object)encryptedDeltaParts2);
    }
}

