/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.access;

import java.io.Serializable;
import lofi_acl.access.Group;
import lofi_acl.access.Operation;
import lofi_acl.access.Operation$;
import lofi_acl.access.PermissionManager$;
import lofi_acl.access.PermissionTree;
import lofi_acl.access.PermissionTree$;
import lofi_acl.access.PermissionTree$lattice$;
import lofi_acl.access.Rule;
import rdts.base.Uid;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public class PermissionManager<RDT> {
    private Set<Group> _groups = Predef$.MODULE$.Set().empty();
    private Map<Group, Set<Uid>> _membersOfGroup = ((IterableOnceOps)this._groups.map((Function1 & Serializable)group -> {
        Group group2 = (Group)Predef$.MODULE$.ArrowAssoc(group);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)group2, (Object)Predef$.MODULE$.Set().empty());
    })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private Map<Uid, Set<Group>> _groupsOfUser = Predef$.MODULE$.Map().empty();
    private Set<Uid> _users = Predef$.MODULE$.Set().empty();
    private Set<Rule> _rules = Predef$.MODULE$.Set().empty();
    private Map<Uid, PermissionTree> _readPermissionsOfUser = Predef$.MODULE$.Map().empty();
    private Map<Uid, PermissionTree> _writePermissionsOfUser = Predef$.MODULE$.Map().empty();

    public Option<PermissionTree> getCurrentPermissionsOfUser(Uid user, Operation operation) {
        Option option;
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            Option option2;
            Operation operation2 = operation;
            Operation operation3 = Operation$.READ;
            Operation operation4 = operation2;
            if (!(operation3 != null ? !operation3.equals(operation4) : operation4 != null)) {
                option2 = this._readPermissionsOfUser.get((Object)user);
            } else {
                Operation operation5 = Operation$.WRITE;
                Operation operation6 = operation2;
                if (!(operation5 != null ? !operation5.equals(operation6) : operation6 != null)) {
                    option2 = this._writePermissionsOfUser.get((Object)user);
                } else {
                    throw new MatchError((Object)operation2);
                }
            }
            option = option2;
        }
        return option;
    }

    public void userAdded(Uid newUser, Set<Group> initialGroups) {
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            this._users = (Set)this._users.$plus((Object)newUser);
            this.userJoinedGroups(newUser, initialGroups);
        }
    }

    public void groupAdded(Group newGroup) {
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            this._groups = (Set)this._groups.$plus((Object)newGroup);
        }
    }

    public void rulesAdded(Set<Rule> newRules) {
        Map<Group, PermissionTree> newReadPermissions = PermissionManager$.MODULE$.lofi_acl$access$PermissionManager$$$rulesToGroupedPermissionTrees(newRules, Operation$.READ);
        Map<Group, PermissionTree> newWritePermissions = PermissionManager$.MODULE$.lofi_acl$access$PermissionManager$$$rulesToGroupedPermissionTrees(newRules, Operation$.WRITE);
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            this._readPermissionsOfUser = (Map)newReadPermissions.foldLeft(this._readPermissionsOfUser, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Map permissionTree = (Map)tuple2._1();
                    if (tuple22 != null) {
                        Group group = (Group)tuple22._1();
                        PermissionTree addedPermission = (PermissionTree)tuple22._2();
                        return PermissionManager$.MODULE$.lofi_acl$access$PermissionManager$$$mergePermissionIntoPermissionMap((Map<Uid, PermissionTree>)permissionTree, addedPermission, (Set<Uid>)((Set)this._membersOfGroup.getOrElse((Object)group, PermissionManager::rulesAdded$$anonfun$1$$anonfun$1)));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            this._writePermissionsOfUser = (Map)newWritePermissions.foldLeft(this._writePermissionsOfUser, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Map permissionTree = (Map)tuple2._1();
                    if (tuple22 != null) {
                        Group group = (Group)tuple22._1();
                        PermissionTree addedPermission = (PermissionTree)tuple22._2();
                        return PermissionManager$.MODULE$.lofi_acl$access$PermissionManager$$$mergePermissionIntoPermissionMap((Map<Uid, PermissionTree>)permissionTree, addedPermission, (Set<Uid>)((Set)this._membersOfGroup.getOrElse((Object)group, PermissionManager::rulesAdded$$anonfun$2$$anonfun$1)));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            this._rules = (Set)this._rules.$plus$plus(newRules);
        }
    }

    public void userJoinedGroups(Uid newUser, Set<Group> joinedGroups) {
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            PermissionTree permissionTree;
            PermissionTree permissionTree2;
            block14: {
                block13: {
                    Set<Group> set = this._groups;
                    if (joinedGroups.forall((Function1 & Serializable)elem -> set.contains(elem))) break block13;
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                if (this._users.contains((Object)newUser)) break block14;
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            this._groupsOfUser = (Map)this._groupsOfUser.updatedWith((Object)newUser, (Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Set existingGroups = (Set)((Some)option).value();
                    return Some$.MODULE$.apply((Object)existingGroups.$plus$plus((IterableOnce)joinedGroups));
                }
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply((Object)joinedGroups);
                }
                throw new MatchError((Object)option);
            });
            this._membersOfGroup = (Map)joinedGroups.foldLeft(this._membersOfGroup, (Function2 & Serializable)(membersMap, group) -> (Map)membersMap.updatedWith(group, (Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Set existingMembers = (Set)((Some)option).value();
                    return Some$.MODULE$.apply((Object)existingMembers.$plus((Object)newUser));
                }
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uid[]{newUser})));
                }
                throw new MatchError((Object)option);
            }));
            PermissionTree newReadPermissions = PermissionTree$.MODULE$.fromPathSet((Set<String>)((Set)this._rules.flatMap((Function1 & Serializable)_$1 -> _$1.toPathIfAllowed(joinedGroups, Operation$.READ))));
            PermissionTree newWritePermissions = PermissionTree$.MODULE$.fromPathSet((Set<String>)((Set)this._rules.flatMap((Function1 & Serializable)_$2 -> _$2.toPathIfAllowed(joinedGroups, Operation$.WRITE))));
            Option option = this._readPermissionsOfUser.get((Object)newUser);
            if (option instanceof Some) {
                PermissionTree existingPermissions = (PermissionTree)((Some)option).value();
                PermissionTree$lattice$ Lattice_this = PermissionTree$lattice$.MODULE$;
                permissionTree2 = Lattice_this.merge(existingPermissions, newReadPermissions);
            } else if (None$.MODULE$.equals(option)) {
                permissionTree2 = newReadPermissions;
            } else {
                throw new MatchError((Object)option);
            }
            PermissionTree updatedReadPermissions = permissionTree2;
            Option option2 = this._writePermissionsOfUser.get((Object)newUser);
            if (option2 instanceof Some) {
                PermissionTree existingPermissions = (PermissionTree)((Some)option2).value();
                PermissionTree$lattice$ Lattice_this = PermissionTree$lattice$.MODULE$;
                permissionTree = Lattice_this.merge(existingPermissions, newWritePermissions);
            } else if (None$.MODULE$.equals(option2)) {
                permissionTree = newWritePermissions;
            } else {
                throw new MatchError((Object)option2);
            }
            PermissionTree updatedWritePermissions = permissionTree;
            Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)newUser);
            this._readPermissionsOfUser = (Map)this._readPermissionsOfUser.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)updatedReadPermissions));
            Uid uid2 = (Uid)Predef$.MODULE$.ArrowAssoc((Object)newUser);
            this._writePermissionsOfUser = (Map)this._writePermissionsOfUser.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid2, (Object)updatedWritePermissions));
        }
    }

    private static final Set rulesAdded$$anonfun$1$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final Set rulesAdded$$anonfun$2$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }
}

