/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.sync.acl.bft;

import channels.tls.PrivateIdentity;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec;
import crypto.PublicIdentity;
import java.security.PrivateKey;
import java.util.concurrent.atomic.AtomicReference;
import lofi_acl.access.Filter;
import lofi_acl.access.Operation;
import lofi_acl.access.Operation$;
import lofi_acl.access.PermissionTree;
import lofi_acl.access.PermissionTree$;
import lofi_acl.sync.acl.Sync;
import lofi_acl.sync.acl.bft.Acl;
import lofi_acl.sync.acl.bft.BftAclOpGraph;
import lofi_acl.sync.acl.bft.BftAclOpGraph$;
import lofi_acl.sync.acl.bft.BftFilteringAntiEntropy;
import lofi_acl.sync.acl.bft.SyncWithBftMonotonicAcl$;
import rdts.base.Bottom;
import rdts.base.Bottom$;
import rdts.base.Lattice;
import rdts.base.Uid$;
import rdts.time.Dot;
import rdts.time.Dot$;
import rdts.time.Dots;
import rdts.time.Dots$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public class SyncWithBftMonotonicAcl<RDT>
implements Sync<RDT> {
    private final PrivateIdentity localIdentity;
    private final Function1<RDT, BoxedUnit> onDeltaReceive;
    private final Lattice<RDT> lattice;
    private final BftFilteringAntiEntropy<RDT> antiEntropy;
    private volatile Option<Thread> antiEntropyThread;
    private final PublicIdentity localPublicId;
    private final AtomicReference<Tuple2<Dots, RDT>> rdtReference;
    private final AtomicReference<Dot> lastLocalRdtDot;
    private final AtomicReference<Tuple2<BftAclOpGraph, Acl>> localAcl;

    public static <RDT> SyncWithBftMonotonicAcl<RDT> createAsRootOfTrust(PrivateIdentity privateIdentity, Lattice<RDT> lattice, Bottom<RDT> bottom2, JsonValueCodec<RDT> jsonValueCodec, Filter<RDT> filter2) {
        return SyncWithBftMonotonicAcl$.MODULE$.createAsRootOfTrust(privateIdentity, lattice, bottom2, jsonValueCodec, filter2);
    }

    public static <RDT> Function1<RDT, BoxedUnit> $lessinit$greater$default$3() {
        return SyncWithBftMonotonicAcl$.MODULE$.$lessinit$greater$default$3();
    }

    public SyncWithBftMonotonicAcl(PrivateIdentity localIdentity, BftAclOpGraph.EncodedDelegation aclRoot, Function1<RDT, BoxedUnit> onDeltaReceive, Lattice<RDT> lattice, Bottom<RDT> bottom2, JsonValueCodec<RDT> rdtJsonCodec, Filter<RDT> filter2) {
        Tuple2 tuple2;
        this.localIdentity = localIdentity;
        this.onDeltaReceive = onDeltaReceive;
        this.lattice = lattice;
        this.antiEntropy = new BftFilteringAntiEntropy<RDT>(localIdentity, aclRoot, this, rdtJsonCodec, filter2, lattice, bottom2);
        this.antiEntropyThread = None$.MODULE$;
        this.localPublicId = localIdentity.getPublic();
        Dots dots = (Dots)Predef$.MODULE$.ArrowAssoc((Object)Dots$.MODULE$.empty());
        this.rdtReference = new AtomicReference<Tuple2>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dots, Bottom$.MODULE$.apply(bottom2).empty()));
        this.lastLocalRdtDot = new AtomicReference<Dot>(Dot$.MODULE$.apply(Uid$.MODULE$.apply(this.localPublicId.id()), -1L));
        Try<Tuple2<String, BftAclOpGraph.Delegation>> try_ = aclRoot.decode(BftAclOpGraph$.MODULE$.opCodec());
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            throw exception;
        }
        if (!(try_ instanceof Success) || (tuple2 = (Tuple2)((Success)try_).value()) == null) {
            throw new MatchError(try_);
        }
        String sig = (String)tuple2._1();
        BftAclOpGraph.Delegation delegation = (BftAclOpGraph.Delegation)tuple2._2();
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)sig);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)delegation);
        BftAclOpGraph opGraph = BftAclOpGraph$.MODULE$.apply((Map<String, BftAclOpGraph.Delegation>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sig}))));
        this.localAcl = new AtomicReference<Tuple2>(Tuple2$.MODULE$.apply((Object)opGraph, opGraph.reconstruct((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sig})))).get()));
    }

    private PrivateIdentity localIdentity() {
        return this.localIdentity;
    }

    public RDT state() {
        return (RDT)this.rdtReference.get()._2();
    }

    public Tuple2<BftAclOpGraph, Acl> currentAcl() {
        return this.localAcl.get();
    }

    public void grantPermissions(PublicIdentity affectedUser, PermissionTree realm, Operation typeOfPermission) {
        Tuple2 tuple2;
        Operation operation = typeOfPermission;
        Operation operation2 = Operation$.READ;
        Operation operation3 = operation;
        if (!(operation2 != null ? !operation2.equals(operation3) : operation3 != null)) {
            tuple2 = Tuple2$.MODULE$.apply((Object)realm, (Object)PermissionTree$.MODULE$.empty());
        } else {
            Operation operation4 = Operation$.WRITE;
            Operation operation5 = operation;
            if (!(operation4 != null ? !operation4.equals(operation5) : operation5 != null)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)realm, (Object)realm);
            } else {
                throw new MatchError((Object)operation);
            }
        }
        Tuple2 tuple22 = tuple2;
        PermissionTree read = (PermissionTree)tuple22._1();
        PermissionTree write = (PermissionTree)tuple22._2();
        AtomicReference<Tuple2<BftAclOpGraph, Acl>> atomicReference = this.localAcl;
        synchronized (atomicReference) {
            Tuple2<BftAclOpGraph, Acl> tuple23 = this.localAcl.get();
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            BftAclOpGraph opGraph = (BftAclOpGraph)tuple23._1();
            Acl acl = (Acl)tuple23._2();
            Tuple2<BftAclOpGraph, Acl> old = tuple23;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(old, (Object)opGraph, (Object)acl);
            Tuple2 old2 = (Tuple2)tuple3._1();
            BftAclOpGraph opGraph2 = (BftAclOpGraph)tuple3._2();
            Acl acl2 = (Acl)tuple3._3();
            PrivateKey privateKey = this.localIdentity().identityKey().getPrivate();
            Tuple2<BftAclOpGraph, BftAclOpGraph.EncodedDelegation> tuple24 = opGraph2.delegateAccess(this.localPublicId, privateKey, affectedUser, read, write);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            BftAclOpGraph updatedOpGraph = (BftAclOpGraph)tuple24._1();
            BftAclOpGraph.EncodedDelegation aclDelta = (BftAclOpGraph.EncodedDelegation)tuple24._2();
            Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)updatedOpGraph, (Object)aclDelta);
            BftAclOpGraph updatedOpGraph2 = (BftAclOpGraph)tuple25._1();
            BftAclOpGraph.EncodedDelegation aclDelta2 = (BftAclOpGraph.EncodedDelegation)tuple25._2();
            Acl updatedAcl = acl2.addPermissions(affectedUser, read, write);
            Predef$.MODULE$.require(this.localAcl.compareAndSet((Tuple2<BftAclOpGraph, Acl>)old2, (Tuple2<BftAclOpGraph, Acl>)Tuple2$.MODULE$.apply((Object)updatedOpGraph2, (Object)updatedAcl)));
            this.antiEntropy.broadcastAclDelegation(aclDelta2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<String> applyAclIfPossible(BftAclOpGraph.EncodedDelegation encodedDelegation) {
        AtomicReference<Tuple2<BftAclOpGraph, Acl>> atomicReference = this.localAcl;
        synchronized (atomicReference) {
            Acl updatedAcl;
            BftAclOpGraph updatedOpGraph;
            Tuple2 old;
            block5: {
                Tuple2<BftAclOpGraph, Acl> tuple2 = this.localAcl.get();
                if (tuple2 == null) throw new MatchError(tuple2);
                BftAclOpGraph opGraph = (BftAclOpGraph)tuple2._1();
                Acl acl = (Acl)tuple2._2();
                Tuple2<BftAclOpGraph, Acl> old2 = tuple2;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply(old2, (Object)opGraph, (Object)acl);
                old = (Tuple2)tuple3._1();
                BftAclOpGraph opGraph2 = (BftAclOpGraph)tuple3._2();
                Acl acl2 = (Acl)tuple3._3();
                Either<Set<String>, BftAclOpGraph> either = opGraph2.receive(encodedDelegation.sig(), encodedDelegation.op());
                if (either instanceof Left) {
                    Set missingSignatures = (Set)((Left)either).value();
                    return missingSignatures;
                }
                if (!(either instanceof Right)) throw new MatchError(either);
                updatedOpGraph = (BftAclOpGraph)((Right)either).value();
                updatedAcl = (Acl)updatedOpGraph.reconstruct(updatedOpGraph.heads()).get();
                BftAclOpGraph.Delegation delegation = (BftAclOpGraph.Delegation)((Tuple2)encodedDelegation.decode(BftAclOpGraph$.MODULE$.opCodec()).get())._2();
                Acl acl3 = updatedAcl;
                Acl acl4 = acl2.addPermissions(delegation.delegatee(), delegation.read(), delegation.write());
                if (!(acl3 == null ? acl4 != null : !((Object)acl3).equals(acl4))) break block5;
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            Predef$.MODULE$.require(this.localAcl.compareAndSet((Tuple2<BftAclOpGraph, Acl>)old, (Tuple2<BftAclOpGraph, Acl>)Tuple2$.MODULE$.apply((Object)updatedOpGraph, (Object)updatedAcl)));
            return Predef$.MODULE$.Set().empty();
        }
    }

    public void mutateRdt(Function1<RDT, RDT> deltaMutator) {
        Dot dot2 = this.lastLocalRdtDot.updateAndGet(dot -> dot.advance());
        this.antiEntropy.mutateRdt(dot2, deltaMutator.apply(this.rdtReference.get()._2()));
    }

    @Override
    public String connectionString() {
        return "localhost:" + this.antiEntropy.listenPort().getOrElse(SyncWithBftMonotonicAcl::connectionString$$anonfun$1);
    }

    @Override
    public void connect(PublicIdentity remoteUser, String remoteAddress) {
        String[] hostParts = remoteAddress.split(":");
        Predef$.MODULE$.require(hostParts.length == 2);
        Object[] objectArray = new Tuple2[1];
        PublicIdentity publicIdentity = (PublicIdentity)Predef$.MODULE$.ArrowAssoc((Object)remoteUser);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)publicIdentity, (Object)Tuple2$.MODULE$.apply((Object)hostParts[0], (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(hostParts[1])))));
        this.antiEntropy.newPeers((Set<Tuple2<PublicIdentity, Tuple2<String, Object>>>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    @Override
    public void receivedDelta(Dot dot, RDT delta) {
        Tuple2<Dots, RDT> tuple2 = this.rdtReference.updateAndGet(x$1 -> {
            Dots dots = (Dots)x$1._1();
            Object object = x$1._2();
            Dots dots2 = (Dots)Predef$.MODULE$.ArrowAssoc((Object)dots.add(dot));
            Lattice<RDT> Lattice_this = this.lattice;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dots2, Lattice_this.merge(object, delta));
        });
        this.onDeltaReceive.apply(delta);
    }

    public void start() {
        SyncWithBftMonotonicAcl syncWithBftMonotonicAcl = this;
        synchronized (syncWithBftMonotonicAcl) {
            Predef$.MODULE$.require(this.antiEntropyThread.isEmpty());
            this.antiEntropyThread = Some$.MODULE$.apply((Object)this.antiEntropy.start());
        }
    }

    public void stop() {
        SyncWithBftMonotonicAcl syncWithBftMonotonicAcl = this;
        synchronized (syncWithBftMonotonicAcl) {
            Predef$.MODULE$.require(this.antiEntropyThread.nonEmpty());
            this.antiEntropy.stop();
            ((Thread)this.antiEntropyThread.get()).interrupt();
            this.antiEntropyThread = None$.MODULE$;
        }
    }

    private static final int connectionString$$anonfun$1() {
        return -1;
    }
}

