/*
 * Decompiled with CFR 0.152.
 */
package lofi_acl.transport;

import channels.tls.P2PX509TrustManager;
import channels.tls.PrivateIdentity;
import channels.tls.X509Util$;
import crypto.PublicIdentity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import lofi_acl.transport.P2PTlsTcpConnector$;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.pem.util.PemUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

public class P2PTlsTcpConnector {
    private final PrivateIdentity identity;
    private final SSLFactory sslFactory;
    private final SSLServerSocket sslServerSocket;

    public static int $lessinit$greater$default$2() {
        return P2PTlsTcpConnector$.MODULE$.$lessinit$greater$default$2();
    }

    public P2PTlsTcpConnector(PrivateIdentity identity, int _listenPort) {
        this.identity = identity;
        Predef$.MODULE$.require(_listenPort >= 0 && _listenPort <= 65535);
        ByteArrayInputStream certPemFile = new ByteArrayInputStream(identity.tlsCertPem().getBytes());
        ByteArrayInputStream keyPemFile = new ByteArrayInputStream(identity.tlsKeyPem().getBytes());
        X509ExtendedKeyManager keyManager = PemUtils.loadIdentityMaterial((InputStream)certPemFile, (InputStream)keyPemFile);
        P2PX509TrustManager trustManager = new P2PX509TrustManager();
        this.sslFactory = SSLFactory.builder().withCiphers(new String[]{"TLS_CHACHA20_POLY1305_SHA256"}).withProtocols(new String[]{"TLSv1.3"}).withIdentityMaterial((X509KeyManager)keyManager).withTrustMaterial((X509TrustManager)trustManager).withNeedClientAuthentication().build();
        this.sslServerSocket = (SSLServerSocket)this.sslFactory.getSslServerSocketFactory().createServerSocket(_listenPort);
    }

    private PrivateIdentity identity() {
        return this.identity;
    }

    public int listenPort() {
        return this.sslServerSocket.getLocalPort();
    }

    public Future<Tuple2<SSLSocket, PublicIdentity>> acceptConnection(ExecutionContext ec) {
        return Future$.MODULE$.apply(this::acceptConnection$$anonfun$1, ec).flatMap((Function1 & Serializable)socket -> this.doHandshake((SSLSocket)socket).map((Function1 & Serializable)publicIdentity -> Tuple2$.MODULE$.apply(socket, publicIdentity), ec), ec);
    }

    public Future<Tuple2<SSLSocket, PublicIdentity>> connect(String host, int port, ExecutionContext ec) {
        return Future$.MODULE$.apply(() -> this.connect$$anonfun$1(host, port), ec).flatMap((Function1 & Serializable)socket -> this.doHandshake((SSLSocket)socket).map((Function1 & Serializable)publicIdentity -> Tuple2$.MODULE$.apply(socket, publicIdentity), ec), ec);
    }

    public Try<BoxedUnit> closeServerSocket() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.closeServerSocket$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private Future<PublicIdentity> doHandshake(SSLSocket socket) {
        BoxedUnit boxedUnit;
        Promise identityPromise = Promise$.MODULE$.apply();
        socket.addHandshakeCompletedListener(ev -> {
            PublicIdentity peerIdentity = X509Util$.MODULE$.certificateToPublicIdentity((X509Certificate)ev.getPeerCertificates()[0]);
            identityPromise.success((Object)peerIdentity);
        });
        try {
            socket.startHandshake();
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (IOException e) {
            boxedUnit = identityPromise.failure((Throwable)e);
        }
        return identityPromise.future();
    }

    private final SSLSocket acceptConnection$$anonfun$1() {
        return (SSLSocket)this.sslServerSocket.accept();
    }

    private final SSLSocket connect$$anonfun$1(String host$1, int port$1) {
        return (SSLSocket)this.sslFactory.getSslSocketFactory().createSocket(host$1, port$1);
    }

    private final void closeServerSocket$$anonfun$1() {
        this.sslServerSocket.close();
    }
}

