/*
 * Decompiled with CFR 0.152.
 */
package rescala.core;

import rescala.core.AccessHandler;
import rescala.core.DynamicTicket;
import rescala.core.Observation;
import rescala.core.ReSource;
import rescala.core.Result;
import rescala.core.Transaction;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;

public final class ReevTicket<S, V>
extends DynamicTicket<S>
implements Result<V> {
    private Object _before;
    private final AccessHandler<S> accessHandler;
    private Set<ReSource> collectedDependencies;
    private boolean _propagate;
    private V value;
    private Observation effect;

    public ReevTicket(Transaction<S> tx, V _before, AccessHandler<S> accessHandler) {
        this._before = _before;
        this.accessHandler = accessHandler;
        super(tx);
        this.collectedDependencies = null;
        this._propagate = false;
        this.effect = null;
    }

    private Transaction<S> tx$accessor() {
        return super.tx();
    }

    private V _before() {
        return (V)this._before;
    }

    private void _before_$eq(V x$0) {
        this._before = x$0;
    }

    @Override
    public Object collectStatic(ReSource reactive) {
        if (this.collectedDependencies != null && !this.collectedDependencies.contains((Object)reactive)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return this.accessHandler.staticAccess(reactive);
    }

    @Override
    public Object collectDynamic(ReSource reactive) {
        if (this.collectedDependencies == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"may not access dynamic dependencies without tracking dependencies");
        }
        Set updatedDeps = (Set)this.collectedDependencies.$plus((Object)reactive);
        if (updatedDeps == this.collectedDependencies) {
            return this.accessHandler.staticAccess(reactive);
        }
        this.collectedDependencies = updatedDeps;
        return this.accessHandler.dynamicAccess(reactive);
    }

    public String toString() {
        return new StringBuilder(39).append("Result(value = ").append(this.value).append(", propagate = ").append(this.activate()).append(", deps = ").append(this.collectedDependencies).append(")").toString();
    }

    public V before() {
        return this._before();
    }

    public ReevTicket<S, V> trackDependencies(Set<ReSource> initial) {
        this.collectedDependencies = initial;
        return this;
    }

    public ReevTicket<S, V> trackStatic() {
        this.collectedDependencies = null;
        return this;
    }

    public ReevTicket<S, V> withPropagate(boolean p) {
        this._propagate = p;
        return this;
    }

    public ReevTicket<S, V> withValue(V v) {
        Predef$.MODULE$.require(v != null, ReevTicket::withValue$$anonfun$1);
        this.value = v;
        this._propagate = true;
        return this;
    }

    public ReevTicket<S, V> withEffect(Observation v) {
        this.effect = v;
        return this;
    }

    @Override
    public boolean activate() {
        return this._propagate;
    }

    @Override
    public void forValue(Function1<V, BoxedUnit> f) {
        if (this.value != null) {
            f.apply(this.value);
            return;
        }
    }

    @Override
    public void forEffect(Function1<Observation, BoxedUnit> f) {
        if (this.effect != null) {
            f.apply((Object)this.effect);
            return;
        }
    }

    @Override
    public Option<Set<ReSource>> inputs() {
        return Option$.MODULE$.apply(this.collectedDependencies);
    }

    public <NT> ReevTicket<S, NT> reset(NT nb) {
        this._propagate = false;
        this.value = null;
        this.effect = null;
        this.collectedDependencies = null;
        ReevTicket res = this;
        res._before_$eq(nb);
        return res;
    }

    private static final Object withValue$$anonfun$1() {
        return "value must not be null";
    }
}

