/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class BLAKEBigCore
extends DigestEngine {
    private static final int[] SIGMA = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3, 11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4, 7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8, 9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13, 2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9, 12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11, 13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10, 6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5, 10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3, 11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4, 7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8, 9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13, 2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9};
    private static final long[] CB = new long[]{2611923443488327891L, 1376283091369227076L, -6626703657320631856L, 589684135938649225L, 4983270260364809079L, -4732044268327596948L, -4563226453097033507L, 4577018097722394903L, -7919907764393346277L, -3372901835766516308L, 3458046377305235383L, -5124621466747896170L, -5008970055469465703L, 2639559389850201335L, 577009281997405206L, 7163292796296056425L};
    private long h0;
    private long h1;
    private long h2;
    private long h3;
    private long h4;
    private long h5;
    private long h6;
    private long h7;
    private long s0;
    private long s1;
    private long s2;
    private long s3;
    private long t0;
    private long t1;
    private long[] tmpM;
    private byte[] tmpBuf;

    BLAKEBigCore() {
    }

    @Override
    public int getBlockLength() {
        return 128;
    }

    protected Digest copyState(BLAKEBigCore dst) {
        dst.h0 = this.h0;
        dst.h1 = this.h1;
        dst.h2 = this.h2;
        dst.h3 = this.h3;
        dst.h4 = this.h4;
        dst.h5 = this.h5;
        dst.h6 = this.h6;
        dst.h7 = this.h7;
        dst.s0 = this.s0;
        dst.s1 = this.s1;
        dst.s2 = this.s2;
        dst.s3 = this.s3;
        dst.t0 = this.t0;
        dst.t1 = this.t1;
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        long[] iv = this.getInitVal();
        this.h0 = iv[0];
        this.h1 = iv[1];
        this.h2 = iv[2];
        this.h3 = iv[3];
        this.h4 = iv[4];
        this.h5 = iv[5];
        this.h6 = iv[6];
        this.h7 = iv[7];
        this.s3 = 0L;
        this.s2 = 0L;
        this.s1 = 0L;
        this.s0 = 0L;
        this.t1 = 0L;
        this.t0 = 0L;
    }

    abstract long[] getInitVal();

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int ptr = this.flush();
        int bitLen = ptr << 3;
        long th = this.t1--;
        long tl = this.t0 + (long)bitLen;
        this.tmpBuf[ptr] = -128;
        if (ptr == 0) {
            this.t0 = -1024L;
            this.t1 = -1L;
        } else {
            this.t0 = this.t0 == 0L ? (long)(-1024 + bitLen) : (this.t0 -= (long)(1024 - bitLen));
        }
        if (ptr < 112) {
            for (int i = ptr + 1; i < 112; ++i) {
                this.tmpBuf[i] = 0;
            }
            if (this.getDigestLength() == 64) {
                this.tmpBuf[111] = (byte)(this.tmpBuf[111] | 1);
            }
            BLAKEBigCore.encodeBELong(th, this.tmpBuf, 112);
            BLAKEBigCore.encodeBELong(tl, this.tmpBuf, 120);
            this.update(this.tmpBuf, ptr, 128 - ptr);
        } else {
            int i;
            for (i = ptr + 1; i < 128; ++i) {
                this.tmpBuf[i] = 0;
            }
            this.update(this.tmpBuf, ptr, 128 - ptr);
            this.t0 = -1024L;
            this.t1 = -1L;
            for (i = 0; i < 112; ++i) {
                this.tmpBuf[i] = 0;
            }
            if (this.getDigestLength() == 64) {
                this.tmpBuf[111] = 1;
            }
            BLAKEBigCore.encodeBELong(th, this.tmpBuf, 112);
            BLAKEBigCore.encodeBELong(tl, this.tmpBuf, 120);
            this.update(this.tmpBuf, 0, 128);
        }
        BLAKEBigCore.encodeBELong(this.h0, output, outputOffset + 0);
        BLAKEBigCore.encodeBELong(this.h1, output, outputOffset + 8);
        BLAKEBigCore.encodeBELong(this.h2, output, outputOffset + 16);
        BLAKEBigCore.encodeBELong(this.h3, output, outputOffset + 24);
        BLAKEBigCore.encodeBELong(this.h4, output, outputOffset + 32);
        BLAKEBigCore.encodeBELong(this.h5, output, outputOffset + 40);
        if (this.getDigestLength() == 64) {
            BLAKEBigCore.encodeBELong(this.h6, output, outputOffset + 48);
            BLAKEBigCore.encodeBELong(this.h7, output, outputOffset + 56);
        }
    }

    @Override
    protected void doInit() {
        this.tmpM = new long[16];
        this.tmpBuf = new byte[128];
        this.engineReset();
    }

    private static final void encodeBELong(long val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 56);
        buf[off + 1] = (byte)(val >>> 48);
        buf[off + 2] = (byte)(val >>> 40);
        buf[off + 3] = (byte)(val >>> 32);
        buf[off + 4] = (byte)(val >>> 24);
        buf[off + 5] = (byte)(val >>> 16);
        buf[off + 6] = (byte)(val >>> 8);
        buf[off + 7] = (byte)val;
    }

    private static final long decodeBELong(byte[] buf, int off) {
        return (long)(buf[off] & 0xFF) << 56 | (long)(buf[off + 1] & 0xFF) << 48 | (long)(buf[off + 2] & 0xFF) << 40 | (long)(buf[off + 3] & 0xFF) << 32 | (long)(buf[off + 4] & 0xFF) << 24 | (long)(buf[off + 5] & 0xFF) << 16 | (long)(buf[off + 6] & 0xFF) << 8 | (long)(buf[off + 7] & 0xFF);
    }

    private static long circularRight(long x, int n) {
        return x >>> n | x << 64 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        this.t0 += 1024L;
        if ((this.t0 & 0xFFFFFFFFFFFFFC00L) == 0L) {
            ++this.t1;
        }
        long v0 = this.h0;
        long v1 = this.h1;
        long v2 = this.h2;
        long v3 = this.h3;
        long v4 = this.h4;
        long v5 = this.h5;
        long v6 = this.h6;
        long v7 = this.h7;
        long v8 = this.s0 ^ 0x243F6A8885A308D3L;
        long v9 = this.s1 ^ 0x13198A2E03707344L;
        long vA = this.s2 ^ 0xA4093822299F31D0L;
        long vB = this.s3 ^ 0x82EFA98EC4E6C89L;
        long vC = this.t0 ^ 0x452821E638D01377L;
        long vD = this.t0 ^ 0xBE5466CF34E90C6CL;
        long vE = this.t1 ^ 0xC0AC29B7C97C50DDL;
        long vF = this.t1 ^ 0x3F84D5B5B5470917L;
        long[] m = this.tmpM;
        for (int i = 0; i < 16; ++i) {
            m[i] = BLAKEBigCore.decodeBELong(data, 8 * i);
        }
        for (int r = 0; r < 16; ++r) {
            int o0 = SIGMA[(r << 4) + 0];
            int o1 = SIGMA[(r << 4) + 1];
            vC = BLAKEBigCore.circularRight(vC ^ (v0 += v4 + (m[o0] ^ CB[o1])), 32);
            v4 = BLAKEBigCore.circularRight(v4 ^ (v8 += vC), 25);
            vC = BLAKEBigCore.circularRight(vC ^ (v0 += v4 + (m[o1] ^ CB[o0])), 16);
            v4 = BLAKEBigCore.circularRight(v4 ^ (v8 += vC), 11);
            o0 = SIGMA[(r << 4) + 2];
            o1 = SIGMA[(r << 4) + 3];
            vD = BLAKEBigCore.circularRight(vD ^ (v1 += v5 + (m[o0] ^ CB[o1])), 32);
            v5 = BLAKEBigCore.circularRight(v5 ^ (v9 += vD), 25);
            vD = BLAKEBigCore.circularRight(vD ^ (v1 += v5 + (m[o1] ^ CB[o0])), 16);
            v5 = BLAKEBigCore.circularRight(v5 ^ (v9 += vD), 11);
            o0 = SIGMA[(r << 4) + 4];
            o1 = SIGMA[(r << 4) + 5];
            vE = BLAKEBigCore.circularRight(vE ^ (v2 += v6 + (m[o0] ^ CB[o1])), 32);
            v6 = BLAKEBigCore.circularRight(v6 ^ (vA += vE), 25);
            vE = BLAKEBigCore.circularRight(vE ^ (v2 += v6 + (m[o1] ^ CB[o0])), 16);
            v6 = BLAKEBigCore.circularRight(v6 ^ (vA += vE), 11);
            o0 = SIGMA[(r << 4) + 6];
            o1 = SIGMA[(r << 4) + 7];
            vF = BLAKEBigCore.circularRight(vF ^ (v3 += v7 + (m[o0] ^ CB[o1])), 32);
            v7 = BLAKEBigCore.circularRight(v7 ^ (vB += vF), 25);
            vF = BLAKEBigCore.circularRight(vF ^ (v3 += v7 + (m[o1] ^ CB[o0])), 16);
            v7 = BLAKEBigCore.circularRight(v7 ^ (vB += vF), 11);
            o0 = SIGMA[(r << 4) + 8];
            o1 = SIGMA[(r << 4) + 9];
            vF = BLAKEBigCore.circularRight(vF ^ (v0 += v5 + (m[o0] ^ CB[o1])), 32);
            v5 = BLAKEBigCore.circularRight(v5 ^ (vA += vF), 25);
            vF = BLAKEBigCore.circularRight(vF ^ (v0 += v5 + (m[o1] ^ CB[o0])), 16);
            v5 = BLAKEBigCore.circularRight(v5 ^ (vA += vF), 11);
            o0 = SIGMA[(r << 4) + 10];
            o1 = SIGMA[(r << 4) + 11];
            vC = BLAKEBigCore.circularRight(vC ^ (v1 += v6 + (m[o0] ^ CB[o1])), 32);
            v6 = BLAKEBigCore.circularRight(v6 ^ (vB += vC), 25);
            vC = BLAKEBigCore.circularRight(vC ^ (v1 += v6 + (m[o1] ^ CB[o0])), 16);
            v6 = BLAKEBigCore.circularRight(v6 ^ (vB += vC), 11);
            o0 = SIGMA[(r << 4) + 12];
            o1 = SIGMA[(r << 4) + 13];
            vD = BLAKEBigCore.circularRight(vD ^ (v2 += v7 + (m[o0] ^ CB[o1])), 32);
            v7 = BLAKEBigCore.circularRight(v7 ^ (v8 += vD), 25);
            vD = BLAKEBigCore.circularRight(vD ^ (v2 += v7 + (m[o1] ^ CB[o0])), 16);
            v7 = BLAKEBigCore.circularRight(v7 ^ (v8 += vD), 11);
            o0 = SIGMA[(r << 4) + 14];
            o1 = SIGMA[(r << 4) + 15];
            vE = BLAKEBigCore.circularRight(vE ^ (v3 += v4 + (m[o0] ^ CB[o1])), 32);
            v4 = BLAKEBigCore.circularRight(v4 ^ (v9 += vE), 25);
            vE = BLAKEBigCore.circularRight(vE ^ (v3 += v4 + (m[o1] ^ CB[o0])), 16);
            v4 = BLAKEBigCore.circularRight(v4 ^ (v9 += vE), 11);
        }
        this.h0 ^= this.s0 ^ v0 ^ v8;
        this.h1 ^= this.s1 ^ v1 ^ v9;
        this.h2 ^= this.s2 ^ v2 ^ vA;
        this.h3 ^= this.s3 ^ v3 ^ vB;
        this.h4 ^= this.s0 ^ v4 ^ vC;
        this.h5 ^= this.s1 ^ v5 ^ vD;
        this.h6 ^= this.s2 ^ v6 ^ vE;
        this.h7 ^= this.s3 ^ v7 ^ vF;
    }

    @Override
    public String toString() {
        return "BLAKE-" + (this.getDigestLength() << 3);
    }
}

