/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.FugueCore;

public class Fugue384
extends FugueCore {
    private static final int[] initVal = new int[]{-1436423155, 824520223, -1608665913, 6293893, 559871050, 1947950748, -93765990, 1195290688, -452809078, -1449384480, -1131064964, 1544590753};

    @Override
    int[] getIV() {
        return initVal;
    }

    @Override
    public int getDigestLength() {
        return 48;
    }

    @Override
    FugueCore dup() {
        return new Fugue384();
    }

    @Override
    void process(int w, byte[] buf, int off, int num) {
        int[] S = this.S;
        switch (this.rshift) {
            case 1: {
                S[7] = S[7] ^ S[27];
                S[27] = w;
                S[35] = S[35] ^ S[27];
                S[28] = S[28] ^ S[18];
                S[31] = S[31] ^ S[21];
                S[24] = S[24] ^ S[28];
                S[25] = S[25] ^ S[29];
                S[26] = S[26] ^ S[30];
                S[6] = S[6] ^ S[28];
                S[7] = S[7] ^ S[29];
                S[8] = S[8] ^ S[30];
                this.smix(24, 25, 26, 27);
                S[21] = S[21] ^ S[25];
                S[22] = S[22] ^ S[26];
                S[23] = S[23] ^ S[27];
                S[3] = S[3] ^ S[25];
                S[4] = S[4] ^ S[26];
                S[5] = S[5] ^ S[27];
                this.smix(21, 22, 23, 24);
                S[18] = S[18] ^ S[22];
                S[19] = S[19] ^ S[23];
                S[20] = S[20] ^ S[24];
                S[0] = S[0] ^ S[22];
                S[1] = S[1] ^ S[23];
                S[2] = S[2] ^ S[24];
                this.smix(18, 19, 20, 21);
                if (num-- <= 0) {
                    this.rshift = 2;
                    return;
                }
                w = buf[off] << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
                off += 4;
            }
            case 2: {
                S[34] = S[34] ^ S[18];
                S[18] = w;
                S[26] = S[26] ^ S[18];
                S[19] = S[19] ^ S[9];
                S[22] = S[22] ^ S[12];
                S[15] = S[15] ^ S[19];
                S[16] = S[16] ^ S[20];
                S[17] = S[17] ^ S[21];
                S[33] = S[33] ^ S[19];
                S[34] = S[34] ^ S[20];
                S[35] = S[35] ^ S[21];
                this.smix(15, 16, 17, 18);
                S[12] = S[12] ^ S[16];
                S[13] = S[13] ^ S[17];
                S[14] = S[14] ^ S[18];
                S[30] = S[30] ^ S[16];
                S[31] = S[31] ^ S[17];
                S[32] = S[32] ^ S[18];
                this.smix(12, 13, 14, 15);
                S[9] = S[9] ^ S[13];
                S[10] = S[10] ^ S[14];
                S[11] = S[11] ^ S[15];
                S[27] = S[27] ^ S[13];
                S[28] = S[28] ^ S[14];
                S[29] = S[29] ^ S[15];
                this.smix(9, 10, 11, 12);
                if (num-- <= 0) {
                    this.rshift = 3;
                    return;
                }
                w = buf[off] << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
                off += 4;
            }
            case 3: {
                S[25] = S[25] ^ S[9];
                S[9] = w;
                S[17] = S[17] ^ S[9];
                S[10] = S[10] ^ S[0];
                S[13] = S[13] ^ S[3];
                S[6] = S[6] ^ S[10];
                S[7] = S[7] ^ S[11];
                S[8] = S[8] ^ S[12];
                S[24] = S[24] ^ S[10];
                S[25] = S[25] ^ S[11];
                S[26] = S[26] ^ S[12];
                this.smix(6, 7, 8, 9);
                S[3] = S[3] ^ S[7];
                S[4] = S[4] ^ S[8];
                S[5] = S[5] ^ S[9];
                S[21] = S[21] ^ S[7];
                S[22] = S[22] ^ S[8];
                S[23] = S[23] ^ S[9];
                this.smix(3, 4, 5, 6);
                S[0] = S[0] ^ S[4];
                S[1] = S[1] ^ S[5];
                S[2] = S[2] ^ S[6];
                S[18] = S[18] ^ S[4];
                S[19] = S[19] ^ S[5];
                S[20] = S[20] ^ S[6];
                this.smix(0, 1, 2, 3);
                if (num-- <= 0) {
                    this.rshift = 0;
                    return;
                }
                w = buf[off] << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
                off += 4;
            }
        }
        while (true) {
            S[16] = S[16] ^ S[0];
            S[0] = w;
            S[8] = S[8] ^ S[0];
            S[1] = S[1] ^ S[27];
            S[4] = S[4] ^ S[30];
            S[33] = S[33] ^ S[1];
            S[34] = S[34] ^ S[2];
            S[35] = S[35] ^ S[3];
            S[15] = S[15] ^ S[1];
            S[16] = S[16] ^ S[2];
            S[17] = S[17] ^ S[3];
            this.smix(33, 34, 35, 0);
            S[30] = S[30] ^ S[34];
            S[31] = S[31] ^ S[35];
            S[32] = S[32] ^ S[0];
            S[12] = S[12] ^ S[34];
            S[13] = S[13] ^ S[35];
            S[14] = S[14] ^ S[0];
            this.smix(30, 31, 32, 33);
            S[27] = S[27] ^ S[31];
            S[28] = S[28] ^ S[32];
            S[29] = S[29] ^ S[33];
            S[9] = S[9] ^ S[31];
            S[10] = S[10] ^ S[32];
            S[11] = S[11] ^ S[33];
            this.smix(27, 28, 29, 30);
            if (num-- <= 0) {
                this.rshift = 1;
                return;
            }
            w = buf[off] << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
            off += 4;
            S[7] = S[7] ^ S[27];
            S[27] = w;
            S[35] = S[35] ^ S[27];
            S[28] = S[28] ^ S[18];
            S[31] = S[31] ^ S[21];
            S[24] = S[24] ^ S[28];
            S[25] = S[25] ^ S[29];
            S[26] = S[26] ^ S[30];
            S[6] = S[6] ^ S[28];
            S[7] = S[7] ^ S[29];
            S[8] = S[8] ^ S[30];
            this.smix(24, 25, 26, 27);
            S[21] = S[21] ^ S[25];
            S[22] = S[22] ^ S[26];
            S[23] = S[23] ^ S[27];
            S[3] = S[3] ^ S[25];
            S[4] = S[4] ^ S[26];
            S[5] = S[5] ^ S[27];
            this.smix(21, 22, 23, 24);
            S[18] = S[18] ^ S[22];
            S[19] = S[19] ^ S[23];
            S[20] = S[20] ^ S[24];
            S[0] = S[0] ^ S[22];
            S[1] = S[1] ^ S[23];
            S[2] = S[2] ^ S[24];
            this.smix(18, 19, 20, 21);
            if (num-- <= 0) {
                this.rshift = 2;
                return;
            }
            w = buf[off] << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
            off += 4;
            S[34] = S[34] ^ S[18];
            S[18] = w;
            S[26] = S[26] ^ S[18];
            S[19] = S[19] ^ S[9];
            S[22] = S[22] ^ S[12];
            S[15] = S[15] ^ S[19];
            S[16] = S[16] ^ S[20];
            S[17] = S[17] ^ S[21];
            S[33] = S[33] ^ S[19];
            S[34] = S[34] ^ S[20];
            S[35] = S[35] ^ S[21];
            this.smix(15, 16, 17, 18);
            S[12] = S[12] ^ S[16];
            S[13] = S[13] ^ S[17];
            S[14] = S[14] ^ S[18];
            S[30] = S[30] ^ S[16];
            S[31] = S[31] ^ S[17];
            S[32] = S[32] ^ S[18];
            this.smix(12, 13, 14, 15);
            S[9] = S[9] ^ S[13];
            S[10] = S[10] ^ S[14];
            S[11] = S[11] ^ S[15];
            S[27] = S[27] ^ S[13];
            S[28] = S[28] ^ S[14];
            S[29] = S[29] ^ S[15];
            this.smix(9, 10, 11, 12);
            if (num-- <= 0) {
                this.rshift = 3;
                return;
            }
            w = buf[off] << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
            off += 4;
            S[25] = S[25] ^ S[9];
            S[9] = w;
            S[17] = S[17] ^ S[9];
            S[10] = S[10] ^ S[0];
            S[13] = S[13] ^ S[3];
            S[6] = S[6] ^ S[10];
            S[7] = S[7] ^ S[11];
            S[8] = S[8] ^ S[12];
            S[24] = S[24] ^ S[10];
            S[25] = S[25] ^ S[11];
            S[26] = S[26] ^ S[12];
            this.smix(6, 7, 8, 9);
            S[3] = S[3] ^ S[7];
            S[4] = S[4] ^ S[8];
            S[5] = S[5] ^ S[9];
            S[21] = S[21] ^ S[7];
            S[22] = S[22] ^ S[8];
            S[23] = S[23] ^ S[9];
            this.smix(3, 4, 5, 6);
            S[0] = S[0] ^ S[4];
            S[1] = S[1] ^ S[5];
            S[2] = S[2] ^ S[6];
            S[18] = S[18] ^ S[4];
            S[19] = S[19] ^ S[5];
            S[20] = S[20] ^ S[6];
            this.smix(0, 1, 2, 3);
            if (num-- <= 0) {
                this.rshift = 0;
                return;
            }
            w = buf[off] << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
            off += 4;
        }
    }

    @Override
    void processFinal(byte[] out) {
        int i;
        int[] S = this.S;
        this.ror(9 * this.rshift, 36);
        for (i = 0; i < 18; ++i) {
            this.ror(3, 36);
            this.cmix36();
            this.smix(0, 1, 2, 3);
        }
        for (i = 0; i < 13; ++i) {
            S[4] = S[4] ^ S[0];
            S[12] = S[12] ^ S[0];
            S[24] = S[24] ^ S[0];
            this.ror(12, 36);
            this.smix(0, 1, 2, 3);
            S[4] = S[4] ^ S[0];
            S[13] = S[13] ^ S[0];
            S[24] = S[24] ^ S[0];
            this.ror(12, 36);
            this.smix(0, 1, 2, 3);
            S[4] = S[4] ^ S[0];
            S[13] = S[13] ^ S[0];
            S[25] = S[25] ^ S[0];
            this.ror(11, 36);
            this.smix(0, 1, 2, 3);
        }
        S[4] = S[4] ^ S[0];
        S[12] = S[12] ^ S[0];
        S[24] = S[24] ^ S[0];
        Fugue384.encodeBEInt(S[1], out, 0);
        Fugue384.encodeBEInt(S[2], out, 4);
        Fugue384.encodeBEInt(S[3], out, 8);
        Fugue384.encodeBEInt(S[4], out, 12);
        Fugue384.encodeBEInt(S[12], out, 16);
        Fugue384.encodeBEInt(S[13], out, 20);
        Fugue384.encodeBEInt(S[14], out, 24);
        Fugue384.encodeBEInt(S[15], out, 28);
        Fugue384.encodeBEInt(S[24], out, 32);
        Fugue384.encodeBEInt(S[25], out, 36);
        Fugue384.encodeBEInt(S[26], out, 40);
        Fugue384.encodeBEInt(S[27], out, 44);
    }
}

