/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;

abstract class FugueCore
implements Digest {
    private long bitCount;
    private int partial;
    private int partialLen;
    private byte[] out = new byte[this.getDigestLength()];
    int rshift;
    int[] S = new int[36];
    int[] tmpS = new int[36];
    static final int[] mixtab0 = new int[]{1667445399, 2088529899, 2004311751, 2071689975, -218961691, 1802177207, 1869551271, -976917191, 808489152, 16844548, 1734815367, 724292012, -16855851, -673770639, -1414824806, 1987467715, -892715003, -2105367746, -909555447, 2105370863, -84225851, 1499042943, 1195888135, -252647699, -1381142910, -724297091, -1566424130, -1347460982, -1667434170, -1532735066, 1920091603, -1061128659, -1212733206, -33700391, -1819028358, 640086680, 909542104, 1061142012, -134745103, -859024867, 875859152, -1515891038, -437940807, -235806231, 1903250655, -656916915, 825333700, 353725268, 67378192, -943234255, 589556108, -1010598111, 404244576, -1768501394, 84220692, -1701123234, 117904668, 303201864, -2139050698, -488466267, -336877695, 656930204, -1296944130, 1970622671, 151600932, -2088524742, 741131440, 437929576, 454771052, 1852707235, 1515887987, -1600107082, 1381147987, 993763820, -690613131, -1280101126, 690610084, -471621727, 791662012, -2071678682, 1397989975, -774831767, 0, -303188583, 539025536, -50543907, -1313785102, 1532729975, 1785335219, -875870463, -1094838322, 960081892, 1246424371, 1280114475, 1482199931, -808494319, -791673235, -269501551, -1431667810, -67381311, 1128518167, 1296955439, 0x333399CC, -2054834654, 1162199055, -101066295, 33689096, 2139055847, 1347464027, 1010611440, -1616908214, -1465354858, 1364307039, -1549581126, 1077992219, -1886420982, -1835871362, -1650590142, 943237344, -168428039, -1128523322, -1229574162, -623235003, 555870084, 269512768, -13359, -202117151, -757987227, -842181351, 202122288, 320043340, -320032099, 1600095847, -1751660438, 1145358091, 387409244, -993760707, -1482205014, 2122211811, 1027453940, 1684285323, 1566410863, 421089124, 1936933591, 1616919451, -2122208718, 1330640423, -589553059, 0x2222EE88, 707450536, -1869554314, -2004314858, 1179044099, -286344043, -1195899434, 336882768, -555865003, 1583251811, 185282860, -606390463, -522152275, 842178248, 976922344, 168441384, 1229579327, 101061144, 606403728, 1549569899, -1027442651, -741142687, -1397986938, 1650603411, -1852712334, -1785346462, -454784323, 2038002943, -404257871, -926396915, 926385628, 1835866287, -1920102910, -707453575, 1313796387, -1448512878, 1819025323, 1448524099, -185271555, -353722235, 1701126287, 2054847987, -1364301938, 134756384, -1162212386, 2021159931, 623246228, 774818488, 471618672, -1499045970, -1263263258, -960076747, -387404147, -572709543, 1953781707, 522149244, 1263266359, -1111679294, -1953784806, -1970627810, 1886407643, 1044298488, -1246419230, 1717971331, 1212736315, 50530572, -151587595, 235809336, 1633762463, 892701652, 1465368135, -1179057454, -2037989586, -1044287191, 488461172, -1633749170, -505310807, -117907763, -1734810282, 0x11117744, 1768490175, -640075447, -1903261938, -1802190490, -1684280230, 505305720, -2021148630, -370562679, -825336811, 1431679055, 673765536, -539022511, -1936946938, -1583265102, -1987472878, 218964788, -1077997366, -421100363, 1111676179, 1751647163, 1094835231, -1717968302, 757973940, 252652860, -1330627082, 1414838091, -1145369382, 370565720};
    static final int[] mixtab1 = new int[]{-1755094222, -344163217, -948471970, -142902406, -437062936, -1217697014, -1485869290, 969262445, -1070583664, 67174663, -2023266514, -1406456879, -704708916, 1909970707, -1700025476, -1015646631, 97176128, 1048740515, 0x9C9C949, -276988568, -973407536, 2136562068, 122111950, -302976794, -2102547090, 2111099930, -1096637885, -1968197792, 1184668921, -1499159471, -747474363, 767606902, -357058776, -637665851, 2056491988, -1742330126, -667535742, -62963779, -235407373, 499960914, -801885044, -1566202538, -1176115827, -370019871, -546213556, 1306056766, -1003409001, 1410667883, 268698652, 835176291, -1943854103, 566477695, 1612191816, 1855362767, 335873307, 1587190507, 470222613, 1209143934, 914391213, -1511857512, -2115245145, -1675155467, -21843405, -814385840, 604571967, 981697444, -1339282236, 1746541126, 1813715777, -1553043951, 1935301277, -1230987187, 1397904037, -331662431, 1977013780, -88886476, -1540806177, -1578900577, -1137758259, 646218929, 1465078690, 1775358209, 0, -1712460363, -2145378080, -570622782, -223235782, 2002475930, -1284871667, 30133063, -826360297, -466011729, 860506861, 726420735, 2069387411, 298831707, 0x6DD0D006, -1846546501, -1632982405, -1040450601, 390284242, 793595384, -869059687, 579175862, 256198080, -906364455, 134349326, -411074714, 1531990187, -264487756, 1251975152, -1767331723, 1599164844, -1163680956, 457195739, 177180544, 2123535059, 1117625854, -533186392, -101321219, -960709607, -290015697, 1171970608, -2078203417, 1074794608, -771751989, -504106001, 1708315144, 432917845, 806095908, 1276318585, -1645417294, 1734303622, 1788319688, 189023431, 1545017189, 1036305514, -1431853224, -478249375, -197313101, -1956355033, 1868389768, 1679366479, -680299710, -1688182725, 847348138, 659509238, 1574755362, -2011028754, -1473631530, 1989185757, 378046613, 54937289, -1779503428, -692537339, 1343493228, 1440669228, 1667128961, 738921265, 1104927543, -1377771370, -936234338, -398837082, 671746614, 1061767652, 403047954, -1876679428, 1801215119, 633520760, 1641272079, -2035504023, -1822268875, 1922142682, 1653970374, -1109072758, -8816268, -1310201981, 231262286, -600361083, -1351783144, 42831246, 2044056861, 592334577, -1834374798, -1418957793, 1129731769, -34278150, -2048202080, -1889180384, -210077059, -1901154713, 537397304, -558188021, -75990925, -1809504773, -1204932918, 1880890452, -1364810145, -424365023, 902219364, -1914115922, 1507712293, -881560489, 2082414429, 927681514, -1027752674, 445352860, 512395931, -613388213, -130138438, -491408090, -2090441175, 994592995, 201523977, -168364300, 940445226, -1621008068, -734710389, 1196906430, -759580414, 780568255, 700563825, 1948065107, 1319018231, -1444814447, -839321378, 1452841189, 0x44111177, -1083610876, 1239013689, 0xE8E8E87, 1721013441, 1520147436, 2015239770, 713525176, -1981158999, 365874780, 1330992560, -1607980840, 1373626155, 109874313, -1298030262, 311003538, 873270563, -893403376, -1243158908, 323109589, -1150785533, 524370396, 1385798114, -1272107581, 1007619885, -156192707, 1263817911, -625231092, 1477842530};
    static final int[] mixtab2 = new int[]{848782179, 1877703804, 1590130551, 2063039355, -387583246, 179792747, 380071791, 1832502725, -1866452944, 117702913, 780625767, -777245909, -858390786, 326227927, 2090511275, 1505982070, 1074121418, -1556184446, 1225378249, 1760525693, -792331526, -1803593383, -838383801, -420613904, 1854057901, 444454100, 1136566946, 1619701679, -112812900, 1369875620, 1171485298, 1982709952, 686471095, -975569411, -730164333, -224909786, -2099759562, -1107542209, -202246153, 1377684684, -1932512204, 1453499813, -1917196827, -504761871, 1289711985, 1045289176, -1748750031, 1800672533, 470811652, 1664206791, -376691933, 2132919235, 1214257176, -814836074, 454296837, -346121574, 354158343, 2118652434, -1388937088, -1733958942, -1484657685, -174315737, 872329906, 1355773301, 1059326217, -1539669117, -995087316, 1181227546, 1097603867, 295923310, -1653384614, 1303814304, -1521266094, -1578353861, 343267030, 888845235, -542889687, -1616780317, -843305169, -1322875772, -1571335341, 23712209, 0, -1248203283, -528474080, -1025639172, 988983729, -1703453861, 229861994, 1191300043, 399425214, -1343997639, -315405750, -13939636, -1820633000, 1527893967, 0x66DD0D0, -1148063761, 2073995946, -675152901, -770227389, -131117747, -1714670797, -1239251579, -1072741051, -641074695, 235405826, 1726447487, -1420079024, -1259324356, -263544929, 1972807848, -1403039407, 1153082275, -618971072, -2146791537, -746679662, -29188707, -1461700552, -33950219, 432454844, 804173494, 809884378, -410771167, 1883246608, -875429889, -270404621, 140890834, 1427754445, 607128588, 2035028755, -1298273044, -2040045729, -932538473, -955562940, 1700534039, 1782432964, 1487579047, 1642299006, -1275839171, 663446628, -2005967523, 1331960089, 1121416051, 1000038496, -1439530623, -165195953, 576576732, -293068254, -693622230, -579432304, -1793685368, -922532282, -1131024658, 97958072, 1817187348, 743825118, -2124194210, 824969995, 927063003, -1766989600, -1631047118, -1494730182, 908593674, -465614519, 303564294, -57662428, -1888789412, 2015740610, 258069459, 1770433708, 898851426, -630025839, -966617707, -1967266588, 1962899833, -2085492761, 1309526216, -2049165513, 414149997, -1912435315, 494523861, -249344434, 1922214313, 531328108, -1186769322, -84019980, -1601836310, 546268517, 2113108602, 1737404078, 941623304, 199146170, 1945860216, -74177243, -893899218, 1416633372, 1605281446, 568767668, 1681245894, -1366431512, 626646493, 1472951412, 1568415519, -365474997, 516079037, -1675981941, -1692497270, 1272672368, -1158136258, 652391861, 696477286, -482654136, 151782147, -185207050, 708316686, 1017078113, -1949027019, -1102620841, 47364537, -1087469946, 1898561985, 1400118557, -145842530, -1851137567, -556926728, -447309672, 0x77441111, 79653225, 961141209, -2029089138, -1050241900, -329606245, 1517821470, -1205172345, -1450579479, 1544933070, -1336978091, -660592600, 726786015, -1996059508, 1253220769, -1844278903, 590613773, 281722815, -2068453658, -720158142, 62613608, -601931455, -497903207, -1011602131, 758910735, 1039577264, -1219799980, 215661499, 1649939990};
    static final int[] mixtab3 = new int[]{1664259939, 2087709564, 2002700151, 2071656315, -219617806, 1795864427, 1863755631, -982697531, 814792752, 17236993, 1731102567, 735161387, -20130306, -686591529, -1417897301, 1985594230, -901773878, -2103230846, -917960247, 2104029053, -86981126, 1502904153, 1204684615, -253301264, -1385266515, -736461356, -1572618590, -1352627537, -1661385060, -1538152796, 1917178738, -1065996864, -1222055241, -37365251, -1814791533, 653432870, 914544694, 1069415487, -135007753, -867033652, 881643572, -1521048923, -443696667, -236852751, 1900863345, -667005480, 832029745, 359355413, 68947972, -949800505, 602508323, -1015078461, 407396376, -1764790634, 85660677, -1695850854, 118823943, 310265874, -2136131968, -493312542, -341343765, 670407719, -1305215310, 1968230261, 155132937, -2086389117, 751087660, 440821786, 457272347, 1846649710, 1520268122, -1605519712, 1386566482, 1000467515, -703302186, -1288373581, 702522409, -476077597, 802012207, -2068765052, 1403148115, -788436527, 0, -306865683, 551583776, -54338052, -1321536847, 1536849755, 1779282794, -884538933, -1105736002, 967828537, 1257059146, 1291791180, 1486060376, -816115249, -804885040, -272920081, -1434739030, -69746181, 1137841987, 1308110669, 0x3399CC33, -2051661179, 1170214725, -103167495, 34473986, 2137450367, 1353407312, 1018490940, -1611642209, -1468688728, 1370251089, -1555776861, 1088101184, -1887434097, -1831633262, -1644281187, 950591544, -167904779, -1139161412, -1238372682, -634370598, 568820769, 275791888, -3419649, -202382861, -771201582, -850060851, 203698188, 326716435, -323838484, 1602643807, -1748473193, 1153895236, 392518679, -999670332, -1487361369, 2120344446, 1035203645, 1680313188, 1569222493, 424633369, 1933760371, 1614519136, -2119552383, 1341531983, -601727524, 0x22EE8822, 718710826, -1864534384, -2003495288, 1187578694, -289630738, -1207576904, 342642708, -567519778, 1585537886, 187771915, -617135653, -526996000, 849266738, 984016954, 171321354, 1239695177, 101849094, 620531748, 1552903004, -1032313406, -753966637, -1402370388, 1647678306, -1847954799, -1782160747, -460669468, 2037710713, -410799641, -934408760, 931519543, 1830334317, -1920073075, -719488555, 1324426062, -1452109143, 1814014828, 1454981974, -184877580, -358578710, 1696632677, 2055074682, -1368944978, 137895944, -1173627206, 2020866936, 637244453, 785037358, 475295772, -1503678810, -1272846668, -966511162, -391213592, -584754723, 1951910772, 526220319, 1273640779, -1122057539, -1952703861, -1969545590, 1884019568, 1052440638, -1255742795, 1713996646, 1222851400, 50924547, -151718410, 237647886, 1631362913, 898356277, 1472087895, -1190997319, -2034291066, -1049548351, 492008477, -1627959650, -510547487, -119616008, -1729800552, 0x11774411, 1761918825, -650556967, -1903751538, -1799264620, -1679009125, 509245470, -2017973625, -374765079, -832825906, 1437618005, 685285416, -550809121, -1937176948, -1588940127, -1986915703, 220410893, -1089418561, -427510298, 1121260354, 1745075048, 1104944961, -1713220967, 767800365, 254622735, -1338116432, 1421298516, -1156785477, 375543830};

    FugueCore() {
        this.doReset();
    }

    @Override
    public void update(byte in) {
        this.bitCount += 8L;
        this.partial = this.partial << 8 | in & 0xFF;
        if (++this.partialLen == 4) {
            this.process(this.partial);
            this.partial = 0;
            this.partialLen = 0;
        }
    }

    @Override
    public void update(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
    }

    @Override
    public void update(byte[] inbuf, int off, int len) {
        this.bitCount += (long)len << 3;
        while (this.partialLen < 4 && len > 0) {
            this.partial = this.partial << 8 | inbuf[off++] & 0xFF;
            ++this.partialLen;
            --len;
        }
        if (this.partialLen == 4 || len > 0) {
            int zlen = len & 0xFFFFFFFC;
            this.process(this.partial, inbuf, off, zlen >>> 2);
            off += zlen;
            this.partial = 0;
            this.partialLen = len -= zlen;
            while (len-- > 0) {
                this.partial = this.partial << 8 | inbuf[off++] & 0xFF;
            }
        }
    }

    private void process(int w) {
        this.process(w, null, 0, 0);
    }

    abstract void process(int var1, byte[] var2, int var3, int var4);

    abstract void processFinal(byte[] var1);

    @Override
    public byte[] digest() {
        int n = this.getDigestLength();
        byte[] out = new byte[n];
        this.digest(out, 0, n);
        return out;
    }

    @Override
    public byte[] digest(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
        return this.digest();
    }

    @Override
    public int digest(byte[] outbuf, int off, int len) {
        if (this.partialLen != 0) {
            while (this.partialLen++ < 4) {
                this.partial <<= 8;
            }
            this.process(this.partial);
        }
        this.process((int)(this.bitCount >>> 32));
        this.process((int)this.bitCount);
        this.processFinal(this.out);
        if (len > this.out.length) {
            len = this.out.length;
        }
        System.arraycopy(this.out, 0, outbuf, off, len);
        this.doReset();
        return len;
    }

    final void ror(int rc, int len) {
        System.arraycopy(this.S, len - rc, this.tmpS, 0, rc);
        System.arraycopy(this.S, 0, this.S, rc, len - rc);
        System.arraycopy(this.tmpS, 0, this.S, 0, rc);
    }

    final void cmix30() {
        int[] S = this.S;
        S[0] = S[0] ^ S[4];
        S[1] = S[1] ^ S[5];
        S[2] = S[2] ^ S[6];
        S[15] = S[15] ^ S[4];
        S[16] = S[16] ^ S[5];
        S[17] = S[17] ^ S[6];
    }

    final void cmix36() {
        int[] S = this.S;
        S[0] = S[0] ^ S[4];
        S[1] = S[1] ^ S[5];
        S[2] = S[2] ^ S[6];
        S[18] = S[18] ^ S[4];
        S[19] = S[19] ^ S[5];
        S[20] = S[20] ^ S[6];
    }

    final void smix(int i0, int i1, int i2, int i3) {
        int[] S = this.S;
        int c0 = 0;
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int r0 = 0;
        int r1 = 0;
        int r2 = 0;
        int r3 = 0;
        int xt = S[i0];
        int tmp = mixtab0[xt >>> 24 & 0xFF];
        c0 ^= tmp;
        tmp = mixtab1[xt >>> 16 & 0xFF];
        c0 ^= tmp;
        r1 ^= tmp;
        tmp = mixtab2[xt >>> 8 & 0xFF];
        c0 ^= tmp;
        r2 ^= tmp;
        tmp = mixtab3[xt >>> 0 & 0xFF];
        c0 ^= tmp;
        r3 ^= tmp;
        xt = S[i1];
        tmp = mixtab0[xt >>> 24 & 0xFF];
        c1 ^= tmp;
        r0 ^= tmp;
        tmp = mixtab1[xt >>> 16 & 0xFF];
        c1 ^= tmp;
        tmp = mixtab2[xt >>> 8 & 0xFF];
        c1 ^= tmp;
        r2 ^= tmp;
        tmp = mixtab3[xt >>> 0 & 0xFF];
        c1 ^= tmp;
        r3 ^= tmp;
        xt = S[i2];
        tmp = mixtab0[xt >>> 24 & 0xFF];
        c2 ^= tmp;
        r0 ^= tmp;
        tmp = mixtab1[xt >>> 16 & 0xFF];
        c2 ^= tmp;
        r1 ^= tmp;
        tmp = mixtab2[xt >>> 8 & 0xFF];
        c2 ^= tmp;
        tmp = mixtab3[xt >>> 0 & 0xFF];
        c2 ^= tmp;
        r3 ^= tmp;
        xt = S[i3];
        tmp = mixtab0[xt >>> 24 & 0xFF];
        c3 ^= tmp;
        r0 ^= tmp;
        tmp = mixtab1[xt >>> 16 & 0xFF];
        c3 ^= tmp;
        r1 ^= tmp;
        tmp = mixtab2[xt >>> 8 & 0xFF];
        c3 ^= tmp;
        r2 ^= tmp;
        tmp = mixtab3[xt >>> 0 & 0xFF];
        S[i0] = (c0 ^ r0 << 0) & 0xFF000000 | (c1 ^ r1 << 0) & 0xFF0000 | (c2 ^ r2 << 0) & 0xFF00 | ((c3 ^= tmp) ^ r3 << 0) & 0xFF;
        S[i1] = (c1 ^ r0 << 8) & 0xFF000000 | (c2 ^ r1 << 8) & 0xFF0000 | (c3 ^ r2 << 8) & 0xFF00 | (c0 ^ r3 >>> 24) & 0xFF;
        S[i2] = (c2 ^ r0 << 16) & 0xFF000000 | (c3 ^ r1 << 16) & 0xFF0000 | (c0 ^ r2 >>> 16) & 0xFF00 | (c1 ^ r3 >>> 16) & 0xFF;
        S[i3] = (c3 ^ r0 << 24) & 0xFF000000 | (c0 ^ r1 >>> 8) & 0xFF0000 | (c1 ^ r2 >>> 8) & 0xFF00 | (c2 ^ r3 >>> 8) & 0xFF;
    }

    static final void encodeBEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 24);
        buf[off + 1] = (byte)(val >>> 16);
        buf[off + 2] = (byte)(val >>> 8);
        buf[off + 3] = (byte)val;
    }

    @Override
    public void reset() {
        this.doReset();
    }

    private void doReset() {
        int[] iv = this.getIV();
        int zlen = this.getDigestLength() <= 32 ? 30 - iv.length : 36 - iv.length;
        for (int i = 0; i < zlen; ++i) {
            this.S[i] = 0;
        }
        System.arraycopy(iv, 0, this.S, zlen, iv.length);
        this.bitCount = 0L;
        this.partial = 0;
        this.partialLen = 0;
        this.rshift = 0;
    }

    abstract int[] getIV();

    @Override
    public Digest copy() {
        FugueCore fc = this.dup();
        fc.bitCount = this.bitCount;
        fc.partial = this.partial;
        fc.partialLen = this.partialLen;
        fc.rshift = this.rshift;
        System.arraycopy(this.S, 0, fc.S, 0, this.S.length);
        return fc;
    }

    abstract FugueCore dup();

    @Override
    public int getBlockLength() {
        return -4;
    }

    @Override
    public String toString() {
        return "Fugue-" + (this.getDigestLength() << 3);
    }
}

