/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class GroestlBigCore
extends DigestEngine {
    private long[] H;
    private long[] G;
    private long[] M;
    private static final long[] T0 = new long[]{-4164997711753927226L, -545050434148268808L, -1270383870729545234L, -686081453637267978L, -6730054438154753L, -3023361491815907882L, -2443545081900715554L, -7967434723809471343L, 6958325654714601568L, 146091023440020226L, -3589684832746624562L, 6255930330611219798L, -1743971568589661721L, -5398788585657638219L, 5583392502777046605L, -1415900931752224020L, -8124265829043452529L, 2279873222033710367L, -8554094632881274743L, -402911055666247686L, -1166362942992214545L, -5578791247000114254L, -8156510642014533234L, -295516791962268677L, 4714758551359384641L, -5540930128835680333L, 6864362130477350239L, 4999037273963686469L, 2592343578064109347L, 6003583038186256211L, -1998013191336782108L, -7244341971501884517L, 8442100590886699637L, -2178295141467874079L, 4455442868826975805L, 5544703456919972428L, 7819073977390226028L, 9132670306605613438L, -724228509300358411L, -8983888165909737597L, 7533647364310981736L, 5860880709750813777L, -3346917568102714159L, -441044865448867591L, -2140143773590514718L, -6107279721009155157L, 7104416678154621794L, 3056608512035798826L, 584364093760080904L, -7682025703185755499L, 5109808103500309830L, -7097705590563971427L, 3479162827357300784L, 4021706366806565175L, 728194521159175946L, 3453069824272282927L, 1014747016965392654L, 2629638421920364068L, 1994450989888215835L, -2335038078271013409L, -3627814261595494707L, 5689659767046039886L, 9165754111272865151L, -1562543875500826646L, 1314819210960182034L, 2136036214644055581L, 6396409395431896152L, 3766823682155490868L, 3909536988695113014L, -2589062142923394340L, -5432139472664531276L, 6578939898331855707L, -6582853124236249436L, 8548350297060953462L, -5254395225484992073L, 9021917103883210365L, 5971647192713427794L, -2477188434857214243L, 6831278325810098526L, 1419094129742616339L, -6439579066800015962L, -5115604941806147399L, 0L, -4488553719321252671L, 4674912750080647232L, -2035027664022200349L, 8735368954651003001L, -5288865415228297802L, -3166635549252141356L, -8266416185629653363L, 7428530189573740903L, 8264067159163161458L, -7715376590192648556L, -7422099498921634664L, -5723191221523060560L, -8837225430649845115L, -4970076868319548485L, -4198623506615686459L, 5727229510166701391L, -1308513299578415379L, -8731823521021835898L, -7279960120439613542L, 7393221008134264166L, 1276391801307173905L, -8448670646785814646L, -1596191746830036759L, 292182046880040452L, -115237058067856898L, -6869383681012928352L, 8697801376227411064L, 2733919972232968741L, 5437321270848316235L, -6724983706489982046L, 6720525123087695453L, -9161628135234748288L, 396463597192645125L, 4599279876216630591L, 2449641249628666913L, 8117976135723141232L, -1009637529924074255L, 7140873784428781411L, 8588180601862799735L, -5822978990657931857L, 4821003773520667458L, 2337456375040323616L, -1888364928762307867L, -148880411024355587L, -4681290130795434561L, -9127155643355411327L, 1739581413678650392L, 2772351728459986214L, -4345286241875578941L, -4718021019658886722L, 3875626355830465077L, -8590810025267835768L, 3343161007842015534L, -7824167246363797613L, 6149680624436965973L, -260754119090535684L, 8841631803626506106L, -4023984215999927096L, -5005695017257277510L, 3625253850797321010L, -1854739133900548634L, -4594802325966839616L, 1849488065411848217L, -6992286122841222754L, -6691643711687917661L, 4967094796960687684L, 6113217024071597652L, 4313857644071136059L, 834747594077274891L, -8302027703037212020L, -4054230146443040313L, 7711691791318569835L, 2912778084636703784L, -6400587616255379033L, -4863538080681565508L, 1599102348857974038L, -5965129347244132691L, -2623824815795127333L, 7250507701594642020L, 8405636990521331316L, 1456389042318351892L, -7862028364528231534L, 869790706839325196L, 5259276843840728136L, -5147834395739298632L, -6955555233977770593L, -4823440487381635395L, 4857460879794827075L, -4308271769190160700L, 4168894719594768441L, 3586826441144312881L, -3203650090657040429L, -976007285409084430L, -3061508547478998315L, -8408566559394675829L, 7964030287516293486L, -2731219079499106342L, 112184874588343297L, -5684197606281354063L, -7137803183863901540L, 5292358346371948617L, -2873358457981127464L, -6000740864651691348L, -866370052478400525L, -3485663905009293873L, -3881844837517905974L, -829355511073501452L, 5145117284939786567L, 1168728187520161808L, 8001600030636954991L, -1120407259932030736L, 5403107271239823178L, 6686322015684031068L, 4058988067861570616L, 6295760635413066071L, 8296003004635989875L, -7537632343013109353L, -3769964635360517173L, -6834911189133591391L, -1704683253982847768L, 4493856998239772990L, -7572102532756415082L, 6998171455993338977L, 980818826006005261L, 1124655833395660047L, -2284543748113461024L, 8987713996479545980L, 8153300676200547441L, -3735201893769303348L, -8006428339051177840L, 434895353419662598L, -579835149127712265L, 2029494033930785308L, -4450402351443893310L, 7677477791710076778L, -5855223803629012562L, 7566728866842202217L, 1711271726969426199L, -7389870044988483431L, 4202818495260665658L, 2879999983209068839L, -2769352889281726247L, -1450663673343437845L, 3163161584953897771L, 2483547398480343842L, -3313287323587724334L, -6252807794495754071L, 542543608168745223L, 3729528769579755315L, 3309232816882628141L, 4348900688113705532L, 1565191715993326101L, -3915492708847116087L, -8692832070477198969L, -6147383808400293974L, 5825556169273407568L, -6544980976428025179L, 254887203023785731L, 6433976973855488089L, 689784669600907273L, 1883411841077745434L, 7282450178597640805L, -2917115187306352169L, -8875097578458069372L, -3457687298110670640L, -9017228160711801982L, 3018198660477530153L, 6540239822830991194L, 2174450344056852766L, 8880331879127370619L, -6289523186882315096L, 7857763023247300205L, 3198204697715948076L};
    private static final long[] T1 = new long[T0.length];
    private static final long[] T2 = new long[T0.length];
    private static final long[] T3 = new long[T0.length];
    private static final long[] T4 = new long[T0.length];
    private static final long[] T5 = new long[T0.length];
    private static final long[] T6 = new long[T0.length];
    private static final long[] T7 = new long[T0.length];

    GroestlBigCore() {
    }

    @Override
    public int getBlockLength() {
        return 128;
    }

    protected Digest copyState(GroestlBigCore dst) {
        System.arraycopy(this.H, 0, dst.H, 0, this.H.length);
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        for (int i = 0; i < 15; ++i) {
            this.H[i] = 0L;
        }
        this.H[15] = this.getDigestLength() << 3;
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int i;
        byte[] buf = this.getBlockBuffer();
        int ptr = this.flush();
        buf[ptr++] = -128;
        long count = this.getBlockCount();
        if (ptr <= 120) {
            for (i = ptr; i < 120; ++i) {
                buf[i] = 0;
            }
            ++count;
        } else {
            for (i = ptr; i < 128; ++i) {
                buf[i] = 0;
            }
            this.processBlock(buf);
            for (i = 0; i < 120; ++i) {
                buf[i] = 0;
            }
            count += 2L;
        }
        GroestlBigCore.encodeBELong(count, buf, 120);
        this.processBlock(buf);
        System.arraycopy(this.H, 0, this.G, 0, this.H.length);
        this.doPermP(this.G);
        for (i = 0; i < 8; ++i) {
            GroestlBigCore.encodeBELong(this.H[i + 8] ^ this.G[i + 8], buf, 8 * i);
        }
        int outLen = this.getDigestLength();
        System.arraycopy(buf, 64 - outLen, output, outputOffset, outLen);
    }

    @Override
    protected void doInit() {
        this.H = new long[16];
        this.G = new long[16];
        this.M = new long[16];
        this.engineReset();
    }

    private static final void encodeBELong(long val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 56);
        buf[off + 1] = (byte)(val >>> 48);
        buf[off + 2] = (byte)(val >>> 40);
        buf[off + 3] = (byte)(val >>> 32);
        buf[off + 4] = (byte)(val >>> 24);
        buf[off + 5] = (byte)(val >>> 16);
        buf[off + 6] = (byte)(val >>> 8);
        buf[off + 7] = (byte)val;
    }

    private static final long decodeBELong(byte[] buf, int off) {
        return (long)(buf[off] & 0xFF) << 56 | (long)(buf[off + 1] & 0xFF) << 48 | (long)(buf[off + 2] & 0xFF) << 40 | (long)(buf[off + 3] & 0xFF) << 32 | (long)(buf[off + 4] & 0xFF) << 24 | (long)(buf[off + 5] & 0xFF) << 16 | (long)(buf[off + 6] & 0xFF) << 8 | (long)(buf[off + 7] & 0xFF);
    }

    private static long circularLeft(long x, int n) {
        return x << n | x >>> 64 - n;
    }

    private void doPermP(long[] x) {
        for (int r = 0; r < 14; ++r) {
            x[0] = x[0] ^ (long)r << 56;
            x[1] = x[1] ^ (long)(16 + r) << 56;
            x[2] = x[2] ^ (long)(32 + r) << 56;
            x[3] = x[3] ^ (long)(48 + r) << 56;
            x[4] = x[4] ^ (long)(64 + r) << 56;
            x[5] = x[5] ^ (long)(80 + r) << 56;
            x[6] = x[6] ^ (long)(96 + r) << 56;
            x[7] = x[7] ^ (long)(112 + r) << 56;
            x[8] = x[8] ^ (long)(128 + r) << 56;
            x[9] = x[9] ^ (long)(144 + r) << 56;
            x[10] = x[10] ^ (long)(160 + r) << 56;
            x[11] = x[11] ^ (long)(176 + r) << 56;
            x[12] = x[12] ^ (long)(192 + r) << 56;
            x[13] = x[13] ^ (long)(208 + r) << 56;
            x[14] = x[14] ^ (long)(224 + r) << 56;
            x[15] = x[15] ^ (long)(240 + r) << 56;
            long t0 = T0[(int)(x[0] >>> 56)] ^ T1[(int)(x[1] >>> 48) & 0xFF] ^ T2[(int)(x[2] >>> 40) & 0xFF] ^ T3[(int)(x[3] >>> 32) & 0xFF] ^ T4[(int)x[4] >>> 24] ^ T5[(int)x[5] >>> 16 & 0xFF] ^ T6[(int)x[6] >>> 8 & 0xFF] ^ T7[(int)x[11] & 0xFF];
            long t1 = T0[(int)(x[1] >>> 56)] ^ T1[(int)(x[2] >>> 48) & 0xFF] ^ T2[(int)(x[3] >>> 40) & 0xFF] ^ T3[(int)(x[4] >>> 32) & 0xFF] ^ T4[(int)x[5] >>> 24] ^ T5[(int)x[6] >>> 16 & 0xFF] ^ T6[(int)x[7] >>> 8 & 0xFF] ^ T7[(int)x[12] & 0xFF];
            long t2 = T0[(int)(x[2] >>> 56)] ^ T1[(int)(x[3] >>> 48) & 0xFF] ^ T2[(int)(x[4] >>> 40) & 0xFF] ^ T3[(int)(x[5] >>> 32) & 0xFF] ^ T4[(int)x[6] >>> 24] ^ T5[(int)x[7] >>> 16 & 0xFF] ^ T6[(int)x[8] >>> 8 & 0xFF] ^ T7[(int)x[13] & 0xFF];
            long t3 = T0[(int)(x[3] >>> 56)] ^ T1[(int)(x[4] >>> 48) & 0xFF] ^ T2[(int)(x[5] >>> 40) & 0xFF] ^ T3[(int)(x[6] >>> 32) & 0xFF] ^ T4[(int)x[7] >>> 24] ^ T5[(int)x[8] >>> 16 & 0xFF] ^ T6[(int)x[9] >>> 8 & 0xFF] ^ T7[(int)x[14] & 0xFF];
            long t4 = T0[(int)(x[4] >>> 56)] ^ T1[(int)(x[5] >>> 48) & 0xFF] ^ T2[(int)(x[6] >>> 40) & 0xFF] ^ T3[(int)(x[7] >>> 32) & 0xFF] ^ T4[(int)x[8] >>> 24] ^ T5[(int)x[9] >>> 16 & 0xFF] ^ T6[(int)x[10] >>> 8 & 0xFF] ^ T7[(int)x[15] & 0xFF];
            long t5 = T0[(int)(x[5] >>> 56)] ^ T1[(int)(x[6] >>> 48) & 0xFF] ^ T2[(int)(x[7] >>> 40) & 0xFF] ^ T3[(int)(x[8] >>> 32) & 0xFF] ^ T4[(int)x[9] >>> 24] ^ T5[(int)x[10] >>> 16 & 0xFF] ^ T6[(int)x[11] >>> 8 & 0xFF] ^ T7[(int)x[0] & 0xFF];
            long t6 = T0[(int)(x[6] >>> 56)] ^ T1[(int)(x[7] >>> 48) & 0xFF] ^ T2[(int)(x[8] >>> 40) & 0xFF] ^ T3[(int)(x[9] >>> 32) & 0xFF] ^ T4[(int)x[10] >>> 24] ^ T5[(int)x[11] >>> 16 & 0xFF] ^ T6[(int)x[12] >>> 8 & 0xFF] ^ T7[(int)x[1] & 0xFF];
            long t7 = T0[(int)(x[7] >>> 56)] ^ T1[(int)(x[8] >>> 48) & 0xFF] ^ T2[(int)(x[9] >>> 40) & 0xFF] ^ T3[(int)(x[10] >>> 32) & 0xFF] ^ T4[(int)x[11] >>> 24] ^ T5[(int)x[12] >>> 16 & 0xFF] ^ T6[(int)x[13] >>> 8 & 0xFF] ^ T7[(int)x[2] & 0xFF];
            long t8 = T0[(int)(x[8] >>> 56)] ^ T1[(int)(x[9] >>> 48) & 0xFF] ^ T2[(int)(x[10] >>> 40) & 0xFF] ^ T3[(int)(x[11] >>> 32) & 0xFF] ^ T4[(int)x[12] >>> 24] ^ T5[(int)x[13] >>> 16 & 0xFF] ^ T6[(int)x[14] >>> 8 & 0xFF] ^ T7[(int)x[3] & 0xFF];
            long t9 = T0[(int)(x[9] >>> 56)] ^ T1[(int)(x[10] >>> 48) & 0xFF] ^ T2[(int)(x[11] >>> 40) & 0xFF] ^ T3[(int)(x[12] >>> 32) & 0xFF] ^ T4[(int)x[13] >>> 24] ^ T5[(int)x[14] >>> 16 & 0xFF] ^ T6[(int)x[15] >>> 8 & 0xFF] ^ T7[(int)x[4] & 0xFF];
            long tA = T0[(int)(x[10] >>> 56)] ^ T1[(int)(x[11] >>> 48) & 0xFF] ^ T2[(int)(x[12] >>> 40) & 0xFF] ^ T3[(int)(x[13] >>> 32) & 0xFF] ^ T4[(int)x[14] >>> 24] ^ T5[(int)x[15] >>> 16 & 0xFF] ^ T6[(int)x[0] >>> 8 & 0xFF] ^ T7[(int)x[5] & 0xFF];
            long tB = T0[(int)(x[11] >>> 56)] ^ T1[(int)(x[12] >>> 48) & 0xFF] ^ T2[(int)(x[13] >>> 40) & 0xFF] ^ T3[(int)(x[14] >>> 32) & 0xFF] ^ T4[(int)x[15] >>> 24] ^ T5[(int)x[0] >>> 16 & 0xFF] ^ T6[(int)x[1] >>> 8 & 0xFF] ^ T7[(int)x[6] & 0xFF];
            long tC = T0[(int)(x[12] >>> 56)] ^ T1[(int)(x[13] >>> 48) & 0xFF] ^ T2[(int)(x[14] >>> 40) & 0xFF] ^ T3[(int)(x[15] >>> 32) & 0xFF] ^ T4[(int)x[0] >>> 24] ^ T5[(int)x[1] >>> 16 & 0xFF] ^ T6[(int)x[2] >>> 8 & 0xFF] ^ T7[(int)x[7] & 0xFF];
            long tD = T0[(int)(x[13] >>> 56)] ^ T1[(int)(x[14] >>> 48) & 0xFF] ^ T2[(int)(x[15] >>> 40) & 0xFF] ^ T3[(int)(x[0] >>> 32) & 0xFF] ^ T4[(int)x[1] >>> 24] ^ T5[(int)x[2] >>> 16 & 0xFF] ^ T6[(int)x[3] >>> 8 & 0xFF] ^ T7[(int)x[8] & 0xFF];
            long tE = T0[(int)(x[14] >>> 56)] ^ T1[(int)(x[15] >>> 48) & 0xFF] ^ T2[(int)(x[0] >>> 40) & 0xFF] ^ T3[(int)(x[1] >>> 32) & 0xFF] ^ T4[(int)x[2] >>> 24] ^ T5[(int)x[3] >>> 16 & 0xFF] ^ T6[(int)x[4] >>> 8 & 0xFF] ^ T7[(int)x[9] & 0xFF];
            long tF = T0[(int)(x[15] >>> 56)] ^ T1[(int)(x[0] >>> 48) & 0xFF] ^ T2[(int)(x[1] >>> 40) & 0xFF] ^ T3[(int)(x[2] >>> 32) & 0xFF] ^ T4[(int)x[3] >>> 24] ^ T5[(int)x[4] >>> 16 & 0xFF] ^ T6[(int)x[5] >>> 8 & 0xFF] ^ T7[(int)x[10] & 0xFF];
            x[0] = t0;
            x[1] = t1;
            x[2] = t2;
            x[3] = t3;
            x[4] = t4;
            x[5] = t5;
            x[6] = t6;
            x[7] = t7;
            x[8] = t8;
            x[9] = t9;
            x[10] = tA;
            x[11] = tB;
            x[12] = tC;
            x[13] = tD;
            x[14] = tE;
            x[15] = tF;
        }
    }

    private void doPermQ(long[] x) {
        for (int r = 0; r < 14; ++r) {
            x[0] = x[0] ^ ((long)r ^ 0xFFFFFFFFFFFFFFFFL);
            x[1] = x[1] ^ ((long)r ^ 0xFFFFFFFFFFFFFFEFL);
            x[2] = x[2] ^ ((long)r ^ 0xFFFFFFFFFFFFFFDFL);
            x[3] = x[3] ^ ((long)r ^ 0xFFFFFFFFFFFFFFCFL);
            x[4] = x[4] ^ ((long)r ^ 0xFFFFFFFFFFFFFFBFL);
            x[5] = x[5] ^ ((long)r ^ 0xFFFFFFFFFFFFFFAFL);
            x[6] = x[6] ^ ((long)r ^ 0xFFFFFFFFFFFFFF9FL);
            x[7] = x[7] ^ ((long)r ^ 0xFFFFFFFFFFFFFF8FL);
            x[8] = x[8] ^ ((long)r ^ 0xFFFFFFFFFFFFFF7FL);
            x[9] = x[9] ^ ((long)r ^ 0xFFFFFFFFFFFFFF6FL);
            x[10] = x[10] ^ ((long)r ^ 0xFFFFFFFFFFFFFF5FL);
            x[11] = x[11] ^ ((long)r ^ 0xFFFFFFFFFFFFFF4FL);
            x[12] = x[12] ^ ((long)r ^ 0xFFFFFFFFFFFFFF3FL);
            x[13] = x[13] ^ ((long)r ^ 0xFFFFFFFFFFFFFF2FL);
            x[14] = x[14] ^ ((long)r ^ 0xFFFFFFFFFFFFFF1FL);
            x[15] = x[15] ^ ((long)r ^ 0xFFFFFFFFFFFFFF0FL);
            long t0 = T0[(int)(x[1] >>> 56)] ^ T1[(int)(x[3] >>> 48) & 0xFF] ^ T2[(int)(x[5] >>> 40) & 0xFF] ^ T3[(int)(x[11] >>> 32) & 0xFF] ^ T4[(int)x[0] >>> 24] ^ T5[(int)x[2] >>> 16 & 0xFF] ^ T6[(int)x[4] >>> 8 & 0xFF] ^ T7[(int)x[6] & 0xFF];
            long t1 = T0[(int)(x[2] >>> 56)] ^ T1[(int)(x[4] >>> 48) & 0xFF] ^ T2[(int)(x[6] >>> 40) & 0xFF] ^ T3[(int)(x[12] >>> 32) & 0xFF] ^ T4[(int)x[1] >>> 24] ^ T5[(int)x[3] >>> 16 & 0xFF] ^ T6[(int)x[5] >>> 8 & 0xFF] ^ T7[(int)x[7] & 0xFF];
            long t2 = T0[(int)(x[3] >>> 56)] ^ T1[(int)(x[5] >>> 48) & 0xFF] ^ T2[(int)(x[7] >>> 40) & 0xFF] ^ T3[(int)(x[13] >>> 32) & 0xFF] ^ T4[(int)x[2] >>> 24] ^ T5[(int)x[4] >>> 16 & 0xFF] ^ T6[(int)x[6] >>> 8 & 0xFF] ^ T7[(int)x[8] & 0xFF];
            long t3 = T0[(int)(x[4] >>> 56)] ^ T1[(int)(x[6] >>> 48) & 0xFF] ^ T2[(int)(x[8] >>> 40) & 0xFF] ^ T3[(int)(x[14] >>> 32) & 0xFF] ^ T4[(int)x[3] >>> 24] ^ T5[(int)x[5] >>> 16 & 0xFF] ^ T6[(int)x[7] >>> 8 & 0xFF] ^ T7[(int)x[9] & 0xFF];
            long t4 = T0[(int)(x[5] >>> 56)] ^ T1[(int)(x[7] >>> 48) & 0xFF] ^ T2[(int)(x[9] >>> 40) & 0xFF] ^ T3[(int)(x[15] >>> 32) & 0xFF] ^ T4[(int)x[4] >>> 24] ^ T5[(int)x[6] >>> 16 & 0xFF] ^ T6[(int)x[8] >>> 8 & 0xFF] ^ T7[(int)x[10] & 0xFF];
            long t5 = T0[(int)(x[6] >>> 56)] ^ T1[(int)(x[8] >>> 48) & 0xFF] ^ T2[(int)(x[10] >>> 40) & 0xFF] ^ T3[(int)(x[0] >>> 32) & 0xFF] ^ T4[(int)x[5] >>> 24] ^ T5[(int)x[7] >>> 16 & 0xFF] ^ T6[(int)x[9] >>> 8 & 0xFF] ^ T7[(int)x[11] & 0xFF];
            long t6 = T0[(int)(x[7] >>> 56)] ^ T1[(int)(x[9] >>> 48) & 0xFF] ^ T2[(int)(x[11] >>> 40) & 0xFF] ^ T3[(int)(x[1] >>> 32) & 0xFF] ^ T4[(int)x[6] >>> 24] ^ T5[(int)x[8] >>> 16 & 0xFF] ^ T6[(int)x[10] >>> 8 & 0xFF] ^ T7[(int)x[12] & 0xFF];
            long t7 = T0[(int)(x[8] >>> 56)] ^ T1[(int)(x[10] >>> 48) & 0xFF] ^ T2[(int)(x[12] >>> 40) & 0xFF] ^ T3[(int)(x[2] >>> 32) & 0xFF] ^ T4[(int)x[7] >>> 24] ^ T5[(int)x[9] >>> 16 & 0xFF] ^ T6[(int)x[11] >>> 8 & 0xFF] ^ T7[(int)x[13] & 0xFF];
            long t8 = T0[(int)(x[9] >>> 56)] ^ T1[(int)(x[11] >>> 48) & 0xFF] ^ T2[(int)(x[13] >>> 40) & 0xFF] ^ T3[(int)(x[3] >>> 32) & 0xFF] ^ T4[(int)x[8] >>> 24] ^ T5[(int)x[10] >>> 16 & 0xFF] ^ T6[(int)x[12] >>> 8 & 0xFF] ^ T7[(int)x[14] & 0xFF];
            long t9 = T0[(int)(x[10] >>> 56)] ^ T1[(int)(x[12] >>> 48) & 0xFF] ^ T2[(int)(x[14] >>> 40) & 0xFF] ^ T3[(int)(x[4] >>> 32) & 0xFF] ^ T4[(int)x[9] >>> 24] ^ T5[(int)x[11] >>> 16 & 0xFF] ^ T6[(int)x[13] >>> 8 & 0xFF] ^ T7[(int)x[15] & 0xFF];
            long tA = T0[(int)(x[11] >>> 56)] ^ T1[(int)(x[13] >>> 48) & 0xFF] ^ T2[(int)(x[15] >>> 40) & 0xFF] ^ T3[(int)(x[5] >>> 32) & 0xFF] ^ T4[(int)x[10] >>> 24] ^ T5[(int)x[12] >>> 16 & 0xFF] ^ T6[(int)x[14] >>> 8 & 0xFF] ^ T7[(int)x[0] & 0xFF];
            long tB = T0[(int)(x[12] >>> 56)] ^ T1[(int)(x[14] >>> 48) & 0xFF] ^ T2[(int)(x[0] >>> 40) & 0xFF] ^ T3[(int)(x[6] >>> 32) & 0xFF] ^ T4[(int)x[11] >>> 24] ^ T5[(int)x[13] >>> 16 & 0xFF] ^ T6[(int)x[15] >>> 8 & 0xFF] ^ T7[(int)x[1] & 0xFF];
            long tC = T0[(int)(x[13] >>> 56)] ^ T1[(int)(x[15] >>> 48) & 0xFF] ^ T2[(int)(x[1] >>> 40) & 0xFF] ^ T3[(int)(x[7] >>> 32) & 0xFF] ^ T4[(int)x[12] >>> 24] ^ T5[(int)x[14] >>> 16 & 0xFF] ^ T6[(int)x[0] >>> 8 & 0xFF] ^ T7[(int)x[2] & 0xFF];
            long tD = T0[(int)(x[14] >>> 56)] ^ T1[(int)(x[0] >>> 48) & 0xFF] ^ T2[(int)(x[2] >>> 40) & 0xFF] ^ T3[(int)(x[8] >>> 32) & 0xFF] ^ T4[(int)x[13] >>> 24] ^ T5[(int)x[15] >>> 16 & 0xFF] ^ T6[(int)x[1] >>> 8 & 0xFF] ^ T7[(int)x[3] & 0xFF];
            long tE = T0[(int)(x[15] >>> 56)] ^ T1[(int)(x[1] >>> 48) & 0xFF] ^ T2[(int)(x[3] >>> 40) & 0xFF] ^ T3[(int)(x[9] >>> 32) & 0xFF] ^ T4[(int)x[14] >>> 24] ^ T5[(int)x[0] >>> 16 & 0xFF] ^ T6[(int)x[2] >>> 8 & 0xFF] ^ T7[(int)x[4] & 0xFF];
            long tF = T0[(int)(x[0] >>> 56)] ^ T1[(int)(x[2] >>> 48) & 0xFF] ^ T2[(int)(x[4] >>> 40) & 0xFF] ^ T3[(int)(x[10] >>> 32) & 0xFF] ^ T4[(int)x[15] >>> 24] ^ T5[(int)x[1] >>> 16 & 0xFF] ^ T6[(int)x[3] >>> 8 & 0xFF] ^ T7[(int)x[5] & 0xFF];
            x[0] = t0;
            x[1] = t1;
            x[2] = t2;
            x[3] = t3;
            x[4] = t4;
            x[5] = t5;
            x[6] = t6;
            x[7] = t7;
            x[8] = t8;
            x[9] = t9;
            x[10] = tA;
            x[11] = tB;
            x[12] = tC;
            x[13] = tD;
            x[14] = tE;
            x[15] = tF;
        }
    }

    @Override
    protected void processBlock(byte[] data) {
        int i;
        for (i = 0; i < 16; ++i) {
            this.M[i] = GroestlBigCore.decodeBELong(data, i * 8);
            this.G[i] = this.M[i] ^ this.H[i];
        }
        this.doPermP(this.G);
        this.doPermQ(this.M);
        for (i = 0; i < 16; ++i) {
            int n = i;
            this.H[n] = this.H[n] ^ (this.G[i] ^ this.M[i]);
        }
    }

    @Override
    public String toString() {
        return "Groestl-" + (this.getDigestLength() << 3);
    }

    static {
        for (int i = 0; i < T0.length; ++i) {
            long v = T0[i];
            GroestlBigCore.T1[i] = GroestlBigCore.circularLeft(v, 56);
            GroestlBigCore.T2[i] = GroestlBigCore.circularLeft(v, 48);
            GroestlBigCore.T3[i] = GroestlBigCore.circularLeft(v, 40);
            GroestlBigCore.T4[i] = GroestlBigCore.circularLeft(v, 32);
            GroestlBigCore.T5[i] = GroestlBigCore.circularLeft(v, 24);
            GroestlBigCore.T6[i] = GroestlBigCore.circularLeft(v, 16);
            GroestlBigCore.T7[i] = GroestlBigCore.circularLeft(v, 8);
        }
    }
}

