/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class LuffaSmallCore
extends DigestEngine {
    private static final int[] IV = new int[]{1831149161, 1152405984, 1319792564, -604535707, 1848188945, -1877660172, -301629127, -554299205, -1011594347, -640486826, 1894705568, -569794653, 1570440535, -1882635085, -820195570, 1953289601, -135280483, 1572493185, 67202277, -1385849851, 50731343, 1718425654, 615129866, -1960424729};
    private static final int[] RC00 = new int[]{809079974, -1058647399, 1824733714, -598304706, 503320719, 2013282877, -1889830782, -1763583214};
    private static final int[] RC04 = new int[]{-533497832, 1142663437, 2134168642, -1819729537, -441926426, 1383381748, 646486951, -1709019491};
    private static final int[] RC10 = new int[]{-1226960659, 1895070382, 117941204, 471764817, 1887059269, -1364032158, -1161161335, 1084518206};
    private static final int[] RC14 = new int[]{23617341, 94469364, -1123431734, -198759640, 340452812, -89674197, 776532417, -1188837628};
    private static final int[] RC20 = new int[]{-64955950, 877997605, 2061009295, -2076674486, -1150427086, -306741048, -645631146, -1563982796};
    private static final int[] RC24 = new int[]{-497126719, -433865870, 1549313188, 507044583, 2028178333, 660104985, 921544063, 1882893543};
    private int V00;
    private int V01;
    private int V02;
    private int V03;
    private int V04;
    private int V05;
    private int V06;
    private int V07;
    private int V10;
    private int V11;
    private int V12;
    private int V13;
    private int V14;
    private int V15;
    private int V16;
    private int V17;
    private int V20;
    private int V21;
    private int V22;
    private int V23;
    private int V24;
    private int V25;
    private int V26;
    private int V27;
    private byte[] tmpBuf;

    LuffaSmallCore() {
    }

    @Override
    public int getInternalBlockLength() {
        return 32;
    }

    @Override
    public int getBlockLength() {
        return -32;
    }

    protected Digest copyState(LuffaSmallCore dst) {
        dst.V00 = this.V00;
        dst.V01 = this.V01;
        dst.V02 = this.V02;
        dst.V03 = this.V03;
        dst.V04 = this.V04;
        dst.V05 = this.V05;
        dst.V06 = this.V06;
        dst.V07 = this.V07;
        dst.V10 = this.V10;
        dst.V11 = this.V11;
        dst.V12 = this.V12;
        dst.V13 = this.V13;
        dst.V14 = this.V14;
        dst.V15 = this.V15;
        dst.V16 = this.V16;
        dst.V17 = this.V17;
        dst.V20 = this.V20;
        dst.V21 = this.V21;
        dst.V22 = this.V22;
        dst.V23 = this.V23;
        dst.V24 = this.V24;
        dst.V25 = this.V25;
        dst.V26 = this.V26;
        dst.V27 = this.V27;
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        this.V00 = IV[0];
        this.V01 = IV[1];
        this.V02 = IV[2];
        this.V03 = IV[3];
        this.V04 = IV[4];
        this.V05 = IV[5];
        this.V06 = IV[6];
        this.V07 = IV[7];
        this.V10 = IV[8];
        this.V11 = IV[9];
        this.V12 = IV[10];
        this.V13 = IV[11];
        this.V14 = IV[12];
        this.V15 = IV[13];
        this.V16 = IV[14];
        this.V17 = IV[15];
        this.V20 = IV[16];
        this.V21 = IV[17];
        this.V22 = IV[18];
        this.V23 = IV[19];
        this.V24 = IV[20];
        this.V25 = IV[21];
        this.V26 = IV[22];
        this.V27 = IV[23];
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int i;
        int ptr = this.flush();
        this.tmpBuf[ptr] = -128;
        for (i = ptr + 1; i < 32; ++i) {
            this.tmpBuf[i] = 0;
        }
        this.update(this.tmpBuf, ptr, 32 - ptr);
        for (i = 0; i < ptr + 1; ++i) {
            this.tmpBuf[i] = 0;
        }
        this.update(this.tmpBuf, 0, 32);
        LuffaSmallCore.encodeBEInt(this.V00 ^ this.V10 ^ this.V20, output, outputOffset + 0);
        LuffaSmallCore.encodeBEInt(this.V01 ^ this.V11 ^ this.V21, output, outputOffset + 4);
        LuffaSmallCore.encodeBEInt(this.V02 ^ this.V12 ^ this.V22, output, outputOffset + 8);
        LuffaSmallCore.encodeBEInt(this.V03 ^ this.V13 ^ this.V23, output, outputOffset + 12);
        LuffaSmallCore.encodeBEInt(this.V04 ^ this.V14 ^ this.V24, output, outputOffset + 16);
        LuffaSmallCore.encodeBEInt(this.V05 ^ this.V15 ^ this.V25, output, outputOffset + 20);
        LuffaSmallCore.encodeBEInt(this.V06 ^ this.V16 ^ this.V26, output, outputOffset + 24);
        if (this.getDigestLength() == 32) {
            LuffaSmallCore.encodeBEInt(this.V07 ^ this.V17 ^ this.V27, output, outputOffset + 28);
        }
    }

    @Override
    protected void doInit() {
        this.tmpBuf = new byte[32];
        this.engineReset();
    }

    private static final void encodeBEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 24);
        buf[off + 1] = (byte)(val >>> 16);
        buf[off + 2] = (byte)(val >>> 8);
        buf[off + 3] = (byte)val;
    }

    private static final int decodeBEInt(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    @Override
    protected void processBlock(byte[] data) {
        int r;
        int M0 = LuffaSmallCore.decodeBEInt(data, 0);
        int M1 = LuffaSmallCore.decodeBEInt(data, 4);
        int M2 = LuffaSmallCore.decodeBEInt(data, 8);
        int M3 = LuffaSmallCore.decodeBEInt(data, 12);
        int M4 = LuffaSmallCore.decodeBEInt(data, 16);
        int M5 = LuffaSmallCore.decodeBEInt(data, 20);
        int M6 = LuffaSmallCore.decodeBEInt(data, 24);
        int M7 = LuffaSmallCore.decodeBEInt(data, 28);
        int a0 = this.V00 ^ this.V10;
        int a1 = this.V01 ^ this.V11;
        int a2 = this.V02 ^ this.V12;
        int a3 = this.V03 ^ this.V13;
        int a4 = this.V04 ^ this.V14;
        int a5 = this.V05 ^ this.V15;
        int a6 = this.V06 ^ this.V16;
        int a7 = this.V07 ^ this.V17;
        a0 ^= this.V20;
        a1 ^= this.V21;
        a2 ^= this.V22;
        int tmp = a7 ^= this.V27;
        a7 = a6 ^= this.V26;
        a6 = a5 ^= this.V25;
        a5 = a4 ^= this.V24;
        a4 = (a3 ^= this.V23) ^ tmp;
        a3 = a2 ^ tmp;
        a2 = a1;
        a1 = a0 ^ tmp;
        a0 = tmp;
        this.V00 = a0 ^ this.V00;
        this.V01 = a1 ^ this.V01;
        this.V02 = a2 ^ this.V02;
        this.V03 = a3 ^ this.V03;
        this.V04 = a4 ^ this.V04;
        this.V05 = a5 ^ this.V05;
        this.V06 = a6 ^ this.V06;
        this.V07 = a7 ^ this.V07;
        this.V00 = M0 ^ this.V00;
        this.V01 = M1 ^ this.V01;
        this.V02 = M2 ^ this.V02;
        this.V03 = M3 ^ this.V03;
        this.V04 = M4 ^ this.V04;
        this.V05 = M5 ^ this.V05;
        this.V06 = M6 ^ this.V06;
        this.V07 = M7 ^ this.V07;
        tmp = M7;
        M7 = M6;
        M6 = M5;
        M5 = M4;
        M4 = M3 ^ tmp;
        M3 = M2 ^ tmp;
        M2 = M1;
        M1 = M0 ^ tmp;
        M0 = tmp;
        this.V10 = a0 ^ this.V10;
        this.V11 = a1 ^ this.V11;
        this.V12 = a2 ^ this.V12;
        this.V13 = a3 ^ this.V13;
        this.V14 = a4 ^ this.V14;
        this.V15 = a5 ^ this.V15;
        this.V16 = a6 ^ this.V16;
        this.V17 = a7 ^ this.V17;
        this.V10 = M0 ^ this.V10;
        this.V11 = M1 ^ this.V11;
        this.V12 = M2 ^ this.V12;
        this.V13 = M3 ^ this.V13;
        this.V14 = M4 ^ this.V14;
        this.V15 = M5 ^ this.V15;
        this.V16 = M6 ^ this.V16;
        this.V17 = M7 ^ this.V17;
        tmp = M7;
        M7 = M6;
        M6 = M5;
        M5 = M4;
        M4 = M3 ^ tmp;
        M3 = M2 ^ tmp;
        M2 = M1;
        M1 = M0 ^ tmp;
        M0 = tmp;
        this.V20 = a0 ^ this.V20;
        this.V21 = a1 ^ this.V21;
        this.V22 = a2 ^ this.V22;
        this.V23 = a3 ^ this.V23;
        this.V24 = a4 ^ this.V24;
        this.V25 = a5 ^ this.V25;
        this.V26 = a6 ^ this.V26;
        this.V27 = a7 ^ this.V27;
        this.V20 = M0 ^ this.V20;
        this.V21 = M1 ^ this.V21;
        this.V22 = M2 ^ this.V22;
        this.V23 = M3 ^ this.V23;
        this.V24 = M4 ^ this.V24;
        this.V25 = M5 ^ this.V25;
        this.V26 = M6 ^ this.V26;
        this.V27 = M7 ^ this.V27;
        this.V14 = this.V14 << 1 | this.V14 >>> 31;
        this.V15 = this.V15 << 1 | this.V15 >>> 31;
        this.V16 = this.V16 << 1 | this.V16 >>> 31;
        this.V17 = this.V17 << 1 | this.V17 >>> 31;
        this.V24 = this.V24 << 2 | this.V24 >>> 30;
        this.V25 = this.V25 << 2 | this.V25 >>> 30;
        this.V26 = this.V26 << 2 | this.V26 >>> 30;
        this.V27 = this.V27 << 2 | this.V27 >>> 30;
        for (r = 0; r < 8; ++r) {
            tmp = this.V00;
            this.V00 |= this.V01;
            this.V02 ^= this.V03;
            this.V01 ^= 0xFFFFFFFF;
            this.V00 ^= this.V03;
            this.V03 &= tmp;
            this.V01 ^= this.V03;
            this.V03 ^= this.V02;
            this.V02 &= this.V00;
            this.V00 ^= 0xFFFFFFFF;
            this.V02 ^= this.V01;
            this.V01 |= this.V03;
            this.V03 ^= this.V02;
            this.V02 &= this.V01;
            this.V01 ^= this.V00;
            this.V00 = tmp ^= this.V01;
            tmp = this.V05;
            this.V05 |= this.V06;
            this.V07 ^= this.V04;
            this.V06 ^= 0xFFFFFFFF;
            this.V05 ^= this.V04;
            this.V04 &= tmp;
            this.V06 ^= this.V04;
            this.V04 ^= this.V07;
            this.V07 &= this.V05;
            this.V05 ^= 0xFFFFFFFF;
            this.V07 ^= this.V06;
            this.V06 |= this.V04;
            this.V04 ^= this.V07;
            this.V07 &= this.V06;
            this.V06 ^= this.V05;
            this.V05 = tmp ^= this.V06;
            this.V04 ^= this.V00;
            this.V00 = (this.V00 << 2 | this.V00 >>> 30) ^ this.V04;
            this.V04 = (this.V04 << 14 | this.V04 >>> 18) ^ this.V00;
            this.V00 = (this.V00 << 10 | this.V00 >>> 22) ^ this.V04;
            this.V04 = this.V04 << 1 | this.V04 >>> 31;
            this.V05 ^= this.V01;
            this.V01 = (this.V01 << 2 | this.V01 >>> 30) ^ this.V05;
            this.V05 = (this.V05 << 14 | this.V05 >>> 18) ^ this.V01;
            this.V01 = (this.V01 << 10 | this.V01 >>> 22) ^ this.V05;
            this.V05 = this.V05 << 1 | this.V05 >>> 31;
            this.V06 ^= this.V02;
            this.V02 = (this.V02 << 2 | this.V02 >>> 30) ^ this.V06;
            this.V06 = (this.V06 << 14 | this.V06 >>> 18) ^ this.V02;
            this.V02 = (this.V02 << 10 | this.V02 >>> 22) ^ this.V06;
            this.V06 = this.V06 << 1 | this.V06 >>> 31;
            this.V07 ^= this.V03;
            this.V03 = (this.V03 << 2 | this.V03 >>> 30) ^ this.V07;
            this.V07 = (this.V07 << 14 | this.V07 >>> 18) ^ this.V03;
            this.V03 = (this.V03 << 10 | this.V03 >>> 22) ^ this.V07;
            this.V07 = this.V07 << 1 | this.V07 >>> 31;
            this.V00 ^= RC00[r];
            this.V04 ^= RC04[r];
        }
        for (r = 0; r < 8; ++r) {
            tmp = this.V10;
            this.V10 |= this.V11;
            this.V12 ^= this.V13;
            this.V11 ^= 0xFFFFFFFF;
            this.V10 ^= this.V13;
            this.V13 &= tmp;
            this.V11 ^= this.V13;
            this.V13 ^= this.V12;
            this.V12 &= this.V10;
            this.V10 ^= 0xFFFFFFFF;
            this.V12 ^= this.V11;
            this.V11 |= this.V13;
            this.V13 ^= this.V12;
            this.V12 &= this.V11;
            this.V11 ^= this.V10;
            this.V10 = tmp ^= this.V11;
            tmp = this.V15;
            this.V15 |= this.V16;
            this.V17 ^= this.V14;
            this.V16 ^= 0xFFFFFFFF;
            this.V15 ^= this.V14;
            this.V14 &= tmp;
            this.V16 ^= this.V14;
            this.V14 ^= this.V17;
            this.V17 &= this.V15;
            this.V15 ^= 0xFFFFFFFF;
            this.V17 ^= this.V16;
            this.V16 |= this.V14;
            this.V14 ^= this.V17;
            this.V17 &= this.V16;
            this.V16 ^= this.V15;
            this.V15 = tmp ^= this.V16;
            this.V14 ^= this.V10;
            this.V10 = (this.V10 << 2 | this.V10 >>> 30) ^ this.V14;
            this.V14 = (this.V14 << 14 | this.V14 >>> 18) ^ this.V10;
            this.V10 = (this.V10 << 10 | this.V10 >>> 22) ^ this.V14;
            this.V14 = this.V14 << 1 | this.V14 >>> 31;
            this.V15 ^= this.V11;
            this.V11 = (this.V11 << 2 | this.V11 >>> 30) ^ this.V15;
            this.V15 = (this.V15 << 14 | this.V15 >>> 18) ^ this.V11;
            this.V11 = (this.V11 << 10 | this.V11 >>> 22) ^ this.V15;
            this.V15 = this.V15 << 1 | this.V15 >>> 31;
            this.V16 ^= this.V12;
            this.V12 = (this.V12 << 2 | this.V12 >>> 30) ^ this.V16;
            this.V16 = (this.V16 << 14 | this.V16 >>> 18) ^ this.V12;
            this.V12 = (this.V12 << 10 | this.V12 >>> 22) ^ this.V16;
            this.V16 = this.V16 << 1 | this.V16 >>> 31;
            this.V17 ^= this.V13;
            this.V13 = (this.V13 << 2 | this.V13 >>> 30) ^ this.V17;
            this.V17 = (this.V17 << 14 | this.V17 >>> 18) ^ this.V13;
            this.V13 = (this.V13 << 10 | this.V13 >>> 22) ^ this.V17;
            this.V17 = this.V17 << 1 | this.V17 >>> 31;
            this.V10 ^= RC10[r];
            this.V14 ^= RC14[r];
        }
        for (r = 0; r < 8; ++r) {
            tmp = this.V20;
            this.V20 |= this.V21;
            this.V22 ^= this.V23;
            this.V21 ^= 0xFFFFFFFF;
            this.V20 ^= this.V23;
            this.V23 &= tmp;
            this.V21 ^= this.V23;
            this.V23 ^= this.V22;
            this.V22 &= this.V20;
            this.V20 ^= 0xFFFFFFFF;
            this.V22 ^= this.V21;
            this.V21 |= this.V23;
            this.V23 ^= this.V22;
            this.V22 &= this.V21;
            this.V21 ^= this.V20;
            this.V20 = tmp ^= this.V21;
            tmp = this.V25;
            this.V25 |= this.V26;
            this.V27 ^= this.V24;
            this.V26 ^= 0xFFFFFFFF;
            this.V25 ^= this.V24;
            this.V24 &= tmp;
            this.V26 ^= this.V24;
            this.V24 ^= this.V27;
            this.V27 &= this.V25;
            this.V25 ^= 0xFFFFFFFF;
            this.V27 ^= this.V26;
            this.V26 |= this.V24;
            this.V24 ^= this.V27;
            this.V27 &= this.V26;
            this.V26 ^= this.V25;
            this.V25 = tmp ^= this.V26;
            this.V24 ^= this.V20;
            this.V20 = (this.V20 << 2 | this.V20 >>> 30) ^ this.V24;
            this.V24 = (this.V24 << 14 | this.V24 >>> 18) ^ this.V20;
            this.V20 = (this.V20 << 10 | this.V20 >>> 22) ^ this.V24;
            this.V24 = this.V24 << 1 | this.V24 >>> 31;
            this.V25 ^= this.V21;
            this.V21 = (this.V21 << 2 | this.V21 >>> 30) ^ this.V25;
            this.V25 = (this.V25 << 14 | this.V25 >>> 18) ^ this.V21;
            this.V21 = (this.V21 << 10 | this.V21 >>> 22) ^ this.V25;
            this.V25 = this.V25 << 1 | this.V25 >>> 31;
            this.V26 ^= this.V22;
            this.V22 = (this.V22 << 2 | this.V22 >>> 30) ^ this.V26;
            this.V26 = (this.V26 << 14 | this.V26 >>> 18) ^ this.V22;
            this.V22 = (this.V22 << 10 | this.V22 >>> 22) ^ this.V26;
            this.V26 = this.V26 << 1 | this.V26 >>> 31;
            this.V27 ^= this.V23;
            this.V23 = (this.V23 << 2 | this.V23 >>> 30) ^ this.V27;
            this.V27 = (this.V27 << 14 | this.V27 >>> 18) ^ this.V23;
            this.V23 = (this.V23 << 10 | this.V23 >>> 22) ^ this.V27;
            this.V27 = this.V27 << 1 | this.V27 >>> 31;
            this.V20 ^= RC20[r];
            this.V24 ^= RC24[r];
        }
    }

    @Override
    public String toString() {
        return "Luffa-" + (this.getDigestLength() << 3);
    }
}

