/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.MDHelper;

public class SHA1
extends MDHelper {
    private int[] currentVal;

    public SHA1() {
        super(false, 8);
    }

    @Override
    public Digest copy() {
        SHA1 d = new SHA1();
        System.arraycopy(this.currentVal, 0, d.currentVal, 0, this.currentVal.length);
        return this.copyState(d);
    }

    @Override
    public int getDigestLength() {
        return 20;
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        this.currentVal[0] = 1732584193;
        this.currentVal[1] = -271733879;
        this.currentVal[2] = -1732584194;
        this.currentVal[3] = 271733878;
        this.currentVal[4] = -1009589776;
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        this.makeMDPadding();
        for (int i = 0; i < 5; ++i) {
            SHA1.encodeBEInt(this.currentVal[i], output, outputOffset + 4 * i);
        }
    }

    @Override
    protected void doInit() {
        this.currentVal = new int[5];
        this.engineReset();
    }

    private static final void encodeBEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 24);
        buf[off + 1] = (byte)(val >>> 16);
        buf[off + 2] = (byte)(val >>> 8);
        buf[off + 3] = (byte)val;
    }

    private static final int decodeBEInt(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    @Override
    protected void processBlock(byte[] data) {
        int A = this.currentVal[0];
        int B = this.currentVal[1];
        int C = this.currentVal[2];
        int D = this.currentVal[3];
        int E = this.currentVal[4];
        int W0 = SHA1.decodeBEInt(data, 0);
        E = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + W0 + 1518500249;
        B = B << 30 | B >>> 2;
        int W1 = SHA1.decodeBEInt(data, 4);
        D = (E << 5 | E >>> 27) + (A & B | ~A & C) + D + W1 + 1518500249;
        A = A << 30 | A >>> 2;
        int W2 = SHA1.decodeBEInt(data, 8);
        C = (D << 5 | D >>> 27) + (E & A | ~E & B) + C + W2 + 1518500249;
        E = E << 30 | E >>> 2;
        int W3 = SHA1.decodeBEInt(data, 12);
        B = (C << 5 | C >>> 27) + (D & E | ~D & A) + B + W3 + 1518500249;
        D = D << 30 | D >>> 2;
        int W4 = SHA1.decodeBEInt(data, 16);
        A = (B << 5 | B >>> 27) + (C & D | ~C & E) + A + W4 + 1518500249;
        C = C << 30 | C >>> 2;
        int W5 = SHA1.decodeBEInt(data, 20);
        E = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + W5 + 1518500249;
        B = B << 30 | B >>> 2;
        int W6 = SHA1.decodeBEInt(data, 24);
        D = (E << 5 | E >>> 27) + (A & B | ~A & C) + D + W6 + 1518500249;
        A = A << 30 | A >>> 2;
        int W7 = SHA1.decodeBEInt(data, 28);
        C = (D << 5 | D >>> 27) + (E & A | ~E & B) + C + W7 + 1518500249;
        E = E << 30 | E >>> 2;
        int W8 = SHA1.decodeBEInt(data, 32);
        B = (C << 5 | C >>> 27) + (D & E | ~D & A) + B + W8 + 1518500249;
        D = D << 30 | D >>> 2;
        int W9 = SHA1.decodeBEInt(data, 36);
        A = (B << 5 | B >>> 27) + (C & D | ~C & E) + A + W9 + 1518500249;
        C = C << 30 | C >>> 2;
        int Wa = SHA1.decodeBEInt(data, 40);
        E = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + Wa + 1518500249;
        B = B << 30 | B >>> 2;
        int Wb = SHA1.decodeBEInt(data, 44);
        D = (E << 5 | E >>> 27) + (A & B | ~A & C) + D + Wb + 1518500249;
        A = A << 30 | A >>> 2;
        int Wc = SHA1.decodeBEInt(data, 48);
        C = (D << 5 | D >>> 27) + (E & A | ~E & B) + C + Wc + 1518500249;
        E = E << 30 | E >>> 2;
        int Wd = SHA1.decodeBEInt(data, 52);
        B = (C << 5 | C >>> 27) + (D & E | ~D & A) + B + Wd + 1518500249;
        D = D << 30 | D >>> 2;
        int We = SHA1.decodeBEInt(data, 56);
        A = (B << 5 | B >>> 27) + (C & D | ~C & E) + A + We + 1518500249;
        C = C << 30 | C >>> 2;
        int Wf = SHA1.decodeBEInt(data, 60);
        E = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + Wf + 1518500249;
        B = B << 30 | B >>> 2;
        int U = Wd ^ W8 ^ W2 ^ W0;
        W0 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A & B | ~A & C) + D + W0 + 1518500249;
        A = A << 30 | A >>> 2;
        U = We ^ W9 ^ W3 ^ W1;
        W1 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E & A | ~E & B) + C + W1 + 1518500249;
        E = E << 30 | E >>> 2;
        U = Wf ^ Wa ^ W4 ^ W2;
        W2 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D & E | ~D & A) + B + W2 + 1518500249;
        D = D << 30 | D >>> 2;
        U = W0 ^ Wb ^ W5 ^ W3;
        W3 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C & D | ~C & E) + A + W3 + 1518500249;
        C = C << 30 | C >>> 2;
        U = W1 ^ Wc ^ W6 ^ W4;
        W4 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W4 + 1859775393;
        B = B << 30 | B >>> 2;
        U = W2 ^ Wd ^ W7 ^ W5;
        W5 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + W5 + 1859775393;
        A = A << 30 | A >>> 2;
        U = W3 ^ We ^ W8 ^ W6;
        W6 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + W6 + 1859775393;
        E = E << 30 | E >>> 2;
        U = W4 ^ Wf ^ W9 ^ W7;
        W7 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + W7 + 1859775393;
        D = D << 30 | D >>> 2;
        U = W5 ^ W0 ^ Wa ^ W8;
        W8 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + W8 + 1859775393;
        C = C << 30 | C >>> 2;
        U = W6 ^ W1 ^ Wb ^ W9;
        W9 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W9 + 1859775393;
        B = B << 30 | B >>> 2;
        U = W7 ^ W2 ^ Wc ^ Wa;
        Wa = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + Wa + 1859775393;
        A = A << 30 | A >>> 2;
        U = W8 ^ W3 ^ Wd ^ Wb;
        Wb = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + Wb + 1859775393;
        E = E << 30 | E >>> 2;
        U = W9 ^ W4 ^ We ^ Wc;
        Wc = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + Wc + 1859775393;
        D = D << 30 | D >>> 2;
        U = Wa ^ W5 ^ Wf ^ Wd;
        Wd = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + Wd + 1859775393;
        C = C << 30 | C >>> 2;
        U = Wb ^ W6 ^ W0 ^ We;
        We = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + We + 1859775393;
        B = B << 30 | B >>> 2;
        U = Wc ^ W7 ^ W1 ^ Wf;
        Wf = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + Wf + 1859775393;
        A = A << 30 | A >>> 2;
        U = Wd ^ W8 ^ W2 ^ W0;
        W0 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + W0 + 1859775393;
        E = E << 30 | E >>> 2;
        U = We ^ W9 ^ W3 ^ W1;
        W1 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + W1 + 1859775393;
        D = D << 30 | D >>> 2;
        U = Wf ^ Wa ^ W4 ^ W2;
        W2 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + W2 + 1859775393;
        C = C << 30 | C >>> 2;
        U = W0 ^ Wb ^ W5 ^ W3;
        W3 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W3 + 1859775393;
        B = B << 30 | B >>> 2;
        U = W1 ^ Wc ^ W6 ^ W4;
        W4 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + W4 + 1859775393;
        A = A << 30 | A >>> 2;
        U = W2 ^ Wd ^ W7 ^ W5;
        W5 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + W5 + 1859775393;
        E = E << 30 | E >>> 2;
        U = W3 ^ We ^ W8 ^ W6;
        W6 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + W6 + 1859775393;
        D = D << 30 | D >>> 2;
        U = W4 ^ Wf ^ W9 ^ W7;
        W7 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + W7 + 1859775393;
        C = C << 30 | C >>> 2;
        U = W5 ^ W0 ^ Wa ^ W8;
        W8 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + W8 + -1894007588;
        B = B << 30 | B >>> 2;
        U = W6 ^ W1 ^ Wb ^ W9;
        W9 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A & B | A & C | B & C) + D + W9 + -1894007588;
        A = A << 30 | A >>> 2;
        U = W7 ^ W2 ^ Wc ^ Wa;
        Wa = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E & A | E & B | A & B) + C + Wa + -1894007588;
        E = E << 30 | E >>> 2;
        U = W8 ^ W3 ^ Wd ^ Wb;
        Wb = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D & E | D & A | E & A) + B + Wb + -1894007588;
        D = D << 30 | D >>> 2;
        U = W9 ^ W4 ^ We ^ Wc;
        Wc = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C & D | C & E | D & E) + A + Wc + -1894007588;
        C = C << 30 | C >>> 2;
        U = Wa ^ W5 ^ Wf ^ Wd;
        Wd = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + Wd + -1894007588;
        B = B << 30 | B >>> 2;
        U = Wb ^ W6 ^ W0 ^ We;
        We = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A & B | A & C | B & C) + D + We + -1894007588;
        A = A << 30 | A >>> 2;
        U = Wc ^ W7 ^ W1 ^ Wf;
        Wf = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E & A | E & B | A & B) + C + Wf + -1894007588;
        E = E << 30 | E >>> 2;
        U = Wd ^ W8 ^ W2 ^ W0;
        W0 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D & E | D & A | E & A) + B + W0 + -1894007588;
        D = D << 30 | D >>> 2;
        U = We ^ W9 ^ W3 ^ W1;
        W1 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C & D | C & E | D & E) + A + W1 + -1894007588;
        C = C << 30 | C >>> 2;
        U = Wf ^ Wa ^ W4 ^ W2;
        W2 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + W2 + -1894007588;
        B = B << 30 | B >>> 2;
        U = W0 ^ Wb ^ W5 ^ W3;
        W3 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A & B | A & C | B & C) + D + W3 + -1894007588;
        A = A << 30 | A >>> 2;
        U = W1 ^ Wc ^ W6 ^ W4;
        W4 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E & A | E & B | A & B) + C + W4 + -1894007588;
        E = E << 30 | E >>> 2;
        U = W2 ^ Wd ^ W7 ^ W5;
        W5 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D & E | D & A | E & A) + B + W5 + -1894007588;
        D = D << 30 | D >>> 2;
        U = W3 ^ We ^ W8 ^ W6;
        W6 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C & D | C & E | D & E) + A + W6 + -1894007588;
        C = C << 30 | C >>> 2;
        U = W4 ^ Wf ^ W9 ^ W7;
        W7 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + W7 + -1894007588;
        B = B << 30 | B >>> 2;
        U = W5 ^ W0 ^ Wa ^ W8;
        W8 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A & B | A & C | B & C) + D + W8 + -1894007588;
        A = A << 30 | A >>> 2;
        U = W6 ^ W1 ^ Wb ^ W9;
        W9 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E & A | E & B | A & B) + C + W9 + -1894007588;
        E = E << 30 | E >>> 2;
        U = W7 ^ W2 ^ Wc ^ Wa;
        Wa = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D & E | D & A | E & A) + B + Wa + -1894007588;
        D = D << 30 | D >>> 2;
        U = W8 ^ W3 ^ Wd ^ Wb;
        Wb = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C & D | C & E | D & E) + A + Wb + -1894007588;
        C = C << 30 | C >>> 2;
        U = W9 ^ W4 ^ We ^ Wc;
        Wc = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + Wc + -899497514;
        B = B << 30 | B >>> 2;
        U = Wa ^ W5 ^ Wf ^ Wd;
        Wd = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + Wd + -899497514;
        A = A << 30 | A >>> 2;
        U = Wb ^ W6 ^ W0 ^ We;
        We = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + We + -899497514;
        E = E << 30 | E >>> 2;
        U = Wc ^ W7 ^ W1 ^ Wf;
        Wf = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + Wf + -899497514;
        D = D << 30 | D >>> 2;
        U = Wd ^ W8 ^ W2 ^ W0;
        W0 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + W0 + -899497514;
        C = C << 30 | C >>> 2;
        U = We ^ W9 ^ W3 ^ W1;
        W1 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W1 + -899497514;
        B = B << 30 | B >>> 2;
        U = Wf ^ Wa ^ W4 ^ W2;
        W2 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + W2 + -899497514;
        A = A << 30 | A >>> 2;
        U = W0 ^ Wb ^ W5 ^ W3;
        W3 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + W3 + -899497514;
        E = E << 30 | E >>> 2;
        U = W1 ^ Wc ^ W6 ^ W4;
        W4 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + W4 + -899497514;
        D = D << 30 | D >>> 2;
        U = W2 ^ Wd ^ W7 ^ W5;
        W5 = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + W5 + -899497514;
        C = C << 30 | C >>> 2;
        U = W3 ^ We ^ W8 ^ W6;
        W6 = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W6 + -899497514;
        B = B << 30 | B >>> 2;
        U = W4 ^ Wf ^ W9 ^ W7;
        W7 = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + W7 + -899497514;
        A = A << 30 | A >>> 2;
        U = W5 ^ W0 ^ Wa ^ W8;
        W8 = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + W8 + -899497514;
        E = E << 30 | E >>> 2;
        U = W6 ^ W1 ^ Wb ^ W9;
        W9 = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + W9 + -899497514;
        D = D << 30 | D >>> 2;
        U = W7 ^ W2 ^ Wc ^ Wa;
        Wa = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + Wa + -899497514;
        C = C << 30 | C >>> 2;
        U = W8 ^ W3 ^ Wd ^ Wb;
        Wb = U << 1 | U >>> 31;
        E = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + Wb + -899497514;
        B = B << 30 | B >>> 2;
        U = W9 ^ W4 ^ We ^ Wc;
        Wc = U << 1 | U >>> 31;
        D = (E << 5 | E >>> 27) + (A ^ B ^ C) + D + Wc + -899497514;
        A = A << 30 | A >>> 2;
        U = Wa ^ W5 ^ Wf ^ Wd;
        Wd = U << 1 | U >>> 31;
        C = (D << 5 | D >>> 27) + (E ^ A ^ B) + C + Wd + -899497514;
        E = E << 30 | E >>> 2;
        U = Wb ^ W6 ^ W0 ^ We;
        We = U << 1 | U >>> 31;
        B = (C << 5 | C >>> 27) + (D ^ E ^ A) + B + We + -899497514;
        D = D << 30 | D >>> 2;
        U = Wc ^ W7 ^ W1 ^ Wf;
        Wf = U << 1 | U >>> 31;
        A = (B << 5 | B >>> 27) + (C ^ D ^ E) + A + Wf + -899497514;
        C = C << 30 | C >>> 2;
        this.currentVal[0] = this.currentVal[0] + A;
        this.currentVal[1] = this.currentVal[1] + B;
        this.currentVal[2] = this.currentVal[2] + C;
        this.currentVal[3] = this.currentVal[3] + D;
        this.currentVal[4] = this.currentVal[4] + E;
    }

    @Override
    public String toString() {
        return "SHA-1";
    }
}

