/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class SIMDSmallCore
extends DigestEngine {
    private int[] state;
    private int[] q;
    private int[] w;
    private int[] tmpState;
    private int[] tA;
    private static final int[] alphaTab = new int[]{1, 41, 139, 45, 46, 87, 226, 14, 60, 147, 116, 130, 190, 80, 196, 69, 2, 82, 21, 90, 92, 174, 195, 28, 120, 37, 232, 3, 123, 160, 135, 138, 4, 164, 42, 180, 184, 91, 133, 56, 240, 74, 207, 6, 246, 63, 13, 19, 8, 71, 84, 103, 111, 182, 9, 112, 223, 148, 157, 12, 235, 126, 26, 38, 16, 142, 168, 206, 222, 107, 18, 224, 189, 39, 57, 24, 213, 252, 52, 76, 32, 27, 79, 155, 187, 214, 36, 191, 121, 78, 114, 48, 169, 247, 104, 152, 64, 54, 158, 53, 117, 171, 72, 125, 242, 156, 228, 96, 81, 237, 208, 47, 128, 108, 59, 106, 234, 85, 144, 250, 227, 55, 199, 192, 162, 217, 159, 94, 256, 216, 118, 212, 211, 170, 31, 243, 197, 110, 141, 127, 67, 177, 61, 188, 255, 175, 236, 167, 165, 83, 62, 229, 137, 220, 25, 254, 134, 97, 122, 119, 253, 93, 215, 77, 73, 166, 124, 201, 17, 183, 50, 251, 11, 194, 244, 238, 249, 186, 173, 154, 146, 75, 248, 145, 34, 109, 100, 245, 22, 131, 231, 219, 241, 115, 89, 51, 35, 150, 239, 33, 68, 218, 200, 233, 44, 5, 205, 181, 225, 230, 178, 102, 70, 43, 221, 66, 136, 179, 143, 209, 88, 10, 153, 105, 193, 203, 99, 204, 140, 86, 185, 132, 15, 101, 29, 161, 176, 20, 49, 210, 129, 149, 198, 151, 23, 172, 113, 7, 30, 202, 58, 65, 95, 40, 98, 163};
    private static final int[] yoffN = new int[]{1, 98, 95, 58, 30, 113, 23, 198, 129, 49, 176, 29, 15, 185, 140, 99, 193, 153, 88, 143, 136, 221, 70, 178, 225, 205, 44, 200, 68, 239, 35, 89, 241, 231, 22, 100, 34, 248, 146, 173, 249, 244, 11, 50, 17, 124, 73, 215, 253, 122, 134, 25, 137, 62, 165, 236, 255, 61, 67, 141, 197, 31, 211, 118, 256, 159, 162, 199, 227, 144, 234, 59, 128, 208, 81, 228, 242, 72, 117, 158, 64, 104, 169, 114, 121, 36, 187, 79, 32, 52, 213, 57, 189, 18, 222, 168, 16, 26, 235, 157, 223, 9, 111, 84, 8, 13, 246, 207, 240, 133, 184, 42, 4, 135, 123, 232, 120, 195, 92, 21, 2, 196, 190, 116, 60, 226, 46, 139};
    private static final int[] yoffF = new int[]{2, 156, 118, 107, 45, 212, 111, 162, 97, 249, 211, 3, 49, 101, 151, 223, 189, 178, 253, 204, 76, 82, 232, 65, 96, 176, 161, 47, 189, 61, 248, 107, 0, 131, 133, 113, 17, 33, 12, 111, 251, 103, 57, 148, 47, 65, 249, 143, 189, 8, 204, 230, 205, 151, 187, 227, 247, 111, 140, 6, 77, 10, 21, 149, 255, 101, 139, 150, 212, 45, 146, 95, 160, 8, 46, 254, 208, 156, 106, 34, 68, 79, 4, 53, 181, 175, 25, 192, 161, 81, 96, 210, 68, 196, 9, 150, 0, 126, 124, 144, 240, 224, 245, 146, 6, 154, 200, 109, 210, 192, 8, 114, 68, 249, 53, 27, 52, 106, 70, 30, 10, 146, 117, 251, 180, 247, 236, 108};
    private static final int[] pp4k = new int[]{1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2};
    private static final int[] wsp = new int[]{32, 48, 0, 16, 56, 40, 24, 8, 120, 88, 96, 64, 72, 104, 80, 112, 136, 144, 184, 160, 176, 168, 128, 152, 240, 192, 200, 248, 216, 232, 224, 208};

    SIMDSmallCore() {
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    protected Digest copyState(SIMDSmallCore dst) {
        System.arraycopy(this.state, 0, dst.state, 0, 16);
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        int[] iv = this.getInitVal();
        System.arraycopy(iv, 0, this.state, 0, 16);
    }

    abstract int[] getInitVal();

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int ptr = this.flush();
        byte[] buf = this.getBlockBuffer();
        if (ptr != 0) {
            for (int i = ptr; i < 64; ++i) {
                buf[i] = 0;
            }
            this.compress(buf, false);
        }
        long count = (this.getBlockCount() << 9) + (long)(ptr << 3);
        SIMDSmallCore.encodeLEInt((int)count, buf, 0);
        SIMDSmallCore.encodeLEInt((int)(count >> 32), buf, 4);
        for (int i = 8; i < 64; ++i) {
            buf[i] = 0;
        }
        this.compress(buf, true);
        int n = this.getDigestLength() >>> 2;
        for (int i = 0; i < n; ++i) {
            SIMDSmallCore.encodeLEInt(this.state[i], output, outputOffset + (i << 2));
        }
    }

    @Override
    protected void doInit() {
        this.state = new int[16];
        this.q = new int[128];
        this.w = new int[32];
        this.tmpState = new int[16];
        this.tA = new int[4];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return (buf[off + 3] & 0xFF) << 24 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 1] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    private static int circularLeft(int x, int n) {
        return x >>> 32 - n | x << n;
    }

    @Override
    protected void processBlock(byte[] data) {
        this.compress(data, false);
    }

    private final void fft32(byte[] x, int xb, int xs, int qoff) {
        int xd = xs << 1;
        int x0 = x[xb] & 0xFF;
        int x1 = x[xb + 2 * xd] & 0xFF;
        int x2 = x[xb + 4 * xd] & 0xFF;
        int x3 = x[xb + 6 * xd] & 0xFF;
        int a0 = x0 + x2;
        int a1 = x0 + (x2 << 4);
        int a2 = x0 - x2;
        int a3 = x0 - (x2 << 4);
        int b0 = x1 + x3;
        int b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        int b2 = (x1 << 4) - (x3 << 4);
        int b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        int d1_0 = a0 + b0;
        int d1_1 = a1 + b1;
        int d1_2 = a2 + b2;
        int d1_3 = a3 + b3;
        int d1_4 = a0 - b0;
        int d1_5 = a1 - b1;
        int d1_6 = a2 - b2;
        int d1_7 = a3 - b3;
        x0 = x[xb + xd] & 0xFF;
        x1 = x[xb + 3 * xd] & 0xFF;
        x2 = x[xb + 5 * xd] & 0xFF;
        x3 = x[xb + 7 * xd] & 0xFF;
        a0 = x0 + x2;
        a1 = x0 + (x2 << 4);
        a2 = x0 - x2;
        a3 = x0 - (x2 << 4);
        b0 = x1 + x3;
        b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        b2 = (x1 << 4) - (x3 << 4);
        b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        int d2_0 = a0 + b0;
        int d2_1 = a1 + b1;
        int d2_2 = a2 + b2;
        int d2_3 = a3 + b3;
        int d2_4 = a0 - b0;
        int d2_5 = a1 - b1;
        int d2_6 = a2 - b2;
        int d2_7 = a3 - b3;
        this.q[qoff + 0] = d1_0 + d2_0;
        this.q[qoff + 1] = d1_1 + (d2_1 << 1);
        this.q[qoff + 2] = d1_2 + (d2_2 << 2);
        this.q[qoff + 3] = d1_3 + (d2_3 << 3);
        this.q[qoff + 4] = d1_4 + (d2_4 << 4);
        this.q[qoff + 5] = d1_5 + (d2_5 << 5);
        this.q[qoff + 6] = d1_6 + (d2_6 << 6);
        this.q[qoff + 7] = d1_7 + (d2_7 << 7);
        this.q[qoff + 8] = d1_0 - d2_0;
        this.q[qoff + 9] = d1_1 - (d2_1 << 1);
        this.q[qoff + 10] = d1_2 - (d2_2 << 2);
        this.q[qoff + 11] = d1_3 - (d2_3 << 3);
        this.q[qoff + 12] = d1_4 - (d2_4 << 4);
        this.q[qoff + 13] = d1_5 - (d2_5 << 5);
        this.q[qoff + 14] = d1_6 - (d2_6 << 6);
        this.q[qoff + 15] = d1_7 - (d2_7 << 7);
        x0 = x[xb + xs] & 0xFF;
        x1 = x[xb + xs + 2 * xd] & 0xFF;
        x2 = x[xb + xs + 4 * xd] & 0xFF;
        x3 = x[xb + xs + 6 * xd] & 0xFF;
        a0 = x0 + x2;
        a1 = x0 + (x2 << 4);
        a2 = x0 - x2;
        a3 = x0 - (x2 << 4);
        b0 = x1 + x3;
        b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        b2 = (x1 << 4) - (x3 << 4);
        b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        d1_0 = a0 + b0;
        d1_1 = a1 + b1;
        d1_2 = a2 + b2;
        d1_3 = a3 + b3;
        d1_4 = a0 - b0;
        d1_5 = a1 - b1;
        d1_6 = a2 - b2;
        d1_7 = a3 - b3;
        x0 = x[xb + xs + xd] & 0xFF;
        x1 = x[xb + xs + 3 * xd] & 0xFF;
        x2 = x[xb + xs + 5 * xd] & 0xFF;
        x3 = x[xb + xs + 7 * xd] & 0xFF;
        a0 = x0 + x2;
        a1 = x0 + (x2 << 4);
        a2 = x0 - x2;
        a3 = x0 - (x2 << 4);
        b0 = x1 + x3;
        b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        b2 = (x1 << 4) - (x3 << 4);
        b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        d2_0 = a0 + b0;
        d2_1 = a1 + b1;
        d2_2 = a2 + b2;
        d2_3 = a3 + b3;
        d2_4 = a0 - b0;
        d2_5 = a1 - b1;
        d2_6 = a2 - b2;
        d2_7 = a3 - b3;
        this.q[qoff + 16 + 0] = d1_0 + d2_0;
        this.q[qoff + 16 + 1] = d1_1 + (d2_1 << 1);
        this.q[qoff + 16 + 2] = d1_2 + (d2_2 << 2);
        this.q[qoff + 16 + 3] = d1_3 + (d2_3 << 3);
        this.q[qoff + 16 + 4] = d1_4 + (d2_4 << 4);
        this.q[qoff + 16 + 5] = d1_5 + (d2_5 << 5);
        this.q[qoff + 16 + 6] = d1_6 + (d2_6 << 6);
        this.q[qoff + 16 + 7] = d1_7 + (d2_7 << 7);
        this.q[qoff + 16 + 8] = d1_0 - d2_0;
        this.q[qoff + 16 + 9] = d1_1 - (d2_1 << 1);
        this.q[qoff + 16 + 10] = d1_2 - (d2_2 << 2);
        this.q[qoff + 16 + 11] = d1_3 - (d2_3 << 3);
        this.q[qoff + 16 + 12] = d1_4 - (d2_4 << 4);
        this.q[qoff + 16 + 13] = d1_5 - (d2_5 << 5);
        this.q[qoff + 16 + 14] = d1_6 - (d2_6 << 6);
        this.q[qoff + 16 + 15] = d1_7 - (d2_7 << 7);
        int m = this.q[qoff];
        int n = this.q[qoff + 16];
        this.q[qoff] = m + n;
        this.q[qoff + 16] = m - n;
        int u = 0;
        int v = 0;
        while (u < 16) {
            int t;
            if (u != 0) {
                m = this.q[qoff + u + 0];
                n = this.q[qoff + u + 0 + 16];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[qoff + u + 0] = m + t;
                this.q[qoff + u + 0 + 16] = m - t;
            }
            m = this.q[qoff + u + 1];
            n = this.q[qoff + u + 1 + 16];
            t = (n * alphaTab[v + 8] & 0xFFFF) + (n * alphaTab[v + 8] >> 16);
            this.q[qoff + u + 1] = m + t;
            this.q[qoff + u + 1 + 16] = m - t;
            m = this.q[qoff + u + 2];
            n = this.q[qoff + u + 2 + 16];
            t = (n * alphaTab[v + 16] & 0xFFFF) + (n * alphaTab[v + 16] >> 16);
            this.q[qoff + u + 2] = m + t;
            this.q[qoff + u + 2 + 16] = m - t;
            m = this.q[qoff + u + 3];
            n = this.q[qoff + u + 3 + 16];
            t = (n * alphaTab[v + 24] & 0xFFFF) + (n * alphaTab[v + 24] >> 16);
            this.q[qoff + u + 3] = m + t;
            this.q[qoff + u + 3 + 16] = m - t;
            u += 4;
            v += 32;
        }
    }

    private final void oneRound(int isp, int p0, int p1, int p2, int p3) {
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p0);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p0);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p0);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p0);
        int tmp = this.state[12] + this.w[0] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 0] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[1] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 0] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[2] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 0] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[3] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 0] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p1);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p1);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p1);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p1);
        tmp = this.state[12] + this.w[4] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 1] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[5] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 1] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[6] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 1] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[7] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 1] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p2);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p2);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p2);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p2);
        tmp = this.state[12] + this.w[8] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 2] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[9] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 2] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[10] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 2] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[11] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 2] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p3);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p3);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p3);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p3);
        tmp = this.state[12] + this.w[12] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 3] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[13] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 3] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[14] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 3] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[15] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 3] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p0);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p0);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p0);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p0);
        tmp = this.state[12] + this.w[16] + (this.state[0] & this.state[4] | (this.state[0] | this.state[4]) & this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 4] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[17] + (this.state[1] & this.state[5] | (this.state[1] | this.state[5]) & this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 4] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[18] + (this.state[2] & this.state[6] | (this.state[2] | this.state[6]) & this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 4] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[19] + (this.state[3] & this.state[7] | (this.state[3] | this.state[7]) & this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p1) + this.tA[pp4k[isp + 4] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p1);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p1);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p1);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p1);
        tmp = this.state[12] + this.w[20] + (this.state[0] & this.state[4] | (this.state[0] | this.state[4]) & this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 5] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[21] + (this.state[1] & this.state[5] | (this.state[1] | this.state[5]) & this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 5] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[22] + (this.state[2] & this.state[6] | (this.state[2] | this.state[6]) & this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 5] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[23] + (this.state[3] & this.state[7] | (this.state[3] | this.state[7]) & this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p2) + this.tA[pp4k[isp + 5] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p2);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p2);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p2);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p2);
        tmp = this.state[12] + this.w[24] + (this.state[0] & this.state[4] | (this.state[0] | this.state[4]) & this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 6] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[25] + (this.state[1] & this.state[5] | (this.state[1] | this.state[5]) & this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 6] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[26] + (this.state[2] & this.state[6] | (this.state[2] | this.state[6]) & this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 6] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[27] + (this.state[3] & this.state[7] | (this.state[3] | this.state[7]) & this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p3) + this.tA[pp4k[isp + 6] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
        this.tA[0] = SIMDSmallCore.circularLeft(this.state[0], p3);
        this.tA[1] = SIMDSmallCore.circularLeft(this.state[1], p3);
        this.tA[2] = SIMDSmallCore.circularLeft(this.state[2], p3);
        this.tA[3] = SIMDSmallCore.circularLeft(this.state[3], p3);
        tmp = this.state[12] + this.w[28] + (this.state[0] & this.state[4] | (this.state[0] | this.state[4]) & this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 7] ^ 0];
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = this.tA[0];
        tmp = this.state[13] + this.w[29] + (this.state[1] & this.state[5] | (this.state[1] | this.state[5]) & this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 7] ^ 1];
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = this.tA[1];
        tmp = this.state[14] + this.w[30] + (this.state[2] & this.state[6] | (this.state[2] | this.state[6]) & this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 7] ^ 2];
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = this.tA[2];
        tmp = this.state[15] + this.w[31] + (this.state[3] & this.state[7] | (this.state[3] | this.state[7]) & this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, p0) + this.tA[pp4k[isp + 7] ^ 3];
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = this.tA[3];
    }

    private final void compress(byte[] x, boolean last) {
        int tq;
        int i;
        int t;
        this.fft32(x, 0, 4, 0);
        this.fft32(x, 2, 4, 32);
        int m = this.q[0];
        int n = this.q[32];
        this.q[0] = m + n;
        this.q[32] = m - n;
        int u = 0;
        int v = 0;
        while (u < 32) {
            if (u != 0) {
                m = this.q[0 + u + 0];
                n = this.q[0 + u + 0 + 32];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[0 + u + 0] = m + t;
                this.q[0 + u + 0 + 32] = m - t;
            }
            m = this.q[0 + u + 1];
            n = this.q[0 + u + 1 + 32];
            t = (n * alphaTab[v + 4] & 0xFFFF) + (n * alphaTab[v + 4] >> 16);
            this.q[0 + u + 1] = m + t;
            this.q[0 + u + 1 + 32] = m - t;
            m = this.q[0 + u + 2];
            n = this.q[0 + u + 2 + 32];
            t = (n * alphaTab[v + 8] & 0xFFFF) + (n * alphaTab[v + 8] >> 16);
            this.q[0 + u + 2] = m + t;
            this.q[0 + u + 2 + 32] = m - t;
            m = this.q[0 + u + 3];
            n = this.q[0 + u + 3 + 32];
            t = (n * alphaTab[v + 12] & 0xFFFF) + (n * alphaTab[v + 12] >> 16);
            this.q[0 + u + 3] = m + t;
            this.q[0 + u + 3 + 32] = m - t;
            u += 4;
            v += 16;
        }
        this.fft32(x, 1, 4, 64);
        this.fft32(x, 3, 4, 96);
        m = this.q[64];
        n = this.q[96];
        this.q[64] = m + n;
        this.q[96] = m - n;
        u = 0;
        v = 0;
        while (u < 32) {
            if (u != 0) {
                m = this.q[64 + u + 0];
                n = this.q[64 + u + 0 + 32];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[64 + u + 0] = m + t;
                this.q[64 + u + 0 + 32] = m - t;
            }
            m = this.q[64 + u + 1];
            n = this.q[64 + u + 1 + 32];
            t = (n * alphaTab[v + 4] & 0xFFFF) + (n * alphaTab[v + 4] >> 16);
            this.q[64 + u + 1] = m + t;
            this.q[64 + u + 1 + 32] = m - t;
            m = this.q[64 + u + 2];
            n = this.q[64 + u + 2 + 32];
            t = (n * alphaTab[v + 8] & 0xFFFF) + (n * alphaTab[v + 8] >> 16);
            this.q[64 + u + 2] = m + t;
            this.q[64 + u + 2 + 32] = m - t;
            m = this.q[64 + u + 3];
            n = this.q[64 + u + 3 + 32];
            t = (n * alphaTab[v + 12] & 0xFFFF) + (n * alphaTab[v + 12] >> 16);
            this.q[64 + u + 3] = m + t;
            this.q[64 + u + 3 + 32] = m - t;
            u += 4;
            v += 16;
        }
        m = this.q[0];
        n = this.q[64];
        this.q[0] = m + n;
        this.q[64] = m - n;
        u = 0;
        v = 0;
        while (u < 64) {
            if (u != 0) {
                m = this.q[0 + u + 0];
                n = this.q[0 + u + 0 + 64];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[0 + u + 0] = m + t;
                this.q[0 + u + 0 + 64] = m - t;
            }
            m = this.q[0 + u + 1];
            n = this.q[0 + u + 1 + 64];
            t = (n * alphaTab[v + 2] & 0xFFFF) + (n * alphaTab[v + 2] >> 16);
            this.q[0 + u + 1] = m + t;
            this.q[0 + u + 1 + 64] = m - t;
            m = this.q[0 + u + 2];
            n = this.q[0 + u + 2 + 64];
            t = (n * alphaTab[v + 4] & 0xFFFF) + (n * alphaTab[v + 4] >> 16);
            this.q[0 + u + 2] = m + t;
            this.q[0 + u + 2 + 64] = m - t;
            m = this.q[0 + u + 3];
            n = this.q[0 + u + 3 + 64];
            t = (n * alphaTab[v + 6] & 0xFFFF) + (n * alphaTab[v + 6] >> 16);
            this.q[0 + u + 3] = m + t;
            this.q[0 + u + 3 + 64] = m - t;
            u += 4;
            v += 8;
        }
        if (last) {
            for (i = 0; i < 128; ++i) {
                tq = this.q[i] + yoffF[i];
                tq = (tq & 0xFFFF) + (tq >> 16);
                tq = (tq & 0xFF) - (tq >> 8);
                this.q[i] = (tq = (tq & 0xFF) - (tq >> 8)) <= 128 ? tq : tq - 257;
            }
        } else {
            for (i = 0; i < 128; ++i) {
                tq = this.q[i] + yoffN[i];
                tq = (tq & 0xFFFF) + (tq >> 16);
                tq = (tq & 0xFF) - (tq >> 8);
                this.q[i] = (tq = (tq & 0xFF) - (tq >> 8)) <= 128 ? tq : tq - 257;
            }
        }
        System.arraycopy(this.state, 0, this.tmpState, 0, 16);
        for (i = 0; i < 16; i += 4) {
            int n2 = i + 0;
            this.state[n2] = this.state[n2] ^ SIMDSmallCore.decodeLEInt(x, 4 * (i + 0));
            int n3 = i + 1;
            this.state[n3] = this.state[n3] ^ SIMDSmallCore.decodeLEInt(x, 4 * (i + 1));
            int n4 = i + 2;
            this.state[n4] = this.state[n4] ^ SIMDSmallCore.decodeLEInt(x, 4 * (i + 2));
            int n5 = i + 3;
            this.state[n5] = this.state[n5] ^ SIMDSmallCore.decodeLEInt(x, 4 * (i + 3));
        }
        for (u = 0; u < 32; u += 4) {
            v = wsp[(u >> 2) + 0];
            this.w[u + 0] = (this.q[v + 0 + 0] * 185 & 0xFFFF) + (this.q[v + 0 + 1] * 185 << 16);
            this.w[u + 1] = (this.q[v + 2 + 0] * 185 & 0xFFFF) + (this.q[v + 2 + 1] * 185 << 16);
            this.w[u + 2] = (this.q[v + 4 + 0] * 185 & 0xFFFF) + (this.q[v + 4 + 1] * 185 << 16);
            this.w[u + 3] = (this.q[v + 6 + 0] * 185 & 0xFFFF) + (this.q[v + 6 + 1] * 185 << 16);
        }
        this.oneRound(0, 3, 23, 17, 27);
        for (u = 0; u < 32; u += 4) {
            v = wsp[(u >> 2) + 8];
            this.w[u + 0] = (this.q[v + 0 + 0] * 185 & 0xFFFF) + (this.q[v + 0 + 1] * 185 << 16);
            this.w[u + 1] = (this.q[v + 2 + 0] * 185 & 0xFFFF) + (this.q[v + 2 + 1] * 185 << 16);
            this.w[u + 2] = (this.q[v + 4 + 0] * 185 & 0xFFFF) + (this.q[v + 4 + 1] * 185 << 16);
            this.w[u + 3] = (this.q[v + 6 + 0] * 185 & 0xFFFF) + (this.q[v + 6 + 1] * 185 << 16);
        }
        this.oneRound(2, 28, 19, 22, 7);
        for (u = 0; u < 32; u += 4) {
            v = wsp[(u >> 2) + 16];
            this.w[u + 0] = (this.q[v + 0 + -128] * 233 & 0xFFFF) + (this.q[v + 0 + -64] * 233 << 16);
            this.w[u + 1] = (this.q[v + 2 + -128] * 233 & 0xFFFF) + (this.q[v + 2 + -64] * 233 << 16);
            this.w[u + 2] = (this.q[v + 4 + -128] * 233 & 0xFFFF) + (this.q[v + 4 + -64] * 233 << 16);
            this.w[u + 3] = (this.q[v + 6 + -128] * 233 & 0xFFFF) + (this.q[v + 6 + -64] * 233 << 16);
        }
        this.oneRound(1, 29, 9, 15, 5);
        for (u = 0; u < 32; u += 4) {
            v = wsp[(u >> 2) + 24];
            this.w[u + 0] = (this.q[v + 0 + -191] * 233 & 0xFFFF) + (this.q[v + 0 + -127] * 233 << 16);
            this.w[u + 1] = (this.q[v + 2 + -191] * 233 & 0xFFFF) + (this.q[v + 2 + -127] * 233 << 16);
            this.w[u + 2] = (this.q[v + 4 + -191] * 233 & 0xFFFF) + (this.q[v + 4 + -127] * 233 << 16);
            this.w[u + 3] = (this.q[v + 6 + -191] * 233 & 0xFFFF) + (this.q[v + 6 + -127] * 233 << 16);
        }
        this.oneRound(0, 4, 13, 10, 25);
        int tA0 = SIMDSmallCore.circularLeft(this.state[0], 4);
        int tA1 = SIMDSmallCore.circularLeft(this.state[1], 4);
        int tA2 = SIMDSmallCore.circularLeft(this.state[2], 4);
        int tA3 = SIMDSmallCore.circularLeft(this.state[3], 4);
        int tmp = this.state[12] + this.tmpState[0] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, 13) + tA3;
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = tA0;
        tmp = this.state[13] + this.tmpState[1] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, 13) + tA2;
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = tA1;
        tmp = this.state[14] + this.tmpState[2] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, 13) + tA1;
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = tA2;
        tmp = this.state[15] + this.tmpState[3] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, 13) + tA0;
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = tA3;
        tA0 = SIMDSmallCore.circularLeft(this.state[0], 13);
        tA1 = SIMDSmallCore.circularLeft(this.state[1], 13);
        tA2 = SIMDSmallCore.circularLeft(this.state[2], 13);
        tA3 = SIMDSmallCore.circularLeft(this.state[3], 13);
        tmp = this.state[12] + this.tmpState[4] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, 10) + tA1;
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = tA0;
        tmp = this.state[13] + this.tmpState[5] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, 10) + tA0;
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = tA1;
        tmp = this.state[14] + this.tmpState[6] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, 10) + tA3;
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = tA2;
        tmp = this.state[15] + this.tmpState[7] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, 10) + tA2;
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = tA3;
        tA0 = SIMDSmallCore.circularLeft(this.state[0], 10);
        tA1 = SIMDSmallCore.circularLeft(this.state[1], 10);
        tA2 = SIMDSmallCore.circularLeft(this.state[2], 10);
        tA3 = SIMDSmallCore.circularLeft(this.state[3], 10);
        tmp = this.state[12] + this.tmpState[8] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, 25) + tA2;
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = tA0;
        tmp = this.state[13] + this.tmpState[9] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, 25) + tA3;
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = tA1;
        tmp = this.state[14] + this.tmpState[10] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, 25) + tA0;
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = tA2;
        tmp = this.state[15] + this.tmpState[11] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, 25) + tA1;
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = tA3;
        tA0 = SIMDSmallCore.circularLeft(this.state[0], 25);
        tA1 = SIMDSmallCore.circularLeft(this.state[1], 25);
        tA2 = SIMDSmallCore.circularLeft(this.state[2], 25);
        tA3 = SIMDSmallCore.circularLeft(this.state[3], 25);
        tmp = this.state[12] + this.tmpState[12] + ((this.state[4] ^ this.state[8]) & this.state[0] ^ this.state[8]);
        this.state[0] = SIMDSmallCore.circularLeft(tmp, 4) + tA3;
        this.state[12] = this.state[8];
        this.state[8] = this.state[4];
        this.state[4] = tA0;
        tmp = this.state[13] + this.tmpState[13] + ((this.state[5] ^ this.state[9]) & this.state[1] ^ this.state[9]);
        this.state[1] = SIMDSmallCore.circularLeft(tmp, 4) + tA2;
        this.state[13] = this.state[9];
        this.state[9] = this.state[5];
        this.state[5] = tA1;
        tmp = this.state[14] + this.tmpState[14] + ((this.state[6] ^ this.state[10]) & this.state[2] ^ this.state[10]);
        this.state[2] = SIMDSmallCore.circularLeft(tmp, 4) + tA1;
        this.state[14] = this.state[10];
        this.state[10] = this.state[6];
        this.state[6] = tA2;
        tmp = this.state[15] + this.tmpState[15] + ((this.state[7] ^ this.state[11]) & this.state[3] ^ this.state[11]);
        this.state[3] = SIMDSmallCore.circularLeft(tmp, 4) + tA0;
        this.state[15] = this.state[11];
        this.state[11] = this.state[7];
        this.state[7] = tA3;
    }

    @Override
    public String toString() {
        return "SIMD-" + (this.getDigestLength() << 3);
    }
}

