/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;

abstract class SkeinBigCore
implements Digest {
    private static final int BLOCK_LEN = 64;
    private byte[] buf = new byte[64];
    private byte[] tmpOut = new byte[64];
    private int ptr;
    private long[] h = new long[27];
    private long bcount;

    SkeinBigCore() {
        this.reset();
    }

    @Override
    public void update(byte in) {
        if (this.ptr == 64) {
            int etype = this.bcount == 0L ? 224 : 96;
            ++this.bcount;
            this.ubi(etype, 0);
            this.buf[0] = in;
            this.ptr = 1;
        } else {
            this.buf[this.ptr++] = in;
        }
    }

    @Override
    public void update(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
    }

    @Override
    public void update(byte[] inbuf, int off, int len) {
        if (len <= 0) {
            return;
        }
        int clen = 64 - this.ptr;
        if (len <= clen) {
            System.arraycopy(inbuf, off, this.buf, this.ptr, len);
            this.ptr += len;
            return;
        }
        if (clen != 0) {
            System.arraycopy(inbuf, off, this.buf, this.ptr, clen);
            off += clen;
            len -= clen;
        }
        while (true) {
            int etype = this.bcount == 0L ? 224 : 96;
            ++this.bcount;
            this.ubi(etype, 0);
            if (len <= 64) break;
            System.arraycopy(inbuf, off, this.buf, 0, 64);
            off += 64;
            len -= 64;
        }
        System.arraycopy(inbuf, off, this.buf, 0, len);
        this.ptr = len;
    }

    @Override
    public byte[] digest() {
        int len = this.getDigestLength();
        byte[] out = new byte[len];
        this.digest(out, 0, len);
        return out;
    }

    @Override
    public byte[] digest(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
        return this.digest();
    }

    @Override
    public int digest(byte[] outbuf, int off, int len) {
        int i;
        for (i = this.ptr; i < 64; ++i) {
            this.buf[i] = 0;
        }
        this.ubi(this.bcount == 0L ? 480 : 352, this.ptr);
        for (i = 0; i < 64; ++i) {
            this.buf[i] = 0;
        }
        this.bcount = 0L;
        this.ubi(510, 8);
        for (i = 0; i < 8; ++i) {
            SkeinBigCore.encodeLELong(this.h[i], this.tmpOut, i << 3);
        }
        int dlen = this.getDigestLength();
        if (len > dlen) {
            len = dlen;
        }
        System.arraycopy(this.tmpOut, 0, outbuf, off, len);
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        this.ptr = 0;
        long[] iv = this.getInitVal();
        System.arraycopy(iv, 0, this.h, 0, 8);
        this.bcount = 0L;
    }

    @Override
    public Digest copy() {
        SkeinBigCore dst = this.dup();
        System.arraycopy(this.buf, 0, dst.buf, 0, this.ptr);
        dst.ptr = this.ptr;
        System.arraycopy(this.h, 0, dst.h, 0, 8);
        dst.bcount = this.bcount;
        return dst;
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    abstract SkeinBigCore dup();

    abstract long[] getInitVal();

    private static final void encodeLELong(long val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
        buf[off + 4] = (byte)(val >>> 32);
        buf[off + 5] = (byte)(val >>> 40);
        buf[off + 6] = (byte)(val >>> 48);
        buf[off + 7] = (byte)(val >>> 56);
    }

    private static final long decodeLELong(byte[] buf, int off) {
        return (long)(buf[off] & 0xFF) | (long)(buf[off + 1] & 0xFF) << 8 | (long)(buf[off + 2] & 0xFF) << 16 | (long)(buf[off + 3] & 0xFF) << 24 | (long)(buf[off + 4] & 0xFF) << 32 | (long)(buf[off + 5] & 0xFF) << 40 | (long)(buf[off + 6] & 0xFF) << 48 | (long)(buf[off + 7] & 0xFF) << 56;
    }

    private final void ubi(int etype, int extra) {
        int u;
        long m0 = SkeinBigCore.decodeLELong(this.buf, 0);
        long m1 = SkeinBigCore.decodeLELong(this.buf, 8);
        long m2 = SkeinBigCore.decodeLELong(this.buf, 16);
        long m3 = SkeinBigCore.decodeLELong(this.buf, 24);
        long m4 = SkeinBigCore.decodeLELong(this.buf, 32);
        long m5 = SkeinBigCore.decodeLELong(this.buf, 40);
        long m6 = SkeinBigCore.decodeLELong(this.buf, 48);
        long m7 = SkeinBigCore.decodeLELong(this.buf, 56);
        long p0 = m0;
        long p1 = m1;
        long p2 = m2;
        long p3 = m3;
        long p4 = m4;
        long p5 = m5;
        long p6 = m6;
        long p7 = m7;
        this.h[8] = this.h[0] ^ this.h[1] ^ (this.h[2] ^ this.h[3]) ^ (this.h[4] ^ this.h[5] ^ (this.h[6] ^ this.h[7])) ^ 0x1BD11BDAA9FC1A22L;
        long t0 = (this.bcount << 6) + (long)extra;
        long t1 = (this.bcount >>> 58) + ((long)etype << 55);
        long t2 = t0 ^ t1;
        for (u = 0; u <= 15; u += 3) {
            this.h[u + 9] = this.h[u + 0];
            this.h[u + 10] = this.h[u + 1];
            this.h[u + 11] = this.h[u + 2];
        }
        for (u = 0; u < 9; ++u) {
            int s = u << 1;
            p0 += this.h[s + 0];
            p1 += this.h[s + 1];
            p2 += this.h[s + 2];
            p3 += this.h[s + 3];
            p4 += this.h[s + 4];
            p5 += this.h[s + 5] + t0;
            p6 += this.h[s + 6] + t1;
            p7 += this.h[s + 7] + (long)s;
            p0 += p1;
            p1 = p1 << 46 ^ p1 >>> 18 ^ p0;
            p2 += p3;
            p3 = p3 << 36 ^ p3 >>> 28 ^ p2;
            p4 += p5;
            p5 = p5 << 19 ^ p5 >>> 45 ^ p4;
            p6 += p7;
            p7 = p7 << 37 ^ p7 >>> 27 ^ p6;
            p2 += p1;
            p1 = p1 << 33 ^ p1 >>> 31 ^ p2;
            p4 += p7;
            p7 = p7 << 27 ^ p7 >>> 37 ^ p4;
            p6 += p5;
            p5 = p5 << 14 ^ p5 >>> 50 ^ p6;
            p0 += p3;
            p3 = p3 << 42 ^ p3 >>> 22 ^ p0;
            p4 += p1;
            p1 = p1 << 17 ^ p1 >>> 47 ^ p4;
            p6 += p3;
            p3 = p3 << 49 ^ p3 >>> 15 ^ p6;
            p0 += p5;
            p5 = p5 << 36 ^ p5 >>> 28 ^ p0;
            p2 += p7;
            p7 = p7 << 39 ^ p7 >>> 25 ^ p2;
            p6 += p1;
            p1 = p1 << 44 ^ p1 >>> 20 ^ p6;
            p0 += p7;
            p7 = p7 << 9 ^ p7 >>> 55 ^ p0;
            p2 += p5;
            p5 = p5 << 54 ^ p5 >>> 10 ^ p2;
            p4 += p3;
            p3 = p3 << 56 ^ p3 >>> 8 ^ p4;
            p0 += this.h[s + 1 + 0];
            p1 += this.h[s + 1 + 1];
            p2 += this.h[s + 1 + 2];
            p3 += this.h[s + 1 + 3];
            p4 += this.h[s + 1 + 4];
            p5 += this.h[s + 1 + 5] + t1;
            p6 += this.h[s + 1 + 6] + t2;
            p7 += this.h[s + 1 + 7] + (long)s + 1L;
            p0 += p1;
            p1 = p1 << 39 ^ p1 >>> 25 ^ p0;
            p2 += p3;
            p3 = p3 << 30 ^ p3 >>> 34 ^ p2;
            p4 += p5;
            p5 = p5 << 34 ^ p5 >>> 30 ^ p4;
            p6 += p7;
            p7 = p7 << 24 ^ p7 >>> 40 ^ p6;
            p2 += p1;
            p1 = p1 << 13 ^ p1 >>> 51 ^ p2;
            p4 += p7;
            p7 = p7 << 50 ^ p7 >>> 14 ^ p4;
            p6 += p5;
            p5 = p5 << 10 ^ p5 >>> 54 ^ p6;
            p0 += p3;
            p3 = p3 << 17 ^ p3 >>> 47 ^ p0;
            p4 += p1;
            p1 = p1 << 25 ^ p1 >>> 39 ^ p4;
            p6 += p3;
            p3 = p3 << 29 ^ p3 >>> 35 ^ p6;
            p0 += p5;
            p5 = p5 << 39 ^ p5 >>> 25 ^ p0;
            p2 += p7;
            p7 = p7 << 43 ^ p7 >>> 21 ^ p2;
            p6 += p1;
            p1 = p1 << 8 ^ p1 >>> 56 ^ p6;
            p0 += p7;
            p7 = p7 << 35 ^ p7 >>> 29 ^ p0;
            p2 += p5;
            p5 = p5 << 56 ^ p5 >>> 8 ^ p2;
            p4 += p3;
            p3 = p3 << 22 ^ p3 >>> 42 ^ p4;
            long tmp = t2;
            t2 = t1;
            t1 = t0;
            t0 = tmp;
        }
        p0 += this.h[18];
        p1 += this.h[19];
        p2 += this.h[20];
        p3 += this.h[21];
        p4 += this.h[22];
        p5 += this.h[23] + t0;
        p6 += this.h[24] + t1;
        p7 += this.h[25] + 18L;
        this.h[0] = m0 ^ p0;
        this.h[1] = m1 ^ p1;
        this.h[2] = m2 ^ p2;
        this.h[3] = m3 ^ p3;
        this.h[4] = m4 ^ p4;
        this.h[5] = m5 ^ p5;
        this.h[6] = m6 ^ p6;
        this.h[7] = m7 ^ p7;
    }

    @Override
    public String toString() {
        return "Skein-" + (this.getDigestLength() << 3);
    }
}

