/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.actson;

import de.undercouch.actson.JsonFeeder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;

public class DefaultJsonFeeder
implements JsonFeeder {
    private final ByteBuffer byteBuf;
    private final CharBuffer charBuf;
    private final CharsetDecoder decoder;
    private boolean done = false;

    public DefaultJsonFeeder(Charset charset) {
        this(charset, 1024);
    }

    public DefaultJsonFeeder(Charset charset, int capacity) {
        this.byteBuf = ByteBuffer.allocate(capacity);
        this.charBuf = CharBuffer.allocate(capacity * 2);
        this.charBuf.limit(0);
        this.decoder = charset.newDecoder();
    }

    @Override
    public void feed(byte b) {
        if (this.isFull()) {
            throw new IllegalStateException("JSON parser is full");
        }
        this.byteBuf.put(b);
    }

    @Override
    public int feed(byte[] buf) {
        return this.feed(buf, 0, buf.length);
    }

    @Override
    public int feed(byte[] buf, int offset, int len) {
        int i;
        for (i = 0; i < len && !this.isFull(); ++i) {
            this.feed(buf[i + offset]);
        }
        return i;
    }

    @Override
    public void done() {
        this.done = true;
    }

    @Override
    public boolean isFull() {
        return !this.byteBuf.hasRemaining();
    }

    @Override
    public boolean hasInput() throws CharacterCodingException {
        this.fillBuffer();
        return this.charBuf.hasRemaining();
    }

    @Override
    public boolean isDone() throws CharacterCodingException {
        return this.done && !this.hasInput();
    }

    @Override
    public char nextInput() throws CharacterCodingException {
        if (!this.hasInput()) {
            throw new IllegalStateException("Not enough input data");
        }
        return this.charBuf.get();
    }

    private void fillBuffer() throws CharacterCodingException {
        if (this.charBuf.hasRemaining()) {
            return;
        }
        if (this.byteBuf.position() == 0) {
            return;
        }
        this.charBuf.position(0);
        this.charBuf.limit(this.charBuf.capacity());
        this.byteBuf.flip();
        CoderResult result = this.decoder.decode(this.byteBuf, this.charBuf, this.done);
        if (result.isMalformed()) {
            throw new MalformedInputException(result.length());
        }
        if (result.isUnmappable()) {
            throw new UnmappableCharacterException(result.length());
        }
        this.charBuf.flip();
        this.byteBuf.compact();
    }
}

