/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import de.undercouch.bson4jackson.io.DynamicOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.impl.JsonGeneratorBase;

public class BsonGenerator
extends JsonGeneratorBase {
    protected final int _bsonFeatures;
    protected final OutputStream _out;
    protected final DynamicOutputBuffer _buffer = new DynamicOutputBuffer(ByteOrder.LITTLE_ENDIAN);
    protected int _typeMarker = 0;
    protected Deque<DocumentInfo> _documents = new ArrayDeque<DocumentInfo>();

    public BsonGenerator(int n, int n2, OutputStream outputStream) {
        super(n, null);
        this._bsonFeatures = n2;
        this._out = outputStream;
        if (this.isEnabled(Feature.ENABLE_STREAMING)) {
            this._buffer.setReuseBuffersCount(2);
        }
    }

    protected boolean isEnabled(Feature feature) {
        return (this._bsonFeatures & feature.getMask()) != 0;
    }

    protected boolean isArray() {
        return this._documents.isEmpty() ? false : this._documents.peek().currentArrayPos >= 0;
    }

    protected int getAndIncCurrentArrayPos() {
        if (this._documents.isEmpty()) {
            return -1;
        }
        DocumentInfo documentInfo = this._documents.peek();
        int n = documentInfo.currentArrayPos++;
        return n;
    }

    protected void reserveHeader() {
        this._buffer.putInt(0);
    }

    protected void putHeader(int n) {
        this._buffer.putInt(n, this._buffer.size() - n);
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    protected void _releaseBuffers() {
        this._buffer.clear();
    }

    public void close() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (!this._documents.isEmpty()) {
                this.writeEndObject();
            }
        }
        this._buffer.writeTo(this._out);
        this._buffer.clear();
        this._out.flush();
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        }
        super.close();
    }

    public void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeStartObject(true);
    }

    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this.writeEndObjectInternal();
        this._writeContext = this._writeContext.getParent();
    }

    public void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writeStartObject(false);
    }

    protected void _writeStartObject(boolean bl) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        if (!this._documents.isEmpty()) {
            this._buffer.putByte(this._typeMarker, bl ? (byte)4 : 3);
        }
        this._documents.push(new DocumentInfo(this._buffer.size(), bl));
        this.reserveHeader();
    }

    public void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.writeEndObjectInternal();
    }

    private void writeEndObjectInternal() {
        if (!this._documents.isEmpty()) {
            this._buffer.putByte((byte)0);
            DocumentInfo documentInfo = this._documents.pop();
            if (!this.isEnabled(Feature.ENABLE_STREAMING)) {
                this.putHeader(documentInfo.headerPos);
            }
        }
    }

    protected void _writeArrayFieldNameIfNeeded() throws IOException {
        if (this.isArray()) {
            int n = this.getAndIncCurrentArrayPos();
            this._writeFieldName(String.valueOf(n));
        }
    }

    public void writeFieldName(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeFieldName(string);
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    private void _writeFieldName(String string) throws IOException, JsonGenerationException {
        this._typeMarker = this._buffer.size();
        this._buffer.putByte((byte)0);
        this._buffer.putUTF8(string);
        this._buffer.putByte((byte)0);
    }

    protected void _verifyValueWrite(String string) throws IOException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.isEnabled(Feature.ENABLE_STREAMING)) {
            this._buffer.flushTo(this._out);
        }
    }

    public void writeString(String string) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write string");
        this._buffer.putByte(this._typeMarker, (byte)2);
        int n = this._buffer.size();
        this._buffer.putInt(0);
        int n2 = this._buffer.putUTF8(string);
        this._buffer.putByte((byte)0);
        this._buffer.putInt(n, n2 + 1);
        this.flushBuffer();
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeString(new String(cArray, n, n2));
    }

    public void writeRaw(String string) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw string");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(string.length() * 2);
        this._buffer.putByte((byte)0);
        this._buffer.putString(string);
        this.flushBuffer();
    }

    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        this.writeRaw(string.substring(n, n2));
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw string");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(cArray.length * 2);
        this._buffer.putByte((byte)0);
        this._buffer.putString(CharBuffer.wrap(cArray));
        this.flushBuffer();
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.writeRaw(new char[]{c}, 0, 1);
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write binary");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(byArray.length);
        this._buffer.putByte((byte)0);
        int n3 = n + n2;
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        while (n < n3) {
            this._buffer.putByte(byArray[n]);
            ++n;
        }
        this.flushBuffer();
    }

    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)16);
        this._buffer.putInt(n);
        this.flushBuffer();
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)18);
        this._buffer.putLong(l);
        this.flushBuffer();
    }

    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        int n = bigInteger.bitLength();
        if (n < 32) {
            this.writeNumber(bigInteger.intValue());
        } else if (n < 64) {
            this.writeNumber(bigInteger.longValue());
        } else {
            this.writeString(bigInteger.toString());
        }
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)1);
        this._buffer.putDouble(d);
        this.flushBuffer();
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.writeNumber((double)f);
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        float f = bigDecimal.floatValue();
        if (!Float.isInfinite(f)) {
            this.writeNumber(f);
        } else {
            double d = bigDecimal.doubleValue();
            if (!Double.isInfinite(d)) {
                this.writeNumber(d);
            } else {
                this.writeString(bigDecimal.toString());
            }
        }
    }

    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.writeString(string);
    }

    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write boolean");
        this._buffer.putByte(this._typeMarker, (byte)8);
        this._buffer.putByte((byte)(bl ? 1 : 0));
        this.flushBuffer();
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write null");
        this._buffer.putByte(this._typeMarker, (byte)10);
        this.flushBuffer();
    }

    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw utf8 string");
        this._buffer.putByte(this._typeMarker, (byte)2);
        int n3 = this._buffer.size();
        this._buffer.putInt(0);
        for (int i = n; i < n2; ++i) {
            this._buffer.putByte(byArray[i]);
        }
        this._buffer.putByte((byte)0);
        this._buffer.putInt(n3, n2);
        this.flushBuffer();
    }

    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeRawUTF8String(byArray, n, n2);
    }

    private static class DocumentInfo {
        final int headerPos;
        int currentArrayPos;

        public DocumentInfo(int n, boolean bl) {
            this.headerPos = n;
            this.currentArrayPos = bl ? 0 : -1;
        }
    }

    public static enum Feature {
        ENABLE_STREAMING;


        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

