/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import de.undercouch.bson4jackson.io.DynamicOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.impl.JsonGeneratorBase;

public class BsonGenerator
extends JsonGeneratorBase {
    protected final int _bsonFeatures;
    protected final OutputStream _out;
    protected final DynamicOutputBuffer _buffer = new DynamicOutputBuffer(ByteOrder.LITTLE_ENDIAN);
    protected int _typeMarker = 0;
    protected Deque<DocumentInfo> _documents = new ArrayDeque<DocumentInfo>();

    public BsonGenerator(int jsonFeatures, int bsonFeatures, OutputStream out) {
        super(jsonFeatures, null);
        this._bsonFeatures = bsonFeatures;
        this._out = out;
        if (this.isEnabled(Feature.ENABLE_STREAMING)) {
            this._buffer.setReuseBuffersCount(2);
        }
    }

    protected boolean isEnabled(Feature f) {
        return (this._bsonFeatures & f.getMask()) != 0;
    }

    protected boolean isArray() {
        return this._documents.isEmpty() ? false : this._documents.peek().currentArrayPos >= 0;
    }

    protected int getAndIncCurrentArrayPos() {
        if (this._documents.isEmpty()) {
            return -1;
        }
        DocumentInfo di = this._documents.peek();
        int r = di.currentArrayPos++;
        return r;
    }

    protected void reserveHeader() {
        this._buffer.putInt(0);
    }

    protected void putHeader(int pos) {
        this._buffer.putInt(pos, this._buffer.size() - pos);
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    protected void _releaseBuffers() {
        this._buffer.clear();
    }

    public void close() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (!this._documents.isEmpty()) {
                this.writeEndObject();
            }
        }
        this._buffer.writeTo(this._out);
        this._buffer.clear();
        this._out.flush();
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        }
        super.close();
    }

    public void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeStartObject(true);
    }

    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this.writeEndObjectInternal();
        this._writeContext = this._writeContext.getParent();
    }

    public void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writeStartObject(false);
    }

    protected void _writeStartObject(boolean array) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        if (!this._documents.isEmpty()) {
            this._buffer.putByte(this._typeMarker, array ? (byte)4 : 3);
        }
        this._documents.push(new DocumentInfo(this._buffer.size(), array));
        this.reserveHeader();
    }

    public void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.writeEndObjectInternal();
    }

    private void writeEndObjectInternal() {
        if (!this._documents.isEmpty()) {
            this._buffer.putByte((byte)0);
            DocumentInfo info = this._documents.pop();
            if (!this.isEnabled(Feature.ENABLE_STREAMING)) {
                this.putHeader(info.headerPos);
            }
        }
    }

    protected void _writeArrayFieldNameIfNeeded() throws IOException {
        if (this.isArray()) {
            int p = this.getAndIncCurrentArrayPos();
            this._writeFieldName(String.valueOf(p));
        }
    }

    public void writeFieldName(String name) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeFieldName(name);
        if (status == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    private void _writeFieldName(String name) throws IOException, JsonGenerationException {
        this._typeMarker = this._buffer.size();
        this._buffer.putByte((byte)0);
        this._buffer.putUTF8(name);
        this._buffer.putByte((byte)0);
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.isEnabled(Feature.ENABLE_STREAMING)) {
            this._buffer.flushTo(this._out);
        }
    }

    public void writeString(String text) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write string");
        this._buffer.putByte(this._typeMarker, (byte)2);
        int p = this._buffer.size();
        this._buffer.putInt(0);
        int l = this._buffer.putUTF8(text);
        this._buffer.putByte((byte)0);
        this._buffer.putInt(p, l + 1);
        this.flushBuffer();
    }

    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeString(new String(text, offset, len));
    }

    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw string");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(text.length() * 2);
        this._buffer.putByte((byte)0);
        this._buffer.putString(text);
        this.flushBuffer();
    }

    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeRaw(text.substring(offset, len));
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw string");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(text.length * 2);
        this._buffer.putByte((byte)0);
        this._buffer.putString(CharBuffer.wrap(text));
        this.flushBuffer();
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.writeRaw(new char[]{c}, 0, 1);
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        this.writeBinary(b64variant, (byte)0, data, offset, len);
    }

    public void writeBinary(Base64Variant b64variant, byte subType, byte[] data, int offset, int len) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write binary");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(len);
        this._buffer.putByte(subType);
        int end = offset + len;
        if (end > data.length) {
            end = data.length;
        }
        while (offset < end) {
            this._buffer.putByte(data[offset]);
            ++offset;
        }
        this.flushBuffer();
    }

    public void writeNumber(int v) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)16);
        this._buffer.putInt(v);
        this.flushBuffer();
    }

    public void writeNumber(long v) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)18);
        this._buffer.putLong(v);
        this.flushBuffer();
    }

    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        int bl = v.bitLength();
        if (bl < 32) {
            this.writeNumber(v.intValue());
        } else if (bl < 64) {
            this.writeNumber(v.longValue());
        } else {
            this.writeString(v.toString());
        }
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)1);
        this._buffer.putDouble(d);
        this.flushBuffer();
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.writeNumber((double)f);
    }

    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        float f = dec.floatValue();
        if (!Float.isInfinite(f)) {
            this.writeNumber(f);
        } else {
            double d = dec.doubleValue();
            if (!Double.isInfinite(d)) {
                this.writeNumber(d);
            } else {
                this.writeString(dec.toString());
            }
        }
    }

    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.writeString(encodedValue);
    }

    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write boolean");
        this._buffer.putByte(this._typeMarker, (byte)8);
        this._buffer.putByte((byte)(state ? 1 : 0));
        this.flushBuffer();
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write null");
        this._buffer.putByte(this._typeMarker, (byte)10);
        this.flushBuffer();
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw utf8 string");
        this._buffer.putByte(this._typeMarker, (byte)2);
        int p = this._buffer.size();
        this._buffer.putInt(0);
        for (int i = offset; i < length; ++i) {
            this._buffer.putByte(text[i]);
        }
        this._buffer.putByte((byte)0);
        this._buffer.putInt(p, length);
        this.flushBuffer();
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this.writeRawUTF8String(text, offset, length);
    }

    private static class DocumentInfo {
        final int headerPos;
        int currentArrayPos;

        public DocumentInfo(int headerPos, boolean array) {
            this.headerPos = headerPos;
            this.currentArrayPos = array ? 0 : -1;
        }
    }

    public static enum Feature {
        ENABLE_STREAMING;


        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

