/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.type.TypeReference;
import de.undercouch.bson4jackson.io.BoundedInputStream;
import de.undercouch.bson4jackson.io.ByteOrderUtil;
import de.undercouch.bson4jackson.io.CountingInputStream;
import de.undercouch.bson4jackson.io.LittleEndianInputStream;
import de.undercouch.bson4jackson.io.StaticBufferedInputStream;
import de.undercouch.bson4jackson.io.UnsafeByteArrayInputStream;
import de.undercouch.bson4jackson.types.Decimal128;
import de.undercouch.bson4jackson.types.JavaScript;
import de.undercouch.bson4jackson.types.ObjectId;
import de.undercouch.bson4jackson.types.Symbol;
import de.undercouch.bson4jackson.types.Timestamp;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class BsonParser
extends ParserBase {
    protected int _bsonFeatures;
    protected LittleEndianInputStream _in;
    protected CountingInputStream _counter;
    protected InputStream _rawInputStream;
    protected boolean _closed;
    protected ObjectCodec _codec;
    protected int _tokenPos;
    protected Context _currentContext;

    public BsonParser(IOContext ctxt, int jsonFeatures, int bsonFeatures, InputStream in) {
        super(ctxt, jsonFeatures);
        this._bsonFeatures = bsonFeatures;
        this._rawInputStream = in;
        if (!this.isEnabled(Feature.HONOR_DOCUMENT_LENGTH)) {
            if (!(in instanceof UnsafeByteArrayInputStream)) {
                in = new StaticBufferedInputStream(in);
            }
            this._counter = new CountingInputStream(in);
            this._in = new LittleEndianInputStream(this._counter);
        }
    }

    protected boolean isEnabled(Feature f) {
        return (this._bsonFeatures & f.getMask()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpectedStartArrayToken() {
        JsonToken t = this._currToken;
        if (t == JsonToken.START_OBJECT) {
            boolean isarray;
            if (this._in.markSupported()) {
                this._in.mark(3);
                try {
                    byte tpe = this._in.readByte();
                    if (tpe != 0) {
                        if (this._in.readByte() == 48 && this._in.readByte() == 0) {
                            isarray = true;
                        }
                        isarray = false;
                    }
                    isarray = true;
                }
                catch (IOException e) {
                    isarray = true;
                }
                finally {
                    try {
                        this._in.reset();
                    }
                    catch (IOException re) {
                        throw new IllegalStateException("Could not reset input stream", re);
                    }
                }
            } else {
                isarray = true;
            }
            if (isarray) {
                this._currToken = JsonToken.START_ARRAY;
                this._currentContext = this._currentContext.copy(this._currentContext.parent, true);
                return true;
            }
        }
        return super.isExpectedStartArrayToken();
    }

    public ObjectCodec getCodec() {
        return this._codec;
    }

    public void setCodec(ObjectCodec c) {
        this._codec = c;
    }

    public void close() throws IOException {
        if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
            this._in.close();
        }
        this._closed = true;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        boolean readValue;
        Context ctx;
        block34: {
            ctx = this._currentContext;
            if (this._currToken == null && ctx == null) {
                try {
                    this._currToken = this.handleNewDocument(false);
                }
                catch (EOFException e) {
                    return null;
                }
            }
            this._tokenPos = this._counter.getPosition();
            if (ctx == null) {
                if (this._currToken == JsonToken.END_OBJECT) {
                    return null;
                }
                throw new JsonParseException("Found element outside the document", this.getTokenLocation());
            }
            if (ctx.state == State.DONE) {
                ctx.reset();
            }
            readValue = true;
            if (ctx.state == State.FIELDNAME) {
                readValue = false;
                while (true) {
                    ctx.type = this._in.readByte();
                    if (ctx.type == 0) {
                        this._currToken = ctx.array ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                        this._currentContext = this._currentContext.parent;
                        break block34;
                    }
                    if (ctx.type != 6) break;
                    this.skipCString();
                }
                ctx.state = State.VALUE;
                this._currToken = JsonToken.FIELD_NAME;
                if (ctx.array) {
                    readValue = true;
                    this.skipCString();
                    ctx.fieldName = null;
                } else {
                    ctx.fieldName = this.readCString();
                }
            }
        }
        if (readValue) {
            switch (ctx.type) {
                case 1: {
                    ctx.value = this._in.readDouble();
                    this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                    break;
                }
                case 2: {
                    ctx.value = this.readString();
                    this._currToken = JsonToken.VALUE_STRING;
                    break;
                }
                case 3: {
                    this._currToken = this.handleNewDocument(false);
                    break;
                }
                case 4: {
                    this._currToken = this.handleNewDocument(true);
                    break;
                }
                case 5: {
                    this._currToken = this.handleBinary();
                    break;
                }
                case 7: {
                    ctx.value = this.readObjectId();
                    this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                    break;
                }
                case 8: {
                    boolean b = this._in.readBoolean();
                    ctx.value = b;
                    this._currToken = b ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                    break;
                }
                case 9: {
                    ctx.value = new Date(this._in.readLong());
                    this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                    break;
                }
                case 10: {
                    this._currToken = JsonToken.VALUE_NULL;
                    break;
                }
                case 11: {
                    this._currToken = this.handleRegEx();
                    break;
                }
                case 12: {
                    this._currToken = this.handleDBPointer();
                    break;
                }
                case 13: {
                    ctx.value = new JavaScript(this.readString());
                    this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                    break;
                }
                case 14: {
                    ctx.value = this.readSymbol();
                    this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                    break;
                }
                case 15: {
                    this._currToken = this.handleJavascriptWithScope();
                    break;
                }
                case 16: {
                    ctx.value = this._in.readInt();
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    break;
                }
                case 17: {
                    ctx.value = this.readTimestamp();
                    this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                    break;
                }
                case 18: {
                    ctx.value = this._in.readLong();
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    break;
                }
                case 19: {
                    long low = this._in.readLong();
                    long high = this._in.readLong();
                    ctx.value = Decimal128.fromIEEE754BIDEncoding(high, low);
                    this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                    break;
                }
                case -1: {
                    ctx.value = "MinKey";
                    this._currToken = JsonToken.VALUE_STRING;
                    break;
                }
                case 127: {
                    ctx.value = "MaxKey";
                    this._currToken = JsonToken.VALUE_STRING;
                    break;
                }
                default: {
                    throw new JsonParseException("Unknown element type " + ctx.type, this.getTokenLocation());
                }
            }
            ctx.state = State.DONE;
        }
        return this._currToken;
    }

    protected JsonToken handleNewDocument(boolean array) throws IOException {
        if (this._in == null) {
            int l;
            byte[] buf = new byte[4];
            for (int len = 0; len < buf.length; len += l) {
                l = this._rawInputStream.read(buf, len, buf.length - len);
                if (l != -1) continue;
                throw new IOException("Not enough bytes for length of document");
            }
            int documentLength = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
            InputStream in = new BoundedInputStream(this._rawInputStream, documentLength - buf.length);
            if (!(this._rawInputStream instanceof BufferedInputStream)) {
                in = new StaticBufferedInputStream(in);
            }
            this._counter = new CountingInputStream(in);
            this._in = new LittleEndianInputStream(this._counter);
        } else {
            this._in.readInt();
        }
        this._currentContext = new Context(this._currentContext, array);
        return array ? JsonToken.START_ARRAY : JsonToken.START_OBJECT;
    }

    protected JsonToken handleBinary() throws IOException {
        int size = this._in.readInt();
        byte subtype = this._in.readByte();
        Context ctx = this.getContext();
        switch (subtype) {
            case 2: {
                int size2 = this._in.readInt();
                byte[] buf2 = new byte[size2];
                this._in.readFully(buf2);
                ctx.value = buf2;
                break;
            }
            case 3: {
                long l1 = this._in.readLong();
                long l2 = this._in.readLong();
                ctx.value = new UUID(l1, l2);
                break;
            }
            default: {
                byte[] buf = new byte[size];
                this._in.readFully(buf);
                ctx.value = buf;
            }
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected int regexStrToFlags(String pattern) throws JsonParseException {
        int flags = 0;
        block7: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case 'i': {
                    flags |= 2;
                    continue block7;
                }
                case 'm': {
                    flags |= 8;
                    continue block7;
                }
                case 's': {
                    flags |= 0x20;
                    continue block7;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block7;
                }
                case 'l': 
                case 'x': {
                    continue block7;
                }
                default: {
                    throw new JsonParseException("Invalid regex", this.getTokenLocation());
                }
            }
        }
        return flags;
    }

    protected JsonToken handleRegEx() throws IOException {
        String regex = this.readCString();
        String pattern = this.readCString();
        this.getContext().value = Pattern.compile(regex, this.regexStrToFlags(pattern));
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected JsonToken handleDBPointer() throws IOException {
        LinkedHashMap<String, Object> pointer = new LinkedHashMap<String, Object>();
        pointer.put("$ns", this.readString());
        pointer.put("$id", this.readObjectId());
        this.getContext().value = pointer;
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected JsonToken handleJavascriptWithScope() throws IOException {
        this._in.readInt();
        String code = this.readString();
        Map<String, Object> doc = this.readDocument();
        this.getContext().value = new JavaScript(code, doc);
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected String readCString() throws IOException {
        return this._in.readUTF(-1);
    }

    protected void skipCString() throws IOException {
        while (this._in.readByte() != 0) {
        }
    }

    protected String readString() throws IOException {
        int bytes = this._in.readInt();
        if (bytes <= 0) {
            throw new IOException("Invalid number of string bytes");
        }
        String s = bytes > 1 ? this._in.readUTF(bytes - 1) : "";
        this._in.readByte();
        return s;
    }

    protected Symbol readSymbol() throws IOException {
        return new Symbol(this.readString());
    }

    protected Timestamp readTimestamp() throws IOException {
        int inc = this._in.readInt();
        int time = this._in.readInt();
        return new Timestamp(time, inc);
    }

    protected ObjectId readObjectId() throws IOException {
        int time = ByteOrderUtil.flip(this._in.readInt());
        int machine = ByteOrderUtil.flip(this._in.readInt());
        int inc = ByteOrderUtil.flip(this._in.readInt());
        return new ObjectId(time, machine, inc);
    }

    protected Map<String, Object> readDocument() throws IOException {
        ObjectCodec codec = this.getCodec();
        if (codec == null) {
            throw new IllegalStateException("Could not parse embedded document because BSON parser has no codec");
        }
        this._currToken = this.handleNewDocument(false);
        return (Map)codec.readValue((JsonParser)this, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected Context getContext() throws IOException {
        if (this._currentContext == null) {
            throw new IOException("Context unknown");
        }
        return this._currentContext;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public String getCurrentName() throws IOException, JsonParseException {
        if (this._currentContext == null) {
            return null;
        }
        return this._currentContext.fieldName;
    }

    public byte getCurrentBsonType() {
        if (this._currentContext == null) {
            return 6;
        }
        return this._currentContext.type;
    }

    public JsonLocation getTokenLocation() {
        return new BsonLocation(this._in, this._tokenPos);
    }

    public JsonLocation getCurrentLocation() {
        return new BsonLocation(this._in, this._counter.getPosition());
    }

    public String getText() throws IOException, JsonParseException {
        if (this._currentContext == null || this._currentContext.state == State.FIELDNAME) {
            return null;
        }
        if (this._currentContext.state == State.VALUE) {
            return this._currentContext.fieldName;
        }
        return String.valueOf(this._currentContext.value);
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return (Number)this.getContext().value;
    }

    public Number getNumberValueExact() throws IOException {
        return this.getNumberValue();
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        if (this._currentContext == null) {
            return null;
        }
        if (this._currentContext.value instanceof Integer) {
            return JsonParser.NumberType.INT;
        }
        if (this._currentContext.value instanceof Long) {
            return JsonParser.NumberType.LONG;
        }
        if (this._currentContext.value instanceof BigInteger) {
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if (this._currentContext.value instanceof Float) {
            return JsonParser.NumberType.FLOAT;
        }
        if (this._currentContext.value instanceof Double) {
            return JsonParser.NumberType.DOUBLE;
        }
        if (this._currentContext.value instanceof BigDecimal) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return null;
    }

    public int getIntValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).intValue();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).longValue();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        Number n = this.getNumberValue();
        if (n == null) {
            return null;
        }
        if (n instanceof Byte || n instanceof Integer || n instanceof Long || n instanceof Short) {
            return BigInteger.valueOf(n.longValue());
        }
        if (n instanceof Double || n instanceof Float) {
            return BigDecimal.valueOf(n.doubleValue()).toBigInteger();
        }
        return new BigInteger(n.toString());
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).floatValue();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).doubleValue();
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        Number n = this.getNumberValue();
        if (n == null) {
            return null;
        }
        if (n instanceof Byte || n instanceof Integer || n instanceof Long || n instanceof Short) {
            return BigDecimal.valueOf(n.longValue());
        }
        if (n instanceof Double || n instanceof Float) {
            return BigDecimal.valueOf(n.doubleValue());
        }
        return new BigDecimal(n.toString());
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException, JsonParseException {
        return (byte[])this.getContext().value;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return this._currentContext != null ? this._currentContext.value : null;
    }

    protected void _handleEOF() throws JsonParseException {
        this._reportInvalidEOF();
    }

    protected boolean loadMore() throws IOException {
        return true;
    }

    protected void _finishString() throws IOException, JsonParseException {
    }

    protected void _closeInput() throws IOException {
        this._rawInputStream.close();
    }

    protected static class BsonLocation
    extends JsonLocation {
        private static final long serialVersionUID = -5441597278886285168L;

        public BsonLocation(Object srcRef, long totalBytes) {
            super(srcRef, totalBytes, -1L, -1, -1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(80);
            sb.append("[Source: ");
            if (this.getSourceRef() == null) {
                sb.append("UNKNOWN");
            } else {
                sb.append(this.getSourceRef().toString());
            }
            sb.append("; pos: ");
            sb.append(this.getByteOffset());
            sb.append(']');
            return sb.toString();
        }
    }

    protected static class Context {
        final Context parent;
        final boolean array;
        byte type;
        String fieldName;
        Object value;
        State state = State.FIELDNAME;

        public Context(Context parent, boolean array) {
            this.parent = parent;
            this.array = array;
        }

        public void reset() {
            this.type = 0;
            this.fieldName = null;
            this.value = null;
            this.state = State.FIELDNAME;
        }

        public Context copy(Context parent, boolean array) {
            Context r = new Context(parent, array);
            r.type = this.type;
            r.fieldName = this.fieldName;
            r.value = this.value;
            r.state = this.state;
            return r;
        }
    }

    protected static enum State {
        FIELDNAME,
        VALUE,
        DONE;

    }

    public static enum Feature {
        HONOR_DOCUMENT_LENGTH;


        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

