/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import de.undercouch.bson4jackson.BsonParser;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class BsonCalendarDeserializer
extends JsonDeserializer<Calendar> {
    public Calendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            Object obj;
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 9) {
                ctxt.reportBadDefinition(Date.class, "Current token isn't embedded object or date time");
            }
            if ((obj = bsonParser.getEmbeddedObject()) == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            return cal;
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)jp.getEmbeddedObject());
            return cal;
        }
        Date date = new Date(jp.getLongValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

