/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.undercouch.bson4jackson.BsonParser;
import java.io.IOException;
import java.util.regex.Pattern;

public class BsonRegexDeserializer
extends JsonDeserializer<Pattern> {
    public Pattern deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 11) {
                throw ctxt.mappingException(Pattern.class);
            }
            return (Pattern)bsonParser.getEmbeddedObject();
        }
        TreeNode tree = jp.getCodec().readTree(jp);
        String pattern = null;
        TreeNode patternNode = tree.get("$pattern");
        if (patternNode instanceof ValueNode) {
            pattern = ((ValueNode)patternNode).asText();
        }
        int flags = 0;
        TreeNode flagsNode = tree.get("$flags");
        if (flagsNode instanceof ValueNode) {
            flags = ((ValueNode)flagsNode).asInt();
        }
        return Pattern.compile(pattern, flags);
    }
}

