/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.types.JavaScript;
import java.io.IOException;
import java.util.Map;

public class BsonJavaScriptDeserializer
extends JsonDeserializer<JavaScript> {
    public JavaScript deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 13 && bsonParser.getCurrentBsonType() != 15) {
                throw ctxt.mappingException(JavaScript.class);
            }
            return (JavaScript)bsonParser.getEmbeddedObject();
        }
        TreeNode tree = jp.getCodec().readTree(jp);
        String code = null;
        TreeNode codeNode = tree.get("$code");
        if (codeNode instanceof ValueNode) {
            code = ((ValueNode)codeNode).asText();
        }
        Map scope = null;
        TreeNode scopeNode = tree.get("$scope");
        if (scopeNode instanceof ObjectNode) {
            Map scope2;
            scope = scope2 = (Map)jp.getCodec().treeToValue(scopeNode, Map.class);
        }
        return new JavaScript(code, scope);
    }
}

