/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.http.protocol;

import de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpResponse;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpResponseInterceptor;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;
import de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpDateGenerator;
import de.undercouch.gradle.tasks.download.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

