/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.traces.peppermodules;

import de.uni_hamburg.traces.peppermodules.GeTaMapper;
import java.io.File;
import java.io.IOException;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="GeTaImporterComponent", factory="PepperImporterComponentFactory")
public class GeTaImporter
extends PepperImporterImpl
implements PepperImporter {
    public GeTaImporter() {
        this.setName("GeTaImporter");
        this.setSupplierContact(URI.createURI((String)"mail@sdruskat.net"));
        this.setSupplierHomepage(URI.createURI((String)"http://sdruskat.net/traces-importer"));
        this.setDesc("An importer for the custom JSON-based format used by the GeTa research project (https://www.traces.uni-hamburg.de/).");
        this.addSupportedFormat("traces-json", "1.0", null);
        this.getDocumentEndings().add("json");
    }

    public PepperMapper createPepperMapper(Identifier identifier) {
        GeTaMapper mapper = new GeTaMapper();
        mapper.setResourceURI((URI)this.getIdentifier2ResourceTable().get(identifier));
        return mapper;
    }

    public Double isImportable(URI corpusPath) {
        return null;
    }

    protected Boolean importCorpusStructureRec(URI currURI, SCorpus parent) {
        SALT_TYPE type;
        boolean ignoreAnnotationFile;
        Boolean retVal = false;
        if (this.getCorpusGraph().getName() == null || this.getCorpusGraph().getName().isEmpty()) {
            this.getCorpusGraph().setName(currURI.lastSegment());
        }
        boolean bl = ignoreAnnotationFile = currURI.toString().endsWith("TEA.json") || currURI.toString().endsWith("DEA.json") || currURI.toString().endsWith("NEA.json") || currURI.toString().endsWith("QEA.json") || currURI.toString().endsWith("MetaEA.json");
        if (currURI.lastSegment() != null && !this.getIgnoreEndings().contains(currURI.lastSegment()) && !ignoreAnnotationFile && (type = this.setTypeOfResource(currURI)) != null) {
            File currFile = new File(currURI.toFileString());
            if (SALT_TYPE.SCORPUS.equals((Object)type)) {
                File[] files;
                SCorpus sCorpus = this.getCorpusGraph().createCorpus(parent, currURI.lastSegment());
                this.getIdentifier2ResourceTable().put(sCorpus.getIdentifier(), currURI);
                if (currFile.isDirectory() && (files = currFile.listFiles()) != null) {
                    for (File file : files) {
                        try {
                            Boolean containsDocuments = this.importCorpusStructureRec(URI.createFileURI((String)file.getCanonicalPath()), sCorpus);
                            retVal = retVal != false || containsDocuments != false;
                        }
                        catch (IOException e) {
                            throw new PepperModuleException("Cannot import corpus structure, because cannot create a URI out of file '" + file + "'. ", (Throwable)e);
                        }
                    }
                }
            } else if (SALT_TYPE.SDOCUMENT.equals((Object)type)) {
                retVal = true;
                if (parent == null) {
                    parent = this.getCorpusGraph().createCorpus(null, currURI.lastSegment().replace("." + currURI.fileExtension(), ""));
                    this.getIdentifier2ResourceTable().put(parent.getIdentifier(), currURI);
                }
                File docFile = new File(currURI.toFileString());
                SDocument sDocument = null;
                sDocument = docFile.isDirectory() ? this.getCorpusGraph().createDocument(parent, currURI.lastSegment()) : this.getCorpusGraph().createDocument(parent, currURI.lastSegment().replace("." + currURI.fileExtension(), ""));
                this.getIdentifier2ResourceTable().put(sDocument.getIdentifier(), currURI);
            }
        }
        return retVal;
    }
}

