/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.traces.peppermodules;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uni_hamburg.traces.peppermodules.GeTaUtil;
import de.uni_hamburg.traces.peppermodules.model.dea.GeTaDEA;
import de.uni_hamburg.traces.peppermodules.model.ea.GeTaEA;
import de.uni_hamburg.traces.peppermodules.model.ea.GeTaEd;
import de.uni_hamburg.traces.peppermodules.model.ea.GeTaFC;
import de.uni_hamburg.traces.peppermodules.model.ea.GeTaFidalword;
import de.uni_hamburg.traces.peppermodules.model.ea.GeTaLL;
import de.uni_hamburg.traces.peppermodules.model.metaea.GeTaMetaEA;
import de.uni_hamburg.traces.peppermodules.model.nea.GeTaNEA;
import de.uni_hamburg.traces.peppermodules.model.nea.GeTaRef;
import de.uni_hamburg.traces.peppermodules.model.tea.GeTaAL;
import de.uni_hamburg.traces.peppermodules.model.tea.GeTaLT;
import de.uni_hamburg.traces.peppermodules.model.tea.GeTaM;
import de.uni_hamburg.traces.peppermodules.model.tea.GeTaTEA;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.graph.Node;
import org.eclipse.emf.common.util.URI;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeTaMapper
extends PepperMapperImpl
implements PepperMapper {
    private static final Logger logger = LoggerFactory.getLogger(GeTaMapper.class);
    public static final String TR = "TR";
    public static final String SCR = "SCR";
    public static final String FIDALWORDS = "FIDALWORDS";
    public static final String ID = "ID";
    public static final String FID = "FID";
    public static final String FIDED = "FIDED";
    public static final String FIDEDh = "FIDEDh";
    public static final String Sid = "Sid";
    public static final String Qid = "Qid";
    public static final String Tid = "Tid";
    public static final String NE = "NE";
    public static final String Comm = "Comm";
    public static final String FC = "FC";
    public static final String FIDLET = "FIDLET";
    public static final String FIDLETED = "FIDLETED";
    public static final String TRFID = "TRFID";
    public static final String pLB = "pLB";
    public static final String pPB = "pPB";
    public static final String Ed = "Ed";
    public static final String LL = "LL";
    public static final String LAT = "LAT";
    public static final String Id = "Id";
    public static final String TOKL = "TOKL";
    public static final String NEId = "NEId";
    public static final String M = "M";
    public static final String ne = "ne";
    public static final String LT = "LT";
    public static final String NT = "NT";
    public static final String AL = "AL";
    public static final String N1 = "N1";
    public static final String V1 = "V1";
    public static final String N2 = "N2";
    public static final String V2 = "V2";
    public static final String N3 = "N3";
    public static final String V3 = "V3";
    public static final String N = "N";
    public static final String V = "V";
    public static final String WB = "WB";
    public static final String WE = "WE";
    public static final String NRI = "NRI";
    public static final String NR = "NR";
    public static final String LE = "LE";
    public static final String G = "G";
    public static final String C = "C";
    public static final String DP = "DP";
    public static final String NA = "NA";
    public static final String CR = "CR";
    public static final String HWB = "HWB";
    public static final String HWE = "HWE";
    public static final String DC = "DC";
    public static final String R = "R";
    public static final String T = "T";
    public static final String ref = "ref";
    public static final String feat = "feat";
    public static final String WId = "WId";
    public static final String TID = "TID";
    public static final String ANNOT = "ANNOT";
    public static final String SOFT = "SOFT";
    public static final String NAME = "NAME";
    public static final String LANG = "LANG";
    public static final String DATE = "DATE";
    public static final String EDITION = "EDITION";
    public static final String PARTS = "PARTS";
    public static final String REF = "REF";
    public static final String QWB = "QWB";
    public static final String QWE = "QWE";
    private GeTaMetaEA metaea;
    private static final String JSON_FILE_SUFFIX = "EA";
    private static final String TEA_FILE_SUFFIX = "TEA";
    private static final String DEA_FILE_SUFFIX = "DEA";
    private static final String NEA_FILE_SUFFIX = "NEA";
    private static final String MetaEA_FILE_SUFFIX = "MetaEA";
    private static final String ANN_FILE_ENDING = "ann";
    private static final String JSON_FILE_ENDING = ".json";
    private boolean mapTEA = true;
    private boolean mapDEA = true;
    private boolean mapNEA = true;
    private boolean mapMetaEA = true;
    private static final String GETA_NAMESPACE = "GeTa";
    private static final String GETA_META_NAMESPACE = "GeTa_META";
    private static final String GETA_NAMESPACE_TEA = "GeTa_TEA";
    private static final String GETA_NAMESPACE_DEA = "GeTa_DEA";
    private static final String GETA_NAMESPACE_NEA = "GeTa_NEA";
    private static final String GETA_NAMESPACE_LT_ALS = "GeTa_META_LT_ALS";
    private static final String GETA_NAMESPACE_TEA_LT_ALS = "GeTa_TEA_LT_ALS";
    private static final String GETA_NAMESPACE_NEA_FEAT_ALS = "GeTa_NEA_FEAT_ALS";
    private static final String lex = "lex";
    private static final String lexh = "lexh";
    private static final String vocalized = "vocalized";
    private static final String unvocalized = "unvocalized";
    private static final String GEEZ = "Ge'ez";
    private static final String SOUTH_ARABIAN = "SouthArabian";
    private static final String NET = "NET";

    public DOCUMENT_STATUS mapSCorpus() {
        return super.mapSCorpus();
    }

    public DOCUMENT_STATUS mapSDocument() {
        SDocumentGraph graph = SaltFactory.createSDocumentGraph();
        this.getDocument().setDocumentGraph(graph);
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        graph.addNode((Node)text);
        URI resource = this.getResourceURI();
        String eaPath = resource.toFileString();
        String teaPath = eaPath.split("EA.json")[0].concat("TEA.ann");
        String deaPath = eaPath.split("EA.json")[0].concat("DEA.ann");
        String neaPath = eaPath.split("EA.json")[0].concat("NEA.ann");
        String metaeaPath = eaPath.split("EA.json")[0].concat("MetaEA.ann");
        File eaFile = new File(eaPath);
        File teaFile = new File(teaPath);
        this.mapTEA = this.checkFileExists(teaFile, teaPath);
        File deaFile = new File(deaPath);
        this.mapDEA = this.checkFileExists(deaFile, deaPath);
        File neaFile = new File(neaPath);
        this.mapNEA = this.checkFileExists(neaFile, neaPath);
        File metaeaFile = new File(metaeaPath);
        this.mapMetaEA = this.checkFileExists(metaeaFile, metaeaPath);
        try {
            GeTaEA ea;
            ObjectMapper eaMapper = new ObjectMapper();
            ObjectMapper teaMapper = new ObjectMapper();
            ObjectMapper dEAMapper = new ObjectMapper();
            ObjectMapper neaMapper = new ObjectMapper();
            ObjectMapper metaeaMapper = new ObjectMapper();
            List tea = null;
            List dea = null;
            List nea = null;
            this.metaea = null;
            try {
                ea = (GeTaEA)eaMapper.readValue(eaFile, (TypeReference)new TypeReference<GeTaEA>(){});
                if (this.mapTEA) {
                    tea = (List)teaMapper.readValue(teaFile, (TypeReference)new TypeReference<List<GeTaTEA>>(){});
                }
                if (this.mapDEA) {
                    dea = (List)dEAMapper.readValue(deaFile, (TypeReference)new TypeReference<List<GeTaDEA>>(){});
                }
                if (this.mapNEA) {
                    nea = (List)neaMapper.readValue(neaFile, (TypeReference)new TypeReference<List<GeTaNEA>>(){});
                }
                if (this.mapMetaEA) {
                    this.metaea = (GeTaMetaEA)metaeaMapper.readValue(metaeaFile, (TypeReference)new TypeReference<GeTaMetaEA>(){});
                }
            }
            catch (JsonParseException | JsonMappingException e) {
                logger.error("Error while parsing JSON.", e);
                return DOCUMENT_STATUS.FAILED;
            }
            this.getDocument().createMetaAnnotation(GETA_NAMESPACE, SCR, (Object)(ea.getSCR() == 0 ? GEEZ : SOUTH_ARABIAN));
            this.getDocument().createMetaAnnotation(GETA_NAMESPACE, TR, (Object)(ea.getTR() == 0 ? vocalized : unvocalized));
            if (this.mapMetaEA) {
                List<String> parts;
                for (Map.Entry<String, Object> meta : this.metaea.getAnnotations().entrySet()) {
                    this.getDocument().createMetaAnnotation(GETA_META_NAMESPACE, meta.getKey(), meta.getValue());
                }
                this.getDocument().createMetaAnnotation(GETA_META_NAMESPACE, SCR, (Object)(ea.getSCR() == 0 ? GEEZ : SOUTH_ARABIAN));
                this.getDocument().createMetaAnnotation(GETA_META_NAMESPACE, TR, (Object)(ea.getTR() == 0 ? vocalized : unvocalized));
                if (this.metaea.getId() != null) {
                    String rawValue = this.metaea.getId();
                    boolean isURL = GeTaUtil.isValidJavaNetURL(rawValue);
                    if (isURL) {
                        this.getDocument().createMetaAnnotation(GETA_META_NAMESPACE, ID, (Object)("<a href =\"" + rawValue + "\">" + rawValue + "</a>"));
                    } else {
                        this.getDocument().createMetaAnnotation(GETA_META_NAMESPACE, ID, (Object)rawValue);
                    }
                }
                if ((parts = this.metaea.getParts()) != null) {
                    String partsString = StringUtil.join(this.metaea.getParts(), (String)",");
                    this.getDocument().createMetaAnnotation(GETA_META_NAMESPACE, PARTS, (Object)partsString);
                }
            }
            HashMap<String, SSpan> fidalwordSpanIndex = new HashMap<String, SSpan>();
            HashMap<String, Object> tidTokensMap = new HashMap<String, Object>();
            HashMap<String, ArrayList<SToken>> sidTokensMap = new HashMap<String, ArrayList<SToken>>();
            HashMap<String, ArrayList<SToken>> wordNETokensMap = new HashMap<String, ArrayList<SToken>>();
            for (GeTaFidalword fidalword : ea.getFidalwords()) {
                ArrayList<SToken> fidalwordTokens = new ArrayList<SToken>();
                for (GeTaFC fc : fidalword.getFc()) {
                    List<GeTaLT> lts;
                    ArrayList<SSpan> fcSpans = new ArrayList<SSpan>();
                    ArrayList<SToken> fcTokens = new ArrayList<SToken>();
                    for (GeTaLL ll : fc.getLl()) {
                        text.setText(text.getText().concat(ll.getLat()));
                        SToken tok = graph.createToken((SSequentialDS)text, Integer.valueOf(text.getText().length() - ll.getLat().length()), Integer.valueOf(text.getText().length()));
                        fcTokens.add(tok);
                        fidalwordTokens.add(tok);
                        Object llTidTokenList = null;
                        String tid = ll.getTid();
                        llTidTokenList = (ArrayList)tidTokensMap.get(tid);
                        if (llTidTokenList != null) {
                            ((ArrayList)llTidTokenList).add(tok);
                            tidTokensMap.put(ll.getTid(), llTidTokenList);
                        } else {
                            tidTokensMap.put(ll.getTid(), new ArrayList<SToken>(Arrays.asList(tok)));
                        }
                        ArrayList llSidTokenList = null;
                        List<String> sids = fidalword.getSid();
                        for (String sid : sids) {
                            llSidTokenList = (ArrayList)sidTokensMap.get(sid);
                            if (llSidTokenList != null) {
                                llSidTokenList.add(tok);
                                continue;
                            }
                            sidTokensMap.put(sid, new ArrayList<SToken>(Arrays.asList(tok)));
                        }
                        String neId = fidalword.getNe();
                        if (neId == null || neId.isEmpty()) continue;
                        List neTokens = (List)wordNETokensMap.get(neId);
                        if (neTokens == null) {
                            wordNETokensMap.put(neId, new ArrayList<SToken>(Arrays.asList(tok)));
                            continue;
                        }
                        neTokens.add(tok);
                    }
                    SSpan singleFcSpan = graph.createSpan(fcTokens);
                    fcSpans.add(singleFcSpan);
                    this.annotateSpan(fc.getAnnotations(), singleFcSpan, GETA_NAMESPACE);
                    GeTaEd ed = fc.getEd();
                    if (ed == null || (lts = ed.getLt()) == null) continue;
                    for (GeTaLT lt : lts) {
                        String nt = lt.getNt();
                        List<GeTaAL> als = lt.getAl();
                        if (als == null && nt == null) continue;
                        SSpan ltSpan = graph.createSpan(fcTokens);
                        if (nt != null && !nt.isEmpty()) {
                            ltSpan.createAnnotation(GETA_NAMESPACE, NT, (Object)lt.getNt());
                        }
                        if (als == null) continue;
                        for (GeTaAL al : als) {
                            this.annotateSpan(al.getAnnotations(), ltSpan, GETA_NAMESPACE_LT_ALS);
                        }
                    }
                }
                SSpan fidalwordSpan = graph.createSpan(fidalwordTokens);
                this.annotateSpan(fidalword.getAnnotations(), fidalwordSpan, GETA_NAMESPACE);
                fidalwordSpanIndex.put(fidalword.getId(), fidalwordSpan);
                SSpan trSpan = graph.createSpan(fidalwordTokens);
                trSpan.createAnnotation(GETA_NAMESPACE, TR, (Object)fidalword.getTr());
                String fided = fidalword.getFided();
                fidalwordSpan.createAnnotation(GETA_NAMESPACE, FIDEDh, (Object)fided);
                fidalwordSpan.getAnnotation(GETA_NAMESPACE, FIDED).setValue((Object)Jsoup.parse((String)fided).text());
                text.setText(text.getText().concat(" "));
            }
            if (this.mapTEA) {
                for (GeTaTEA t : tea) {
                    String potentialURL;
                    boolean isURL;
                    String rawValue;
                    String[] splitLemmaURL;
                    SAnnotation lexAnnotation;
                    String id = t.getId();
                    ArrayList teaTokens = (ArrayList)tidTokensMap.get(id);
                    if (teaTokens == null) continue;
                    SSpan teaSpan = graph.createSpan((List)teaTokens);
                    this.annotateSpan(t.getAnnotations(), teaSpan, GETA_NAMESPACE_TEA);
                    GeTaM m = t.getM();
                    if (m != null) {
                        List<GeTaLT> lts;
                        Boolean mNe = m.getNe();
                        if (mNe != null) {
                            teaSpan.createAnnotation(GETA_NAMESPACE_TEA, ne, (Object)mNe);
                        }
                        if ((lts = m.getLt()) != null) {
                            for (GeTaLT lt : lts) {
                                teaSpan.createAnnotation(GETA_NAMESPACE_TEA, NT, (Object)lt.getNt());
                                List<GeTaAL> als = lt.getAl();
                                this.annotateSpanWithALs(als, teaSpan, GETA_NAMESPACE_TEA_LT_ALS);
                            }
                        }
                    }
                    if ((lexAnnotation = teaSpan.getAnnotation(GETA_NAMESPACE_TEA_LT_ALS, lex)) == null || (splitLemmaURL = (rawValue = lexAnnotation.getValue_STEXT()).split("\\s+")).length != 2 || !(isURL = GeTaUtil.isValidJavaNetURL(potentialURL = splitLemmaURL[1]))) continue;
                    lexAnnotation.setValue((Object)splitLemmaURL[0]);
                    teaSpan.createAnnotation(GETA_NAMESPACE_TEA_LT_ALS, lexh, (Object)("<a href=\"" + potentialURL + "\">" + splitLemmaURL[0] + "</a>"));
                }
            }
            if (this.mapDEA) {
                for (GeTaDEA d : dea) {
                    SSpan deaSpan = graph.createSpan((List)sidTokensMap.get(d.getId()));
                    this.annotateSpan(d.getAnnotations(), deaSpan, GETA_NAMESPACE_DEA);
                }
            }
            if (this.mapNEA) {
                for (GeTaNEA ne : nea) {
                    ArrayList<SSpan> refTokenSpans = new ArrayList<SSpan>();
                    ArrayList<SSpan> refWordSpans = new ArrayList<SSpan>();
                    for (GeTaRef neRef : ne.getRef()) {
                        List<String> tokenIds = neRef.getTid();
                        ArrayList tokenSTokenList = new ArrayList();
                        for (String tid : tokenIds) {
                            tokenSTokenList.addAll((Collection)tidTokensMap.get(tid));
                        }
                        SSpan tokenNESpan = graph.createSpan(tokenSTokenList);
                        refTokenSpans.add(tokenNESpan);
                        SSpan refWordSpan = (SSpan)fidalwordSpanIndex.get(neRef.getWid());
                        if (refWordSpan == null) continue;
                        refWordSpans.add(refWordSpan);
                    }
                    String rawValue = ne.getR();
                    boolean isURL = GeTaUtil.isValidJavaNetURL(rawValue);
                    for (SSpan span : refTokenSpans) {
                        List<GeTaAL> neFeat;
                        this.annotateSpan(ne.getAnnotations(), span, GETA_NAMESPACE_NEA);
                        SAnnotation rAnnotation = span.getAnnotation(GETA_NAMESPACE_NEA, R);
                        if (rAnnotation != null && isURL) {
                            rAnnotation.setValue((Object)("<a href=\"" + rawValue + "\">" + rawValue + "</a>"));
                        }
                        if ((neFeat = ne.getFeat()) == null) continue;
                        for (GeTaAL al : neFeat) {
                            this.annotateSpan(al.getAnnotations(), span, GETA_NAMESPACE_NEA_FEAT_ALS);
                        }
                    }
                    if (rawValue == null || rawValue.isEmpty()) continue;
                    for (SSpan span : refWordSpans) {
                        try {
                            span.createAnnotation(GETA_NAMESPACE_NEA, NET, (Object)rawValue);
                        }
                        catch (SaltInsertionException e) {
                            logger.warn("Duplicate annotation caught, not adding: {}.", (Object)("NET:" + rawValue));
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PepperModuleException("Error parsing the JSON file " + eaFile.getName() + "!", (Throwable)e);
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private void annotateSpanWithALs(List<GeTaAL> als, SSpan span, String namespace) {
        if (als != null) {
            for (GeTaAL al : als) {
                this.annotateSpan(al.getAnnotations(), span, namespace);
            }
        }
    }

    private void annotateSpan(Map<String, ?> annotationMap, SSpan span, String namespace) {
        for (Map.Entry<String, ?> a : annotationMap.entrySet()) {
            String aStr;
            String key = a.getKey();
            if (key == null || key.isEmpty()) continue;
            key = key.replaceAll("\\s", "-");
            Object value = a.getValue();
            if (a.getValue() == null || a.getValue() instanceof String && (aStr = (String)a.getValue()).isEmpty()) continue;
            span.createAnnotation(namespace, key, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFileExists(File fileToCheck, String filePath) {
        String name = fileToCheck.getName();
        if (!fileToCheck.exists()) {
            logger.error("No {} file found or file is empty!", (Object)name);
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(fileToCheck));){
            String rl = br.readLine();
            if (rl == null) {
                logger.error("No {} file found or file is empty!", (Object)name);
                boolean bl = false;
                return bl;
            }
            if (!rl.isEmpty()) return true;
            logger.error("{} file is empty!", (Object)name);
            boolean bl = false;
            return bl;
        }
        catch (IOException e2) {
            logger.error("Error occurred reading the file {}.", (Object)name, (Object)e2);
        }
        return true;
    }
}

