/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ComprehensiveGroebnerBaseSeq;
import edu.jas.application.Dimension;
import edu.jas.application.GBAlgorithmBuilder;
import edu.jas.application.GroebnerSystem;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.ResidueRing;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ProductRing;
import edu.jas.gb.Cyclic;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.RGroebnerBasePseudoSeq;
import edu.jas.gbufd.RReductionSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.Scripting;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class Examples {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            Examples.example1();
            Examples.example2();
            Examples.example3();
            Examples.example4();
        }
        Examples.example5();
        Examples.example6();
        Examples.example10();
        Examples.example11();
        Examples.example12();
        ComputerThreads.terminate();
    }

    public static void example1() {
        int n = 4;
        Cyclic cyclic = new Cyclic(n);
        System.out.println("ring = " + cyclic.ring);
        List list = cyclic.cyclicPolys();
        System.out.println("cp = " + list + "\n");
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(cyclic.ring.coFac);
        List list2 = groebnerBaseAbstract.GB(list);
        System.out.println("gb = " + list2);
    }

    public static void example2() {
        ArrayList arrayList = null;
        arrayList = new ArrayList();
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = null;
        genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 3);
        ArrayList arrayList2 = null;
        arrayList2 = new ArrayList();
        GenPolynomial<BigRational> genPolynomial = null;
        for (int i = 0; i < 2; ++i) {
            genPolynomial = genPolynomialRing.random(5, 4, 3, 0.4f);
            if (genPolynomial.isConstant()) continue;
            arrayList2.add(genPolynomial);
        }
        Ideal<BigRational> ideal = new Ideal<BigRational>(genPolynomialRing, arrayList2);
        ideal.doGB();
        if (ideal.isONE() || ideal.isZERO()) {
            System.out.println("id zero or one = " + ideal);
            return;
        }
        ResidueRing<BigRational> residueRing = new ResidueRing<BigRational>(ideal);
        System.out.println("rr = " + residueRing);
        ProductRing<BigRational> productRing = null;
        productRing = new ProductRing<BigRational>(residueRing, 3);
        String[] stringArray = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(productRing, 2, stringArray);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(2, 4, 4, 0.4f);
            if (genPolynomial2.isConstant()) continue;
            arrayList.add(genPolynomial2);
        }
        System.out.println("L = " + arrayList);
        RGroebnerBasePseudoSeq<BigRational> rGroebnerBasePseudoSeq = new RGroebnerBasePseudoSeq<BigRational>(productRing);
        System.out.println("isGB(L) = " + rGroebnerBasePseudoSeq.isGB(arrayList));
        List list = null;
        list = rGroebnerBasePseudoSeq.GB(arrayList);
        System.out.println("G = " + list);
        System.out.println("isGB(G) = " + rGroebnerBasePseudoSeq.isGB(list));
    }

    public static void example3() {
        ArrayList arrayList = null;
        arrayList = new ArrayList();
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = null;
        genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2);
        ArrayList arrayList2 = null;
        arrayList2 = new ArrayList();
        GenPolynomial<BigRational> genPolynomial = null;
        for (int i = 0; i < 2; ++i) {
            genPolynomial = genPolynomialRing.random(5, 5, 5, 0.4f);
            if (genPolynomial.isConstant()) continue;
            arrayList2.add(genPolynomial);
        }
        Ideal<BigRational> ideal = new Ideal<BigRational>(genPolynomialRing, arrayList2);
        ideal.doGB();
        if (ideal.isONE() || ideal.isZERO()) {
            System.out.println("id zero or one = " + ideal);
            return;
        }
        ResidueRing<BigRational> residueRing = new ResidueRing<BigRational>(ideal);
        System.out.println("rr = " + residueRing);
        String[] stringArray = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(residueRing, 2, stringArray);
        for (int i = 0; i < 2; ++i) {
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(2, 4, 6, 0.2f);
            if (genPolynomial2.isConstant()) continue;
            arrayList.add(genPolynomial2);
        }
        System.out.println("L = " + arrayList);
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(residueRing);
        System.out.println("isGB(L) = " + groebnerBaseAbstract.isGB(arrayList));
        List list = null;
        list = groebnerBaseAbstract.GB(arrayList);
        System.out.println("G = " + list);
        System.out.println("isGB(G) = " + groebnerBaseAbstract.isGB(list));
    }

    public static void example4() {
        int n = 2;
        int n2 = 3;
        int n3 = 3;
        float f = 0.2f;
        BigRational bigRational = new BigRational(n);
        String[] stringArray = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2, stringArray);
        String[] stringArray2 = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, 2, stringArray2);
        ComprehensiveGroebnerBaseSeq<BigRational> comprehensiveGroebnerBaseSeq = new ComprehensiveGroebnerBaseSeq<BigRational>(bigRational);
        List<GenPolynomial<GenPolynomial<Object>>> list = new ArrayList();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing2.random(n, n2, n3, f);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(n, n2, n3, f);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomial;
        if (genPolynomial.isZERO() || genPolynomial2.isZERO() || genPolynomial3.isZERO()) {
            return;
        }
        list.add(genPolynomial);
        System.out.println("CGB exam L = " + list);
        list = comprehensiveGroebnerBaseSeq.GB(list);
        System.out.println("CGB( L )   = " + list);
        System.out.println("isCGB( L ) = " + comprehensiveGroebnerBaseSeq.isGB(list));
        list.add(genPolynomial2);
        System.out.println("CGB exam L = " + list);
        list = comprehensiveGroebnerBaseSeq.GB(list);
        System.out.println("CGB( L )   = " + list);
        System.out.println("isCGB( L ) = " + comprehensiveGroebnerBaseSeq.isGB(list));
        list.add(genPolynomial3);
        System.out.println("CGB exam L = " + list);
        list = comprehensiveGroebnerBaseSeq.GB(list);
        System.out.println("CGB( L )   = " + list);
        System.out.println("isCGB( L ) = " + comprehensiveGroebnerBaseSeq.isGB(list));
    }

    public static void example5() {
        int n = 2;
        int n2 = 4;
        int n3 = 3;
        float f = 0.3f;
        BigRational bigRational = new BigRational(n);
        String[] stringArray = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2, stringArray);
        String[] stringArray2 = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, 2, stringArray2);
        ComprehensiveGroebnerBaseSeq<BigRational> comprehensiveGroebnerBaseSeq = new ComprehensiveGroebnerBaseSeq<BigRational>(bigRational);
        ArrayList arrayList = new ArrayList();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing2.random(n, n2, n3, f);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(n, n2, n3, f);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomial;
        if (genPolynomial.isZERO() || genPolynomial2.isZERO() || genPolynomial3.isZERO()) {
            return;
        }
        arrayList.add(genPolynomial);
        arrayList.add(genPolynomial2);
        arrayList.add(genPolynomial3);
        System.out.println("CGB exam L = " + arrayList);
        GroebnerSystem<BigRational> groebnerSystem = comprehensiveGroebnerBaseSeq.GBsys(arrayList);
        boolean bl = comprehensiveGroebnerBaseSeq.isGB(groebnerSystem.getCGB());
        System.out.println("CGB( L )   = " + groebnerSystem.getCGB());
        System.out.println("isCGB( L ) = " + bl);
        RReductionSeq rReductionSeq = new RReductionSeq();
        List list = PolyUtilApp.toProductRes(groebnerSystem.list);
        List list2 = rReductionSeq.booleanClosure(list);
        System.out.println("booleanClosed(Lr)   = " + list2);
        if (list2.size() > 0) {
            RGroebnerBasePseudoSeq rGroebnerBasePseudoSeq = new RGroebnerBasePseudoSeq(list2.get((int)0).ring.coFac);
            System.out.println("isRegularGB(Lr) = " + rGroebnerBasePseudoSeq.isGB(list2));
        }
    }

    public static void example6() {
        BigRational bigRational = new BigRational();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        String string = "(x,y,z) L ( ( x^2 - 2 ), ( y^2 - 3 ), ( z^2 + x * y )) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        System.out.println("F = " + polynomialList);
        List list = groebnerBaseAbstract.GB(polynomialList.list);
        PolynomialList polynomialList2 = new PolynomialList(polynomialList.ring, list);
        System.out.println("G = " + polynomialList2);
        Ideal ideal = new Ideal(polynomialList2);
        List list2 = PolyUtilApp.realAlgebraicRoots(ideal);
        for (IdealWithRealAlgebraicRoots idealWithRealAlgebraicRoots : list2) {
            idealWithRealAlgebraicRoots.doDecimalApproximation();
            for (List<BigDecimal> list3 : idealWithRealAlgebraicRoots.decimalApproximation()) {
                System.out.println(list3.toString());
            }
            System.out.println();
        }
    }

    public static void example7() {
        Serializable serializable;
        String[] stringArray = new String[]{"v3", "v2", "v1"};
        ModIntegerRing modIntegerRing = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, stringArray.length, new TermOrder(2), stringArray);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            serializable = genPolynomialRing.univariate(i);
            arrayList.add(serializable.multiply((ModInteger)serializable).sum((GenPolynomial<ModInteger>)serializable));
        }
        Ideal<ModInteger> ideal = new Ideal<ModInteger>(genPolynomialRing, arrayList);
        serializable = new ResidueRing<ModInteger>(ideal);
        String[] stringArray2 = new String[]{"mv3", "mv2", "mv1"};
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)serializable, stringArray2.length, stringArray2);
        ArrayList arrayList2 = new ArrayList();
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing2.univariate(0);
        GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing2.univariate(1);
        GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing2.univariate(2);
        GenPolynomial genPolynomial4 = genPolynomial.sum((ModInteger)((Object)genPolynomialRing2.ONE));
        GenPolynomial genPolynomial5 = genPolynomial2.sum((ModInteger)((Object)genPolynomialRing2.ONE));
        GenPolynomial genPolynomial6 = genPolynomial3.sum((ModInteger)((Object)genPolynomialRing2.ONE));
        GenPolynomial<GenPolynomial<ModInteger>> genPolynomial7 = genPolynomial.multiply((ModInteger)((Object)genPolynomial2));
        GenPolynomial genPolynomial8 = genPolynomial4.multiply(genPolynomial5);
        GenPolynomial genPolynomial9 = genPolynomial4.multiply(genPolynomial6);
        arrayList2.add(genPolynomial7);
        arrayList2.add(genPolynomial8);
        arrayList2.add(genPolynomial9);
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract = GBFactory.getImplementation(serializable);
        List list = groebnerBaseAbstract.GB(arrayList2);
        System.out.println(list);
    }

    public static void example8() {
        Serializable serializable;
        String[] stringArray = new String[]{"v3", "v2", "v1"};
        ModIntegerRing modIntegerRing = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, stringArray.length, new TermOrder(2), stringArray);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            serializable = genPolynomialRing.univariate(i);
            arrayList.add(((GenPolynomial)serializable).multiply(serializable).sum((Serializable)((GenPolynomial<ModInteger>)serializable)));
        }
        Ideal<ModInteger> ideal = new Ideal<ModInteger>(genPolynomialRing, arrayList);
        serializable = new ResidueRing<ModInteger>(ideal);
        String[] stringArray2 = new String[]{"mv3", "mv2", "mv1"};
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)serializable, stringArray2.length, stringArray2);
        ArrayList arrayList2 = new ArrayList();
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing2.univariate(0);
        GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing2.univariate(1);
        GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing2.univariate(2);
        GenPolynomial genPolynomial4 = genPolynomial.sum((ModInteger)((Object)genPolynomialRing2.ONE));
        GenPolynomial genPolynomial5 = genPolynomial2.sum((ModInteger)((Object)genPolynomialRing2.ONE));
        GenPolynomial genPolynomial6 = genPolynomial3.sum((ModInteger)((Object)genPolynomialRing2.ONE));
        GenPolynomial<GenPolynomial<ModInteger>> genPolynomial7 = genPolynomial.multiply((ModInteger)((Object)genPolynomial2));
        GenPolynomial genPolynomial8 = genPolynomial4.multiply(genPolynomial5);
        GenPolynomial genPolynomial9 = genPolynomial4.multiply(genPolynomial6);
        arrayList2.add(genPolynomial7);
        arrayList2.add(genPolynomial8);
        arrayList2.add(genPolynomial9);
        List list = ((ResidueRing)serializable).generators();
        System.out.println("gens = " + list);
        GenPolynomial<ModInteger> genPolynomial10 = genPolynomial3.subtract((ModInteger)((Object)list.get(1)));
        GenPolynomial<ModInteger> genPolynomial11 = genPolynomial2.subtract((ModInteger)((Object)list.get(2)));
        GenPolynomial<ModInteger> genPolynomial12 = genPolynomial.subtract((ModInteger)((Object)list.get(3)));
        System.out.println("mv3v3 = " + genPolynomial10);
        System.out.println("mv2v2 = " + genPolynomial11);
        System.out.println("mv1v1 = " + genPolynomial12);
        arrayList2.add(genPolynomial10);
        arrayList2.add(genPolynomial11);
        arrayList2.add(genPolynomial12);
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(serializable);
        List list2 = groebnerBaseAbstract.GB(arrayList2);
        System.out.println(list2);
    }

    public static void example9() {
        String[] stringArray = new String[]{"d1", "d2", "d3", "p1a", "p1b", "p1c", "p2a", "p2b", "p2c", "p3a", "p3b", "p3c", "p4a", "p4b", "p4c", "A", "B", "C", "D"};
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        Element element = genPolynomialRing.parse("A*p1a+B*p1b+C*p1c+D");
        Element element2 = genPolynomialRing.parse("A*p2a+B*p2b+C*p2c+D");
        Element element3 = genPolynomialRing.parse("A*p3a+B*p3b+C*p3c+D");
        Element element4 = genPolynomialRing.parse("A*p4a+B*p4b+C*p4c+D");
        Element element5 = genPolynomialRing.parse("p2a-p3a");
        Element element6 = genPolynomialRing.parse("p2b-p3b");
        Element element7 = genPolynomialRing.parse("p2c-p3c");
        Element element8 = genPolynomialRing.parse("(p2a-p1a)^2+(p2b-p1b)^2+(p2c-p1c)^2-d1^2");
        Element element9 = genPolynomialRing.parse("(p4a-p3a)^2+(p4b-p3b)^2+(p4c-p3c)^2-d2^2");
        ArrayList arrayList = new ArrayList(9);
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(element3);
        arrayList.add(element4);
        arrayList.add(element5);
        arrayList.add(element6);
        arrayList.add(element7);
        arrayList.add(element8);
        arrayList.add(element9);
        Element element10 = genPolynomialRing.parse("(p4a-p1a)^2+(p4b-p1b)^2+(p4c-p1c)^2-d3^2");
        arrayList.add(element10);
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        List list = groebnerBaseAbstract.GB(arrayList);
        PolynomialList<BigRational> polynomialList = new PolynomialList<BigRational>(genPolynomialRing, list);
        Ideal<BigRational> ideal = new Ideal<BigRational>(polynomialList, true);
        System.out.println("cp = " + arrayList);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
    }

    public static void example10() {
        Scripting.setLang(Scripting.Lang.Ruby);
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, new String[]{"w2"});
        System.out.println("pfac = " + genPolynomialRing.toScript());
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, 2L).subtract((BigRational)genPolynomialRing.fromInteger(2L));
        System.out.println("p = " + genPolynomial.toScript());
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        System.out.println("afac = " + algebraicNumberRing.toScript());
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(algebraicNumberRing, new String[]{"x"});
        System.out.println("pafac = " + genPolynomialRing2.toScript());
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing2);
        System.out.println("qafac = " + quotientRing.toScript());
        GenPolynomialRing<BigRational> genPolynomialRing3 = new GenPolynomialRing<BigRational>(quotientRing, new String[]{"wx"});
        System.out.println("pqafac = " + genPolynomialRing3.toScript());
        List<GenPolynomial<BigRational>> list = genPolynomialRing3.generators();
        System.out.println("qgen = " + list);
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial2 = genPolynomialRing3.univariate(0, 2L).subtract((BigRational)((Object)list.get(2)));
        System.out.println("q = " + genPolynomial2.toScript());
        AlgebraicNumberRing<GenPolynomial<BigRational>> algebraicNumberRing2 = new AlgebraicNumberRing<GenPolynomial<BigRational>>(genPolynomial2, true);
        System.out.println("aqafac = " + algebraicNumberRing2.toScript());
        GenPolynomialRing<GenPolynomial<BigRational>> genPolynomialRing4 = new GenPolynomialRing<GenPolynomial<BigRational>>(algebraicNumberRing2, new String[]{"y", "z"});
        System.out.println("paqafac = " + genPolynomialRing4.toScript());
        ArrayList arrayList = new ArrayList();
        Element element = genPolynomialRing4.parse("(( y^2 - x )*( z^2 - 2 ) )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing4.parse("( y^2 z - x^3 z - w2*wx )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        GroebnerBaseAbstract<GenPolynomial<BigRational>> groebnerBaseAbstract = GBFactory.getImplementation(algebraicNumberRing2);
        System.out.println("isGB(L) = " + groebnerBaseAbstract.isGB(arrayList));
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(arrayList);
        l = System.currentTimeMillis() - l;
        System.out.println("time = " + l + " milliseconds");
        for (GenPolynomial<GenPolynomial<BigRational>> genPolynomial3 : list2) {
            System.out.println("g = " + genPolynomial3.toScript());
        }
        System.out.println("isGB(G) = " + groebnerBaseAbstract.isGB(list2));
        groebnerBaseAbstract.terminate();
    }

    public static void example11() {
        Scripting.setLang(Scripting.Lang.Ruby);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"w2", "xi", "x", "wx", "y", "z"};
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray, termOrder);
        System.out.println("pfac = " + genPolynomialRing.toScript());
        ArrayList arrayList = new ArrayList();
        Element element = genPolynomialRing.parse("( w2^2 - 2 )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing.parse("( wx^2 - x )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing.parse("( xi * x - 1 )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing.parse("(( y^2 - x )*( z^2 - 2 ) )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing.parse("( y^2 z - x^3 z - w2*wx )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        System.out.println("isGB(L) = " + groebnerBaseAbstract.isGB(arrayList));
        long l = System.currentTimeMillis();
        List list = groebnerBaseAbstract.GB(arrayList);
        l = System.currentTimeMillis() - l;
        System.out.println("time = " + l + " milliseconds");
        for (GenPolynomial<BigRational> genPolynomial : list) {
            System.out.println("g = " + genPolynomial.toScript());
        }
        System.out.println("isGB(G) = " + groebnerBaseAbstract.isGB(list));
        groebnerBaseAbstract.terminate();
    }

    public static void example12() {
        Scripting.setLang(Scripting.Lang.Ruby);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray, termOrder);
        System.out.println("cfac = " + genPolynomialRing.toScript());
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        System.out.println("qfac = " + quotientRing.toScript());
        String[] stringArray2 = new String[]{"w2", "wx", "y", "z"};
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(quotientRing, stringArray2, termOrder);
        System.out.println("pfac = " + genPolynomialRing2.toScript());
        ArrayList arrayList = new ArrayList();
        Element element = genPolynomialRing2.parse("( w2^2 - 2 )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing2.parse("( wx^2 - x )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing2.parse("(( y^2 - x )*( z^2 - 2 ) )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        element = genPolynomialRing2.parse("( y^2 z - x^3 z - w2*wx )");
        System.out.println("pp = " + ((GenPolynomial)element).toScript());
        arrayList.add(element);
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(quotientRing);
        System.out.println("isGB(L) = " + groebnerBaseAbstract.isGB(arrayList));
        long l = System.currentTimeMillis();
        List list = groebnerBaseAbstract.GB(arrayList);
        l = System.currentTimeMillis() - l;
        System.out.println("time = " + l + " milliseconds");
        for (GenPolynomial<Quotient<BigRational>> genPolynomial : list) {
            System.out.println("g = " + genPolynomial.toScript());
        }
        System.out.println("isGB(G) = " + groebnerBaseAbstract.isGB(list));
        groebnerBaseAbstract.terminate();
        groebnerBaseAbstract = GBFactory.getProxy(quotientRing);
        System.out.println("isGB(L) = " + groebnerBaseAbstract.isGB(arrayList));
        l = System.currentTimeMillis();
        list = groebnerBaseAbstract.GB(arrayList);
        l = System.currentTimeMillis() - l;
        System.out.println("time = " + l + " milliseconds");
        for (GenPolynomial<Object> genPolynomial : list) {
            System.out.println("g = " + genPolynomial.toScript());
        }
        System.out.println("isGB(G) = " + groebnerBaseAbstract.isGB(list));
        groebnerBaseAbstract.terminate();
        groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing2).fractionFree().syzygyPairlist().parallel(3).build();
        System.out.println("isGB(L) = " + groebnerBaseAbstract.isGB(arrayList));
        l = System.currentTimeMillis();
        list = groebnerBaseAbstract.GB(arrayList);
        l = System.currentTimeMillis() - l;
        System.out.println("time = " + l + " milliseconds");
        for (GenPolynomial<Object> genPolynomial : list) {
            System.out.println("g = " + genPolynomial.toScript());
        }
        System.out.println("isGB(G) = " + groebnerBaseAbstract.isGB(list));
        groebnerBaseAbstract.terminate();
    }
}

