/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableResidue;
import edu.jas.application.SolvableResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.QLRSolvablePolynomial;
import edu.jas.poly.QLRSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ResidueSolvablePolynomialQLRTest
extends TestCase {
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> a;
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> b;
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> c;
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> d;
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> e;
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> f;
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> x1;
    QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational> x2;
    int rl = 4;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.3f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    SolvableResidueRing<BigRational> rring;
    SolvableIdeal<BigRational> sideal;
    QLRSolvablePolynomialRing<SolvableResidue<BigRational>, BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> sring;
    GenPolynomialRing<BigRational> cring;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ResidueSolvablePolynomialQLRTest.suite());
    }

    public ResidueSolvablePolynomialQLRTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ResidueSolvablePolynomialQLRTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.sring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.sring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.sring, arrayList);
        this.sideal = this.sideal.twosidedGB();
        if (this.sideal.isONE()) {
            System.out.println("twosided sideal = " + this.sideal.toScript());
            throw new IllegalArgumentException("ideal is one");
        }
        this.rring = new SolvableResidueRing<BigRational>(this.sideal);
        this.ring = new QLRSolvablePolynomialRing(this.rring, this.tord, this.vars);
        WeylRelations weylRelations = new WeylRelations();
        weylRelations.generate(this.ring);
        List list = this.ring.table.relationList();
        ArrayList arrayList2 = new ArrayList();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            RecSolvablePolynomial<BigRational> recSolvablePolynomial = this.ring.toPolyCoefficients(genSolvablePolynomial);
            arrayList2.add(recSolvablePolynomial);
        }
        this.ring.polCoeff.table.addSolvRelations(arrayList2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        ResidueSolvablePolynomialQLRTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational>(this.ring);
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            ResidueSolvablePolynomialQLRTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            ResidueSolvablePolynomialQLRTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ResidueSolvablePolynomialQLRTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ResidueSolvablePolynomialQLRTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableResidue<BigRational>)((Object)this.a));
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (QLRSolvablePolynomial)this.a.sum((SolvableResidue<BigRational>)((Object)this.a));
        this.c = (QLRSolvablePolynomial)this.b.subtract((SolvableResidue<BigRational>)((Object)this.a));
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableResidue<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableResidue<BigRational>)((Object)this.b));
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableResidue<BigRational>)((Object)this.b.sum((SolvableResidue<BigRational>)((Object)this.c))));
        this.e = (QLRSolvablePolynomial)this.a.sum((SolvableResidue<BigRational>)((Object)this.b)).sum(this.c);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.rring.random(this.kl);
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.a.sum((SolvableResidue<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableResidue<BigRational>)element, expVector);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableResidue<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableResidue<BigRational>)element, expVector);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableResidue<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableResidue<BigRational>)element, expVector);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableResidue<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableResidue<BigRational>)element, expVector);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((SolvableResidue<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableResidue<BigRational>)((Object)this.b));
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((SolvableResidue<BigRational>)((Object)this.b.multiply((SolvableResidue<BigRational>)((Object)this.c))));
        this.e = this.a.multiply((SolvableResidue<BigRational>)((Object)this.b)).multiply(this.c);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        this.d = (QLRSolvablePolynomial)this.a.monic();
        ResidueSolvablePolynomialQLRTest.assertTrue((String)("a.monic(): " + this.d), (((SolvableResidue)this.d.leadingBaseCoefficient()).isONE() || ((SolvableResidue)this.d.leadingBaseCoefficient()).equals(this.a.leadingBaseCoefficient()) ? 1 : 0) != 0);
    }

    public void testPartCommutative() {
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.ring = new QLRSolvablePolynomialRing(this.rring, this.ring);
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (this.ring.isCommutative() || !this.rring.isCommutative() ? 1 : 0) != 0);
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((SolvableResidue<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableResidue<BigRational>)((Object)this.b));
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"ba == ab: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((SolvableResidue<BigRational>)((Object)((QLRSolvablePolynomial)this.b.sum((SolvableResidue<BigRational>)((Object)this.c)))));
        this.e = (QLRSolvablePolynomial)this.a.multiply((SolvableResidue<BigRational>)((Object)this.b)).sum(this.a.multiply((SolvableResidue<BigRational>)((Object)this.c)));
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testSolvableCoeffsRelations() {
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        ResidueSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("z");
        GenPolynomial genPolynomial = this.sring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a z + b");
        RecSolvablePolynomial<BigRational> recSolvablePolynomial = this.ring.toPolyCoefficients((QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational>)genSolvablePolynomial2);
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)recSolvablePolynomial);
        ResidueSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial2 : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial2;
            this.a = new QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial3 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial3;
                this.b = new QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply((SolvableResidue<BigRational>)((Object)this.b));
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                ResidueSolvablePolynomialQLRTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
                expVector = ((SolvableResidue)this.a.leadingBaseCoefficient()).val.leadingExpVector().sum(((SolvableResidue)this.b.leadingBaseCoefficient()).val.leadingExpVector());
                ResidueSolvablePolynomialQLRTest.assertTrue((String)"LT(lc(a))*LT(lc(b)) == LT(lc(c))", (boolean)((SolvableResidue)this.c.leadingBaseCoefficient()).val.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((SolvableResidue<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableResidue<BigRational>)((Object)this.b));
        ResidueSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
    }

    public void testExtendContractWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = this.sring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)this.ring.toPolyCoefficients((QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational>)genSolvablePolynomial2));
        int n = this.rl;
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.extend(n);
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((QLRSolvablePolynomialRing)genSolvablePolynomialRing).contract(n);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"ring == pfec", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)genSolvablePolynomial3.extend(genSolvablePolynomialRing, 0, 0L);
        Map map = qLRSolvablePolynomial.contract(genSolvablePolynomialRing2);
        ArrayList arrayList = new ArrayList(map.values());
        GenPolynomial genPolynomial2 = (GenPolynomial)arrayList.get(0);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a == aec", (Object)genSolvablePolynomial3, (Object)genPolynomial2);
    }

    public void testReverseWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = this.sring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)this.ring.toPolyCoefficients((QLRSolvablePolynomial<SolvableResidue<BigRational>, BigRational>)genSolvablePolynomial2));
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.reverse();
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((QLRSolvablePolynomialRing)genSolvablePolynomialRing).reverse();
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"pf == pfrr", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)genSolvablePolynomial3.reverse(genSolvablePolynomialRing);
        QLRSolvablePolynomial qLRSolvablePolynomial2 = (QLRSolvablePolynomial)qLRSolvablePolynomial.reverse(genSolvablePolynomialRing2);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"a == arr", (Object)genSolvablePolynomial3, (Object)qLRSolvablePolynomial2);
    }

    public void testRecursiveWeyl() {
        GenPolynomialRing genPolynomialRing = this.ring.recursive(2);
        GenSolvablePolynomial genSolvablePolynomial = this.ring.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial<GenSolvablePolynomial> genSolvablePolynomial3 = genSolvablePolynomial.multiply(genSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial3 = recSolvablePolynomial.multiply(recSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial4 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial3);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"dr.ring == cr.ring", recSolvablePolynomial4.ring, recSolvablePolynomial3.ring);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"dr == cr", (Object)recSolvablePolynomial4, recSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)PolyUtil.distribute(this.ring, recSolvablePolynomial3);
        ResidueSolvablePolynomialQLRTest.assertEquals((String)"dd == cd", (Object)genSolvablePolynomial4, genSolvablePolynomial3);
    }
}

