/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableResidueRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import edu.jas.structure.Value;
import java.util.ArrayList;

public class SolvableResidue<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableResidue<C>>,
QuotPair<GenPolynomial<C>>,
Value<GenPolynomial<C>> {
    public final SolvableResidueRing<C> ring;
    public final GenSolvablePolynomial<C> val;
    protected int isunit = -1;

    public SolvableResidue(SolvableResidueRing<C> solvableResidueRing) {
        this(solvableResidueRing, (GenSolvablePolynomial<C>)solvableResidueRing.ring.getZERO(), 0);
    }

    public SolvableResidue(SolvableResidueRing<C> solvableResidueRing, GenSolvablePolynomial<C> genSolvablePolynomial) {
        this(solvableResidueRing, genSolvablePolynomial, -1);
    }

    public SolvableResidue(SolvableResidueRing<C> solvableResidueRing, GenSolvablePolynomial<C> genSolvablePolynomial, int n) {
        this.ring = solvableResidueRing;
        this.val = this.ring.ideal.normalform(genSolvablePolynomial);
        if (n == 0 || n == 1) {
            this.isunit = n;
            return;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
            return;
        }
        if (this.val.isUnit()) {
            this.isunit = 1;
        }
        this.isunit = -1;
    }

    @Override
    public SolvableResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> value() {
        return this.val;
    }

    @Override
    public GenSolvablePolynomial<C> numerator() {
        return this.val;
    }

    @Override
    public GenSolvablePolynomial<C> denominator() {
        return this.ring.ring.getONE();
    }

    @Override
    public SolvableResidue<C> copy() {
        return new SolvableResidue<C>(this.ring, this.val, this.isunit);
    }

    @Override
    public boolean isZERO() {
        return this.val.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.val.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        boolean bl = this.ring.ideal.isUnit(this.val);
        this.isunit = bl ? 1 : 0;
        return this.isunit > 0;
    }

    @Override
    public boolean isConstant() {
        return this.val.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return this.val.toString(this.ring.ring.getVars());
        }
        return "SolvableResidue[ " + this.val.toString() + " mod " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return this.val.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableResidue<C> solvableResidue) {
        GenSolvablePolynomial<C> genSolvablePolynomial = solvableResidue.val;
        if (!this.ring.equals(solvableResidue.ring)) {
            genSolvablePolynomial = this.ring.ideal.normalform(genSolvablePolynomial);
        }
        return this.val.compareTo(genSolvablePolynomial);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SolvableResidue)) {
            return false;
        }
        SolvableResidue solvableResidue = null;
        try {
            solvableResidue = (SolvableResidue)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (solvableResidue == null) {
            return false;
        }
        return this.compareTo(solvableResidue) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.val.hashCode();
        return n;
    }

    @Override
    public SolvableResidue<C> abs() {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.abs(), this.isunit);
    }

    @Override
    public SolvableResidue<C> sum(SolvableResidue<C> solvableResidue) {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.sum(solvableResidue.val));
    }

    @Override
    public SolvableResidue<C> negate() {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.negate(), this.isunit);
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public SolvableResidue<C> subtract(SolvableResidue<C> solvableResidue) {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.subtract(solvableResidue.val));
    }

    @Override
    public SolvableResidue<C> divide(SolvableResidue<C> solvableResidue) {
        if (this.ring.isField()) {
            return this.multiply((C)solvableResidue.inverse());
        }
        try {
            return this.multiply((C)solvableResidue.inverse());
        }
        catch (NotInvertibleException notInvertibleException) {
            System.out.println("catch: " + notInvertibleException);
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(this.ring.ring.getZERO());
            ArrayList arrayList2 = new ArrayList(1);
            arrayList2.add(solvableResidue.val);
            GenSolvablePolynomial genSolvablePolynomial = this.ring.bb.sred.leftNormalform(arrayList, arrayList2, this.val);
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)arrayList.get(0);
            System.out.println("SolvableResidue val = " + this.val + ", div = " + solvableResidue.val + ", quotient = " + genSolvablePolynomial2 + ", remainder = " + genSolvablePolynomial);
            return new SolvableResidue<C>(this.ring, genSolvablePolynomial2);
        }
    }

    @Override
    public SolvableResidue<C> inverse() {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = this.ring.ideal.inverse(this.val);
        SolvableResidue<SolvableResidue> solvableResidue = new SolvableResidue<SolvableResidue>(this.ring, genSolvablePolynomial, 1);
        if (solvableResidue.isZERO()) {
            throw new NotInvertibleException("(" + genSolvablePolynomial + ") * (" + this.val + ") = " + genSolvablePolynomial.multiply(this.val) + " = 0 mod " + this.ring.ideal);
        }
        if (!solvableResidue.multiply(this).isONE()) {
            throw new NotInvertibleException("(" + genSolvablePolynomial + ") * (" + this.val + ") = " + genSolvablePolynomial.multiply(this.val) + " != 1 mod " + this.ring.ideal);
        }
        return solvableResidue;
    }

    @Override
    public SolvableResidue<C> remainder(SolvableResidue<C> solvableResidue) {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(solvableResidue.val);
        GenSolvablePolynomial genSolvablePolynomial = this.ring.bb.sred.leftNormalform(arrayList, this.val);
        return new SolvableResidue<C>(this.ring, genSolvablePolynomial);
    }

    @Override
    public SolvableResidue<C> multiply(SolvableResidue<C> solvableResidue) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = this.val.multiply(solvableResidue.val);
        int n = -1;
        if (this.isunit == 1 && solvableResidue.isunit == 1) {
            n = 1;
        } else if (this.isunit == 0 || solvableResidue.isunit == 0) {
            n = 0;
        }
        return new SolvableResidue<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial, n);
    }

    @Override
    public SolvableResidue<C> multiply(GenSolvablePolynomial<C> genSolvablePolynomial) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = this.val.multiply(genSolvablePolynomial);
        int n = -1;
        if (this.isunit == 1 && genSolvablePolynomial.isUnit()) {
            n = 1;
        } else if (this.isunit == 0 || !genSolvablePolynomial.isUnit()) {
            n = 0;
        }
        return new SolvableResidue<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial2, n);
    }

    @Override
    public SolvableResidue<C> multiply(C c) {
        GenPolynomial genPolynomial = this.val.multiply((RingElem)c);
        int n = -1;
        if (this.isunit == 1 && c.isUnit()) {
            n = 1;
        } else if (this.isunit == 0 || !c.isUnit()) {
            n = 0;
        }
        return new SolvableResidue<C>(this.ring, genPolynomial, n);
    }

    @Override
    public SolvableResidue<C> multiply(ExpVector expVector) {
        GenPolynomial genPolynomial = this.val.multiply(expVector);
        int n = -1;
        if (this.isunit == 1 && expVector.isZERO()) {
            n = 1;
        } else if (this.isunit == 0 || !expVector.isZERO()) {
            n = 0;
        }
        return new SolvableResidue<C>(this.ring, genPolynomial, n);
    }

    public SolvableResidue<C> monic() {
        return new SolvableResidue<C>(this.ring, this.val.monic(), this.isunit);
    }

    @Override
    public SolvableResidue<C> gcd(SolvableResidue<C> solvableResidue) {
        throw new UnsupportedOperationException("gcd not implemented");
    }

    public SolvableResidue<C>[] egcd(SolvableResidue<C> solvableResidue) {
        throw new UnsupportedOperationException("egcd not implemented");
    }
}

