/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordGroebnerBaseSeq;
import edu.jas.gb.WordReduction;
import edu.jas.gb.WordReductionSeq;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.Scripting;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WordIdeal<C extends GcdRingElem<C>>
implements Comparable<WordIdeal<C>>,
Serializable {
    private static final Logger logger = LogManager.getLogger(WordIdeal.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected List<GenWordPolynomial<C>> list;
    protected GenWordPolynomialRing<C> ring;
    protected boolean isGB;
    protected boolean testGB;
    protected final WordGroebnerBaseAbstract<C> bb;
    protected final WordReduction<C> red;

    public WordIdeal(GenWordPolynomialRing<C> genWordPolynomialRing) {
        this(genWordPolynomialRing, new ArrayList<GenWordPolynomial<C>>());
    }

    public WordIdeal(GenWordPolynomialRing<C> genWordPolynomialRing, List<GenWordPolynomial<C>> list) {
        this(genWordPolynomialRing, list, false);
    }

    public WordIdeal(GenWordPolynomialRing<C> genWordPolynomialRing, List<GenWordPolynomial<C>> list, WordGroebnerBaseAbstract<C> wordGroebnerBaseAbstract, WordReduction<C> wordReduction) {
        this(genWordPolynomialRing, list, false, wordGroebnerBaseAbstract, wordReduction);
    }

    public WordIdeal(GenWordPolynomialRing<C> genWordPolynomialRing, List<GenWordPolynomial<C>> list, boolean bl) {
        this(genWordPolynomialRing, list, bl, new WordGroebnerBaseSeq(), new WordReductionSeq());
    }

    public WordIdeal(GenWordPolynomialRing<C> genWordPolynomialRing, List<GenWordPolynomial<C>> list, boolean bl, WordGroebnerBaseAbstract<C> wordGroebnerBaseAbstract) {
        this(genWordPolynomialRing, list, bl, wordGroebnerBaseAbstract, wordGroebnerBaseAbstract.red);
    }

    public WordIdeal(GenWordPolynomialRing<C> genWordPolynomialRing, List<GenWordPolynomial<C>> list, boolean bl, WordGroebnerBaseAbstract<C> wordGroebnerBaseAbstract, WordReduction<C> wordReduction) {
        if (genWordPolynomialRing == null) {
            throw new IllegalArgumentException("ring may not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("list may not be null");
        }
        this.ring = genWordPolynomialRing;
        this.list = list;
        this.isGB = bl;
        this.testGB = bl;
        this.bb = wordGroebnerBaseAbstract;
        this.red = wordReduction;
        if (debug) {
            logger.info("constructed: " + this);
        }
    }

    public WordIdeal<C> copy() {
        return new WordIdeal<C>(this.ring, new ArrayList<GenWordPolynomial<C>>(this.list), this.isGB, this.bb, this.red);
    }

    public List<GenWordPolynomial<C>> getList() {
        return this.list;
    }

    public GenWordPolynomialRing<C> getRing() {
        return this.ring;
    }

    public WordIdeal<C> getZERO() {
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(0);
        return new WordIdeal<C>(this.ring, arrayList, true, this.bb, this.red);
    }

    public WordIdeal<C> getONE() {
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(1);
        arrayList.add((GenWordPolynomial<C>)this.getRing().getONE());
        return new WordIdeal<C>(this.ring, arrayList, true, this.bb, this.red);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        boolean bl = true;
        for (GenWordPolynomial<C> genWordPolynomial : this.list) {
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(genWordPolynomial.toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("WordPolyIdeal.new(");
                break;
            }
            default: {
                stringBuffer.append("WordIdeal(");
            }
        }
        if (this.ring != null) {
            stringBuffer.append(this.ring.toScript());
        }
        if (this.list == null) {
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append(",\"\",[");
                break;
            }
            default: {
                stringBuffer.append(",list=[");
            }
        }
        boolean bl = true;
        String string = null;
        for (GenWordPolynomial<C> genWordPolynomial : this.list) {
            string = genWordPolynomial.toScript();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof WordIdeal)) {
            logger.warn("equals no Ideal");
            return false;
        }
        WordIdeal wordIdeal = null;
        try {
            wordIdeal = (WordIdeal)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        TreeSet<GenWordPolynomial<C>> treeSet = new TreeSet<GenWordPolynomial<C>>(this.list);
        TreeSet<GenWordPolynomial<C>> treeSet2 = new TreeSet<GenWordPolynomial<C>>(wordIdeal.list);
        if (this.isGB && wordIdeal.isGB) {
            return ((Object)treeSet).equals(treeSet2);
        }
        if (((Object)treeSet).equals(treeSet2)) {
            return true;
        }
        return this.contains(wordIdeal) && wordIdeal.contains(this);
    }

    @Override
    public int compareTo(WordIdeal<C> wordIdeal) {
        int n = Math.min(wordIdeal.list.size(), this.list.size());
        int n2 = 0;
        final WordFactory.WordComparator wordComparator = this.ring.alphabet.getAscendComparator();
        Comparator comparator = new Comparator<GenWordPolynomial<C>>(){

            @Override
            public int compare(GenWordPolynomial<C> genWordPolynomial, GenWordPolynomial<C> genWordPolynomial2) {
                Word word = genWordPolynomial.leadingWord();
                Word word2 = genWordPolynomial2.leadingWord();
                if (word == null) {
                    return -1;
                }
                if (word2 == null) {
                    return 1;
                }
                if (word.length() != word2.length()) {
                    if (word.length() > word2.length()) {
                        return 1;
                    }
                    return -1;
                }
                return wordComparator.compare(word, word2);
            }
        };
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(this.list);
        ArrayList<GenWordPolynomial<C>> arrayList2 = new ArrayList<GenWordPolynomial<C>>(wordIdeal.list);
        Collections.sort(arrayList, comparator);
        Collections.sort(arrayList2, comparator);
        for (int i = 0; i < n; ++i) {
            GenWordPolynomial genWordPolynomial;
            GenWordPolynomial genWordPolynomial2 = (GenWordPolynomial)arrayList.get(i);
            n2 = genWordPolynomial2.compareTo(genWordPolynomial = (GenWordPolynomial)arrayList2.get(i));
            if (n2 == 0) continue;
            return n2;
        }
        if (this.list.size() > n) {
            return 1;
        }
        if (wordIdeal.list.size() > n) {
            return -1;
        }
        return n2;
    }

    public int hashCode() {
        int n = this.list.hashCode();
        if (this.isGB) {
            n <<= 1;
        }
        if (this.testGB) {
            ++n;
        }
        return n;
    }

    public boolean isZERO() {
        if (this.list == null) {
            return true;
        }
        for (GenWordPolynomial<C> genWordPolynomial : this.list) {
            if (genWordPolynomial == null || genWordPolynomial.isZERO()) continue;
            return false;
        }
        return true;
    }

    public boolean isONE() {
        if (this.list == null) {
            return false;
        }
        for (GenWordPolynomial<C> genWordPolynomial : this.list) {
            if (genWordPolynomial == null || !genWordPolynomial.isONE()) continue;
            return true;
        }
        return false;
    }

    public boolean isGB() {
        if (this.testGB) {
            return this.isGB;
        }
        logger.warn("isGB computing");
        this.isGB = this.bb.isGB(this.getList());
        this.testGB = true;
        return this.isGB;
    }

    public void doGB() {
        if (this.isGB && this.testGB) {
            return;
        }
        List<GenWordPolynomial<C>> list = this.getList();
        logger.info("GB computing = " + list);
        this.list = this.bb.GB(list);
        this.isGB = true;
        this.testGB = true;
    }

    public WordIdeal<C> GB() {
        if (this.isGB) {
            return this;
        }
        this.doGB();
        return this;
    }

    public boolean contains(WordIdeal<C> wordIdeal) {
        if (wordIdeal == null || wordIdeal.isZERO()) {
            return true;
        }
        return this.contains(wordIdeal.getList());
    }

    public boolean contains(GenWordPolynomial<C> genWordPolynomial) {
        GenWordPolynomial<C> genWordPolynomial2;
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (this.isZERO()) {
            return false;
        }
        if (!this.isGB) {
            this.doGB();
        }
        return (genWordPolynomial2 = this.red.normalform(this.getList(), genWordPolynomial)) == null || genWordPolynomial2.isZERO();
    }

    public boolean contains(List<GenWordPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (!this.isGB) {
            this.doGB();
        }
        List<GenWordPolynomial<C>> list2 = this.getList();
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            GenWordPolynomial<C> genWordPolynomial2;
            if (genWordPolynomial == null || (genWordPolynomial2 = this.red.normalform(list2, genWordPolynomial)).isZERO()) continue;
            System.out.println("contains nf(b) != 0: " + genWordPolynomial + ", z = " + genWordPolynomial2);
            return false;
        }
        return true;
    }

    public WordIdeal<C> sum(WordIdeal<C> wordIdeal) {
        if (wordIdeal == null || wordIdeal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return wordIdeal;
        }
        int n = this.getList().size() + wordIdeal.getList().size();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.addAll(wordIdeal.getList());
        WordIdeal<C> wordIdeal2 = new WordIdeal<C>(this.getRing(), arrayList, false);
        if (this.isGB && wordIdeal.isGB) {
            wordIdeal2.doGB();
        }
        return wordIdeal2;
    }

    public WordIdeal<C> sum(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return this;
        }
        int n = this.getList().size() + 1;
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.add(genWordPolynomial);
        WordIdeal<C> wordIdeal = new WordIdeal<C>(this.getRing(), arrayList, false);
        if (this.isGB) {
            wordIdeal.doGB();
        }
        return wordIdeal;
    }

    public WordIdeal<C> sum(List<GenWordPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return this;
        }
        int n = this.getList().size() + list.size();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.addAll(list);
        WordIdeal<C> wordIdeal = new WordIdeal<C>(this.getRing(), arrayList, false);
        if (this.isGB) {
            wordIdeal.doGB();
        }
        return wordIdeal;
    }

    public WordIdeal<C> product(WordIdeal<C> wordIdeal) {
        if (wordIdeal == null || wordIdeal.isZERO()) {
            return wordIdeal;
        }
        if (this.isZERO()) {
            return this;
        }
        int n = this.getList().size() * wordIdeal.getList().size();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(n);
        for (GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial : this.getList()) {
            for (GenWordPolynomial<Object> genWordPolynomial2 : wordIdeal.getList()) {
                genWordPolynomial2 = genWordPolynomial.multiply(genWordPolynomial2);
                arrayList.add(genWordPolynomial2);
            }
        }
        WordIdeal<C> wordIdeal2 = new WordIdeal<C>(this.getRing(), arrayList, false);
        if (this.isGB && wordIdeal.isGB) {
            wordIdeal2.doGB();
        }
        return wordIdeal2;
    }

    public WordIdeal<C> product(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(this.getList().size());
        for (GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial2 : this.getList()) {
            GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial3 = genWordPolynomial2.multiply(genWordPolynomial);
            arrayList.add(genWordPolynomial3);
        }
        WordIdeal<C> wordIdeal = new WordIdeal<C>(this.getRing(), arrayList, false);
        if (this.isGB) {
            wordIdeal.doGB();
        }
        return wordIdeal;
    }

    public WordIdeal<C> intersect(List<WordIdeal<C>> list) {
        if (list == null || list.size() == 0) {
            return this.getZERO();
        }
        WordIdeal<C> wordIdeal = null;
        for (WordIdeal<C> wordIdeal2 : list) {
            if (wordIdeal == null) {
                wordIdeal = wordIdeal2;
                continue;
            }
            if (wordIdeal.isONE()) {
                return wordIdeal;
            }
            wordIdeal = wordIdeal.intersect(wordIdeal2);
        }
        return wordIdeal;
    }

    public WordIdeal<C> intersect(WordIdeal<C> wordIdeal) {
        if (wordIdeal == null || wordIdeal.isZERO()) {
            return wordIdeal;
        }
        if (this.isZERO()) {
            return this;
        }
        List<GenWordPolynomial<C>> list = PolyGBUtil.intersect(this.getRing(), this.getList(), wordIdeal.getList());
        WordIdeal<C> wordIdeal2 = new WordIdeal<C>(this.getRing(), list, true);
        return wordIdeal2;
    }

    public WordIdeal<C> intersect(GenWordPolynomialRing<C> genWordPolynomialRing) {
        if (genWordPolynomialRing == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        List<GenWordPolynomial<C>> list = PolyUtil.intersect(genWordPolynomialRing, this.getList());
        return new WordIdeal<C>(genWordPolynomialRing, list, this.isGB);
    }

    public WordIdeal<C> eliminate(GenWordPolynomialRing<C> genWordPolynomialRing) {
        if (genWordPolynomialRing == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        if (this.getRing().equals(genWordPolynomialRing)) {
            return this;
        }
        return this.intersect(genWordPolynomialRing);
    }

    public WordIdeal<C> power(int n) {
        if (n <= 0) {
            return this.getONE();
        }
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        WordIdeal<C> wordIdeal = this;
        for (int i = 1; i < n; ++i) {
            wordIdeal = wordIdeal.product(this);
        }
        return wordIdeal;
    }

    public GenWordPolynomial<C> normalform(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null) {
            return genWordPolynomial;
        }
        if (genWordPolynomial.isZERO()) {
            return genWordPolynomial;
        }
        if (this.isZERO()) {
            return genWordPolynomial;
        }
        GenWordPolynomial<C> genWordPolynomial2 = this.red.normalform(this.getList(), genWordPolynomial);
        return genWordPolynomial2;
    }

    public List<GenWordPolynomial<C>> normalform(List<GenWordPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() == 0) {
            return list;
        }
        if (this.isZERO()) {
            return list;
        }
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(list.size());
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            GenWordPolynomial<C> genWordPolynomial2 = this.normalform(genWordPolynomial);
            if (genWordPolynomial2 == null || genWordPolynomial2.isZERO()) continue;
            arrayList.add(genWordPolynomial2);
        }
        return arrayList;
    }

    public GenWordPolynomial<C> inverse(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            throw new NotInvertibleException("zero not invertible");
        }
        if (this.isZERO()) {
            throw new NotInvertibleException("zero ideal");
        }
        if (genWordPolynomial.isUnit()) {
            return genWordPolynomial.inverse();
        }
        throw new UnsupportedOperationException("inverse of " + genWordPolynomial);
    }

    public boolean isUnit(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return false;
        }
        if (this.isZERO()) {
            return false;
        }
        return genWordPolynomial.isUnit();
    }

    public int commonZeroTest() {
        if (this.isZERO()) {
            return 1;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return -1;
        }
        return this.bb.commonZeroTest(this.getList());
    }

    public boolean isMaximal() {
        if (this.commonZeroTest() != 0) {
            return false;
        }
        for (Long l : this.univariateDegrees()) {
            if (l <= 1L) continue;
            return false;
        }
        return true;
    }

    public List<Long> univariateDegrees() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (this.isZERO()) {
            return arrayList;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return arrayList;
        }
        return this.bb.univariateDegrees(this.getList());
    }
}

